<?php

namespace Modules\Attendance\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TimesheetType extends Model
{
    protected $table = 'att_timesheet_types';

    protected $fillable = [
        'name',
        'color',
        'multiplier',
        'status',
    ];

    protected $casts = [
        'multiplier' => 'decimal:2',
        'status' => 'boolean',
    ];

    public function additionalHours(): HasMany
    {
        return $this->hasMany(AdditionalHour::class, 'timesheet_type_id');
    }
}
