<style>
.extra-form-container { max-width: 800px; margin: 0 auto; padding: 20px; }
.extra-form-header { margin-bottom: 24px; }
.extra-form-back { display: inline-flex; align-items: center; gap: 6px; color: var(--text-muted); text-decoration: none; font-size: 14px; margin-bottom: 12px; }
.extra-form-back:hover { color: var(--primary); }
.extra-form-title { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
.extra-form-title svg { width: 28px; height: 28px; color: var(--primary); }

.extra-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
.extra-card-body { padding: 24px; }

.alert { padding: 12px 16px; border-radius: 8px; margin-bottom: 20px; font-size: 14px; }
.alert-error { background: rgba(239, 68, 68, 0.1); border: 1px solid #ef4444; color: #ef4444; }
.alert-error ul { margin: 0; padding-left: 20px; }

.form-section { margin-bottom: 24px; padding-bottom: 20px; border-bottom: 1px solid var(--card-border); }
.form-section:last-child { margin-bottom: 0; padding-bottom: 0; border-bottom: none; }
.form-section-title { font-size: 14px; font-weight: 700; color: var(--text-primary); text-transform: uppercase; letter-spacing: 0.5px; margin-bottom: 16px; }

.staff-selector-actions { display: flex; gap: 8px; margin-bottom: 12px; }
.staff-selector-btn { padding: 6px 14px; border: 1px solid var(--card-border); border-radius: 6px; font-size: 13px; font-weight: 500; background: var(--card-bg); color: var(--text-primary); cursor: pointer; transition: all 0.2s; }
.staff-selector-btn:hover { border-color: var(--primary); color: var(--primary); }

.staff-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(220px, 1fr)); gap: 10px; max-height: 320px; overflow-y: auto; padding: 4px; }
.staff-item { display: flex; align-items: center; gap: 10px; padding: 12px 14px; border: 2px solid var(--card-border); border-radius: 10px; cursor: pointer; transition: all 0.2s; background: var(--card-bg); }
.staff-item:hover { border-color: var(--primary); background: rgba(59, 130, 246, 0.05); }
.staff-item.selected { border-color: var(--primary); background: rgba(59, 130, 246, 0.1); }
.staff-item input { display: none; }
.staff-avatar { width: 40px; height: 40px; border-radius: 50%; background: linear-gradient(135deg, var(--primary), var(--primary-hover)); display: flex; align-items: center; justify-content: center; color: white; font-weight: 600; font-size: 15px; flex-shrink: 0; }
.staff-details { flex: 1; min-width: 0; }
.staff-name { font-weight: 600; font-size: 14px; color: var(--text-primary); white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
.staff-role { font-size: 12px; color: var(--text-muted); }
.staff-check { width: 22px; height: 22px; border: 2px solid var(--card-border); border-radius: 5px; display: flex; align-items: center; justify-content: center; transition: all 0.2s; flex-shrink: 0; }
.staff-item.selected .staff-check { background: var(--primary); border-color: var(--primary); }
.staff-check svg { display: none; color: white; }
.staff-item.selected .staff-check svg { display: block; }
.staff-hint { font-size: 12px; color: var(--text-muted); margin-top: 8px; }

.form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
.form-row-3 { display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 16px; }
.form-group { margin-bottom: 16px; }
.form-label { display: block; font-size: 14px; font-weight: 500; color: var(--text-primary); margin-bottom: 6px; }
.form-label .req { color: #dc2626; }
.form-input, .form-select, .form-textarea { width: 100%; padding: 10px 14px; border: 1px solid var(--input-border); border-radius: 8px; font-size: 14px; background: var(--input-bg); color: var(--input-text); transition: all 0.2s; }
.form-input:focus, .form-select:focus, .form-textarea:focus { outline: none; border-color: var(--primary); box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); }
.form-textarea { min-height: 80px; resize: vertical; }
.form-hint { font-size: 12px; color: var(--text-muted); margin-top: 4px; }

.form-actions { display: flex; gap: 12px; padding-top: 20px; border-top: 1px solid var(--card-border); margin-top: 24px; justify-content: flex-end; }
.btn { padding: 10px 24px; border-radius: 8px; font-weight: 600; font-size: 14px; cursor: pointer; transition: all 0.2s; border: none; display: inline-flex; align-items: center; gap: 6px; text-decoration: none; }
.btn-primary { background: var(--primary); color: #fff; }
.btn-primary:hover { background: var(--primary-hover); }
.btn-secondary { background: var(--card-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
.btn-secondary:hover { background: var(--hover-bg); }

@media (max-width: 600px) { 
    .form-row, .form-row-3 { grid-template-columns: 1fr; }
    .staff-grid { grid-template-columns: 1fr; }
}
</style>

<div class="extra-form-container">
    <div class="extra-form-header">
        <a href="{{ route('admin.attendance.additional_hours.index') }}" class="extra-form-back">
            <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M19 12H5m7-7l-7 7 7 7"/></svg>
            Back
        </a>
        <h1 class="extra-form-title">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            Assign Extra Work
        </h1>
    </div>

    <div class="extra-card">
        <div class="extra-card-body">
            @if ($errors->any())
                <div class="alert alert-error">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('admin.attendance.additional_hours.store') }}" method="POST" id="extraForm">
                @csrf

                {{-- Staff Selection --}}
                <div class="form-section">
                    <div class="form-section-title">Select Staff<span class="req">*</span></div>
                    
                    <div class="staff-selector-actions">
                        <button type="button" class="staff-selector-btn" onclick="selectAllStaff()">Select All</button>
                        <button type="button" class="staff-selector-btn" onclick="clearAllStaff()">Clear All</button>
                    </div>

                    <div class="staff-grid">
                        @forelse($staffList ?? [] as $staff)
                      <div class="staff-item" onclick="toggleStaff(this)">
                            <input type="checkbox" name="staff_ids[]" value="{{ $staff->id }}">
                            <div class="staff-avatar">{{ strtoupper(substr($staff->first_name ?? 'S', 0, 1)) }}</div>
                            <div class="staff-details">
                                <div class="staff-name">{{ $staff->first_name }} {{ $staff->last_name }}</div>
                                <div class="staff-role">{{ $staff->role->name ?? 'Staff' }}</div>
                            </div>
                            <div class="staff-check">
                                <svg width="14" height="14" fill="none" stroke="currentColor" stroke-width="3" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg>
                            </div>
                    </div>
                        @empty
                        <div style="grid-column: 1/-1; text-align:center; padding:20px; color:var(--text-muted);">
                            No staff available
                        </div>
                        @endforelse
                    </div>
                    <div class="staff-hint">Select one or more staff members to assign extra work</div>
                </div>

                {{-- Work Details --}}
                <div class="form-section">
                    <div class="form-section-title">Work Details</div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Work Date<span class="req">*</span></label>
                            <input type="date" name="work_date" class="form-input" value="{{ date('Y-m-d') }}" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Work Type</label>
                            <select name="work_type_id" class="form-select">
                                <option value="">-- Select Type --</option>
                                @foreach($workTypes ?? [] as $type)
                                <option value="{{ $type->id }}">{{ $type->name }}</option>
                                @endforeach
                            </select>
                            <div class="form-hint">Different types have different pay multipliers</div>
                        </div>
                    </div>

                    <div class="form-row-3">
                        <div class="form-group">
                            <label class="form-label">Time In</label>
                            <input type="time" name="time_in" class="form-input">
                        </div>
                        <div class="form-group">
                            <label class="form-label">Time Out</label>
                            <input type="time" name="time_out" class="form-input">
                        </div>
                        <div class="form-group">
                            <label class="form-label">Hours<span class="req">*</span></label>
                            <input type="number" name="hours" class="form-input" value="1" min="0.5" max="24" step="0.5" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Reason / Description</label>
                        <textarea name="reason" class="form-textarea" placeholder="Optional reason for extra work...">{{ old('reason') }}</textarea>
                    </div>
                </div>

                <div class="form-actions">
                    <a href="{{ route('admin.attendance.additional_hours.index') }}" class="btn btn-secondary">Cancel</a>
                    <button type="submit" class="btn btn-primary">
                        <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg>
                        Assign Extra Work
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function toggleStaff(el) {
    el.classList.toggle('selected');
    var cb = el.querySelector('input[type="checkbox"]');
    cb.checked = el.classList.contains('selected');
}

function selectAllStaff() {
    document.querySelectorAll('.staff-item').forEach(function(el) {
        el.classList.add('selected');
        el.querySelector('input').checked = true;
    });
}

function clearAllStaff() {
    document.querySelectorAll('.staff-item').forEach(function(el) {
        el.classList.remove('selected');
        el.querySelector('input').checked = false;
    });
}
</script>
