<style>
.extra-view-container { max-width: 600px; margin: 0 auto; padding: 20px; }
.extra-view-header { margin-bottom: 24px; }
.extra-view-back { display: inline-flex; align-items: center; gap: 6px; color: var(--text-muted); text-decoration: none; font-size: 14px; margin-bottom: 12px; }
.extra-view-back:hover { color: var(--primary); }
.extra-view-title { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
.extra-view-title svg { width: 28px; height: 28px; color: var(--primary); }

.extra-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
.extra-card-body { padding: 24px; }

.staff-header { display: flex; align-items: center; gap: 16px; padding-bottom: 20px; margin-bottom: 20px; border-bottom: 1px solid var(--card-border); }
.staff-avatar-lg { width: 60px; height: 60px; border-radius: 50%; background: linear-gradient(135deg, var(--primary), var(--primary-hover)); display: flex; align-items: center; justify-content: center; color: white; font-weight: 700; font-size: 22px; }
.staff-info h3 { font-size: 18px; font-weight: 600; color: var(--text-primary); margin: 0 0 4px 0; }
.staff-info p { font-size: 13px; color: var(--text-muted); margin: 0; }

.info-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 16px; margin-bottom: 24px; }
.info-item { }
.info-label { font-size: 12px; color: var(--text-muted); text-transform: uppercase; margin-bottom: 4px; }
.info-value { font-size: 15px; font-weight: 500; color: var(--text-primary); }
.info-value.large { font-size: 28px; font-weight: 700; color: var(--primary); }

.status-badge { display: inline-flex; padding: 6px 14px; border-radius: 20px; font-size: 13px; font-weight: 600; }
.status-assigned { background: rgba(59, 130, 246, 0.15); color: #3b82f6; }
.status-acknowledged { background: rgba(245, 158, 11, 0.15); color: #f59e0b; }
.status-completed { background: rgba(16, 185, 129, 0.15); color: #10b981; }
.status-cancelled { background: rgba(107, 114, 128, 0.15); color: #6b7280; }

.timeline { border-left: 2px solid var(--card-border); padding-left: 20px; margin: 24px 0; }
.timeline-item { position: relative; padding-bottom: 20px; }
.timeline-item:last-child { padding-bottom: 0; }
.timeline-item::before { content: ''; position: absolute; left: -26px; top: 4px; width: 12px; height: 12px; border-radius: 50%; background: var(--card-border); }
.timeline-item.done::before { background: #10b981; }
.timeline-item.current::before { background: var(--primary); box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.2); }
.timeline-title { font-size: 14px; font-weight: 600; color: var(--text-primary); }
.timeline-date { font-size: 12px; color: var(--text-muted); }

.reason-box { background: var(--hover-bg); border-radius: 8px; padding: 14px; margin-top: 20px; }
.reason-box-title { font-size: 12px; color: var(--text-muted); text-transform: uppercase; margin-bottom: 6px; }
.reason-box-text { font-size: 14px; color: var(--text-primary); line-height: 1.5; }

.form-actions { display: flex; gap: 12px; padding-top: 20px; border-top: 1px solid var(--card-border); margin-top: 24px; }
.btn { padding: 10px 20px; border-radius: 8px; font-weight: 600; font-size: 14px; cursor: pointer; transition: all 0.2s; border: none; display: inline-flex; align-items: center; gap: 6px; text-decoration: none; }
.btn-primary { background: var(--primary); color: #fff; }
.btn-primary:hover { background: var(--primary-hover); }
.btn-success { background: #10b981; color: #fff; }
.btn-success:hover { background: #059669; }
.btn-danger { background: #ef4444; color: #fff; }
.btn-danger:hover { background: #dc2626; }
.btn-secondary { background: var(--card-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
.btn-secondary:hover { background: var(--hover-bg); }
</style>

<div class="extra-view-container">
    <div class="extra-view-header">
        <a href="{{ route('admin.attendance.additional_hours.index') }}" class="extra-view-back">
            <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M19 12H5m7-7l-7 7 7 7"/></svg>
            Back to List
        </a>
        <h1 class="extra-view-title">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            Extra Work Details
        </h1>
    </div>

    <div class="extra-card">
        <div class="extra-card-body">
            {{-- Staff Header --}}
            <div class="staff-header">
                <div class="staff-avatar-lg">{{ strtoupper(substr($additionalHour->staff->first_name ?? 'S', 0, 1)) }}</div>
                <div class="staff-info">
                    <h3>{{ $additionalHour->staff->first_name ?? '' }} {{ $additionalHour->staff->last_name ?? '' }}</h3>
                    <p>{{ $additionalHour->staff->designation ?? $additionalHour->staff->role->name ?? 'Staff' }}</p>
                </div>
            </div>

            {{-- Info Grid --}}
            <div class="info-grid">
                <div class="info-item">
                    <div class="info-label">Work Date</div>
                    <div class="info-value">{{ $additionalHour->work_date ? \Carbon\Carbon::parse($additionalHour->work_date)->format('d M Y') : '-' }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">Hours</div>
                    <div class="info-value large">{{ $additionalHour->hours ?? 0 }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">Work Type</div>
                    <div class="info-value">{{ $additionalHour->workType->name ?? '-' }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">Assigned By</div>
                    <div class="info-value">{{ $additionalHour->assigner->first_name ?? '' }} {{ $additionalHour->assigner->last_name ?? '' }}</div>
                </div>
                @if($additionalHour->time_in || $additionalHour->time_out)
                <div class="info-item">
                    <div class="info-label">Time In</div>
                    <div class="info-value">{{ $additionalHour->time_in ?? '-' }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">Time Out</div>
                    <div class="info-value">{{ $additionalHour->time_out ?? '-' }}</div>
                </div>
                @endif
            </div>

            {{-- Status --}}
            <div style="margin-bottom: 20px;">
                <div class="info-label">Status</div>
                <span class="status-badge status-{{ $additionalHour->status }}">{{ ucfirst($additionalHour->status) }}</span>
            </div>

            {{-- Timeline --}}
            <div class="timeline">
                <div class="timeline-item {{ in_array($additionalHour->status, ['assigned', 'acknowledged', 'completed']) ? 'done' : '' }}">
                    <div class="timeline-title">Assigned</div>
                    <div class="timeline-date">{{ $additionalHour->created_at ? $additionalHour->created_at->format('d M Y, h:i A') : '-' }}</div>
                </div>
                <div class="timeline-item {{ in_array($additionalHour->status, ['acknowledged', 'completed']) ? 'done' : ($additionalHour->status == 'assigned' ? 'current' : '') }}">
                    <div class="timeline-title">Acknowledged</div>
                    <div class="timeline-date">{{ $additionalHour->acknowledged_at ? \Carbon\Carbon::parse($additionalHour->acknowledged_at)->format('d M Y, h:i A') : 'Pending' }}</div>
                </div>
                <div class="timeline-item {{ $additionalHour->status == 'completed' ? 'done' : ($additionalHour->status == 'acknowledged' ? 'current' : '') }}">
                    <div class="timeline-title">Completed</div>
                    <div class="timeline-date">{{ $additionalHour->status == 'completed' ? $additionalHour->updated_at->format('d M Y, h:i A') : 'Pending' }}</div>
                </div>
            </div>

            {{-- Reason --}}
            @if($additionalHour->reason)
            <div class="reason-box">
                <div class="reason-box-title">Reason / Description</div>
                <div class="reason-box-text">{{ $additionalHour->reason }}</div>
            </div>
            @endif

            {{-- Actions --}}
            <div class="form-actions">
                @if($additionalHour->status == 'assigned' || $additionalHour->status == 'acknowledged')
                <form action="{{ route('admin.attendance.additional_hours.complete', $additionalHour->id) }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-success">✓ Mark Complete</button>
                </form>
                <a href="{{ route('admin.attendance.additional_hours.index') }}" class="btn btn-secondary">Back to List</a>
                @elseif($additionalHour->status == 'completed')
                <form action="{{ route('admin.attendance.additional_hours.cancel', $additionalHour->id) }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-danger">Cancel Assignment</button>
                </form>
                <a href="{{ route('admin.attendance.additional_hours.index') }}" class="btn btn-secondary">Back to List</a>
                @else
                <a href="{{ route('admin.attendance.additional_hours.index') }}" class="btn btn-secondary">Back to List</a>
                @endif
            </div>
        </div>
    </div>
</div>
