<style>
    .att-logs { padding: 20px; max-width: 1600px; }
    
    /* Header */
    .att-logs-header { background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%); border-radius: 12px; padding: 24px; margin-bottom: 24px; color: #fff; }
    .att-logs-header h1 { font-size: 24px; font-weight: 700; margin: 0 0 6px 0; }
    .att-logs-header p { margin: 0; opacity: 0.9; font-size: 14px; }
    
    /* Stats Cards */
    .att-stats-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 16px; margin-bottom: 24px; }
    .att-stat-card { background: var(--card-bg, #fff); border: 1px solid var(--card-border, #e5e7eb); border-radius: 12px; padding: 20px; display: flex; align-items: center; gap: 16px; transition: all 0.2s; }
    .att-stat-card:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(0,0,0,0.08); }
    .att-stat-icon { width: 48px; height: 48px; border-radius: 12px; display: flex; align-items: center; justify-content: center; }
    .att-stat-icon.blue { background: #dbeafe; color: #2563eb; }
    .att-stat-icon.purple { background: #ede9fe; color: #7c3aed; }
    .att-stat-icon.orange { background: #ffedd5; color: #ea580c; }
    .att-stat-icon.green { background: #dcfce7; color: #16a34a; }
    .att-stat-icon.red { background: #fee2e2; color: #dc2626; }
    .att-stat-value { font-size: 28px; font-weight: 700; color: var(--text-primary, #1f2937); line-height: 1; }
    .att-stat-label { font-size: 12px; color: var(--text-muted, #6b7280); text-transform: uppercase; font-weight: 600; letter-spacing: 0.5px; margin-top: 4px; }
    
    /* Filter Card */
    .att-filter-card { background: var(--card-bg, #fff); border: 1px solid var(--card-border, #e5e7eb); border-radius: 12px; padding: 16px 20px; margin-bottom: 24px; }
    .att-filter-row { display: flex; flex-wrap: wrap; align-items: center; gap: 12px; }
    
    /* Filter Tabs */
    .att-filter-tabs { display: flex; gap: 8px; flex-wrap: wrap; }
    .att-filter-tab { padding: 8px 16px; border-radius: 8px; font-size: 13px; font-weight: 600; cursor: pointer; border: none; background: var(--hover-bg, #f3f4f6); color: var(--text-muted, #6b7280); transition: all 0.2s; }
    .att-filter-tab:hover { background: #e5e7eb; }
    .att-filter-tab.active { background: #3b82f6; color: #fff; }
    
    /* Filter Inputs */
    .att-filter-select, .att-filter-input { padding: 8px 12px; border: 1px solid var(--input-border, #e5e7eb); border-radius: 8px; font-size: 13px; background: var(--input-bg, #fff); color: var(--text-primary, #1f2937); min-width: 150px; }
    .att-filter-select:focus, .att-filter-input:focus { outline: none; border-color: #3b82f6; }
    
    .att-filter-spacer { flex: 1; }
    
    .att-per-page { display: flex; align-items: center; gap: 8px; font-size: 13px; color: var(--text-muted); }
    
    /* Table Card */
    .att-table-card { background: var(--card-bg, #fff); border: 1px solid var(--card-border, #e5e7eb); border-radius: 12px; overflow: hidden; }
    .att-table-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border, #e5e7eb); display: flex; justify-content: space-between; align-items: center; }
    .att-table-title { font-size: 16px; font-weight: 600; color: var(--text-primary, #1f2937); display: flex; align-items: center; gap: 8px; }
    .att-table-count { font-size: 13px; color: var(--text-muted, #6b7280); }
    
    /* Table */
    .att-table-wrap { overflow-x: auto; }
    .att-table { width: 100%; border-collapse: collapse; min-width: 900px; }
    .att-table th { padding: 12px 16px; text-align: left; font-size: 11px; font-weight: 600; color: var(--text-muted, #6b7280); text-transform: uppercase; letter-spacing: 0.5px; background: var(--hover-bg, #f9fafb); border-bottom: 1px solid var(--card-border, #e5e7eb); }
    .att-table td { padding: 14px 16px; border-bottom: 1px solid var(--card-border, #e5e7eb); font-size: 14px; color: var(--text-primary, #1f2937); vertical-align: middle; }
    .att-table tr:hover td { background: var(--hover-bg, #f9fafb); }
    .att-table tr:last-child td { border-bottom: none; }
    
    /* Avatar */
    .att-avatar { width: 36px; height: 36px; border-radius: 50%; background: linear-gradient(135deg, #3b82f6, #8b5cf6); color: #fff; display: flex; align-items: center; justify-content: center; font-size: 12px; font-weight: 600; flex-shrink: 0; }
    .att-staff-cell { display: flex; align-items: center; gap: 10px; }
    .att-staff-name { font-weight: 500; }
    
    /* Badges */
    .att-badge { display: inline-flex; padding: 4px 10px; border-radius: 20px; font-size: 11px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.3px; }
    .att-badge-success { background: #dcfce7; color: #166534; }
    .att-badge-danger { background: #fee2e2; color: #991b1b; }
    .att-badge-warning { background: #fef3c7; color: #92400e; }
    .att-badge-info { background: #dbeafe; color: #1e40af; }
    .att-badge-secondary { background: #f3f4f6; color: #4b5563; }
    
    /* Location */
    .att-location { display: flex; align-items: center; gap: 6px; }
    .att-location-text { max-width: 150px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; }
    .att-map-btn { background: none; border: none; color: #3b82f6; cursor: pointer; padding: 4px; border-radius: 4px; display: inline-flex; align-items: center; gap: 4px; font-size: 12px; text-decoration: none; }
    .att-map-btn:hover { background: #dbeafe; color: #1d4ed8; }
    
    /* Actions */
    .att-action-btn { padding: 6px 10px; border-radius: 6px; font-size: 12px; cursor: pointer; border: none; display: inline-flex; align-items: center; gap: 4px; }
    .att-action-btn.view { background: #dbeafe; color: #2563eb; }
    .att-action-btn:hover { opacity: 0.8; }
    
    /* Pagination */
    .att-pagination { padding: 16px 20px; border-top: 1px solid var(--card-border, #e5e7eb); display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 12px; }
    .att-pagination-info { font-size: 13px; color: var(--text-muted, #6b7280); }
    .att-pagination-btns { display: flex; gap: 4px; }
    .att-page-btn { padding: 8px 12px; border: 1px solid var(--card-border, #e5e7eb); border-radius: 6px; font-size: 13px; cursor: pointer; background: var(--card-bg, #fff); color: var(--text-primary, #1f2937); }
    .att-page-btn:hover:not(:disabled) { background: var(--hover-bg, #f3f4f6); }
    .att-page-btn:disabled { opacity: 0.5; cursor: not-allowed; }
    .att-page-btn.active { background: #3b82f6; color: #fff; border-color: #3b82f6; }
    
    /* Empty State */
    .att-empty { padding: 60px 20px; text-align: center; }
    .att-empty-icon { width: 64px; height: 64px; margin: 0 auto 16px; background: #f3f4f6; border-radius: 50%; display: flex; align-items: center; justify-content: center; color: #9ca3af; }
    .att-empty-title { font-size: 16px; font-weight: 600; color: var(--text-primary); margin-bottom: 4px; }
    .att-empty-desc { font-size: 14px; color: var(--text-muted); }
    
    /* Loading */
    .att-loading { padding: 40px; text-align: center; color: var(--text-muted); }
    
    /* Modal */
    .att-modal-overlay { position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 9999; display: none; align-items: center; justify-content: center; padding: 20px; }
    .att-modal-overlay.show { display: flex; }
    .att-modal { background: var(--card-bg, #fff); border-radius: 16px; width: 100%; max-width: 700px; max-height: 90vh; overflow: hidden; box-shadow: 0 20px 60px rgba(0,0,0,0.3); }
    .att-modal-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border, #e5e7eb); display: flex; justify-content: space-between; align-items: center; }
    .att-modal-title { font-size: 16px; font-weight: 600; color: var(--text-primary); }
    .att-modal-close { background: none; border: none; font-size: 24px; cursor: pointer; color: var(--text-muted); line-height: 1; padding: 0; }
    .att-modal-body { padding: 0; overflow: hidden; }
    
    /* Detail Modal */
    .att-detail-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 16px; padding: 20px; }
    .att-detail-item { }
    .att-detail-label { font-size: 11px; color: var(--text-muted); text-transform: uppercase; font-weight: 600; margin-bottom: 4px; }
    .att-detail-value { font-size: 14px; color: var(--text-primary); }
    .att-detail-full { grid-column: span 2; }
</style>

<div class="att-logs">
    {{-- Header --}}
    <div class="att-logs-header">
        <h1>📋 Attendance Logs</h1>
        <p>Track and manage all attendance entries</p>
    </div>
    
    {{-- Stats --}}
    <div class="att-stats-grid">
        <div class="att-stat-card">
            <div class="att-stat-icon blue">
                <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg>
            </div>
            <div>
                <div class="att-stat-value">{{ number_format($totalLogs) }}</div>
                <div class="att-stat-label">Total Entries</div>
            </div>
        </div>
        <div class="att-stat-card">
            <div class="att-stat-icon purple">
                <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg>
            </div>
            <div>
                <div class="att-stat-value">{{ number_format($myLogs) }}</div>
                <div class="att-stat-label">My Entries</div>
            </div>
        </div>
        <div class="att-stat-card">
            <div class="att-stat-icon orange">
                <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            </div>
            <div>
                <div class="att-stat-value">{{ number_format($todayLogs) }}</div>
                <div class="att-stat-label">Today's Entries</div>
            </div>
        </div>
        <div class="att-stat-card">
            <div class="att-stat-icon green">
                <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"/></svg>
            </div>
            <div>
                <div class="att-stat-value">{{ number_format($checkIns) }}</div>
                <div class="att-stat-label">Check-ins</div>
            </div>
        </div>
        <div class="att-stat-card">
            <div class="att-stat-icon red">
                <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/></svg>
            </div>
            <div>
                <div class="att-stat-value">{{ number_format($checkOuts) }}</div>
                <div class="att-stat-label">Check-outs</div>
            </div>
        </div>
    </div>
    
    {{-- Filters --}}
    <div class="att-filter-card">
        <div class="att-filter-row">
            <div class="att-filter-tabs">
                <button class="att-filter-tab active" data-filter="all">All</button>
                <button class="att-filter-tab" data-filter="my">My Logs</button>
                <button class="att-filter-tab" data-filter="today">Today</button>
                <button class="att-filter-tab" data-filter="checkin">Check-ins</button>
                <button class="att-filter-tab" data-filter="checkout">Check-outs</button>
            </div>
            
            <div class="att-filter-spacer"></div>
            
            <select id="staffFilter" class="att-filter-select">
                <option value="">All Staff</option>
                @foreach($staffList as $s)
                <option value="{{ $s->id }}">{{ $s->first_name }} {{ $s->last_name }}</option>
                @endforeach
            </select>
            
            <input type="date" id="fromDate" class="att-filter-input" placeholder="From Date">
            <input type="date" id="toDate" class="att-filter-input" placeholder="To Date">
            
            <input type="text" id="searchInput" class="att-filter-input" placeholder="Search..." style="min-width:180px;">
            
            <div class="att-per-page">
                Show:
                <select id="perPage" class="att-filter-select" style="min-width:70px;">
                    <option value="15">15</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
            </div>
        </div>
    </div>
    
    {{-- Table --}}
    <div class="att-table-card">
        <div class="att-table-header">
            <div class="att-table-title">
                <svg width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M4 6h16M4 10h16M4 14h16M4 18h16"/></svg>
                All Attendance Logs
            </div>
            <div class="att-table-count" id="tableCount">Showing 0-0 of 0 logs</div>
        </div>
        
        <div class="att-table-wrap">
            <table class="att-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Staff</th>
                        <th>Date</th>
                        <th>Time</th>
                        <th>Action</th>
                        <th>Location</th>
                        <th>IP Address</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody id="logsTableBody">
                    <tr>
                        <td colspan="8" class="att-loading">Loading...</td>
                    </tr>
                </tbody>
            </table>
        </div>
        
        <div class="att-pagination">
            <div class="att-pagination-info" id="paginationInfo">Showing 0-0 of 0 entries</div>
            <div class="att-pagination-btns" id="paginationBtns"></div>
        </div>
    </div>
</div>

{{-- Detail Modal --}}
<div id="detailModal" class="att-modal-overlay" onclick="if(event.target===this)closeDetailModal()">
    <div class="att-modal">
        <div class="att-modal-header">
            <div class="att-modal-title">📋 Log Details</div>
            <button class="att-modal-close" onclick="closeDetailModal()">&times;</button>
        </div>
        <div class="att-modal-body">
            <div class="att-detail-grid" id="detailContent">
                <!-- Populated by JS -->
            </div>
        </div>
    </div>
</div>

<script>
let currentFilter = 'all';
let currentPage = 1;

// Load data
function loadLogs(page = 1) {
    currentPage = page;
    const tbody = document.getElementById('logsTableBody');
    tbody.innerHTML = '<tr><td colspan="8" class="att-loading">Loading...</td></tr>';
    
    const params = new URLSearchParams({
        filter: currentFilter,
        page: page,
        per_page: document.getElementById('perPage').value,
        staff_id: document.getElementById('staffFilter').value,
        from_date: document.getElementById('fromDate').value,
        to_date: document.getElementById('toDate').value,
        search: document.getElementById('searchInput').value,
    });
    
    fetch('{{ route("admin.attendance.logs.data") }}?' + params.toString())
        .then(r => r.json())
        .then(data => {
            renderTable(data);
            renderPagination(data);
        })
        .catch(err => {
            tbody.innerHTML = '<tr><td colspan="8" class="att-empty"><div class="att-empty-icon"><svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg></div><div class="att-empty-title">Error loading data</div></td></tr>';
        });
}

function renderTable(data) {
    const tbody = document.getElementById('logsTableBody');
    
    if (!data.data || data.data.length === 0) {
        tbody.innerHTML = `
            <tr>
                <td colspan="8">
                    <div class="att-empty">
                        <div class="att-empty-icon">
                            <svg width="24" height="24" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg>
                        </div>
                        <div class="att-empty-title">No logs found</div>
                        <div class="att-empty-desc">Try adjusting your filters</div>
                    </div>
                </td>
            </tr>
        `;
        return;
    }
    
    let html = '';
    data.data.forEach(log => {
        const badgeClass = {
            'success': 'att-badge-success',
            'danger': 'att-badge-danger',
            'warning': 'att-badge-warning',
            'info': 'att-badge-info',
            'secondary': 'att-badge-secondary',
        }[log.action_color] || 'att-badge-secondary';
        
        html += `
            <tr>
                <td><strong>#${log.id}</strong></td>
                <td>
                    <div class="att-staff-cell">
                        <div class="att-avatar">${log.staff_avatar}</div>
                        <span class="att-staff-name">${log.staff_name}</span>
                    </div>
                </td>
                <td>${log.date}</td>
                <td><strong>${log.time}</strong></td>
                <td><span class="att-badge ${badgeClass}">${log.action_label}</span></td>
                <td>
                    <div class="att-location">
                        ${log.latitude && log.longitude ? `
                            <span class="att-location-text" title="${log.location || ''}">${log.location || log.latitude + ', ' + log.longitude}</span>
                            <a href="https://www.google.com/maps?q=${log.latitude},${log.longitude}" target="_blank" class="att-map-btn">
                                <svg width="14" height="14" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                                Map
                            </a>
                        ` : '<span style="color:var(--text-muted);">-</span>'}
                    </div>
                </td>
                <td><code style="font-size:12px;background:#f3f4f6;padding:2px 6px;border-radius:4px;">${log.ip_address || '-'}</code></td>
                <td>
                    <button class="att-action-btn view" onclick='viewDetail(${JSON.stringify(log)})'>
                        <svg width="14" height="14" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg>
                        View
                    </button>
                </td>
            </tr>
        `;
    });
    
    tbody.innerHTML = html;
    
    // Update count
    document.getElementById('tableCount').textContent = `Showing ${data.from || 0}-${data.to || 0} of ${data.total} logs`;
}

function renderPagination(data) {
    const container = document.getElementById('paginationBtns');
    const info = document.getElementById('paginationInfo');
    
    info.textContent = `Showing ${data.from || 0}-${data.to || 0} of ${data.total} entries`;
    
    if (data.last_page <= 1) {
        container.innerHTML = '';
        return;
    }
    
    let html = '';
    
    // Previous
    html += `<button class="att-page-btn" onclick="loadLogs(${data.current_page - 1})" ${data.current_page <= 1 ? 'disabled' : ''}>‹ Prev</button>`;
    
    // Page numbers
    let startPage = Math.max(1, data.current_page - 2);
    let endPage = Math.min(data.last_page, data.current_page + 2);
    
    if (startPage > 1) {
        html += `<button class="att-page-btn" onclick="loadLogs(1)">1</button>`;
        if (startPage > 2) html += `<span style="padding:8px;">...</span>`;
    }
    
    for (let i = startPage; i <= endPage; i++) {
        html += `<button class="att-page-btn ${i === data.current_page ? 'active' : ''}" onclick="loadLogs(${i})">${i}</button>`;
    }
    
    if (endPage < data.last_page) {
        if (endPage < data.last_page - 1) html += `<span style="padding:8px;">...</span>`;
        html += `<button class="att-page-btn" onclick="loadLogs(${data.last_page})">${data.last_page}</button>`;
    }
    
    // Next
    html += `<button class="att-page-btn" onclick="loadLogs(${data.current_page + 1})" ${data.current_page >= data.last_page ? 'disabled' : ''}>Next ›</button>`;
    
    container.innerHTML = html;
}

// Open Google Maps in new tab
function openGoogleMap(lat, lng) {
    window.open('https://www.google.com/maps?q=' + lat + ',' + lng, '_blank');
}

// Detail modal
function viewDetail(log) {
    const content = document.getElementById('detailContent');
    content.innerHTML = `
        <div class="att-detail-item">
            <div class="att-detail-label">ID</div>
            <div class="att-detail-value">#${log.id}</div>
        </div>
        <div class="att-detail-item">
            <div class="att-detail-label">Staff</div>
            <div class="att-detail-value">${log.staff_name}</div>
        </div>
        <div class="att-detail-item">
            <div class="att-detail-label">Date</div>
            <div class="att-detail-value">${log.date}</div>
        </div>
        <div class="att-detail-item">
            <div class="att-detail-label">Time</div>
            <div class="att-detail-value">${log.time}</div>
        </div>
        <div class="att-detail-item">
            <div class="att-detail-label">Action</div>
            <div class="att-detail-value">${log.action_label}</div>
        </div>
        <div class="att-detail-item">
            <div class="att-detail-label">IP Address</div>
            <div class="att-detail-value">${log.ip_address || '-'}</div>
        </div>
        <div class="att-detail-item att-detail-full">
            <div class="att-detail-label">Location</div>
            <div class="att-detail-value">${log.location || '-'}</div>
        </div>
        <div class="att-detail-item">
            <div class="att-detail-label">Latitude</div>
            <div class="att-detail-value">${log.latitude || '-'}</div>
        </div>
        <div class="att-detail-item">
            <div class="att-detail-label">Longitude</div>
            <div class="att-detail-value">${log.longitude || '-'}</div>
        </div>
        <div class="att-detail-item att-detail-full">
            <div class="att-detail-label">Device Info</div>
            <div class="att-detail-value" style="font-size:12px;word-break:break-all;">${log.device_info || '-'}</div>
        </div>
        <div class="att-detail-item">
            <div class="att-detail-label">Performed By</div>
            <div class="att-detail-value">${log.performed_by}</div>
        </div>
        <div class="att-detail-item">
            <div class="att-detail-label">Notes</div>
            <div class="att-detail-value">${log.notes || '-'}</div>
        </div>
        ${log.latitude && log.longitude ? `
        <div class="att-detail-item att-detail-full" style="padding-top:12px;">
            <a href="https://www.google.com/maps?q=${log.latitude},${log.longitude}" target="_blank" class="att-action-btn view" style="width:100%;justify-content:center;padding:10px;text-decoration:none;">
                <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                Open in Google Maps
            </a>
        </div>
        ` : ''}
    `;
    document.getElementById('detailModal').classList.add('show');
}

function closeDetailModal() {
    document.getElementById('detailModal').classList.remove('show');
}

// Event listeners
document.querySelectorAll('.att-filter-tab').forEach(tab => {
    tab.addEventListener('click', function() {
        document.querySelectorAll('.att-filter-tab').forEach(t => t.classList.remove('active'));
        this.classList.add('active');
        currentFilter = this.dataset.filter;
        loadLogs(1);
    });
});

document.getElementById('staffFilter').addEventListener('change', () => loadLogs(1));
document.getElementById('fromDate').addEventListener('change', () => loadLogs(1));
document.getElementById('toDate').addEventListener('change', () => loadLogs(1));
document.getElementById('perPage').addEventListener('change', () => loadLogs(1));

let searchTimeout;
document.getElementById('searchInput').addEventListener('input', function() {
    clearTimeout(searchTimeout);
    searchTimeout = setTimeout(() => loadLogs(1), 300);
});

// Close modals on Escape
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeDetailModal();
    }
});

// Initial load
document.addEventListener('DOMContentLoaded', function() {
    loadLogs(1);
});
</script>
