<style>
.my-leaves-container { max-width: 1000px; margin: 0 auto; padding: 20px; }
.my-leaves-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
.my-leaves-title { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
.my-leaves-title svg { width: 28px; height: 28px; color: var(--primary); }
.btn-apply { 
    display: inline-flex; align-items: center; gap: 8px; 
    background: linear-gradient(135deg, var(--primary), var(--primary-hover)); color: #fff; 
    padding: 10px 20px; border-radius: 8px; text-decoration: none; 
    font-weight: 600; font-size: 14px; transition: all 0.2s; 
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}
.btn-apply:hover { transform: translateY(-2px); box-shadow: 0 6px 16px rgba(59, 130, 246, 0.4); color: #fff; }
.btn-apply svg { width: 18px; height: 18px; }

.balance-overview { 
    display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); 
    gap: 16px; margin-bottom: 24px; 
}
.balance-item { 
    background: var(--card-bg); border: 1px solid var(--card-border); 
    border-radius: 10px; padding: 16px; 
}
.balance-item-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px; }
.balance-item-name { font-size: 14px; font-weight: 600; color: var(--text-primary); }
.balance-item-code { font-size: 11px; color: var(--text-muted); background: var(--hover-bg); padding: 2px 8px; border-radius: 4px; }
.balance-item-value { font-size: 24px; font-weight: 700; color: var(--primary); }
.balance-item-detail { font-size: 12px; color: var(--text-muted); margin-top: 4px; }

.filter-tabs { display: flex; gap: 8px; margin-bottom: 20px; flex-wrap: wrap; }
.filter-tab { 
    padding: 8px 16px; background: var(--card-bg); border: 1px solid var(--card-border); 
    border-radius: 8px; font-size: 13px; font-weight: 500; color: var(--text-primary); 
    cursor: pointer; transition: all 0.2s; text-decoration: none; 
}
.filter-tab:hover { border-color: var(--primary); color: var(--primary); }
.filter-tab.active { background: var(--primary); border-color: var(--primary); color: #fff; }
.filter-tab .count { margin-left: 6px; opacity: 0.8; }

.leaves-list { display: flex; flex-direction: column; gap: 12px; }
.leave-card { 
    background: var(--card-bg); border: 1px solid var(--card-border); 
    border-radius: 10px; padding: 16px; transition: all 0.2s; 
}
.leave-card:hover { border-color: var(--primary); box-shadow: 0 4px 12px rgba(0,0,0,0.08); }
.leave-card-header { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 12px; }
.leave-card-type { font-size: 16px; font-weight: 600; color: var(--text-primary); }
.leave-card-code { font-size: 12px; color: var(--text-muted); margin-left: 8px; }
.leave-card-status { padding: 4px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; }
.status-new { background: rgba(245, 158, 11, 0.15); color: #f59e0b; }
.status-approved { background: rgba(16, 185, 129, 0.15); color: #10b981; }
.status-rejected { background: rgba(239, 68, 68, 0.15); color: #ef4444; }

.leave-card-body { display: flex; gap: 24px; flex-wrap: wrap; }
.leave-card-info { }
.leave-card-label { font-size: 11px; color: var(--text-muted); text-transform: uppercase; margin-bottom: 2px; }
.leave-card-value { font-size: 14px; color: var(--text-primary); font-weight: 500; }

.leave-card-footer { 
    margin-top: 12px; padding-top: 12px; border-top: 1px solid var(--card-border); 
    display: flex; justify-content: space-between; align-items: center; 
}
.leave-card-reason { font-size: 13px; color: var(--text-muted); flex: 1; }
.leave-card-date { font-size: 12px; color: var(--text-muted); }

.empty-state { 
    text-align: center; padding: 60px 20px; 
    background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 10px; 
}
.empty-state svg { width: 64px; height: 64px; color: var(--text-muted); margin-bottom: 16px; }
.empty-state-title { font-size: 18px; font-weight: 600; color: var(--text-primary); margin-bottom: 8px; }
.empty-state-text { font-size: 14px; color: var(--text-muted); margin-bottom: 20px; }

@media (max-width: 600px) {
    .my-leaves-header { flex-direction: column; align-items: flex-start; }
    .btn-apply { width: 100%; justify-content: center; }
}
</style>

<div class="my-leaves-container">
    <div class="my-leaves-header">
        <h1 class="my-leaves-title">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
            </svg>
            My Leaves
        </h1>
        @if(empty($noShift))
        <a href="{{ route('admin.attendance.leave.create') }}" class="btn-apply">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 4v16m8-8H4"/></svg>
            Apply for Leave
        </a>
        @endif
    </div>

    {{-- No Shift Warning --}}
    @if(!empty($noShift))
    <div class="empty-state">
        <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
        </svg>
        <div class="empty-state-title">No Shift Assigned</div>
        <div class="empty-state-text">You do not have an active shift assigned yet. Please contact your administrator to get a shift assigned before applying for leave.</div>
    </div>
    @else

    {{-- Monthly Leave Balance Overview --}}
    @if(!empty($leaveBalances) && count($leaveBalances) > 0)
    <div class="balance-overview">
        @foreach($leaveBalances as $balance)
        <div class="balance-item" style="{{ $balance->remaining <= 0 && $balance->monthly_limit > 0 ? 'border-color: #f59e0b;' : '' }}">
            <div class="balance-item-header">
                <span class="balance-item-name">{{ $balance->leaveType->name ?? 'Unknown' }}</span>
                @if($balance->leaveType && $balance->leaveType->code)
                <span class="balance-item-code">{{ $balance->leaveType->code }}</span>
                @endif
            </div>
            <div class="balance-item-value" style="{{ $balance->remaining <= 0 && $balance->monthly_limit > 0 ? 'color: #f59e0b;' : '' }}">
                {{ number_format($balance->remaining, 1) }}
            </div>
            <div class="balance-item-detail">
                {{ $balance->used_this_month }} used of {{ $balance->monthly_limit }} days/month
            </div>
        </div>
        @endforeach
    </div>
    @endif

    {{-- Filter Tabs --}}
    <div class="filter-tabs">
        <a href="{{ route('admin.attendance.my_leaves') }}" class="filter-tab {{ $currentStatus == 'all' ? 'active' : '' }}">
            All<span class="count">({{ $stats['total'] ?? 0 }})</span>
        </a>
        <a href="{{ route('admin.attendance.my_leaves', ['status' => 'new']) }}" class="filter-tab {{ $currentStatus == 'new' ? 'active' : '' }}">
            Pending<span class="count">({{ $stats['new'] ?? 0 }})</span>
        </a>
        <a href="{{ route('admin.attendance.my_leaves', ['status' => 'approved']) }}" class="filter-tab {{ $currentStatus == 'approved' ? 'active' : '' }}">
            Approved<span class="count">({{ $stats['approved'] ?? 0 }})</span>
        </a>
        <a href="{{ route('admin.attendance.my_leaves', ['status' => 'rejected']) }}" class="filter-tab {{ $currentStatus == 'rejected' ? 'active' : '' }}">
            Rejected<span class="count">({{ $stats['rejected'] ?? 0 }})</span>
        </a>
    </div>

    {{-- Leaves List --}}
    @if(isset($leaves) && $leaves->count() > 0)
    <div class="leaves-list">
        @foreach($leaves as $leave)
        <div class="leave-card">
            <div class="leave-card-header">
                <div>
                    <span class="leave-card-type">{{ $leave->leaveType->name ?? 'Leave' }}</span>
                    @if($leave->leaveType && $leave->leaveType->code)
                    <span class="leave-card-code">({{ $leave->leaveType->code }})</span>
                    @endif
                </div>
                <span class="leave-card-status status-{{ $leave->status }}">
                    {{ ucfirst($leave->status) }}
                </span>
            </div>
            <div class="leave-card-body">
                <div class="leave-card-info">
                    <div class="leave-card-label">Duration</div>
                    <div class="leave-card-value">
                        {{ $leave->from_date->format('d M Y') }}
                        @if($leave->from_date->ne($leave->to_date))
                        - {{ $leave->to_date->format('d M Y') }}
                        @endif
                    </div>
                </div>
                <div class="leave-card-info">
                    <div class="leave-card-label">Days</div>
                    <div class="leave-card-value">{{ $leave->number_of_days }} day(s)</div>
                </div>
                @if($leave->approver)
                <div class="leave-card-info">
                    <div class="leave-card-label">{{ $leave->status == 'approved' ? 'Approved By' : 'Processed By' }}</div>
                    <div class="leave-card-value">{{ $leave->approver->first_name ?? '' }} {{ $leave->approver->last_name ?? '' }}</div>
                </div>
                @endif
            </div>
            @if($leave->reason || $leave->created_at)
            <div class="leave-card-footer">
                <div class="leave-card-reason">
                    @if($leave->reason)
                    📝 {{ Str::limit($leave->reason, 80) }}
                    @endif
                </div>
                <div class="leave-card-date">Applied: {{ $leave->created_at->format('d M Y') }}</div>
            </div>
            @endif
        </div>
        @endforeach
    </div>

    {{-- Pagination --}}
    @if($leaves->hasPages())
    <div style="margin-top: 20px;">
        {{ $leaves->links() }}
    </div>
    @endif

    @else
    <div class="empty-state">
        <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
        </svg>
        <div class="empty-state-title">No Leave Applications</div>
        <div class="empty-state-text">You haven't applied for any leave yet.</div>
        <a href="{{ route('admin.attendance.leave.create') }}" class="btn-apply">
            <svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M12 4v16m8-8H4"/></svg>
            Apply for Leave
        </a>
    </div>
    @endif
    
    @endif {{-- End noShift check --}}
</div>
