<div>
<div wire:poll.10s>
    {{-- Filters --}}
    <div style="display:flex;flex-wrap:wrap;gap:12px;margin-bottom:20px;align-items:flex-end;">
        {{-- Month Selector --}}
        <div>
            <label style="display:block;font-size:12px;font-weight:600;color:var(--text-muted);margin-bottom:4px;">Month</label>
            <div style="display:flex;align-items:center;gap:4px;">
                <button wire:click="previousMonth" style="padding:8px 12px;border:1px solid var(--input-border);border-radius:6px;background:var(--card-bg);cursor:pointer;">
                    <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M15 19l-7-7 7-7"/></svg>
                </button>
                <input type="month" wire:model.live="month" style="padding:8px 12px;border:1px solid var(--input-border);border-radius:6px;font-size:14px;background:var(--input-bg);color:var(--text-primary);">
                <button wire:click="nextMonth" style="padding:8px 12px;border:1px solid var(--input-border);border-radius:6px;background:var(--card-bg);cursor:pointer;">
                    <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M9 5l7 7-7 7"/></svg>
                </button>
            </div>
        </div>
        
        {{-- Department --}}
        @if(count($departments) > 0)
        <div>
            <label style="display:block;font-size:12px;font-weight:600;color:var(--text-muted);margin-bottom:4px;">Department</label>
            <select wire:model.live="departmentId" style="padding:8px 12px;border:1px solid var(--input-border);border-radius:6px;font-size:14px;background:var(--input-bg);color:var(--text-primary);min-width:150px;">
                <option value="">All Departments</option>
                @foreach($departments as $dept)
                <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                @endforeach
            </select>
        </div>
        @endif
        
        {{-- Role --}}
        @if(count($roles) > 0)
        <div>
            <label style="display:block;font-size:12px;font-weight:600;color:var(--text-muted);margin-bottom:4px;">Role</label>
            <select wire:model.live="roleFilter" style="padding:8px 12px;border:1px solid var(--input-border);border-radius:6px;font-size:14px;background:var(--input-bg);color:var(--text-primary);min-width:150px;">
                <option value="">All Roles</option>
                @foreach($roles as $role)
                <option value="{{ $role['name'] }}">{{ ucfirst($role['name']) }}</option>
                @endforeach
            </select>
        </div>
        @endif
        
        {{-- Staff --}}
        <div>
            <label style="display:block;font-size:12px;font-weight:600;color:var(--text-muted);margin-bottom:4px;">Staff</label>
            <select wire:model.live="staffFilter" style="padding:8px 12px;border:1px solid var(--input-border);border-radius:6px;font-size:14px;background:var(--input-bg);color:var(--text-primary);min-width:150px;">
                <option value="">All Staff</option>
                @foreach($allStaff as $s)
                <option value="{{ $s['id'] }}">{{ $s['first_name'] }} {{ $s['last_name'] }}</option>
                @endforeach
            </select>
        </div>
        
        {{-- Loading indicator --}}
        <div wire:loading style="padding:8px;">
            <svg width="20" height="20" viewBox="0 0 24 24" style="animation:spin 1s linear infinite;">
                <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2" fill="none" stroke-dasharray="30 70"></circle>
            </svg>
        </div>
    </div>

    {{-- Legend --}}
    <div style="display:flex;flex-wrap:wrap;gap:16px;margin-bottom:16px;padding:12px;background:var(--hover-bg);border-radius:8px;">
        <div style="display:flex;align-items:center;gap:6px;font-size:12px;">
            <span class="att-status P" style="width:auto;padding:2px 8px;">P</span>
            <span>Present</span>
        </div>
        <div style="display:flex;align-items:center;gap:6px;font-size:12px;">
            <span class="att-status W" style="width:auto;padding:2px 8px;">W:8</span>
            <span>Worked (hours)</span>
        </div>
        <div style="display:flex;align-items:center;gap:6px;font-size:12px;">
            <span class="att-status A" style="width:auto;padding:2px 8px;">A</span>
            <span>Absent</span>
        </div>
        <div style="display:flex;align-items:center;gap:6px;font-size:12px;">
            <span class="att-status L" style="width:auto;padding:2px 8px;">L</span>
            <span>Leave</span>
        </div>
        <div style="display:flex;align-items:center;gap:6px;font-size:12px;">
            <span class="att-status H" style="width:auto;padding:2px 8px;">H</span>
            <span>Holiday</span>
        </div>
        <div style="display:flex;align-items:center;gap:6px;font-size:12px;">
            <span class="att-status OFF" style="width:auto;padding:2px 8px;">OFF</span>
            <span>Day Off</span>
        </div>
        <div style="display:flex;align-items:center;gap:6px;font-size:12px;">
            <span class="att-status NS" style="width:auto;padding:2px 8px;">NS</span>
            <span>No Shift</span>
        </div>
    </div>

    {{-- Table --}}
    <div style="overflow-x:auto;border:1px solid var(--card-border);border-radius:8px;">
        <table class="att-table">
            <thead>
                <tr>
                    <th style="position:sticky;left:0;z-index:2;background:var(--table-header-bg,#f9fafb);">#</th>
                    <th style="position:sticky;left:40px;z-index:2;background:var(--table-header-bg,#f9fafb);min-width:150px;">Staff</th>
                    @for($day = 1; $day <= $this->daysInMonth; $day++)
                        @php
                            $date = $this->startDate->copy()->addDays($day - 1);
                            $isToday = $date->isToday();
                            $isWeekend = $date->isWeekend();
                        @endphp
                        <th style="{{ $isToday ? 'background:#dbeafe;' : ($isWeekend ? 'background:#f3f4f6;' : '') }}">
                            <div style="font-size:10px;color:var(--text-muted);">{{ $date->format('D') }}</div>
                            <div>{{ str_pad($day, 2, '0', STR_PAD_LEFT) }}</div>
                        </th>
                    @endfor
                </tr>
            </thead>
            <tbody>
                @forelse($this->staffList as $index => $staff)
                    <tr>
                        <td style="position:sticky;left:0;background:var(--card-bg,#fff);z-index:1;">{{ $index + 1 }}</td>
                        <td style="position:sticky;left:40px;background:var(--card-bg,#fff);z-index:1;white-space:nowrap;">
                            <div style="display:flex;align-items:center;gap:8px;">
                                <div style="width:28px;height:28px;border-radius:50%;background:var(--primary,#3b82f6);color:#fff;display:flex;align-items:center;justify-content:center;font-size:11px;font-weight:600;">
                                    {{ strtoupper(substr($staff->first_name, 0, 1) . substr($staff->last_name, 0, 1)) }}
                                </div>
                                <span style="font-size:13px;">{{ $staff->first_name }} {{ $staff->last_name }}</span>
                            </div>
                        </td>
                        @for($day = 1; $day <= $this->daysInMonth; $day++)
                            @php
                                $date = $this->startDate->copy()->addDays($day - 1);
                                $status = $this->getStatusForDay($staff->id, $date);
                                $isToday = $date->isToday();
                            @endphp
                            <td style="{{ $isToday ? 'background:#eff6ff;' : '' }}" title="{{ $status['title'] }}">
                                @if($status['value'])
                                    <span class="att-status {{ $status['class'] }}" 
                                          style="cursor:pointer;" 
                                          onclick="showDayDetail({{ $staff->id }}, '{{ $date->format('Y-m-d') }}', '{{ $staff->first_name }} {{ $staff->last_name }}', '{{ $date->format('D, d M Y') }}')">
                                        {{ $status['value'] }}
                                    </span>
                                @endif
                            </td>
                        @endfor
                    </tr>
                @empty
                    <tr>
                        <td colspan="{{ $this->daysInMonth + 2 }}" style="text-align:center;padding:40px;color:var(--text-muted);">
                            No staff found. Please assign shifts to staff first.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

<style>
@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

.att-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 13px;
}

.att-table th, .att-table td {
    padding: 8px 6px;
    text-align: center;
    border-bottom: 1px solid var(--card-border, #e5e7eb);
    min-width: 45px;
}

.att-table th {
    background: var(--table-header-bg, #f9fafb);
    font-weight: 600;
    font-size: 12px;
}

.att-table tbody tr:hover {
    background: var(--hover-bg, #f8fafc);
}

.att-status {
    display: inline-block;
    padding: 2px 6px;
    border-radius: 4px;
    font-size: 11px;
    font-weight: 600;
}

.att-status.P { background: #dbeafe; color: #1e40af; }
.att-status.W { background: #dcfce7; color: #166534; }
.att-status.A { background: #fee2e2; color: #991b1b; }
.att-status.L { background: #fef3c7; color: #92400e; }
.att-status.H { background: #f3e8ff; color: #7c3aed; }
.att-status.OFF { background: #f3f4f6; color: #6b7280; }
.att-status.NS { background: #f9fafb; color: #9ca3af; font-style: italic; }

.att-status:hover { opacity: 0.8; transform: scale(1.05); }
</style>

{{-- Day Detail Modal --}}
<div id="dayDetailModal" style="position:fixed;inset:0;background:rgba(0,0,0,.5);z-index:9999;display:none;align-items:center;justify-content:center;padding:20px;" onclick="if(event.target===this)this.style.display='none'">
<div style="background:var(--card-bg,#fff);border-radius:12px;width:100%;max-width:450px;box-shadow:0 20px 60px rgba(0,0,0,0.3);max-height:90vh;overflow:hidden;display:flex;flex-direction:column;">
    
    {{-- Header --}}
    <div style="padding:16px 20px;border-bottom:1px solid var(--card-border,#e5e7eb);display:flex;justify-content:space-between;align-items:center;">
        <div>
            <h3 id="modalStaffName" style="margin:0;font-size:16px;font-weight:600;color:var(--text-primary,#1f2937);">Staff Name</h3>
            <div id="modalDate" style="font-size:12px;color:var(--text-muted);">Date</div>
        </div>
        <button onclick="document.getElementById('dayDetailModal').style.display='none'" style="background:none;border:none;cursor:pointer;color:var(--text-muted);font-size:24px;line-height:1;">&times;</button>
    </div>
    
    {{-- Content --}}
    <div id="modalContent" style="flex:1;overflow-y:auto;padding:20px;">
        <div style="text-align:center;padding:40px;color:var(--text-muted);">
            <svg width="32" height="32" viewBox="0 0 24 24" style="animation:spin 1s linear infinite;margin-bottom:10px;">
                <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2" fill="none" stroke-dasharray="30 70"></circle>
            </svg>
            <div>Loading...</div>
        </div>
    </div>
</div>
</div>

<script>
function showDayDetail(staffId, date, staffName, dateFormatted) {
    const modal = document.getElementById('dayDetailModal');
    const content = document.getElementById('modalContent');
    
    document.getElementById('modalStaffName').textContent = staffName;
    document.getElementById('modalDate').textContent = dateFormatted;
    
    content.innerHTML = `
        <div style="text-align:center;padding:40px;color:var(--text-muted);">
            <svg width="32" height="32" viewBox="0 0 24 24" style="animation:spin 1s linear infinite;margin-bottom:10px;">
                <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2" fill="none" stroke-dasharray="30 70"></circle>
            </svg>
            <div>Loading...</div>
        </div>
    `;
    
    modal.style.display = 'flex';
    
    // Fetch data via AJAX
    fetch(`{{ url('admin/attendance/day-detail') }}/${staffId}/${date}`)
        .then(res => res.json())
        .then(data => {
            if (data.logs && data.logs.length > 0) {
                let html = `
                    <div style="display:flex;gap:10px;margin-bottom:20px;">
                        <div style="flex:1;background:#dcfce7;border-radius:8px;padding:12px;text-align:center;">
                            <div style="font-size:20px;font-weight:700;color:#166534;">${data.worked_time}</div>
                            <div style="font-size:11px;color:#166534;">Worked</div>
                        </div>
                        <div style="flex:1;background:#fef3c7;border-radius:8px;padding:12px;text-align:center;">
                            <div style="font-size:20px;font-weight:700;color:#92400e;">${data.break_time}</div>
                            <div style="font-size:11px;color:#92400e;">Break</div>
                        </div>
                        <div style="flex:1;background:#dbeafe;border-radius:8px;padding:12px;text-align:center;">
                            <div style="font-size:20px;font-weight:700;color:#1e40af;">${data.logs.length}</div>
                            <div style="font-size:11px;color:#1e40af;">Entries</div>
                        </div>
                    </div>
                    <div style="font-size:12px;font-weight:600;color:var(--text-muted);margin-bottom:10px;text-transform:uppercase;">Time Log</div>
                `;
                
                data.logs.forEach((log, i) => {
                    const isIn = log.action === 'check_in';
                    html += `
                        <div style="display:flex;align-items:flex-start;padding:10px 0;border-bottom:1px solid var(--card-border,#e5e7eb);${i === data.logs.length - 1 ? 'border-bottom:none;' : ''}">
                            <div style="width:32px;height:32px;border-radius:50%;background:${isIn ? '#dcfce7' : '#fee2e2'};display:flex;align-items:center;justify-content:center;margin-right:12px;flex-shrink:0;">
                                ${isIn ? 
                                    '<svg width="14" height="14" fill="none" stroke="#166534" stroke-width="2" viewBox="0 0 24 24"><path d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"/></svg>' : 
                                    '<svg width="14" height="14" fill="none" stroke="#991b1b" stroke-width="2" viewBox="0 0 24 24"><path d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/></svg>'
                                }
                            </div>
                            <div style="flex:1;min-width:0;">
                                <div style="font-size:14px;font-weight:600;color:var(--text-primary,#1f2937);">${log.time}</div>
                                <div style="font-size:11px;color:var(--text-muted);">${isIn ? 'Check In' : 'Check Out'}</div>
                                ${log.location ? `<div style="font-size:10px;color:var(--text-muted);margin-top:2px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;">📍 ${log.location}</div>` : ''}
                            </div>
                            ${log.duration ? `<div style="font-size:13px;font-weight:600;color:#166534;background:#dcfce7;padding:4px 8px;border-radius:4px;flex-shrink:0;">${log.duration}</div>` : ''}
                        </div>
                    `;
                });
                
                // First check-in and last check-out
                html += `
                    <div style="margin-top:16px;padding-top:16px;border-top:1px solid var(--card-border,#e5e7eb);">
                        <div style="display:flex;justify-content:space-between;font-size:12px;color:var(--text-muted);margin-bottom:4px;">
                            <span>First In:</span><span style="font-weight:600;color:var(--text-primary);">${data.first_in || '-'}</span>
                        </div>
                        <div style="display:flex;justify-content:space-between;font-size:12px;color:var(--text-muted);">
                            <span>Last Out:</span><span style="font-weight:600;color:var(--text-primary);">${data.last_out || '-'}</span>
                        </div>
                    </div>
                `;
                
                content.innerHTML = html;
            } else if (data.status) {
                content.innerHTML = `
                    <div style="text-align:center;padding:40px;">
                        <div style="font-size:48px;margin-bottom:16px;">${data.icon || '📋'}</div>
                        <div style="font-size:16px;font-weight:600;color:var(--text-primary);margin-bottom:4px;">${data.status}</div>
                        <div style="font-size:13px;color:var(--text-muted);">${data.message || ''}</div>
                    </div>
                `;
            } else {
                content.innerHTML = `
                    <div style="text-align:center;padding:40px;color:var(--text-muted);">
                        <div style="font-size:48px;margin-bottom:16px;">📭</div>
                        <div>No attendance records for this day</div>
                    </div>
                `;
            }
        })
        .catch(err => {
            content.innerHTML = `
                <div style="text-align:center;padding:40px;color:#991b1b;">
                    <div style="font-size:48px;margin-bottom:16px;">❌</div>
                    <div>Error loading data</div>
                </div>
            `;
        });
}

// Close on Escape
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        document.getElementById('dayDetailModal').style.display = 'none';
    }
});
</script>
</div>