<div>
    <div wire:poll.5s>
        {{-- Staff Selector (for admins) --}}
        @if($canMarkOthers && count($staffList) > 0)
        <div style="margin-bottom:16px;">
            <select wire:model.live="selectedStaffId" style="width:100%;padding:10px 14px;border:1px solid var(--input-border,#e5e7eb);border-radius:8px;font-size:14px;background:var(--input-bg,#fff);color:var(--text-primary,#1f2937);">
                <option value="self">{{ $this->staff ? $this->staff->first_name . ' ' . $this->staff->last_name . ' (Me)' : 'Select Staff' }}</option>
                @foreach($staffList as $s)
                    @if(!$this->staff || $s['id'] != $this->staff->id)
                    <option value="{{ $s['id'] }}">{{ $s['first_name'] }} {{ $s['last_name'] }}</option>
                    @endif
                @endforeach
            </select>
        </div>
        @else
        <div style="font-size:14px;color:var(--text-primary,#1f2937);font-weight:600;margin-bottom:12px;text-align:center;">
            {{ $this->staff ? $this->staff->first_name . ' ' . $this->staff->last_name : 'Unknown' }}
        </div>
        @endif

        {{-- Live Clock --}}
        <div style="text-align:center;margin-bottom:16px;">
            <div id="liveClock" style="font-size:32px;font-weight:700;color:var(--text-primary,#1f2937);font-family:monospace;"></div>
            <div style="background:var(--text-primary,#1f2937);color:#fff;padding:6px 14px;border-radius:6px;display:inline-block;font-size:13px;font-weight:600;margin-top:8px;">
                {{ now()->format('D, d M Y') }}
            </div>
        </div>

        {{-- No Shift Warning --}}
        @if($this->effectiveStaffId && !$this->hasShift)
        <div style="background:#fef2f2;border:1px solid #fecaca;border-radius:8px;padding:12px;margin-bottom:16px;font-size:13px;color:#991b1b;text-align:center;">
            <strong>⚠️ No shift assigned!</strong><br>
            <span style="font-size:12px;">Contact admin to assign a shift.</span>
        </div>
        @endif

        {{-- Message --}}
        @if($message)
        <div style="background:{{ $messageType === 'success' ? '#f0fdf4' : '#fef2f2' }};border:1px solid {{ $messageType === 'success' ? '#bbf7d0' : '#fecaca' }};border-radius:8px;padding:10px;margin-bottom:16px;font-size:13px;color:{{ $messageType === 'success' ? '#166534' : '#991b1b' }};text-align:center;">
            {{ $message }}
        </div>
        @endif

        {{-- Today's Summary --}}
        @if($this->todayLogs->isNotEmpty())
        <div style="background:var(--hover-bg,#f8fafc);border-radius:8px;padding:12px;margin-bottom:16px;">
            <div style="display:flex;justify-content:space-around;text-align:center;margin-bottom:12px;">
                <div>
                    <div style="font-size:20px;font-weight:700;color:#10b981;">{{ $this->formattedWorkedTime }}</div>
                    <div style="font-size:11px;color:var(--text-muted);">Worked</div>
                </div>
                <div>
                    <div style="font-size:20px;font-weight:700;color:#f59e0b;">{{ $this->formattedBreakTime }}</div>
                    <div style="font-size:11px;color:var(--text-muted);">Break</div>
                </div>
                <div>
                    <div style="font-size:20px;font-weight:700;color:#3b82f6;">{{ $this->todayLogs->count() }}</div>
                    <div style="font-size:11px;color:var(--text-muted);">Entries</div>
                </div>
            </div>
            
            {{-- Current Status --}}
            @if($this->isCurrentlyCheckedIn)
            <div style="background:#dcfce7;border-radius:6px;padding:8px;text-align:center;font-size:12px;color:#166534;">
                <span style="display:inline-block;width:8px;height:8px;background:#10b981;border-radius:50%;margin-right:6px;animation:pulse 1.5s infinite;"></span>
                Currently working since {{ $this->currentSessionStart->format('h:i A') }}
            </div>
            @else
            <div style="background:#fef3c7;border-radius:6px;padding:8px;text-align:center;font-size:12px;color:#92400e;">
                On break / Not working
            </div>
            @endif
        </div>

        {{-- Today's Log --}}
        <div style="max-height:200px;overflow-y:auto;margin-bottom:16px;">
            <div style="font-size:11px;font-weight:600;color:var(--text-muted);margin-bottom:8px;text-transform:uppercase;">Today's Log</div>
            @php
                $logs = $this->todayLogs;
                $lastCheckIn = null;
            @endphp
            @foreach($logs as $index => $log)
                @php
                    $time = \Carbon\Carbon::parse($log->action_time);
                    $duration = '';
                    if ($log->action === 'check_in') {
                        $lastCheckIn = $time;
                    } elseif ($log->action === 'check_out' && $lastCheckIn) {
                        $mins = $lastCheckIn->diffInMinutes($time);
                        $duration = sprintf('%dh %02dm', floor($mins/60), $mins%60);
                        $lastCheckIn = null;
                    }
                @endphp
                <div style="display:flex;align-items:center;padding:8px 0;border-bottom:1px solid var(--card-border,#e5e7eb);{{ $index === $logs->count() - 1 ? 'border-bottom:none;' : '' }}">
                    <div style="width:24px;height:24px;border-radius:50%;background:{{ $log->action === 'check_in' ? '#dcfce7' : '#fee2e2' }};display:flex;align-items:center;justify-content:center;margin-right:10px;">
                        @if($log->action === 'check_in')
                        <svg width="12" height="12" fill="none" stroke="#166534" stroke-width="2" viewBox="0 0 24 24"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                        @else
                        <svg width="12" height="12" fill="none" stroke="#991b1b" stroke-width="2" viewBox="0 0 24 24"><path d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/></svg>
                        @endif
                    </div>
                    <div style="flex:1;">
                        <div style="font-size:13px;font-weight:500;color:var(--text-primary);">
                            {{ $time->format('h:i A') }}
                            <span style="font-size:11px;color:var(--text-muted);margin-left:4px;">{{ $log->action === 'check_in' ? 'IN' : 'OUT' }}</span>
                        </div>
                        @if($log->location)
                        <div style="font-size:10px;color:var(--text-muted);">📍 {{ Str::limit($log->location, 40) }}</div>
                        @endif
                    </div>
                    @if($duration)
                    <div style="font-size:12px;font-weight:600;color:#10b981;">{{ $duration }}</div>
                    @endif
                </div>
            @endforeach
        </div>
        @endif

        {{-- Location Status --}}
        <div id="locationBox" style="background:{{ $latitude ? '#f0fdf4' : '#fef3c7' }};border:1px solid {{ $latitude ? '#bbf7d0' : '#fcd34d' }};border-radius:8px;padding:10px 12px;margin-bottom:16px;font-size:12px;color:{{ $latitude ? '#166534' : '#92400e' }};text-align:center;">
            @if($latitude)
                <svg width="14" height="14" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="display:inline;vertical-align:middle;"><path d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                📍 {{ $locationText ?: $latitude . ', ' . $longitude }}
            @else
                <span id="locationStatus">📍 Click "Get Location" to enable</span>
            @endif
        </div>
        
        {{-- Get Location Button --}}
        @if(!$latitude)
        <div style="text-align:center;margin-bottom:16px;">
            <button type="button" onclick="requestLocation()" style="padding:10px 20px;background:#3b82f6;color:#fff;border:none;border-radius:8px;font-size:13px;font-weight:600;cursor:pointer;">
                📍 Get My Location
            </button>
        </div>
        @endif

        {{-- Action Buttons --}}
        <div style="display:flex;gap:10px;">
            <button 
                wire:click="checkIn" 
                wire:loading.attr="disabled"
                wire:loading.class="opacity-50"
                @if(!$this->hasShift || $this->isCurrentlyCheckedIn || !$latitude) disabled @endif
                style="flex:1;padding:14px;border-radius:8px;font-size:14px;font-weight:600;cursor:pointer;border:none;background:#10b981;color:#fff;{{ (!$this->hasShift || $this->isCurrentlyCheckedIn || !$latitude) ? 'opacity:0.5;cursor:not-allowed;' : '' }}"
            >
                <span wire:loading.remove wire:target="checkIn">
                    <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="display:inline;vertical-align:middle;margin-right:4px;"><path d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"/></svg>
                    Check In
                </span>
                <span wire:loading wire:target="checkIn">Processing...</span>
            </button>
            <button 
                wire:click="checkOut" 
                wire:loading.attr="disabled"
                wire:loading.class="opacity-50"
                @if(!$this->isCurrentlyCheckedIn) disabled @endif
                style="flex:1;padding:14px;border-radius:8px;font-size:14px;font-weight:600;cursor:pointer;border:none;background:#ef4444;color:#fff;{{ !$this->isCurrentlyCheckedIn ? 'opacity:0.5;cursor:not-allowed;' : '' }}"
            >
                <span wire:loading.remove wire:target="checkOut">
                    <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="display:inline;vertical-align:middle;margin-right:4px;"><path d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/></svg>
                    Check Out
                </span>
                <span wire:loading wire:target="checkOut">Processing...</span>
            </button>
        </div>
    </div>

    <style>
    @keyframes pulse {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.5; }
    }
    </style>

    <script>
    function updateClock() {
        var now = new Date();
        var h = now.getHours();
        var m = now.getMinutes();
        var s = now.getSeconds();
        var ampm = h >= 12 ? 'PM' : 'AM';
        h = h % 12 || 12;
        var clockEl = document.getElementById('liveClock');
        if (clockEl) {
            clockEl.textContent = (h < 10 ? '0' : '') + h + ':' + (m < 10 ? '0' : '') + m + ':' + (s < 10 ? '0' : '') + s + ' ' + ampm;
        }
    }
    setInterval(updateClock, 1000);
    updateClock();

    function requestLocation() {
        var statusEl = document.getElementById('locationStatus');
        var boxEl = document.getElementById('locationBox');
        if (!navigator.geolocation) {
            if (statusEl) statusEl.textContent = '❌ Geolocation not supported by your browser';
            return;
        }
        if (statusEl) statusEl.textContent = '⏳ Getting location...';
        navigator.geolocation.getCurrentPosition(
            function(pos) {
                var lat = pos.coords.latitude;
                var lng = pos.coords.longitude;
                var coordsText = lat.toFixed(6) + ', ' + lng.toFixed(6);
                @this.call('locationCaptured', lat, lng, coordsText);
            },
            function(err) {
                var msg = '❌ ';
                if (err.code === 1) msg += 'Location permission denied. Please enable in browser settings.';
                else if (err.code === 2) msg += 'Location unavailable.';
                else msg += 'Location timeout. Please try again.';
                if (statusEl) statusEl.textContent = msg;
                if (boxEl) {
                    boxEl.style.background = '#fef2f2';
                    boxEl.style.borderColor = '#fecaca';
                    boxEl.style.color = '#991b1b';
                }
            },
            { enableHighAccuracy: true, timeout: 15000, maximumAge: 0 }
        );
    }

    document.addEventListener('DOMContentLoaded', function() {
        updateClock();
    });
    </script>
</div>