{{-- Navbar Check-in Button & Modal --}}
@php
    $admin = auth('admin')->user();
    $staff = $admin ? \App\Models\Admin\Staff::where('admin_id', $admin->id)->first() : null;
    $todayRecord = null;
    $isCurrentlyIn = false;
    
    if ($staff) {
        $todayRecord = \Modules\Attendance\Models\Attendance::where('staff_id', $staff->id)
            ->whereDate('attendance_date', today())
            ->first();
        
        if ($todayRecord) {
            $lastLog = \Modules\Attendance\Models\AttendanceLog::where('attendance_id', $todayRecord->id)
                ->whereIn('action', ['check_in', 'check_out'])
                ->orderBy('action_time', 'desc')
                ->first();
            $isCurrentlyIn = $lastLog && $lastLog->action === 'check_in';
        }
    }
    
    // Get leave types
    $leaveTypes = \Modules\Attendance\Models\LeaveType::where('status', true)->orderBy('name')->get();
@endphp

{{-- Clock Icon Button --}}
<button type="button" onclick="document.getElementById('attHubModal').style.display='flex'" class="nav-btn" title="My Attendance" style="position:relative;color:{{ $isCurrentlyIn ? '#10b981' : 'inherit' }};">
    <svg width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10"/><path d="M12 6v6l4 2"/></svg>
    @if($isCurrentlyIn)
    <span style="position:absolute;top:-2px;right:-2px;width:8px;height:8px;background:#10b981;border-radius:50%;border:2px solid var(--card-bg,#fff);animation:pulse 1.5s infinite;"></span>
    @endif
</button>

{{-- Modal --}}
<div id="attHubModal" style="position:fixed;inset:0;background:rgba(0,0,0,.5);z-index:9999;display:none;align-items:center;justify-content:center;padding:20px;" onclick="if(event.target===this)this.style.display='none'">
<div style="background:var(--card-bg,#fff);border-radius:12px;width:100%;max-width:420px;box-shadow:0 20px 60px rgba(0,0,0,0.3);max-height:90vh;overflow:hidden;display:flex;flex-direction:column;">
    
    {{-- Header --}}
    <div style="padding:16px 20px;border-bottom:1px solid var(--card-border,#e5e7eb);display:flex;justify-content:space-between;align-items:center;flex-shrink:0;">
        <h3 style="margin:0;font-size:16px;font-weight:600;color:var(--text-primary,#1f2937);">My Attendance</h3>
        <button onclick="document.getElementById('attHubModal').style.display='none'" style="background:none;border:none;cursor:pointer;color:var(--text-muted,#9ca3af);font-size:24px;line-height:1;">&times;</button>
    </div>
    
    {{-- Tabs --}}
    <div style="display:flex;border-bottom:1px solid var(--card-border,#e5e7eb);flex-shrink:0;">
        <button onclick="showAttTab('checkin')" class="att-hub-tab active" data-tab="checkin" style="flex:1;padding:12px;font-size:11px;font-weight:600;border:none;background:none;cursor:pointer;color:var(--text-muted);border-bottom:2px solid transparent;">
            Check In
        </button>
        <button onclick="window.location='{{ route('admin.attendance.my') }}'" class="att-hub-tab" style="flex:1;padding:12px;font-size:11px;font-weight:600;border:none;background:none;cursor:pointer;color:var(--text-muted);border-bottom:2px solid transparent;">
            My Records
        </button>
        <button onclick="showAttTab('leave')" class="att-hub-tab" data-tab="leave" style="flex:1;padding:12px;font-size:11px;font-weight:600;border:none;background:none;cursor:pointer;color:var(--text-muted);border-bottom:2px solid transparent;">
            Leave
        </button>
        <button onclick="showAttTab('extra')" class="att-hub-tab" data-tab="extra" style="flex:1;padding:12px;font-size:11px;font-weight:600;border:none;background:none;cursor:pointer;color:var(--text-muted);border-bottom:2px solid transparent;">
            Extra Hours
        </button>
    </div>
    
    {{-- Tab Content --}}
    <div style="flex:1;overflow-y:auto;">
        
        {{-- CHECK IN/OUT TAB (Livewire) --}}
        <div id="attTabCheckin" class="att-hub-content" style="padding:20px;">
            @livewire('attendance::check-in-out')
        </div>
        
        {{-- APPLY LEAVE TAB --}}
        <div id="attTabLeave" class="att-hub-content" style="padding:20px;display:none;">
            <form action="{{ route('admin.attendance.leave.store') }}" method="POST">
                @csrf
                
                <div style="margin-bottom:16px;">
                    <label style="display:block;font-size:12px;font-weight:600;color:var(--text-muted);margin-bottom:6px;">Leave Type <span style="color:#ef4444;">*</span></label>
                    <select name="leave_type_id" required style="width:100%;padding:10px 12px;border:1px solid var(--input-border,#e5e7eb);border-radius:8px;font-size:14px;background:var(--input-bg,#fff);color:var(--text-primary,#1f2937);">
                        @if($leaveTypes->isEmpty())
                        <option value="">No leave types available</option>
                        @else
                        @foreach($leaveTypes as $lt)
                        <option value="{{ $lt->id }}">{{ $lt->name }}{{ $lt->code ? ' ('.$lt->code.')' : '' }}</option>
                        @endforeach
                        @endif
                    </select>
                </div>
                
                <div style="display:grid;grid-template-columns:1fr 1fr;gap:12px;margin-bottom:16px;">
                    <div>
                        <label style="display:block;font-size:12px;font-weight:600;color:var(--text-muted);margin-bottom:6px;">From <span style="color:#ef4444;">*</span></label>
                        <input type="date" name="from_date" value="{{ date('Y-m-d') }}" required style="width:100%;padding:10px 12px;border:1px solid var(--input-border,#e5e7eb);border-radius:8px;font-size:14px;background:var(--input-bg,#fff);color:var(--text-primary,#1f2937);">
                    </div>
                    <div>
                        <label style="display:block;font-size:12px;font-weight:600;color:var(--text-muted);margin-bottom:6px;">To <span style="color:#ef4444;">*</span></label>
                        <input type="date" name="to_date" value="{{ date('Y-m-d') }}" required style="width:100%;padding:10px 12px;border:1px solid var(--input-border,#e5e7eb);border-radius:8px;font-size:14px;background:var(--input-bg,#fff);color:var(--text-primary,#1f2937);">
                    </div>
                </div>
                
                <div style="margin-bottom:16px;">
                    <label style="display:block;font-size:12px;font-weight:600;color:var(--text-muted);margin-bottom:6px;">Reason</label>
                    <textarea name="reason" rows="2" placeholder="Optional reason..." style="width:100%;padding:10px 12px;border:1px solid var(--input-border,#e5e7eb);border-radius:8px;font-size:14px;background:var(--input-bg,#fff);color:var(--text-primary,#1f2937);resize:none;"></textarea>
                </div>
                
                <button type="submit" style="width:100%;padding:12px;border-radius:8px;font-size:14px;font-weight:600;cursor:pointer;border:none;background:#10b981;color:#fff;">
                    <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" style="display:inline;vertical-align:middle;margin-right:6px;"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                    Apply for Leave
                </button>
            </form>
        </div>
        
        {{-- EXTRA HOURS TAB (Livewire) --}}
        <div id="attTabExtra" class="att-hub-content" style="padding:20px;display:none;">
            @livewire('attendance::my-extra-hours')
        </div>
        
    </div>
</div>
</div>

<style>
.att-hub-tab.active { color: var(--primary, #3b82f6) !important; border-bottom-color: var(--primary, #3b82f6) !important; }
@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}
</style>

<script>
function showAttTab(tab) {
    document.querySelectorAll('.att-hub-tab').forEach(function(t) { t.classList.remove('active'); });
    document.querySelectorAll('.att-hub-content').forEach(function(c) { c.style.display = 'none'; });
    document.querySelector('.att-hub-tab[data-tab="'+tab+'"]').classList.add('active');
    document.getElementById('attTab' + tab.charAt(0).toUpperCase() + tab.slice(1)).style.display = 'block';
}

// Close modal on Escape
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        document.getElementById('attHubModal').style.display = 'none';
    }
});
</script>
