<style>
    .page-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; }
    .page-header h1 { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
    .page-header h1 svg { width: 28px; height: 28px; color: var(--primary); }
    
    .table-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
    .table-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); background: var(--hover-bg); }
    .table-card-title { font-size: 16px; font-weight: 600; color: var(--text-primary); }
    .table-card-body { padding: 0; overflow-x: auto; }
    
    .leave-table { width: 100%; border-collapse: collapse; min-width: 600px; }
    .leave-table th { padding: 12px 14px; text-align: left; font-size: 12px; font-weight: 600; color: var(--text-muted); text-transform: uppercase; background: var(--card-bg); border-bottom: 1px solid var(--card-border); }
    .leave-table td { padding: 10px 14px; border-bottom: 1px solid var(--card-border); vertical-align: middle; }
    .leave-table tr:hover td { background: var(--hover-bg); }
    .leave-table .col-num { width: 50px; text-align: center; color: var(--text-muted); }
    .leave-table .col-staff { font-weight: 500; color: var(--text-primary); }
    .leave-table .col-role { font-size: 12px; color: var(--text-muted); }
    .leave-table .col-input { width: 80px; }
    .leave-table .col-input input { width: 70px; padding: 6px 10px; border: 1px solid var(--input-border); border-radius: 6px; font-size: 13px; background: var(--input-bg); color: var(--text-primary); text-align: center; }
    .leave-table .col-input input:focus { outline: none; border-color: var(--primary); }
    
    .form-actions { padding: 16px 20px; border-top: 1px solid var(--card-border); display: flex; gap: 12px; }
    .btn { padding: 10px 24px; border-radius: 8px; font-weight: 600; font-size: 14px; cursor: pointer; border: none; display: inline-flex; align-items: center; gap: 8px; }
    .btn-primary { background: var(--primary); color: #fff; }
    .btn-primary:hover { background: var(--primary-hover); }
</style>

<div style="padding: 20px;">
    <div class="page-header">
        <h1>
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
            </svg>
            {{ $pageTitle ?? 'Annual Leave Settings' }}
        </h1>
    </div>

    <form action="{{ route('admin.attendance.settings.annual_leave.update') }}" method="POST">
        @csrf
        
        <div class="table-card">
            <div class="table-card-header">
                <div class="table-card-title">Annual Leave</div>
            </div>
            <div class="table-card-body">
                <table class="leave-table">
                    <thead>
                        <tr>
                            <th class="col-num">#</th>
                            <th>Staff</th>
                            <th>Role</th>
                            @foreach($leaveTypes as $lt)
                                <th class="col-input">{{ $lt->name }}</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($staffList as $index => $staff)
                            <tr>
                                <td class="col-num">{{ $index + 1 }}</td>
                                <td class="col-staff">{{ $staff->first_name }} {{ $staff->last_name }}</td>
                                <td class="col-role">{{ $staff->admin?->roles?->first()?->name ?? '-' }}</td>
                                @foreach($leaveTypes as $lt)
                                    @php
                                        $setting = $settings[$staff->id][$lt->id] ?? null;
                                        $days = $setting ? $setting->annual_days : $lt->default_days;
                                    @endphp
                                    <td class="col-input">
                                        <input type="number" 
                                               name="settings[{{ $staff->id }}][{{ $lt->id }}]" 
                                               value="{{ $days }}" 
                                               min="0" 
                                               step="0.5">
                                    </td>
                                @endforeach
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg>
                    Save Changes
                </button>
            </div>
        </div>
    </form>
</div>
