<style>
    .page-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; }
    .page-header h1 { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
    .page-header h1 svg { width: 28px; height: 28px; color: var(--primary); }
    
    .table-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
    .table-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); background: var(--hover-bg); }
    .table-card-title { font-size: 16px; font-weight: 600; color: var(--text-primary); }
    .table-card-body { padding: 0; }
    
    .process-table { width: 100%; border-collapse: collapse; }
    .process-table th { padding: 12px 20px; text-align: left; font-size: 12px; font-weight: 600; color: var(--text-muted); text-transform: uppercase; background: var(--card-bg); border-bottom: 1px solid var(--card-border); }
    .process-table td { padding: 14px 20px; border-bottom: 1px solid var(--card-border); }
    .process-table tr:hover td { background: var(--hover-bg); }
    .process-table .name { font-weight: 500; color: var(--text-primary); }
    .process-table .related { font-size: 13px; color: var(--text-muted); text-transform: capitalize; }
    
    .btn-edit { color: var(--warning); padding: 5px; display: inline-flex; }
    .btn-edit:hover { color: var(--primary); }
</style>

<div style="padding: 20px;">
    <div class="page-header">
        <h1>
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
            </svg>
            {{ $pageTitle ?? 'Approval Process' }}
        </h1>
    </div>

    <div class="table-card">
        <div class="table-card-header">
            <div class="table-card-title">Approval Process</div>
        </div>
        <div class="table-card-body">
            <table class="process-table">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Related</th>
                        <th style="width:80px;">Options</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($processes as $process)
                        <tr>
                            <td class="name">{{ $process->name }}</td>
                            <td class="related">{{ $process->related_to }}</td>
                            <td>
                                <a href="{{ route('admin.attendance.settings.approval.edit', $process->id) }}" class="btn-edit" title="Edit">
                                    <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" style="text-align:center;padding:40px;color:var(--text-muted);">No approval processes configured</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
