<style>
    .page-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
    .page-header h1 { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
    .page-header h1 svg { width: 28px; height: 28px; color: var(--primary); }
    .btn-back { display: inline-flex; align-items: center; gap: 6px; color: var(--text-muted); text-decoration: none; font-size: 14px; }
    .btn-back:hover { color: var(--primary); }
    
    .form-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; max-width: 600px; }
    .form-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); background: var(--hover-bg); }
    .form-card-title { font-size: 16px; font-weight: 600; color: var(--text-primary); }
    .form-card-body { padding: 24px; }
    
    .form-group { margin-bottom: 20px; }
    .form-label { display: block; font-size: 14px; font-weight: 500; color: var(--text-primary); margin-bottom: 10px; }
    .form-label .req { color: #ef4444; }
    .form-input, .form-select { width: 100%; padding: 10px 14px; border: 1px solid var(--input-border); border-radius: 8px; font-size: 14px; background: var(--input-bg); color: var(--text-primary); }
    .form-input:focus, .form-select:focus { outline: none; border-color: var(--primary); }
    
    .pill-group { display: flex; flex-wrap: wrap; gap: 8px; }
    .pill { padding: 8px 16px; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 6px; font-size: 13px; font-weight: 500; color: var(--text-primary); cursor: pointer; transition: all 0.15s; }
    .pill:hover { border-color: var(--primary); }
    .pill.active { background: var(--primary); border-color: var(--primary); color: #fff; }
    .pill input { display: none; }
    
    .checkbox-grid { display: flex; flex-wrap: wrap; gap: 8px; }
    .checkbox-item { display: flex; align-items: center; gap: 6px; padding: 8px 12px; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 6px; font-size: 13px; color: var(--text-primary); cursor: pointer; transition: all 0.15s; }
    .checkbox-item:hover { border-color: var(--primary); }
    .checkbox-item.checked { background: rgba(59, 130, 246, 0.1); border-color: var(--primary); }
    .checkbox-item input { display: none; }
    .checkbox-box { width: 16px; height: 16px; border: 2px solid var(--input-border); border-radius: 4px; display: flex; align-items: center; justify-content: center; }
    .checkbox-item.checked .checkbox-box { background: var(--primary); border-color: var(--primary); }
    .checkbox-box svg { width: 10px; height: 10px; color: #fff; opacity: 0; }
    .checkbox-item.checked .checkbox-box svg { opacity: 1; }
    
    .switch-wrap { display: flex; align-items: center; gap: 10px; }
    .switch { position: relative; width: 44px; height: 24px; }
    .switch input { opacity: 0; width: 0; height: 0; }
    .slider { position: absolute; cursor: pointer; inset: 0; background: var(--input-border); border-radius: 24px; transition: 0.3s; }
    .slider:before { position: absolute; content: ""; height: 18px; width: 18px; left: 3px; bottom: 3px; background: white; border-radius: 50%; transition: 0.3s; }
    input:checked + .slider { background: var(--primary); }
    input:checked + .slider:before { transform: translateX(20px); }
    
    .form-actions { display: flex; gap: 12px; padding-top: 20px; border-top: 1px solid var(--card-border); margin-top: 24px; }
    .btn { padding: 10px 24px; border-radius: 8px; font-weight: 600; font-size: 14px; cursor: pointer; transition: all 0.2s; border: none; display: inline-flex; align-items: center; gap: 8px; text-decoration: none; }
    .btn-primary { background: var(--primary); color: #fff; }
    .btn-primary:hover { background: var(--primary-hover); }
    .btn-secondary { background: var(--card-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
    .btn-secondary:hover { background: var(--hover-bg); }
</style>

<div style="padding: 20px;">
    <div class="page-header">
        <div>
            <a href="{{ route('admin.attendance.settings.day_off.index') }}" class="btn-back">
                <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M19 12H5m7-7l-7 7 7 7"/></svg>
                Back to Day Off
            </a>
            <h1>
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
                </svg>
                {{ $pageTitle ?? 'New Day Off' }}
            </h1>
        </div>
    </div>

    <div class="form-card">
        <div class="form-card-header">
            <div class="form-card-title">New holiday</div>
        </div>
        <div class="form-card-body">
            <form action="{{ route('admin.attendance.settings.day_off.store') }}" method="POST">
                @csrf
                
                <!-- Off Type -->
                <div class="form-group">
                    <label class="form-label"><span class="req">*</span> Off type</label>
                    <div class="pill-group" id="offTypeGroup">
                        @foreach($offTypes as $ot)
                            <label class="pill {{ $loop->first ? 'active' : '' }}" onclick="selectPill(this, 'offTypeGroup')">
                                <input type="radio" name="off_type_id" value="{{ $ot->id }}" {{ $loop->first ? 'checked' : '' }}>
                                {{ $ot->name }}
                            </label>
                        @endforeach
                    </div>
                </div>
                
                <!-- Off Date -->
                <div class="form-group">
                    <label class="form-label"><span class="req">*</span> Day off</label>
                    <input type="date" name="off_date" class="form-input" value="{{ old('off_date', date('Y-m-d')) }}" required>
                </div>
                
                <!-- Off Reason -->
                <div class="form-group">
                    <label class="form-label"><span class="req">*</span> Off reason</label>
                    <input type="text" name="reason" class="form-input" value="{{ old('reason') }}" required>
                </div>
                
                <!-- Department -->
                <div class="form-group">
                    <label class="form-label">Department</label>
                    <select name="department_id" class="form-select">
                        <option value="">All Departments</option>
                        @foreach($departments as $dept)
                            <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                        @endforeach
                    </select>
                </div>
                
                <!-- Role -->
                <div class="form-group">
                    <label class="form-label">Role</label>
                    <div class="checkbox-grid">
                        @foreach($roles as $role)
                            <label class="checkbox-item" onclick="toggleCheckbox(this)">
                                <input type="checkbox" name="role_name" value="{{ $role->name }}">
                                <span class="checkbox-box"><svg fill="none" stroke="currentColor" stroke-width="3" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg></span>
                                {{ $role->name }}
                            </label>
                        @endforeach
                    </div>
                </div>
                
                <!-- Repeat Yearly -->
                <div class="form-group">
                    <label class="form-label">Automatically repeat by year</label>
                    <div class="switch-wrap">
                        <label class="switch">
                            <input type="checkbox" name="repeat_yearly" value="1">
                            <span class="slider"></span>
                        </label>
                        <span style="font-size:13px;color:var(--text-muted);">Enable to repeat this holiday every year</span>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M5 13l4 4L19 7"/></svg>
                        Save
                    </button>
                    <a href="{{ route('admin.attendance.settings.day_off.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function selectPill(el, groupId) {
    document.querySelectorAll('#' + groupId + ' .pill').forEach(p => p.classList.remove('active'));
    el.classList.add('active');
    el.querySelector('input').checked = true;
}

function toggleCheckbox(el) {
    // Single select for role
    document.querySelectorAll('.checkbox-item').forEach(c => {
        c.classList.remove('checked');
        c.querySelector('input').checked = false;
    });
    el.classList.add('checked');
    el.querySelector('input').checked = true;
}
</script>
