<style>
    .page-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; }
    .page-header h1 { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
    .page-header h1 svg { width: 28px; height: 28px; color: var(--primary); }
    .btn-back { display: inline-flex; align-items: center; gap: 6px; color: var(--text-muted); text-decoration: none; font-size: 14px; }
    .btn-back:hover { color: var(--primary); }
    
    .form-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; max-width: 600px; }
    .form-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); background: var(--hover-bg); }
    .form-card-title { font-size: 16px; font-weight: 600; color: var(--text-primary); }
    .form-card-body { padding: 24px; }
    
    .form-group { margin-bottom: 20px; }
    .form-label { display: block; font-size: 14px; font-weight: 500; color: var(--text-primary); margin-bottom: 8px; }
    .form-input, .form-select { width: 100%; padding: 10px 14px; border: 1px solid var(--input-border); border-radius: 8px; font-size: 14px; background: var(--input-bg); color: var(--text-primary); }
    .form-input:focus, .form-select:focus { outline: none; border-color: var(--primary); }
    
    .switch-wrap { display: flex; align-items: center; gap: 10px; }
    .switch { position: relative; width: 44px; height: 24px; }
    .switch input { opacity: 0; width: 0; height: 0; }
    .slider { position: absolute; cursor: pointer; inset: 0; background: var(--input-border); border-radius: 24px; transition: 0.3s; }
    .slider:before { position: absolute; content: ""; height: 18px; width: 18px; left: 3px; bottom: 3px; background: white; border-radius: 50%; transition: 0.3s; }
    input:checked + .slider { background: var(--primary); }
    input:checked + .slider:before { transform: translateX(20px); }
    
    .form-actions { display: flex; gap: 12px; padding-top: 20px; border-top: 1px solid var(--card-border); margin-top: 24px; }
    .btn { padding: 10px 24px; border-radius: 8px; font-weight: 600; font-size: 14px; cursor: pointer; border: none; display: inline-flex; align-items: center; gap: 8px; text-decoration: none; }
    .btn-primary { background: var(--primary); color: #fff; }
    .btn-primary:hover { background: var(--primary-hover); }
    .btn-secondary { background: var(--card-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
    .btn-secondary:hover { background: var(--hover-bg); }
</style>

<div style="padding: 20px;">
    <div class="page-header">
        <div>
            <a href="{{ route('admin.attendance.settings.day_off.index') }}" class="btn-back">
                <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M19 12H5m7-7l-7 7 7 7"/></svg>
                Back
            </a>
            <h1>
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg>
                {{ $pageTitle ?? 'Edit Day Off' }}
            </h1>
        </div>
    </div>

    <div class="form-card">
        <div class="form-card-header">
            <div class="form-card-title">Edit Holiday</div>
        </div>
        <div class="form-card-body">
            <form action="{{ route('admin.attendance.settings.day_off.update', $dayOff->id) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="form-group">
                    <label class="form-label">Off Type</label>
                    <select name="off_type_id" class="form-select" required>
                        @foreach($offTypes as $ot)
                            <option value="{{ $ot->id }}" {{ $dayOff->off_type_id == $ot->id ? 'selected' : '' }}>{{ $ot->name }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Day off</label>
                    <input type="date" name="off_date" class="form-input" value="{{ $dayOff->off_date->format('Y-m-d') }}" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Off reason</label>
                    <input type="text" name="reason" class="form-input" value="{{ $dayOff->reason }}" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Department</label>
                    <select name="department_id" class="form-select">
                        <option value="">All Departments</option>
                        @foreach($departments as $dept)
                            <option value="{{ $dept->id }}" {{ $dayOff->department_id == $dept->id ? 'selected' : '' }}>{{ $dept->name }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Role</label>
                    <select name="role_name" class="form-select">
                        <option value="">All Roles</option>
                        @foreach($roles as $role)
                            <option value="{{ $role->name }}" {{ $dayOff->role_name == $role->name ? 'selected' : '' }}>{{ $role->name }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Repeat by year</label>
                    <div class="switch-wrap">
                        <label class="switch">
                            <input type="checkbox" name="repeat_yearly" value="1" {{ $dayOff->repeat_yearly ? 'checked' : '' }}>
                            <span class="slider"></span>
                        </label>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">Update</button>
                    <a href="{{ route('admin.attendance.settings.day_off.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
