<?php

use Illuminate\Support\Facades\Route;
use Modules\Attendance\Http\Controllers\AttendanceController;
use Modules\Attendance\Http\Controllers\ShiftTypeController;
use Modules\Attendance\Http\Controllers\ShiftController;
use Modules\Attendance\Http\Controllers\WorkShiftController;
use Modules\Attendance\Http\Controllers\LeaveApplicationController;
use Modules\Attendance\Http\Controllers\AdditionalHourController;
use Modules\Attendance\Http\Controllers\SettingsController;
use App\Http\Middleware\EnsureIsAdmin;

Route::prefix('admin/attendance')
    ->middleware([EnsureIsAdmin::class])
    ->name('admin.attendance.')
    ->group(function () {

        // ===== DAILY ATTENDANCE =====
        Route::get('/', [AttendanceController::class, 'index'])->name('index');
        Route::get('/export', [AttendanceController::class, 'export'])->name('export');
        Route::get('/mark', [AttendanceController::class, 'mark'])->name('mark');
        Route::post('/mark', [AttendanceController::class, 'markStore'])->name('mark.store');
        Route::get('/my', [AttendanceController::class, 'myAttendance'])->name('my');
        
        // ===== ATTENDANCE LOGS =====
        Route::get('/logs', [AttendanceController::class, 'logs'])->name('logs');
        Route::match(['get', 'post'], '/logs/data', [AttendanceController::class, 'logsData'])->name('logs.data');
        Route::get('/day-detail/{staffId}/{date}', [AttendanceController::class, 'dayDetail'])->name('day-detail');
        Route::get('/{id}/show', [AttendanceController::class, 'show'])->name('show');
        Route::get('/{id}/edit', [AttendanceController::class, 'edit'])->name('edit');
        Route::put('/{id}', [AttendanceController::class, 'update'])->name('update');
        Route::delete('/{id}', [AttendanceController::class, 'destroy'])->name('destroy');
        
        // ===== SELF CHECK-IN/OUT (AJAX) =====
        Route::post('/check-in', [AttendanceController::class, 'checkIn'])->name('check-in');
        Route::post('/check-out', [AttendanceController::class, 'checkOut'])->name('check-out');
        Route::get('/my-status', [AttendanceController::class, 'myStatus'])->name('my-status');
        Route::get('/staff-status', [AttendanceController::class, 'staffStatus'])->name('staff-status');

        // ===== MY EXTRA HOURS (Staff View) =====
        Route::get('/my-extra', [AdditionalHourController::class, 'myExtra'])->name('my_extra');

        // ===== MY LEAVES (Staff View) =====
        Route::get('/my-leaves', [LeaveApplicationController::class, 'myLeaves'])->name('my_leaves');

        // ===== SHIFT TYPES =====
        Route::get('/shift-types', [ShiftTypeController::class, 'index'])->name('shift_types.index');
        Route::get('/shift-types/create', [ShiftTypeController::class, 'create'])->name('shift_types.create');
        Route::post('/shift-types', [ShiftTypeController::class, 'store'])->name('shift_types.store');
        Route::match(['get', 'post'], '/shift-types/data', [ShiftTypeController::class, 'handleData'])->name('shift_types.data');
        Route::get('/shift-types/{id}/edit', [ShiftTypeController::class, 'edit'])->name('shift_types.edit');
        Route::put('/shift-types/{id}', [ShiftTypeController::class, 'update'])->name('shift_types.update');
        Route::delete('/shift-types/{id}', [ShiftTypeController::class, 'destroy'])->name('shift_types.destroy');

        // ===== SHIFTS (Assignments) =====
        Route::get('/shifts', [ShiftController::class, 'index'])->name('shifts.index');
        Route::get('/shifts/create', [ShiftController::class, 'create'])->name('shifts.create');
        Route::post('/shifts', [ShiftController::class, 'store'])->name('shifts.store');
        Route::match(['get', 'post'], '/shifts/data', [ShiftController::class, 'handleData'])->name('shifts.data');
        Route::get('/shifts/filter-staff', [ShiftController::class, 'filterStaff'])->name('shifts.filter_staff');
        Route::get('/shifts/{id}/edit', [ShiftController::class, 'edit'])->name('shifts.edit');
        Route::put('/shifts/{id}', [ShiftController::class, 'update'])->name('shifts.update');
        Route::delete('/shifts/{id}', [ShiftController::class, 'destroy'])->name('shifts.destroy');

        // ===== WORK SHIFT TABLE (View Only) =====
        Route::get('/work-shift', [WorkShiftController::class, 'index'])->name('work_shift.index');

        // ===== LEAVE APPLICATIONS =====
        Route::get('/leave', [LeaveApplicationController::class, 'index'])->name('leave.index');
        Route::get('/leave/create', [LeaveApplicationController::class, 'create'])->name('leave.create');
        Route::post('/leave', [LeaveApplicationController::class, 'store'])->name('leave.store');
        Route::match(['get', 'post'], '/leave/data', [LeaveApplicationController::class, 'handleData'])->name('leave.data');
        Route::get('/leave/balance', [LeaveApplicationController::class, 'getLeaveBalance'])->name('leave.balance');
        Route::get('/leave/handover-work', [LeaveApplicationController::class, 'getHandoverWork'])->name('leave.handover_work');
        Route::get('/leave/{id}/edit', [LeaveApplicationController::class, 'edit'])->name('leave.edit');
        Route::put('/leave/{id}', [LeaveApplicationController::class, 'update'])->name('leave.update');
        Route::delete('/leave/{id}', [LeaveApplicationController::class, 'destroy'])->name('leave.destroy');
        Route::post('/leave/{id}/approve', [LeaveApplicationController::class, 'approve'])->name('leave.approve');
        Route::post('/leave/{id}/reject', [LeaveApplicationController::class, 'reject'])->name('leave.reject');

        // ===== ADDITIONAL WORK HOURS =====
        Route::get('/additional-hours', [AdditionalHourController::class, 'index'])->name('additional_hours.index');
        Route::get('/additional-hours/create', [AdditionalHourController::class, 'create'])->name('additional_hours.create');
        Route::post('/additional-hours', [AdditionalHourController::class, 'store'])->name('additional_hours.store');
        Route::match(['get', 'post'], '/additional-hours/data', [AdditionalHourController::class, 'handleData'])->name('additional_hours.data');
        Route::get('/additional-hours/{id}/edit', [AdditionalHourController::class, 'edit'])->name('additional_hours.edit');
        Route::put('/additional-hours/{id}', [AdditionalHourController::class, 'update'])->name('additional_hours.update');
        Route::delete('/additional-hours/{id}', [AdditionalHourController::class, 'destroy'])->name('additional_hours.destroy');
        Route::post('/additional-hours/{id}/complete', [AdditionalHourController::class, 'complete'])->name('additional_hours.complete');
        Route::post('/additional-hours/{id}/cancel', [AdditionalHourController::class, 'cancel'])->name('additional_hours.cancel');

        // ===== SETTINGS (Tabbed View) =====
        Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
        
        // General Settings
        Route::post('/settings/general', [SettingsController::class, 'generalUpdate'])->name('settings.general.update');

        // Leave Types
        Route::post('/settings/leave-types', [SettingsController::class, 'leaveTypeStore'])->name('settings.leave-types.store');
        Route::put('/settings/leave-types/{id}', [SettingsController::class, 'leaveTypeUpdate'])->name('settings.leave-types.update');
        Route::post('/settings/leave-types/{id}/update-limit', [SettingsController::class, 'leaveTypeUpdateLimit'])->name('settings.leave-types.update-limit');
        Route::delete('/settings/leave-types/{id}', [SettingsController::class, 'leaveTypeDestroy'])->name('settings.leave-types.destroy');

        // Holidays
        Route::post('/settings/holidays', [SettingsController::class, 'holidayStore'])->name('settings.holidays.store');
        Route::put('/settings/holidays/{id}', [SettingsController::class, 'holidayUpdate'])->name('settings.holidays.update');
        Route::delete('/settings/holidays/{id}', [SettingsController::class, 'holidayDestroy'])->name('settings.holidays.destroy');

        // Day Off Routes (for legacy views)
        Route::get('/settings/day-off', [SettingsController::class, 'dayOffIndex'])->name('settings.day_off.index');
        Route::get('/settings/day-off/create', [SettingsController::class, 'dayOffCreate'])->name('settings.day_off.create');
        Route::post('/settings/day-off', [SettingsController::class, 'dayOffStore'])->name('settings.day_off.store');
        Route::match(['get', 'post'], '/settings/day-off/data', [SettingsController::class, 'dayOffData'])->name('settings.day_off.data');
        Route::get('/settings/day-off/{id}/edit', [SettingsController::class, 'dayOffEdit'])->name('settings.day_off.edit');
        Route::put('/settings/day-off/{id}', [SettingsController::class, 'dayOffUpdate'])->name('settings.day_off.update');
        Route::delete('/settings/day-off/{id}', [SettingsController::class, 'dayOffDestroy'])->name('settings.day_off.destroy');

        // Annual Leave (legacy)
        Route::post('/settings/annual-leave', [SettingsController::class, 'annualLeaveUpdate'])->name('settings.annual_leave.update');

        // Approval Process
        Route::post('/settings/approval/update-all', [SettingsController::class, 'approvalUpdateAll'])->name('settings.approval.update.all');
        Route::get('/settings/approval/{id}/edit', [SettingsController::class, 'approvalEdit'])->name('settings.approval.edit');
        Route::put('/settings/approval/{id}', [SettingsController::class, 'approvalUpdate'])->name('settings.approval.update');

        // Timesheet Settings
        Route::post('/settings/timesheet', [SettingsController::class, 'timesheetUpdate'])->name('settings.timesheet.update');
        
        // Work Types (Timesheet Types)
        Route::post('/settings/work-types', [SettingsController::class, 'workTypeStore'])->name('settings.work_type.store');
        Route::put('/settings/work-types/{id}', [SettingsController::class, 'workTypeUpdate'])->name('settings.work_type.update');
        Route::delete('/settings/work-types/{id}', [SettingsController::class, 'workTypeDestroy'])->name('settings.work_type.destroy');

    });
