<?php

namespace Modules\Ecommerce\Http\Controllers\Ecommerce;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Ecommerce\Models\WebsiteSetting;

class PagesController extends Controller
{
    protected function getSettings()
    {
        return WebsiteSetting::instance();
    }

    public function privacyPolicy()
    {
        return view('ecommerce::pages.privacy-policy', [
            'settings' => $this->getSettings()
        ]);
    }

    public function termsConditions()
    {
        return view('ecommerce::pages.terms-conditions', [
            'settings' => $this->getSettings()
        ]);
    }

    public function refundPolicy()
    {
        return view('ecommerce::pages.refund-policy', [
            'settings' => $this->getSettings()
        ]);
    }

    public function shippingPolicy()
    {
        return view('ecommerce::pages.shipping-policy', [
            'settings' => $this->getSettings()
        ]);
    }

    public function contactUs()
    {
        return view('ecommerce::pages.contact-us', [
            'settings' => $this->getSettings()
        ]);
    }

    public function aboutUs()
    {
        return view('ecommerce::pages.about-us', [
            'settings' => $this->getSettings()
        ]);
    }
}