<?php

namespace Modules\Ecommerce\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DeliveryAuthenticate
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::guard('delivery')->check()) {
            if ($request->expectsJson()) {
                return response()->json(['message' => 'Unauthenticated.'], 401);
            }
            return redirect()->route('delivery.login');
        }

        // Check if account is active
        $deliveryPerson = Auth::guard('delivery')->user();
        if ($deliveryPerson->status === 'inactive') {
            Auth::guard('delivery')->logout();
            return redirect()->route('delivery.login')
                ->withErrors(['phone' => 'Your account has been deactivated.']);
        }

        return $next($request);
    }
}