@extends('ecommerce::delivery.layout')

@section('header_title', 'Earnings')

@section('content')
<!-- Month Selector -->
<div class="card" style="padding: 16px;">
    <form method="GET" style="display: flex; gap: 10px; align-items: center;">
        <input type="month" name="month" class="form-input" value="{{ $month }}" onchange="this.form.submit()" style="flex: 1;">
    </form>
</div>

<!-- Summary -->
<div class="stats-grid">
    <div class="stat-card delivered">
        <div class="stat-value">{{ $totalDeliveries }}</div>
        <div class="stat-label">Total Deliveries</div>
    </div>
    <div class="stat-card total">
        <div class="stat-value">₹{{ number_format($totalEarnings, 2) }}</div>
        <div class="stat-label">Total Earnings</div>
    </div>
</div>

<!-- Daily Breakdown -->
<div class="card">
    <div class="card-title">Daily Breakdown</div>
    
    @forelse($dailyEarnings->sortKeysDesc() as $date => $data)
    <div style="display: flex; justify-content: space-between; align-items: center; padding: 12px 0; border-bottom: 1px solid #f3f4f6;">
        <div>
            <div style="font-weight: 500; color: #1f2937;">{{ \Carbon\Carbon::parse($date)->format('d M Y') }}</div>
            <div style="font-size: 12px; color: #6b7280;">{{ $data['count'] }} deliveries</div>
        </div>
        <div style="font-weight: 600; color: #10b981;">₹{{ number_format($data['amount'], 2) }}</div>
    </div>
    @empty
    <div class="empty-state">
        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
        </svg>
        <h3>No Earnings This Month</h3>
        <p>Complete deliveries to see your earnings here</p>
    </div>
    @endforelse
</div>
@endsection