@extends('ecommerce::delivery.layout')

@section('header_title', $order->order_no)

@section('content')
<!-- Back Button -->
<a href="{{ route('delivery.orders') }}" style="display: inline-flex; align-items: center; gap: 6px; color: #6b7280; text-decoration: none; margin-bottom: 16px; font-size: 14px;">
    <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg>
    Back to Orders
</a>

<!-- Order Status Card -->
<div class="card">
    <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 16px;">
        <div>
            <h2 style="font-size: 20px; font-weight: 700; color: #1f2937;">{{ $order->order_no }}</h2>
            <p style="color: #6b7280; font-size: 13px; margin-top: 4px;">
                {{ $order->created_at->format('d M Y, h:i A') }}
            </p>
        </div>
        <span class="badge badge-{{ $order->delivery_status }}" style="font-size: 14px; padding: 6px 14px;">
            {{ ucfirst(str_replace('_', ' ', $order->delivery_status)) }}
        </span>
    </div>
    
    <div style="display: flex; justify-content: space-between; align-items: center; padding: 16px; background: #f9fafb; border-radius: 12px;">
        <div>
            <div style="font-size: 13px; color: #6b7280;">Order Total</div>
            <div style="font-size: 24px; font-weight: 700; color: #10b981;">₹{{ number_format($order->total, 2) }}</div>
        </div>
        <div style="text-align: right;">
            <div style="font-size: 13px; color: #6b7280;">Payment</div>
            @if(in_array($order->payment_method, ['cod', 'cash']) && $order->payment_status === 'pending')
            <span class="badge badge-cod" style="font-size: 14px;">Collect COD</span>
            @else
            <span class="badge badge-paid" style="font-size: 14px;">Prepaid</span>
            @endif
        </div>
    </div>
</div>

<!-- Customer Info -->
<div class="card">
    <div class="card-title">Customer Details</div>
    
    <div style="margin-bottom: 16px;">
        <div style="font-weight: 600; color: #1f2937; font-size: 16px;">{{ $order->customer_name }}</div>
        <a href="tel:{{ $order->customer_phone }}" style="display: inline-flex; align-items: center; gap: 6px; color: #3b82f6; font-size: 15px; margin-top: 6px; text-decoration: none;">
            <svg width="18" height="18" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
            {{ $order->customer_phone }}
        </a>
    </div>
    
    <div style="padding: 14px; background: #f9fafb; border-radius: 10px;">
        <div style="font-size: 12px; color: #6b7280; margin-bottom: 6px;">Delivery Address</div>
        <div style="color: #1f2937; line-height: 1.6;">
            {{ $order->shipping_address }}<br>
            {{ $order->shipping_city }}, {{ $order->shipping_state }}<br>
            {{ $order->shipping_pincode }}
        </div>
    </div>
    
    <!-- Quick Actions -->
    <div style="display: flex; gap: 10px; margin-top: 16px;">
        <a href="tel:{{ $order->customer_phone }}" class="btn btn-primary" style="flex: 1;">
            <svg width="18" height="18" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
            Call
        </a>
        <a href="https://maps.google.com/?q={{ urlencode($order->shipping_address . ', ' . $order->shipping_city . ' ' . $order->shipping_pincode) }}" target="_blank" class="btn btn-outline" style="flex: 1;">
            <svg width="18" height="18" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path></svg>
            Navigate
        </a>
    </div>
</div>

<!-- Order Items -->
<div class="card">
    <div class="card-title">Order Items ({{ $order->items->count() }})</div>
    
    @foreach($order->items as $item)
    <div style="display: flex; gap: 12px; padding: 12px 0; border-bottom: 1px solid #f3f4f6;">
        <div style="width: 50px; height: 50px; background: #f3f4f6; border-radius: 8px; overflow: hidden;">
            @if($item->product && $item->product->primaryImage)
            <img src="{{ asset('storage/' . $item->product->primaryImage->image_path) }}" style="width: 100%; height: 100%; object-fit: cover;">
            @endif
        </div>
        <div style="flex: 1;">
            <div style="font-weight: 500; color: #1f2937;">{{ $item->product_name }}</div>
            @if($item->variation_name)
            <div style="font-size: 12px; color: #6b7280;">{{ $item->variation_name }}</div>
            @endif
            <div style="font-size: 13px; color: #6b7280; margin-top: 4px;">Qty: {{ $item->qty }}</div>
        </div>
        <div style="font-weight: 600; color: #1f2937;">₹{{ number_format($item->subtotal, 2) }}</div>
    </div>
    @endforeach
</div>

<!-- Update Status -->
@if(in_array($order->delivery_status, ['assigned', 'picked_up', 'in_transit']))
<div class="card">
    <div class="card-title">Update Status</div>
    
    <form action="{{ route('delivery.order.update-status', $order->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        
        <div class="form-group">
            <label class="form-label">New Status</label>
            <select name="status" class="form-select" id="status-select" required>
                <option value="">Select Status</option>
                @if($order->delivery_status === 'assigned')
                <option value="picked_up">Picked Up</option>
                @endif
                @if(in_array($order->delivery_status, ['assigned', 'picked_up']))
                <option value="in_transit">In Transit</option>
                @endif
                <option value="delivered">Delivered</option>
                <option value="failed">Failed</option>
            </select>
        </div>
        
        <div class="form-group" id="proof-group" style="display: none;">
            <label class="form-label">Proof of Delivery (Photo)</label>
            <input type="file" name="proof_image" class="form-input" accept="image/*" capture="environment">
            <p style="font-size: 12px; color: #6b7280; margin-top: 6px;">Take a photo as proof of delivery</p>
        </div>
        
        <div class="form-group">
            <label class="form-label">Notes (Optional)</label>
            <textarea name="notes" class="form-textarea" placeholder="Any additional notes..."></textarea>
        </div>
        
        <div class="form-group">
            <label class="form-label">Location (Optional)</label>
            <input type="text" name="location" class="form-input" placeholder="Current location">
        </div>
        
        <button type="submit" class="btn btn-success btn-block">
            <svg width="18" height="18" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
            Update Status
        </button>
    </form>
</div>
@endif

<!-- Delivery Timeline -->
@if($order->deliveryStatusHistory->count() > 0)
<div class="card">
    <div class="card-title">Delivery Timeline</div>
    
    @foreach($order->deliveryStatusHistory as $history)
    <div style="display: flex; gap: 12px; padding: 12px 0; border-bottom: 1px solid #f3f4f6;">
        <div style="width: 10px; height: 10px; background: #667eea; border-radius: 50%; margin-top: 5px;"></div>
        <div style="flex: 1;">
            <div style="font-weight: 500; color: #1f2937;">{{ ucfirst(str_replace('_', ' ', $history->status)) }}</div>
            @if($history->notes)
            <div style="font-size: 13px; color: #6b7280; margin-top: 4px;">{{ $history->notes }}</div>
            @endif
            @if($history->location)
            <div style="font-size: 12px; color: #9ca3af; margin-top: 2px;">📍 {{ $history->location }}</div>
            @endif
            <div style="font-size: 12px; color: #9ca3af; margin-top: 4px;">{{ $history->created_at->format('d M Y, h:i A') }}</div>
        </div>
    </div>
    @endforeach
</div>
@endif

@if($order->delivery_notes)
<div class="card">
    <div class="card-title">Delivery Notes</div>
    <p style="color: #4b5563; line-height: 1.6;">{{ $order->delivery_notes }}</p>
</div>
@endif
@endsection

@section('scripts')
<script>
document.getElementById('status-select').addEventListener('change', function() {
    const proofGroup = document.getElementById('proof-group');
    if (this.value === 'delivered') {
        proofGroup.style.display = 'block';
    } else {
        proofGroup.style.display = 'none';
    }
});
</script>
@endsection