@extends('ecommerce::delivery.layout')

@section('header_title', 'My Orders')

@section('content')
<!-- Filters -->
<div class="card" style="padding: 16px;">
    <form method="GET" style="display: flex; gap: 10px; flex-wrap: wrap;">
        <select name="status" class="form-select" style="flex: 1; min-width: 130px;" onchange="this.form.submit()">
            <option value="">All Status</option>
            <option value="assigned" {{ request('status') === 'assigned' ? 'selected' : '' }}>Assigned</option>
            <option value="picked_up" {{ request('status') === 'picked_up' ? 'selected' : '' }}>Picked Up</option>
            <option value="in_transit" {{ request('status') === 'in_transit' ? 'selected' : '' }}>In Transit</option>
            <option value="delivered" {{ request('status') === 'delivered' ? 'selected' : '' }}>Delivered</option>
            <option value="failed" {{ request('status') === 'failed' ? 'selected' : '' }}>Failed</option>
        </select>
        <input type="date" name="date" class="form-input" style="flex: 1; min-width: 130px;" value="{{ request('date') }}" onchange="this.form.submit()">
    </form>
</div>

<!-- Orders List -->
@forelse($orders as $order)
<a href="{{ route('delivery.order.details', $order->id) }}" class="order-card">
    <div class="order-header">
        <div>
            <div class="order-no">{{ $order->order_no }}</div>
            <span class="badge badge-{{ $order->delivery_status }}">{{ ucfirst(str_replace('_', ' ', $order->delivery_status)) }}</span>
        </div>
        <div class="order-amount">₹{{ number_format($order->total, 2) }}</div>
    </div>
    <div class="order-customer">
        <strong>{{ $order->customer_name }}</strong> • {{ $order->customer_phone }}
    </div>
    <div class="order-address">
        📍 {{ $order->shipping_address }}, {{ $order->shipping_city }} - {{ $order->shipping_pincode }}
    </div>
    <div class="order-footer">
        <div class="order-time">
            {{ $order->delivery_assigned_at->format('d M Y, h:i A') }}
        </div>
        @if(in_array($order->payment_method, ['cod', 'cash']) && $order->payment_status === 'pending')
        <span class="badge badge-cod">COD</span>
        @elseif($order->payment_status === 'paid')
        <span class="badge badge-paid">Paid</span>
        @endif
    </div>
</a>
@empty
<div class="empty-state">
    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
    </svg>
    <h3>No Orders Found</h3>
    <p>Try adjusting your filters</p>
</div>
@endforelse

<!-- Pagination -->
@if($orders->hasPages())
<div style="display: flex; justify-content: center; margin-top: 20px;">
    {{ $orders->links() }}
</div>
@endif
@endsection