@extends('ecommerce::public.shop-layout')

@section('title', 'About Us')

@section('content')
{{-- Page Header --}}
<section style="background: linear-gradient(135deg, #0891b2 0%, #0e7490 50%, #164e63 100%); color: #fff; padding: 50px 0;">
    <div class="container">
        <h1 style="font-size: 36px; font-weight: 700; margin-bottom: 10px;">About Us</h1>
        <p style="font-size: 16px; opacity: .9;">Learn more about our story and mission</p>
        <div style="margin-top: 16px; font-size: 14px; opacity: .8;">
            <a href="{{ route('ecommerce.shop') }}" style="color: #fff; opacity: .8;">Home</a>
            <span style="margin: 0 8px;">›</span>
            About Us
        </div>
    </div>
</section>

{{-- Content --}}
<section style="padding: 50px 0 80px;">
    <div class="container">
        <div style="background: #fff; border-radius: 16px; padding: 50px; box-shadow: 0 1px 3px rgba(0,0,0,.05); max-width: 900px; margin: 0 auto;">
            
            <h2 style="font-size: 22px; color: #0f172a; margin: 0 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">Welcome to {{ $settings->site_name ?? 'Our Store' }}</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">{{ $settings->site_name ?? 'Our Store' }} is your trusted online destination for quality products at competitive prices. We are committed to providing our customers with an exceptional shopping experience, combining a wide selection of products with outstanding customer service.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">Our Story</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">Founded with a vision to make online shopping accessible, affordable, and convenient, {{ $settings->site_name ?? 'our store' }} has grown from a small venture into a trusted e-commerce platform serving customers across India.</p>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We believe that everyone deserves access to quality products without compromising on service or value. This belief drives everything we do – from carefully curating our product selection to ensuring timely delivery and responsive customer support.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">Our Mission</h2>
            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;"><strong style="color: #0f172a;">To deliver quality products and exceptional service</strong> that exceed our customers' expectations, making online shopping a delightful and trustworthy experience for everyone.</p>
            </div>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">Our Values</h2>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Quality First</h3>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We are committed to offering products that meet high standards of quality. Every product in our catalog is carefully selected to ensure it delivers value to our customers.</p>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Customer Satisfaction</h3>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">Your satisfaction is our top priority. We go the extra mile to ensure that every interaction with us – from browsing to delivery – is seamless and enjoyable.</p>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Trust & Transparency</h3>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We believe in building long-term relationships with our customers based on trust. We maintain transparency in our pricing, policies, and business practices.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">Why Choose Us?</h2>

            {{-- Feature Cards --}}
            <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px; margin: 30px 0;">
                <div style="background: #f8fafc; padding: 24px; border-radius: 12px; text-align: center;">
                    <svg style="width: 40px; height: 40px; color: #0891b2; margin-bottom: 12px;" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75m-3-7.036A11.959 11.959 0 013.598 6 11.99 11.99 0 003 9.749c0 5.592 3.824 10.29 9 11.623 5.176-1.332 9-6.03 9-11.622 0-1.31-.21-2.571-.598-3.751h-.152c-3.196 0-6.1-1.248-8.25-3.285z"/>
                    </svg>
                    <h4 style="font-size: 16px; color: #0f172a; margin-bottom: 8px;">100% Genuine</h4>
                    <p style="font-size: 14px; color: #64748b; margin: 0;">Authentic products from trusted sources</p>
                </div>
                
                <div style="background: #f8fafc; padding: 24px; border-radius: 12px; text-align: center;">
                    <svg style="width: 40px; height: 40px; color: #0891b2; margin-bottom: 12px;" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 18.75a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h6m-9 0H3.375a1.125 1.125 0 01-1.125-1.125V14.25m17.25 4.5a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h1.125c.621 0 1.129-.504 1.09-1.124a17.902 17.902 0 00-3.213-9.193 2.056 2.056 0 00-1.58-.86H14.25M16.5 18.75h-2.25m0-11.177v-.958c0-.568-.422-1.048-.987-1.106a48.554 48.554 0 00-10.026 0 1.106 1.106 0 00-.987 1.106v7.635m12-6.677v6.677m0 4.5v-4.5m0 0h-12"/>
                    </svg>
                    <h4 style="font-size: 16px; color: #0f172a; margin-bottom: 8px;">Fast Delivery</h4>
                    <p style="font-size: 14px; color: #64748b; margin: 0;">Quick shipping across India</p>
                </div>
                
                <div style="background: #f8fafc; padding: 24px; border-radius: 12px; text-align: center;">
                    <svg style="width: 40px; height: 40px; color: #0891b2; margin-bottom: 12px;" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 8.25h19.5M2.25 9h19.5m-16.5 5.25h6m-6 2.25h3m-3.75 3h15a2.25 2.25 0 002.25-2.25V6.75A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25v10.5A2.25 2.25 0 004.5 19.5z"/>
                    </svg>
                    <h4 style="font-size: 16px; color: #0f172a; margin-bottom: 8px;">Secure Payments</h4>
                    <p style="font-size: 14px; color: #64748b; margin: 0;">100% safe & secure checkout</p>
                </div>
            </div>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">What We Offer</h2>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Wide Product Range:</strong> A carefully curated selection of products to meet your everyday needs</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Competitive Prices:</strong> Best value for your money with regular offers and discounts</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Secure Payments:</strong> Safe and secure payment options powered by Razorpay</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Fast Delivery:</strong> Reliable shipping to your doorstep across India</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Easy Returns:</strong> Hassle-free return and refund process</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Dedicated Support:</strong> Responsive customer service to assist you</li>
            </ul>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">Contact Us</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We'd love to hear from you! Whether you have questions, feedback, or just want to say hello, feel free to reach out:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                @if(!empty($settings->contact_email))<li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Email:</strong> <a href="mailto:{{ $settings->contact_email }}" style="color: #0891b2;">{{ $settings->contact_email }}</a></li>@endif
                @if(!empty($settings->contact_phone))<li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Phone:</strong> {{ $settings->contact_phone }}</li>@endif
                @if(!empty($settings->store_address))<li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Address:</strong> {{ $settings->store_address }}, {{ $settings->store_city }}, {{ $settings->store_state }} - {{ $settings->store_pincode }}</li>@endif
            </ul>

            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;">Thank you for choosing {{ $settings->site_name ?? 'our store' }}. We are honored to serve you and look forward to being your preferred online shopping destination!</p>
            </div>

        </div>
    </div>
</section>

<style>
@media (max-width: 768px) {
    .container > div > div[style*="grid-template-columns: repeat(3"] {
        grid-template-columns: 1fr !important;
    }
}
</style>
@endsection
