@extends('ecommerce::public.shop-layout')

@section('title', 'Contact Us')

@section('content')
{{-- Page Header --}}
<section style="background: linear-gradient(135deg, #0891b2 0%, #0e7490 50%, #164e63 100%); color: #fff; padding: 50px 0;">
    <div class="container">
        <h1 style="font-size: 36px; font-weight: 700; margin-bottom: 10px;">Contact Us</h1>
        <p style="font-size: 16px; opacity: .9;">We're here to help you</p>
        <div style="margin-top: 16px; font-size: 14px; opacity: .8;">
            <a href="{{ route('ecommerce.shop') }}" style="color: #fff; opacity: .8;">Home</a>
            <span style="margin: 0 8px;">›</span>
            Contact Us
        </div>
    </div>
</section>

{{-- Content --}}
<section style="padding: 50px 0 80px;">
    <div class="container">
        <div style="background: #fff; border-radius: 16px; padding: 50px; box-shadow: 0 1px 3px rgba(0,0,0,.05); max-width: 900px; margin: 0 auto;">
            
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">Have a question, feedback, or need assistance? We'd love to hear from you! Our customer support team is dedicated to providing you with the best possible service.</p>

            {{-- Contact Cards --}}
            <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px; margin: 30px 0;">
                <div style="background: #f8fafc; padding: 24px; border-radius: 12px; text-align: center;">
                    <svg style="width: 40px; height: 40px; color: #0891b2; margin-bottom: 12px;" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M21.75 6.75v10.5a2.25 2.25 0 01-2.25 2.25h-15a2.25 2.25 0 01-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25m19.5 0v.243a2.25 2.25 0 01-1.07 1.916l-7.5 4.615a2.25 2.25 0 01-2.36 0L3.32 8.91a2.25 2.25 0 01-1.07-1.916V6.75"/>
                    </svg>
                    <h4 style="font-size: 16px; color: #0f172a; margin-bottom: 8px;">Email Us</h4>
                    @if(!empty($settings->contact_email))
                    <p style="font-size: 14px; color: #64748b; margin: 0;"><a href="mailto:{{ $settings->contact_email }}" style="color: #0891b2; font-weight: 500;">{{ $settings->contact_email }}</a></p>
                    @else
                    <p style="font-size: 14px; color: #64748b; margin: 0;">support@example.com</p>
                    @endif
                </div>
                
                <div style="background: #f8fafc; padding: 24px; border-radius: 12px; text-align: center;">
                    <svg style="width: 40px; height: 40px; color: #0891b2; margin-bottom: 12px;" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 6.75c0 8.284 6.716 15 15 15h2.25a2.25 2.25 0 002.25-2.25v-1.372c0-.516-.351-.966-.852-1.091l-4.423-1.106c-.44-.11-.902.055-1.173.417l-.97 1.293c-.282.376-.769.542-1.21.38a12.035 12.035 0 01-7.143-7.143c-.162-.441.004-.928.38-1.21l1.293-.97c.363-.271.527-.734.417-1.173L6.963 3.102a1.125 1.125 0 00-1.091-.852H4.5A2.25 2.25 0 002.25 4.5v2.25z"/>
                    </svg>
                    <h4 style="font-size: 16px; color: #0f172a; margin-bottom: 8px;">Call Us</h4>
                    @if(!empty($settings->contact_phone))
                    <p style="font-size: 14px; color: #64748b; margin: 0;"><a href="tel:{{ $settings->contact_phone }}" style="color: #0891b2; font-weight: 500;">{{ $settings->contact_phone }}</a></p>
                    @else
                    <p style="font-size: 14px; color: #64748b; margin: 0;">+91 XXXXX XXXXX</p>
                    @endif
                </div>
                
                <div style="background: #f8fafc; padding: 24px; border-radius: 12px; text-align: center;">
                    <svg style="width: 40px; height: 40px; color: #0891b2; margin-bottom: 12px;" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    <h4 style="font-size: 16px; color: #0f172a; margin-bottom: 8px;">Working Hours</h4>
                    <p style="font-size: 14px; color: #64748b; margin: 0;">Mon - Sat: 10 AM - 6 PM<br>Sunday: Closed</p>
                </div>
            </div>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">Our Office Address</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">
                <strong style="color: #0f172a;">{{ $settings->site_name ?? 'Our Store' }}</strong><br>
                @if(!empty($settings->store_address)){{ $settings->store_address }}<br>@endif
                @if(!empty($settings->store_city)){{ $settings->store_city }}, @endif
                @if(!empty($settings->store_state)){{ $settings->store_state }}@endif
                @if(!empty($settings->store_pincode)) - {{ $settings->store_pincode }}@endif<br>
                India
            </p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">Customer Support</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">Our customer support team is available to assist you with:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Order Inquiries:</strong> Track your order, delivery status, or order modifications</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Product Information:</strong> Questions about products, availability, or specifications</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Returns & Refunds:</strong> Assistance with returns, exchanges, and refund status</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Payment Issues:</strong> Help with payment failures, refunds, or transaction queries</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Technical Support:</strong> Website issues, account problems, or app support</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Feedback & Suggestions:</strong> We value your feedback to improve our services</li>
            </ul>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">Response Time</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We strive to respond to all inquiries promptly:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Email:</strong> Within 24-48 hours (business days)</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Phone:</strong> Immediate assistance during working hours</li>
            </ul>

            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;"><strong style="color: #0f172a;">Quick Tip:</strong> For faster resolution, please have your order number ready when contacting us about order-related queries.</p>
            </div>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">Feedback</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">Your feedback helps us improve! If you have suggestions, compliments, or concerns about our products or services, please don't hesitate to reach out. Every piece of feedback is valuable to us.</p>

            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;">We look forward to hearing from you and are committed to providing you with the best shopping experience possible. Thank you for choosing {{ $settings->site_name ?? 'our store' }}!</p>
            </div>

        </div>
    </div>
</section>

<style>
@media (max-width: 768px) {
    .container > div > div:first-of-type {
        grid-template-columns: 1fr !important;
    }
}
</style>
@endsection
