<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title') - {{ $settings->site_name ?? 'Store' }}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @if(!empty($settings->favicon))
    <link rel="icon" href="{{ asset('storage/' . $settings->favicon) }}">
    @endif
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #0891b2;
            --primary-dark: #0e7490;
            --secondary: #f97316;
            --dark: #0f172a;
            --text: #334155;
            --text-light: #64748b;
            --border: #e2e8f0;
            --bg: #f8fafc;
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: var(--bg); color: var(--text); line-height: 1.7; }
        a { text-decoration: none; color: var(--primary); }
        a:hover { color: var(--primary-dark); }
        .container { max-width: 1280px; margin: 0 auto; padding: 0 20px; }
        
        /* Header */
        .header { background: #fff; box-shadow: 0 1px 3px rgba(0,0,0,.08); position: sticky; top: 0; z-index: 100; }
        .header-main { display: flex; align-items: center; justify-content: space-between; height: 70px; }
        .logo { font-size: 24px; font-weight: 700; color: var(--dark); display: flex; align-items: center; gap: 10px; text-decoration: none; }
        .logo img { height: 45px; }
        .logo-icon { width: 40px; height: 40px; background: var(--primary); border-radius: 10px; display: flex; align-items: center; justify-content: center; color: #fff; }
        
        .header-nav { display: flex; align-items: center; gap: 24px; }
        .header-nav a { color: var(--text); font-size: 14px; font-weight: 500; transition: color .2s; }
        .header-nav a:hover { color: var(--primary); }
        .shop-btn { background: var(--primary); color: #fff !important; padding: 10px 24px; border-radius: 8px; }
        .shop-btn:hover { background: var(--primary-dark); }
        
        /* Page Header */
        .page-header { background: linear-gradient(135deg, var(--primary) 0%, #0e7490 50%, #164e63 100%); color: #fff; padding: 50px 0; }
        .page-header h1 { font-size: 36px; font-weight: 700; margin-bottom: 10px; }
        .page-header p { font-size: 16px; opacity: .9; }
        .breadcrumb { margin-top: 16px; font-size: 14px; opacity: .8; }
        .breadcrumb a { color: #fff; opacity: .8; }
        .breadcrumb a:hover { opacity: 1; }
        .breadcrumb span { margin: 0 8px; }
        
        /* Content */
        .page-content { padding: 50px 0 80px; }
        .content-card { background: #fff; border-radius: 16px; padding: 50px; box-shadow: 0 1px 3px rgba(0,0,0,.05); max-width: 900px; margin: 0 auto; }
        
        .content-card h2 { font-size: 22px; color: var(--dark); margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid var(--border); }
        .content-card h2:first-child { margin-top: 0; }
        .content-card h3 { font-size: 18px; color: var(--dark); margin: 30px 0 12px; }
        .content-card p { margin-bottom: 16px; color: var(--text); }
        .content-card ul, .content-card ol { margin: 16px 0; padding-left: 24px; }
        .content-card li { margin-bottom: 10px; }
        .content-card strong { color: var(--dark); }
        
        .highlight-box { background: #ecfeff; border-left: 4px solid var(--primary); padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0; }
        .highlight-box p { margin: 0; }
        
        .last-updated { font-size: 13px; color: var(--text-light); margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid var(--border); }
        
        /* Contact Info */
        .contact-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px; margin: 30px 0; }
        .contact-card { background: var(--bg); padding: 24px; border-radius: 12px; text-align: center; }
        .contact-card svg { width: 40px; height: 40px; color: var(--primary); margin-bottom: 12px; }
        .contact-card h4 { font-size: 16px; color: var(--dark); margin-bottom: 8px; }
        .contact-card p { font-size: 14px; color: var(--text-light); margin: 0; }
        .contact-card a { color: var(--primary); font-weight: 500; }
        
        /* Footer */
        .footer { background: var(--dark); color: #fff; padding: 50px 0 30px; }
        .footer-grid { display: grid; grid-template-columns: 2fr repeat(3, 1fr); gap: 50px; margin-bottom: 40px; }
        .footer-brand { font-size: 22px; font-weight: 700; margin-bottom: 16px; }
        .footer-desc { font-size: 14px; color: #94a3b8; line-height: 1.7; }
        .footer-title { font-size: 15px; font-weight: 600; margin-bottom: 20px; }
        .footer-links { list-style: none; }
        .footer-links li { margin-bottom: 12px; }
        .footer-links a { color: #94a3b8; font-size: 14px; transition: color .2s; text-decoration: none; }
        .footer-links a:hover { color: #fff; }
        .footer-bottom { text-align: center; padding-top: 30px; border-top: 1px solid #334155; color: #64748b; font-size: 13px; }
        
        /* Responsive */
        @media (max-width: 768px) {
            .header-nav { display: none; }
            .page-header { padding: 30px 0; }
            .page-header h1 { font-size: 26px; }
            .content-card { padding: 30px 20px; border-radius: 0; }
            .contact-grid { grid-template-columns: 1fr; }
            .footer-grid { grid-template-columns: 1fr; gap: 30px; text-align: center; }
        }
    </style>
</head>
<body>

{{-- Header --}}
<header class="header">
    <div class="container">
        <div class="header-main">
            <a href="{{ route('ecommerce.shop') }}" class="logo">
                @if(!empty($settings->logo))
                    <img src="{{ asset('storage/' . $settings->logo) }}" alt="{{ $settings->site_name ?? 'Store' }}">
                @else
                    <span class="logo-icon">
                        <svg width="22" height="22" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                        </svg>
                    </span>
                    {{ $settings->site_name ?? 'Store' }}
                @endif
            </a>
            
            <nav class="header-nav">
                <a href="{{ route('ecommerce.shop') }}">Home</a>
                <a href="{{ route('ecommerce.page.about') }}">About Us</a>
                <a href="{{ route('ecommerce.page.contact') }}">Contact</a>
                <a href="{{ route('ecommerce.shop') }}" class="shop-btn">Shop Now</a>
            </nav>
        </div>
    </div>
</header>

{{-- Page Header --}}
<section class="page-header">
    <div class="container">
        <h1>@yield('page_title')</h1>
        <p>@yield('page_subtitle')</p>
        <div class="breadcrumb">
            <a href="{{ route('ecommerce.shop') }}">Home</a>
            <span>›</span>
            @yield('page_title')
        </div>
    </div>
</section>

{{-- Content --}}
<section class="page-content">
    <div class="container">
        <div class="content-card">
            @yield('content')
        </div>
    </div>
</section>

{{-- Footer --}}
<footer class="footer">
    <div class="container">
        <div class="footer-grid">
            <div>
                <div class="footer-brand">{{ $settings->site_name ?? 'Store' }}</div>
                <p class="footer-desc">Your trusted online shopping destination for quality products at great prices.</p>
            </div>
            <div>
                <div class="footer-title">Quick Links</div>
                <ul class="footer-links">
                    <li><a href="{{ route('ecommerce.shop') }}">Shop</a></li>
                    <li><a href="{{ route('ecommerce.page.about') }}">About Us</a></li>
                    <li><a href="{{ route('ecommerce.page.contact') }}">Contact Us</a></li>
                </ul>
            </div>
            <div>
                <div class="footer-title">Policies</div>
                <ul class="footer-links">
                    <li><a href="{{ route('ecommerce.page.privacy') }}">Privacy Policy</a></li>
                    <li><a href="{{ route('ecommerce.page.terms') }}">Terms & Conditions</a></li>
                    <li><a href="{{ route('ecommerce.page.refund') }}">Refund Policy</a></li>
                    <li><a href="{{ route('ecommerce.page.shipping') }}">Shipping Policy</a></li>
                </ul>
            </div>
            <div>
                <div class="footer-title">Contact</div>
                <ul class="footer-links">
                    @if(!empty($settings->contact_email))<li><a href="mailto:{{ $settings->contact_email }}">{{ $settings->contact_email }}</a></li>@endif
                    @if(!empty($settings->contact_phone))<li>{{ $settings->contact_phone }}</li>@endif
                    @if(!empty($settings->store_address))<li>{{ $settings->store_address }}</li>@endif
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            © {{ date('Y') }} {{ $settings->site_name ?? 'Store' }}. All Rights Reserved.
        </div>
    </div>
</footer>

</body>
</html>