@extends('ecommerce::public.shop-layout')

@section('title', 'Privacy Policy')

@section('content')
{{-- Page Header --}}
<section style="background: linear-gradient(135deg, #0891b2 0%, #0e7490 50%, #164e63 100%); color: #fff; padding: 50px 0;">
    <div class="container">
        <h1 style="font-size: 36px; font-weight: 700; margin-bottom: 10px;">Privacy Policy</h1>
        <p style="font-size: 16px; opacity: .9;">How we collect, use, and protect your personal information</p>
        <div style="margin-top: 16px; font-size: 14px; opacity: .8;">
            <a href="{{ route('ecommerce.shop') }}" style="color: #fff; opacity: .8;">Home</a>
            <span style="margin: 0 8px;">›</span>
            Privacy Policy
        </div>
    </div>
</section>

{{-- Content --}}
<section style="padding: 50px 0 80px;">
    <div class="container">
        <div style="background: #fff; border-radius: 16px; padding: 50px; box-shadow: 0 1px 3px rgba(0,0,0,.05); max-width: 900px; margin: 0 auto;">
            
            <p style="font-size: 13px; color: #64748b; margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #e2e8f0;">Last Updated: {{ date('F d, Y') }}</p>

            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">{{ $settings->site_name ?? 'Our Company' }} ("we," "our," or "us") is committed to protecting your privacy. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you visit our website <strong>{{ request()->getHost() }}</strong> and make purchases from our online store.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">1. Information We Collect</h2>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Personal Information</h3>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We may collect personal information that you voluntarily provide to us when you:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Register for an account on our website</li>
                <li style="margin-bottom: 10px;">Place an order for products</li>
                <li style="margin-bottom: 10px;">Subscribe to our newsletter</li>
                <li style="margin-bottom: 10px;">Contact us via email, phone, or contact form</li>
                <li style="margin-bottom: 10px;">Participate in promotions or surveys</li>
            </ul>

            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">This information may include:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Full name</li>
                <li style="margin-bottom: 10px;">Email address</li>
                <li style="margin-bottom: 10px;">Phone number</li>
                <li style="margin-bottom: 10px;">Shipping and billing address</li>
                <li style="margin-bottom: 10px;">Payment information (processed securely through Razorpay)</li>
                <li style="margin-bottom: 10px;">Order history and preferences</li>
            </ul>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Automatically Collected Information</h3>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">When you visit our website, we may automatically collect certain information, including:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">IP address</li>
                <li style="margin-bottom: 10px;">Browser type and version</li>
                <li style="margin-bottom: 10px;">Device type and operating system</li>
                <li style="margin-bottom: 10px;">Pages visited and time spent on pages</li>
                <li style="margin-bottom: 10px;">Referring website addresses</li>
                <li style="margin-bottom: 10px;">Cookies and similar tracking technologies</li>
            </ul>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">2. How We Use Your Information</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We use the collected information for the following purposes:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Process Orders:</strong> To process and fulfill your orders, including payment processing, shipping, and delivery</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Customer Service:</strong> To respond to your inquiries, provide support, and resolve issues</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Communication:</strong> To send order confirmations, shipping updates, and important notices</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Marketing:</strong> To send promotional offers, newsletters, and product updates (with your consent)</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Improvement:</strong> To analyze usage patterns and improve our website, products, and services</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Security:</strong> To detect, prevent, and address fraud and security issues</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Legal Compliance:</strong> To comply with applicable laws, regulations, and legal processes</li>
            </ul>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">3. Information Sharing and Disclosure</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We do not sell, trade, or rent your personal information to third parties. We may share your information only in the following circumstances:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Service Providers:</strong> With trusted third-party service providers who assist us in operating our website, processing payments (Razorpay), and delivering products</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Shipping Partners:</strong> With courier and logistics companies to deliver your orders</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Legal Requirements:</strong> When required by law, court order, or government regulation</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Business Transfers:</strong> In connection with a merger, acquisition, or sale of assets</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Protection:</strong> To protect our rights, privacy, safety, or property</li>
            </ul>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">4. Payment Security</h2>
            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;"><strong style="color: #0f172a;">Secure Payments:</strong> All payment transactions are processed through <strong>Razorpay</strong>, a PCI-DSS compliant payment gateway. We do not store your complete credit/debit card details on our servers. Your payment information is encrypted and transmitted securely.</p>
            </div>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">5. Cookies and Tracking Technologies</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We use cookies and similar tracking technologies to:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Remember your preferences and login status</li>
                <li style="margin-bottom: 10px;">Analyze website traffic and usage</li>
                <li style="margin-bottom: 10px;">Personalize your shopping experience</li>
                <li style="margin-bottom: 10px;">Enable shopping cart functionality</li>
            </ul>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">You can control cookies through your browser settings. However, disabling cookies may affect the functionality of our website.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">6. Data Security</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We implement appropriate technical and organizational security measures to protect your personal information, including:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">SSL/TLS encryption for data transmission</li>
                <li style="margin-bottom: 10px;">Secure servers and databases</li>
                <li style="margin-bottom: 10px;">Regular security assessments</li>
                <li style="margin-bottom: 10px;">Limited access to personal information</li>
            </ul>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">However, no method of transmission over the Internet is 100% secure, and we cannot guarantee absolute security.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">7. Your Rights</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">You have the right to:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Access the personal information we hold about you</li>
                <li style="margin-bottom: 10px;">Request correction of inaccurate information</li>
                <li style="margin-bottom: 10px;">Request deletion of your account and personal data</li>
                <li style="margin-bottom: 10px;">Opt-out of marketing communications</li>
                <li style="margin-bottom: 10px;">Withdraw consent where applicable</li>
            </ul>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">To exercise these rights, please contact us using the information provided below.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">8. Contact Us</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">If you have any questions, concerns, or requests regarding this Privacy Policy or our privacy practices, please contact us:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Business Name:</strong> {{ $settings->site_name ?? 'Our Company' }}</li>
                @if(!empty($settings->contact_email))<li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Email:</strong> <a href="mailto:{{ $settings->contact_email }}" style="color: #0891b2;">{{ $settings->contact_email }}</a></li>@endif
                @if(!empty($settings->contact_phone))<li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Phone:</strong> {{ $settings->contact_phone }}</li>@endif
                @if(!empty($settings->store_address))<li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Address:</strong> {{ $settings->store_address }}, {{ $settings->store_city }}, {{ $settings->store_state }} - {{ $settings->store_pincode }}</li>@endif
            </ul>

            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;">By using our website and services, you acknowledge that you have read and understood this Privacy Policy and agree to its terms.</p>
            </div>

        </div>
    </div>
</section>
@endsection
