@extends('ecommerce::public.shop-layout')

@section('title', 'Refund & Cancellation Policy')

@section('content')
{{-- Page Header --}}
<section style="background: linear-gradient(135deg, #0891b2 0%, #0e7490 50%, #164e63 100%); color: #fff; padding: 50px 0;">
    <div class="container">
        <h1 style="font-size: 36px; font-weight: 700; margin-bottom: 10px;">Refund & Cancellation Policy</h1>
        <p style="font-size: 16px; opacity: .9;">Our commitment to your satisfaction</p>
        <div style="margin-top: 16px; font-size: 14px; opacity: .8;">
            <a href="{{ route('ecommerce.shop') }}" style="color: #fff; opacity: .8;">Home</a>
            <span style="margin: 0 8px;">›</span>
            Refund Policy
        </div>
    </div>
</section>

{{-- Content --}}
<section style="padding: 50px 0 80px;">
    <div class="container">
        <div style="background: #fff; border-radius: 16px; padding: 50px; box-shadow: 0 1px 3px rgba(0,0,0,.05); max-width: 900px; margin: 0 auto;">
            
            <p style="font-size: 13px; color: #64748b; margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #e2e8f0;">Last Updated: {{ date('F d, Y') }}</p>

            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">At {{ $settings->site_name ?? 'our store' }}, customer satisfaction is our top priority. We understand that sometimes things don't work out as expected, which is why we have created this comprehensive Refund and Cancellation Policy to ensure a hassle-free experience.</p>

            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;"><strong style="color: #0f172a;">Our Promise:</strong> We are committed to providing quality products and excellent customer service. If you're not completely satisfied with your purchase, we're here to help.</p>
            </div>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">1. Order Cancellation</h2>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Cancellation by Customer</h3>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">You may cancel your order under the following conditions:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Before Dispatch:</strong> Orders can be cancelled free of charge if the order has not yet been shipped. Please contact us immediately via email or phone.</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">After Dispatch:</strong> Once the order has been shipped, cancellation is not possible. You may refuse delivery or return the product after receiving it as per our return policy.</li>
            </ul>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Cancellation by Us</h3>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We reserve the right to cancel orders due to:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Product unavailability or stock issues</li>
                <li style="margin-bottom: 10px;">Pricing or product description errors</li>
                <li style="margin-bottom: 10px;">Suspected fraudulent transactions</li>
                <li style="margin-bottom: 10px;">Delivery address issues or unserviceable locations</li>
                <li style="margin-bottom: 10px;">Non-payment or payment failures</li>
            </ul>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">In such cases, a full refund will be processed to your original payment method.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">2. Return Policy</h2>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Return Eligibility</h3>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">Products may be returned within <strong>7 days</strong> from the date of delivery if:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">The product is damaged or defective upon receipt</li>
                <li style="margin-bottom: 10px;">The wrong product was delivered</li>
                <li style="margin-bottom: 10px;">The product is significantly different from the description</li>
                <li style="margin-bottom: 10px;">The product is unused and in its original packaging</li>
            </ul>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Non-Returnable Items</h3>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">The following items cannot be returned:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Perishable goods (food items, fresh products)</li>
                <li style="margin-bottom: 10px;">Personal care and hygiene products</li>
                <li style="margin-bottom: 10px;">Customized or personalized items</li>
                <li style="margin-bottom: 10px;">Items with broken seals (health and safety reasons)</li>
                <li style="margin-bottom: 10px;">Downloadable products or digital goods</li>
                <li style="margin-bottom: 10px;">Items marked as "Non-Returnable" on the product page</li>
            </ul>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">3. Refund Policy</h2>

            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;"><strong style="color: #0f172a;">Refund Timeline:</strong> Once your return is received and inspected, we will process your refund within <strong>5-7 business days</strong>. The refund will be credited to your original payment method.</p>
            </div>

            <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
                <tr style="background: #f1f5f9;">
                    <th style="padding: 12px; text-align: left; border: 1px solid #e2e8f0;">Payment Method</th>
                    <th style="padding: 12px; text-align: left; border: 1px solid #e2e8f0;">Refund Timeline</th>
                </tr>
                <tr>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">Credit/Debit Card</td>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">5-7 business days</td>
                </tr>
                <tr>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">Net Banking</td>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">5-7 business days</td>
                </tr>
                <tr>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">UPI</td>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">3-5 business days</td>
                </tr>
                <tr>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">Wallets (Paytm, PhonePe, etc.)</td>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">3-5 business days</td>
                </tr>
                <tr>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">Cash on Delivery (COD)</td>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">Bank transfer within 7-10 business days</td>
                </tr>
            </table>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Refund Amount</h3>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Full Refund:</strong> Product price + shipping charges (for defective/wrong products or our error)</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Product Price Only:</strong> For change of mind returns, original shipping charges are non-refundable</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Partial Refund:</strong> If the returned product shows signs of use or is not in original condition</li>
            </ul>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">4. How to Initiate a Return</h2>
            <ol style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Contact our customer support within 7 days of delivery</li>
                <li style="margin-bottom: 10px;">Provide your order number and reason for return</li>
                <li style="margin-bottom: 10px;">Include photographs of the product (for damaged/defective items)</li>
                <li style="margin-bottom: 10px;">Our team will review and approve/reject the return request within 2 business days</li>
                <li style="margin-bottom: 10px;">If approved, we will arrange for pickup or provide return shipping instructions</li>
                <li style="margin-bottom: 10px;">Pack the product securely in original packaging</li>
            </ol>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">5. Contact Us</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">For any refund or return queries, please contact our customer support:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                @if(!empty($settings->contact_email))<li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Email:</strong> <a href="mailto:{{ $settings->contact_email }}" style="color: #0891b2;">{{ $settings->contact_email }}</a></li>@endif
                @if(!empty($settings->contact_phone))<li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Phone:</strong> {{ $settings->contact_phone }}</li>@endif
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Working Hours:</strong> Monday to Saturday, 10:00 AM to 6:00 PM IST</li>
            </ul>

            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;"><strong style="color: #0f172a;">Note:</strong> This policy is subject to change without prior notice. Please review this page periodically for updates. By making a purchase on our website, you agree to abide by this Refund and Cancellation Policy.</p>
            </div>

        </div>
    </div>
</section>
@endsection
