@extends('ecommerce::public.shop-layout')

@section('title', 'Shipping & Delivery Policy')

@section('content')
{{-- Page Header --}}
<section style="background: linear-gradient(135deg, #0891b2 0%, #0e7490 50%, #164e63 100%); color: #fff; padding: 50px 0;">
    <div class="container">
        <h1 style="font-size: 36px; font-weight: 700; margin-bottom: 10px;">Shipping & Delivery Policy</h1>
        <p style="font-size: 16px; opacity: .9;">Fast, reliable delivery to your doorstep</p>
        <div style="margin-top: 16px; font-size: 14px; opacity: .8;">
            <a href="{{ route('ecommerce.shop') }}" style="color: #fff; opacity: .8;">Home</a>
            <span style="margin: 0 8px;">›</span>
            Shipping Policy
        </div>
    </div>
</section>

{{-- Content --}}
<section style="padding: 50px 0 80px;">
    <div class="container">
        <div style="background: #fff; border-radius: 16px; padding: 50px; box-shadow: 0 1px 3px rgba(0,0,0,.05); max-width: 900px; margin: 0 auto;">
            
            <p style="font-size: 13px; color: #64748b; margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #e2e8f0;">Last Updated: {{ date('F d, Y') }}</p>

            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">At {{ $settings->site_name ?? 'our store' }}, we are committed to delivering your orders quickly and safely. This Shipping and Delivery Policy outlines our shipping methods, delivery times, and related information.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">1. Shipping Coverage</h2>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Domestic Shipping</h3>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We currently ship to all serviceable pin codes across India. Our delivery network covers:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">All major cities and metros</li>
                <li style="margin-bottom: 10px;">Tier 2 and Tier 3 cities</li>
                <li style="margin-bottom: 10px;">Most rural areas (may have extended delivery times)</li>
            </ul>

            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;"><strong style="color: #0f172a;">Pin Code Check:</strong> Enter your pin code during checkout to verify delivery availability and estimated delivery time for your location.</p>
            </div>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">2. Shipping Charges</h2>

            <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
                <tr style="background: #f1f5f9;">
                    <th style="padding: 12px; text-align: left; border: 1px solid #e2e8f0;">Order Value</th>
                    <th style="padding: 12px; text-align: left; border: 1px solid #e2e8f0;">Shipping Charges</th>
                    <th style="padding: 12px; text-align: left; border: 1px solid #e2e8f0;">Estimated Delivery</th>
                </tr>
                <tr>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">Below ₹499</td>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">₹50</td>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">3-5 business days</td>
                </tr>
                <tr>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">₹500 and above</td>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;"><strong style="color: #059669;">FREE</strong></td>
                    <td style="padding: 12px; border: 1px solid #e2e8f0;">3-5 business days</td>
                </tr>
            </table>

            <p style="margin-bottom: 16px; color: #64748b; font-size: 14px;"><em>Note: Shipping charges and free shipping thresholds may vary during promotional periods.</em></p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">3. Delivery Timeframes</h2>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Standard Delivery</h3>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Metro Cities:</strong> 2-3 business days (Bangalore, Chennai, Hyderabad, Mumbai, Delhi, Kolkata)</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Major Cities:</strong> 3-5 business days</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Other Areas:</strong> 5-7 business days</li>
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Remote/Rural Areas:</strong> 7-10 business days</li>
            </ul>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Factors Affecting Delivery Time</h3>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">Delivery times may be affected by:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Public holidays and weekends</li>
                <li style="margin-bottom: 10px;">Natural disasters or adverse weather conditions</li>
                <li style="margin-bottom: 10px;">High order volumes during sale periods</li>
                <li style="margin-bottom: 10px;">Incorrect or incomplete delivery address</li>
            </ul>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">4. Order Processing</h2>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Orders are processed within 1-2 business days</li>
                <li style="margin-bottom: 10px;">Orders placed after 2:00 PM IST may be processed the next business day</li>
                <li style="margin-bottom: 10px;">Orders placed on weekends/holidays will be processed on the next business day</li>
            </ul>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">5. Order Tracking</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">Once your order is shipped, you can track your delivery:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Via the tracking link sent to your email/SMS</li>
                <li style="margin-bottom: 10px;">By logging into your account and viewing "My Orders"</li>
                <li style="margin-bottom: 10px;">By contacting our customer support with your order number</li>
            </ul>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">6. Cash on Delivery (COD)</h2>
            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;"><strong style="color: #0f172a;">COD Availability:</strong> Cash on Delivery is available for most locations. Please keep exact amount ready at the time of delivery.</p>
            </div>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">7. Address Guidelines</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">To ensure smooth delivery, please provide:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Complete door/flat number and floor</li>
                <li style="margin-bottom: 10px;">Building/apartment name</li>
                <li style="margin-bottom: 10px;">Street address and landmark</li>
                <li style="margin-bottom: 10px;">Correct pin code</li>
                <li style="margin-bottom: 10px;">Active mobile number for delivery updates</li>
            </ul>

            <div style="background: #fef3c7; border-left: 4px solid #f59e0b; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;"><strong style="color: #92400e;">Important:</strong> We are not responsible for delays or non-delivery due to incorrect or incomplete address information. Please verify your shipping address before confirming your order.</p>
            </div>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">8. Contact Us</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">For any shipping or delivery queries, please contact us:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                @if(!empty($settings->contact_email))<li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Email:</strong> <a href="mailto:{{ $settings->contact_email }}" style="color: #0891b2;">{{ $settings->contact_email }}</a></li>@endif
                @if(!empty($settings->contact_phone))<li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Phone:</strong> {{ $settings->contact_phone }}</li>@endif
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Working Hours:</strong> Monday to Saturday, 10:00 AM to 6:00 PM IST</li>
            </ul>

            <p style="margin-top: 30px; color: #334155; line-height: 1.7;">We appreciate your patience and understanding. Our team works hard to ensure your orders reach you as quickly and safely as possible.</p>

        </div>
    </div>
</section>
@endsection
