@extends('ecommerce::public.shop-layout')

@section('title', 'Terms and Conditions')

@section('content')
{{-- Page Header --}}
<section style="background: linear-gradient(135deg, #0891b2 0%, #0e7490 50%, #164e63 100%); color: #fff; padding: 50px 0;">
    <div class="container">
        <h1 style="font-size: 36px; font-weight: 700; margin-bottom: 10px;">Terms and Conditions</h1>
        <p style="font-size: 16px; opacity: .9;">Please read these terms carefully before using our services</p>
        <div style="margin-top: 16px; font-size: 14px; opacity: .8;">
            <a href="{{ route('ecommerce.shop') }}" style="color: #fff; opacity: .8;">Home</a>
            <span style="margin: 0 8px;">›</span>
            Terms and Conditions
        </div>
    </div>
</section>

{{-- Content --}}
<section style="padding: 50px 0 80px;">
    <div class="container">
        <div style="background: #fff; border-radius: 16px; padding: 50px; box-shadow: 0 1px 3px rgba(0,0,0,.05); max-width: 900px; margin: 0 auto;">
            
            <p style="font-size: 13px; color: #64748b; margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #e2e8f0;">Last Updated: {{ date('F d, Y') }}</p>

            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">Welcome to {{ $settings->site_name ?? 'our website' }}. These Terms and Conditions ("Terms") govern your use of our website <strong>{{ request()->getHost() }}</strong> and the purchase of products from our online store. By accessing or using our website, you agree to be bound by these Terms.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">1. Acceptance of Terms</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">By accessing, browsing, or using this website, you acknowledge that you have read, understood, and agree to be bound by these Terms and Conditions, along with our Privacy Policy, Refund Policy, and Shipping Policy. If you do not agree with any part of these Terms, please do not use our website.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">2. Eligibility</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">To use our website and make purchases, you must:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Be at least 18 years of age or have parental/guardian consent</li>
                <li style="margin-bottom: 10px;">Have the legal capacity to enter into a binding contract</li>
                <li style="margin-bottom: 10px;">Provide accurate and complete information during registration and checkout</li>
                <li style="margin-bottom: 10px;">Not use the website for any illegal or unauthorized purpose</li>
            </ul>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">3. Account Registration</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">To make purchases, you may need to create an account. You are responsible for:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">Maintaining the confidentiality of your account credentials</li>
                <li style="margin-bottom: 10px;">All activities that occur under your account</li>
                <li style="margin-bottom: 10px;">Notifying us immediately of any unauthorized use of your account</li>
                <li style="margin-bottom: 10px;">Ensuring that your account information is accurate and up-to-date</li>
            </ul>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">We reserve the right to suspend or terminate accounts that violate these Terms or are involved in fraudulent activities.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">4. Products and Pricing</h2>
            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Product Information</h3>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">We strive to display accurate product descriptions, images, and prices</li>
                <li style="margin-bottom: 10px;">Colors may vary slightly due to monitor settings and photography</li>
                <li style="margin-bottom: 10px;">Product availability is subject to change without notice</li>
                <li style="margin-bottom: 10px;">We reserve the right to limit quantities of products ordered</li>
            </ul>

            <h3 style="font-size: 18px; color: #0f172a; margin: 30px 0 12px;">Pricing</h3>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;">All prices are listed in Indian Rupees (INR) and include applicable taxes unless otherwise stated</li>
                <li style="margin-bottom: 10px;">Prices are subject to change without prior notice</li>
                <li style="margin-bottom: 10px;">In case of pricing errors, we reserve the right to cancel orders and issue refunds</li>
                <li style="margin-bottom: 10px;">Promotional offers and discounts are subject to specific terms and validity periods</li>
            </ul>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">5. Orders and Payment</h2>
            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;">All payments are processed securely through <strong>Razorpay</strong>. We accept various payment methods including Credit Cards, Debit Cards, Net Banking, UPI, and Wallets. By making a payment, you confirm that the payment method used belongs to you or you have authorization to use it.</p>
            </div>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">6. Shipping and Delivery</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">Please refer to our <a href="{{ route('ecommerce.page.shipping') }}" style="color: #0891b2;">Shipping Policy</a> for detailed information about shipping methods, charges, estimated delivery times, and delivery areas.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">7. Returns and Refunds</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">Please refer to our <a href="{{ route('ecommerce.page.refund') }}" style="color: #0891b2;">Refund and Cancellation Policy</a> for detailed information about return eligibility, refund process, and cancellation procedures.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">8. Intellectual Property</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">All content on this website, including but not limited to text, graphics, logos, images, product descriptions, website design, software and code is the property of {{ $settings->site_name ?? 'our company' }} or its content suppliers and is protected by intellectual property laws. You may not reproduce, distribute, modify, or create derivative works without our prior written consent.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">9. Limitation of Liability</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">To the maximum extent permitted by law, {{ $settings->site_name ?? 'we' }} shall not be liable for any indirect, incidental, special, consequential, or punitive damages arising from your use or inability to use the website, any products purchased through the website, or unauthorized access to your data.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">10. Governing Law</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">These Terms shall be governed by and construed in accordance with the laws of India. Any disputes arising from these Terms or your use of the website shall be subject to the exclusive jurisdiction of the courts in {{ $settings->store_city ?? 'Bangalore' }}, {{ $settings->store_state ?? 'Karnataka' }}, India.</p>

            <h2 style="font-size: 22px; color: #0f172a; margin: 40px 0 16px; padding-bottom: 10px; border-bottom: 2px solid #e2e8f0;">11. Contact Information</h2>
            <p style="margin-bottom: 16px; color: #334155; line-height: 1.7;">For any questions or concerns regarding these Terms, please contact us:</p>
            <ul style="margin: 16px 0; padding-left: 24px; line-height: 1.7;">
                <li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Business Name:</strong> {{ $settings->site_name ?? 'Our Company' }}</li>
                @if(!empty($settings->contact_email))<li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Email:</strong> <a href="mailto:{{ $settings->contact_email }}" style="color: #0891b2;">{{ $settings->contact_email }}</a></li>@endif
                @if(!empty($settings->contact_phone))<li style="margin-bottom: 10px;"><strong style="color: #0f172a;">Phone:</strong> {{ $settings->contact_phone }}</li>@endif
            </ul>

            <div style="background: #ecfeff; border-left: 4px solid #0891b2; padding: 20px; border-radius: 0 8px 8px 0; margin: 24px 0;">
                <p style="margin: 0; line-height: 1.7;">By using our website, you acknowledge that you have read, understood, and agree to be bound by these Terms and Conditions.</p>
            </div>

        </div>
    </div>
</section>
@endsection
