<?php

namespace Modules\Ecommerce\Services;

/**
 * Ecommerce Module Service
 * 
 * Provides module configuration and menu structure for auto-registration.
 */
class EcommerceService
{
    /**
     * Module configuration
     */
    public static function config(): array
    {
        return [
            'name' => 'Ecommerce',
            'alias' => 'ecommerce',
            'description' => 'Ecommerce store with orders and reviews',
            'version' => '1.0.0',
            'is_core' => false,
            'sort_order' => 15,
        ];
    }

    /**
     * Menu configuration for auto-registration
     */
    public static function menus(): array
    {
        return [
            [
                'menu_name' => 'Ecommerce',
                'slug' => 'ecommerce',
                'icon' => 'shopping-cart',
                'route' => 'admin.ecommerce.index',
                'category' => 'core',
                'sort_order' => 15,
                'actions' => ['read', 'create', 'edit', 'delete', 'export', 'import'],
                'children' => [
                    [
                        'menu_name' => 'Dashboard',
                        'slug' => 'dashboard',
                        'icon' => 'home',
                        'route' => 'admin.ecommerce.index',
                        'sort_order' => 1,
                    ],
                    [
                        'menu_name' => 'Orders',
                        'slug' => 'orders',
                        'icon' => 'cube',
                        'route' => 'admin.ecommerce.orders',
                        'sort_order' => 2,
                    ],
                    [
                        'menu_name' => 'Reviews',
                        'slug' => 'reviews',
                        'icon' => 'star',
                        'route' => 'admin.ecommerce.reviews',
                        'sort_order' => 3,
                    ],
                    [
                        'menu_name' => 'Settings',
                        'slug' => 'settings',
                        'icon' => 'cog-6-tooth',
                        'route' => 'admin.ecommerce.settings',
                        'sort_order' => 4,
                    ],
                ],
            ],
        ];
    }

    /**
     * Get module alias
     */
    public static function getAlias(): string
    {
        return self::config()['alias'];
    }

    /**
     * Get module name
     */
    public static function getName(): string
    {
        return self::config()['name'];
    }
}