<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

/**
 * Add storage_type to racks table
 */
return new class extends Migration
{
    public function up(): void
    {
        // Check if column exists
        if (!Schema::hasColumn('racks', 'storage_type')) {
            // Add column using raw SQL to avoid doctrine/dbal dependency
            DB::statement("ALTER TABLE racks ADD COLUMN storage_type ENUM('PALLET','SHELF','BIN','FLOOR','COLD','FREEZER') DEFAULT 'SHELF' AFTER level");
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('racks', 'storage_type')) {
            Schema::table('racks', function (Blueprint $table) {
                $table->dropColumn('storage_type');
            });
        }
    }
};
