<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Only add column if it doesn't exist (for existing installations)
        if (!Schema::hasColumn('warehouses', 'contact_staff_id')) {
            Schema::table('warehouses', function (Blueprint $table) {
                $table->unsignedBigInteger('contact_staff_id')->nullable()->after('country');
            });
        }
        
        // Add foreign key constraint if staffs table exists and FK doesn't exist
        if (Schema::hasTable('staffs') && Schema::hasColumn('warehouses', 'contact_staff_id')) {
            try {
                Schema::table('warehouses', function (Blueprint $table) {
                    $table->foreign('contact_staff_id')
                        ->references('id')
                        ->on('staffs')
                        ->onDelete('set null');
                });
            } catch (\Exception $e) {
                // Foreign key might already exist, ignore
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('warehouses', 'contact_staff_id')) {
            Schema::table('warehouses', function (Blueprint $table) {
                // Drop foreign key first
                try {
                    $table->dropForeign(['contact_staff_id']);
                } catch (\Exception $e) {
                    // FK might not exist
                }
                $table->dropColumn('contact_staff_id');
            });
        }
    }
};
