<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('delivery_receipts', function (Blueprint $table) {
            $table->id();
            $table->string('receipt_number', 50)->unique();
            $table->unsignedBigInteger('invoice_id');
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->unsignedBigInteger('warehouse_id');
            $table->date('delivery_date');
            $table->enum('status', ['pending', 'approved', 'rejected', 'delivered'])->default('pending');
            $table->text('remarks')->nullable();
            $table->text('rejection_reason')->nullable();
            
            // Approval tracking
            $table->string('approved_by')->nullable();
            $table->timestamp('approved_at')->nullable();
            
            // Delivery tracking
            $table->string('delivered_by')->nullable();
            $table->timestamp('delivered_at')->nullable();
            
            // Audit
            $table->string('created_by')->nullable();
            $table->timestamps();
            
            // Foreign keys
            $table->foreign('invoice_id')->references('id')->on('invoices')->onDelete('cascade');
            $table->foreign('customer_id')->references('id')->on('customers')->onDelete('set null');
            $table->foreign('warehouse_id')->references('id')->on('warehouses')->onDelete('restrict');
            
            // Indexes
            $table->index(['status', 'delivery_date']);
            $table->index('invoice_id');
            $table->index('customer_id');
            $table->index('warehouse_id');
        });

        Schema::create('delivery_receipt_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('delivery_receipt_id');
            $table->unsignedBigInteger('invoice_item_id')->nullable();
            $table->unsignedBigInteger('product_id');
            $table->unsignedBigInteger('variation_id')->nullable();
            $table->unsignedBigInteger('rack_id')->nullable();
            $table->unsignedBigInteger('lot_id')->nullable();
            $table->unsignedBigInteger('unit_id')->nullable();
            $table->string('description', 500)->nullable();
            $table->decimal('quantity', 15, 4);              // Requested quantity
            $table->decimal('delivered_qty', 15, 4)->default(0);  // Actual delivered
            $table->decimal('base_qty', 15, 4)->default(0);  // In base units
            $table->timestamps();
            
            // Foreign keys
            $table->foreign('delivery_receipt_id')->references('id')->on('delivery_receipts')->onDelete('cascade');
            $table->foreign('product_id')->references('id')->on('products')->onDelete('restrict');
            $table->foreign('variation_id')->references('id')->on('product_variations')->onDelete('set null');
            $table->foreign('rack_id')->references('id')->on('racks')->onDelete('set null');
            $table->foreign('lot_id')->references('id')->on('lots')->onDelete('set null');
            $table->foreign('unit_id')->references('id')->on('units')->onDelete('set null');
            
            // Indexes
            $table->index('delivery_receipt_id');
            $table->index('product_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('delivery_receipt_items');
        Schema::dropIfExists('delivery_receipts');
    }
};