
<style>
.alerts-container { padding: 24px; max-width: 1400px; margin: 0 auto; }
.page-title { font-size: 24px; font-weight: 600; color: var(--text-primary); margin-bottom: 24px; }
.stats-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 16px; margin-bottom: 24px; }
.stat-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; padding: 20px; }
.stat-label { font-size: 13px; color: var(--text-muted); margin-bottom: 8px; }
.stat-value { font-size: 28px; font-weight: 700; }
.stat-value.danger { color: #ef4444; }
.stat-value.warning { color: #f59e0b; }
.stat-value.success { color: #10b981; }
.alerts-table { width: 100%; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
.alerts-table th, .alerts-table td { padding: 12px 16px; text-align: left; border-bottom: 1px solid var(--card-border); }
.alerts-table th { background: var(--body-bg); font-weight: 600; font-size: 13px; color: var(--text-muted); }
.alerts-table tr:last-child td { border-bottom: none; }
.badge { padding: 4px 10px; border-radius: 20px; font-size: 12px; font-weight: 600; }
.badge-danger { background: #fef2f2; color: #dc2626; }
.badge-warning { background: #fffbeb; color: #d97706; }
.product-info { display: flex; align-items: center; gap: 12px; }
.product-img { width: 40px; height: 40px; border-radius: 8px; object-fit: cover; background: var(--body-bg); }
.product-name { font-weight: 500; color: var(--text-primary); }
.product-sku { font-size: 12px; color: var(--text-muted); }
.empty-state { text-align: center; padding: 60px 20px; color: var(--text-muted); }
.empty-state svg { width: 64px; height: 64px; margin-bottom: 16px; opacity: 0.5; }
</style>

<div class="alerts-container">
    <h1 class="page-title">Low Stock Alerts</h1>
    
    <!-- Stats Summary -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-label">Out of Stock</div>
            <div class="stat-value danger">{{ $statusSummary['out_of_stock'] ?? 0 }}</div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Critical (Below Min)</div>
            <div class="stat-value warning">{{ $statusSummary['critical'] ?? 0 }}</div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Low Stock</div>
            <div class="stat-value warning">{{ $statusSummary['low'] ?? 0 }}</div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Healthy Stock</div>
            <div class="stat-value success">{{ $statusSummary['healthy'] ?? 0 }}</div>
        </div>
    </div>
    
    <!-- Alerts Table -->
    @if(count($lowStockItems) > 0)
    <table class="alerts-table">
        <thead>
            <tr>
                <th>Product</th>
                <th>SKU</th>
                <th>Current Stock</th>
                <th>Min Level</th>
                <th>Status</th>
                <th>Warehouse</th>
            </tr>
        </thead>
        <tbody>
            @foreach($lowStockItems as $item)
            <tr>
                <td>
                    <div class="product-info">
                        <img src="{{ $item['image'] ?? asset('images/no-image.png') }}" alt="" class="product-img">
                        <div>
                            <div class="product-name">{{ $item['product_name'] }}</div>
                        </div>
                    </div>
                </td>
                <td><span class="product-sku">{{ $item['sku'] }}</span></td>
                <td><strong>{{ number_format($item['current_stock'], 2) }}</strong> {{ $item['unit'] }}</td>
                <td>{{ number_format($item['min_stock_level'], 2) }} {{ $item['unit'] }}</td>
                <td>
                    @if($item['current_stock'] <= 0)
                        <span class="badge badge-danger">Out of Stock</span>
                    @elseif($item['current_stock'] < $item['min_stock_level'])
                        <span class="badge badge-warning">Low Stock</span>
                    @endif
                </td>
                <td>{{ $item['warehouse_name'] ?? 'All' }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @else
    <div class="empty-state">
        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>
        <h3>All Stock Levels are Healthy</h3>
        <p>No products are currently below their minimum stock level.</p>
    </div>
    @endif
</div>
