
<style>
.scan-container { padding: 24px; max-width: 800px; margin: 0 auto; }
.page-title { font-size: 24px; font-weight: 600; color: var(--text-primary); margin-bottom: 24px; text-align: center; }
.scan-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 16px; padding: 32px; margin-bottom: 24px; }
.scan-input-group { display: flex; gap: 12px; margin-bottom: 24px; }
.scan-input { flex: 1; padding: 16px 20px; font-size: 18px; border: 2px solid var(--card-border); border-radius: 12px; background: var(--card-bg); color: var(--text-primary); }
.scan-input:focus { outline: none; border-color: #3b82f6; }
.scan-btn { padding: 16px 32px; background: linear-gradient(135deg, #3b82f6, #2563eb); color: #fff; border: none; border-radius: 12px; font-size: 16px; font-weight: 600; cursor: pointer; }
.scan-btn:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3); }
.camera-section { text-align: center; padding: 40px; border: 2px dashed var(--card-border); border-radius: 12px; margin-bottom: 24px; }
.camera-section svg { width: 64px; height: 64px; color: var(--text-muted); margin-bottom: 16px; }
.camera-btn { padding: 12px 24px; background: var(--body-bg); border: 1px solid var(--card-border); border-radius: 8px; cursor: pointer; font-weight: 500; }
#cameraPreview { width: 100%; max-width: 400px; border-radius: 12px; display: none; margin: 16px auto; }
.result-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; padding: 24px; display: none; }
.result-card.show { display: block; }
.result-card.success { border-color: #10b981; background: rgba(16, 185, 129, 0.05); }
.result-card.error { border-color: #ef4444; background: rgba(239, 68, 68, 0.05); }
.result-header { display: flex; align-items: center; gap: 12px; margin-bottom: 16px; }
.result-header svg { width: 24px; height: 24px; }
.result-header.success svg { color: #10b981; }
.result-header.error svg { color: #ef4444; }
.result-title { font-size: 18px; font-weight: 600; }
.result-details { display: grid; grid-template-columns: repeat(2, 1fr); gap: 12px; }
.result-item { padding: 12px; background: var(--body-bg); border-radius: 8px; }
.result-label { font-size: 12px; color: var(--text-muted); margin-bottom: 4px; }
.result-value { font-weight: 600; color: var(--text-primary); }
.recent-scans { margin-top: 24px; }
.recent-title { font-size: 14px; font-weight: 600; color: var(--text-muted); margin-bottom: 12px; }
.recent-list { display: flex; flex-direction: column; gap: 8px; }
.recent-item { padding: 12px; background: var(--body-bg); border-radius: 8px; display: flex; justify-content: space-between; align-items: center; cursor: pointer; }
.recent-item:hover { background: var(--card-border); }
</style>

<div class="scan-container">
    <h1 class="page-title">Barcode Scanner</h1>
    
    <div class="scan-card">
        <!-- Manual Input -->
        <div class="scan-input-group">
            <input type="text" id="barcodeInput" class="scan-input" placeholder="Enter or scan barcode..." autofocus>
            <button type="button" class="scan-btn" onclick="lookupBarcode()">
                <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24" style="display:inline;vertical-align:middle;margin-right:8px;">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                </svg>
                Search
            </button>
        </div>
        
        <!-- Camera Section -->
        <div class="camera-section" id="cameraSection">
            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 9a2 2 0 012-2h.93a2 2 0 001.664-.89l.812-1.22A2 2 0 0110.07 4h3.86a2 2 0 011.664.89l.812 1.22A2 2 0 0018.07 7H19a2 2 0 012 2v9a2 2 0 01-2 2H5a2 2 0 01-2-2V9z"/>
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 13a3 3 0 11-6 0 3 3 0 016 0z"/>
            </svg>
            <p>Use camera to scan barcode</p>
            <button type="button" class="camera-btn" onclick="startCamera()">Open Camera</button>
            <video id="cameraPreview" autoplay playsinline></video>
        </div>
    </div>
    
    <!-- Result Card -->
    <div class="result-card" id="resultCard">
        <div class="result-header" id="resultHeader">
            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            <span class="result-title" id="resultTitle">Product Found</span>
        </div>
        <div class="result-details" id="resultDetails"></div>
    </div>
    
    <!-- Recent Scans -->
    <div class="recent-scans">
        <div class="recent-title">Recent Scans</div>
        <div class="recent-list" id="recentList"></div>
    </div>
</div>

<script>
var recentScans = JSON.parse(localStorage.getItem('recentBarcodeScans') || '[]');

document.getElementById('barcodeInput').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') lookupBarcode();
});

function lookupBarcode() {
    var barcode = document.getElementById('barcodeInput').value.trim();
    if (!barcode) return;
    
    fetch('{{ route("inventory.barcode.lookup") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({ barcode: barcode })
    })
    .then(r => r.json())
    .then(data => {
        var card = document.getElementById('resultCard');
        var header = document.getElementById('resultHeader');
        var title = document.getElementById('resultTitle');
        var details = document.getElementById('resultDetails');
        
        card.classList.add('show');
        
        if (data.success && data.found) {
            card.className = 'result-card show success';
            header.className = 'result-header success';
            title.textContent = data.product?.name || 'Product Found';
            
            details.innerHTML = `
                <div class="result-item"><div class="result-label">SKU</div><div class="result-value">${data.product?.sku || '-'}</div></div>
                <div class="result-item"><div class="result-label">Barcode</div><div class="result-value">${barcode}</div></div>
                <div class="result-item"><div class="result-label">Price</div><div class="result-value">₹${data.product?.sale_price || '0'}</div></div>
                <div class="result-item"><div class="result-label">Stock</div><div class="result-value">${data.product?.stock || '0'} ${data.product?.unit || 'PCS'}</div></div>
            `;
            
            addToRecent(barcode, data.product?.name || 'Unknown');
        } else {
            card.className = 'result-card show error';
            header.className = 'result-header error';
            title.textContent = 'Product Not Found';
            details.innerHTML = `<div class="result-item" style="grid-column:1/-1"><div class="result-value">No product found with barcode: ${barcode}</div></div>`;
        }
    })
    .catch(err => {
        console.error(err);
        alert('Error looking up barcode');
    });
}

function addToRecent(barcode, name) {
    recentScans = recentScans.filter(s => s.barcode !== barcode);
    recentScans.unshift({ barcode: barcode, name: name, time: new Date().toLocaleTimeString() });
    recentScans = recentScans.slice(0, 10);
    localStorage.setItem('recentBarcodeScans', JSON.stringify(recentScans));
    renderRecent();
}

function renderRecent() {
    var list = document.getElementById('recentList');
    list.innerHTML = recentScans.map(s => `
        <div class="recent-item" onclick="document.getElementById('barcodeInput').value='${s.barcode}';lookupBarcode();">
            <span><strong>${s.barcode}</strong> - ${s.name}</span>
            <span style="color:var(--text-muted);font-size:12px">${s.time}</span>
        </div>
    `).join('');
}

renderRecent();

function startCamera() {
    // Camera scanning would require additional library like QuaggaJS
    alert('Camera scanning requires QuaggaJS library. Use manual input for now.');
}
</script>
