<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px;
    }
    
    .page-header h1 {
        font-size: 24px;
        font-weight: 700;
        color: var(--text-primary);
        margin: 0;
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .page-header h1 svg {
        width: 28px;
        height: 28px;
        color: var(--primary);
    }
    
    .btn-add {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        background: linear-gradient(135deg, var(--primary), var(--primary-hover));
        color: #fff;
        padding: 10px 20px;
        border-radius: 8px;
        text-decoration: none;
        font-weight: 600;
        font-size: 14px;
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
        transition: all 0.2s;
    }
    
    .btn-add:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 16px rgba(59, 130, 246, 0.4);
        color: #fff;
    }
    
    .btn-add svg {
        width: 18px;
        height: 18px;
    }
    
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
        gap: 16px;
        margin-bottom: 24px;
    }
    
    .stat-card {
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        border-radius: 12px;
        padding: 20px;
        display: flex;
        align-items: center;
        gap: 16px;
    }
    
    .stat-icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }
    
    .stat-icon svg {
        width: 24px;
        height: 24px;
    }
    
    .stat-icon.blue { background: #dbeafe; color: #2563eb; }
    .stat-icon.green { background: #d1fae5; color: #059669; }
    .stat-icon.yellow { background: #fef3c7; color: #d97706; }
    .stat-icon.red { background: #fee2e2; color: #dc2626; }
    .stat-icon.purple { background: #ede9fe; color: #7c3aed; }
    
    .stat-content {
        flex: 1;
        min-width: 0;
    }
    
    .stat-value {
        font-size: 28px;
        font-weight: 700;
        color: var(--text-primary);
        line-height: 1;
    }
    
    .stat-label {
        font-size: 13px;
        color: var(--text-muted);
        margin-top: 4px;
    }
    
    .table-card {
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        border-radius: 12px;
        overflow: hidden;
    }
    
    .table-card-header {
        padding: 16px 20px;
        border-bottom: 1px solid var(--card-border);
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 12px;
    }
    
    .table-card-title {
        font-size: 16px;
        font-weight: 600;
        color: var(--text-primary);
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .table-card-title svg {
        width: 20px;
        height: 20px;
        color: var(--text-muted);
    }
    
    .table-filters {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
    }
    
    .table-filters select {
        padding: 8px 12px;
        border: 1px solid var(--card-border);
        border-radius: 6px;
        font-size: 13px;
        background: var(--card-bg);
        color: var(--text-primary);
        min-width: 150px;
    }
    
    .table-card-body {
        padding: 0;
    }

    /* Receipt Number Styling */
    .receipt-number {
        font-family: monospace;
        font-weight: 600;
        color: var(--primary);
    }
    
    .invoice-link {
        font-size: 12px;
        color: var(--text-muted);
        display: block;
        margin-top: 2px;
    }
    
    .invoice-link:hover {
        color: var(--primary);
    }

    /* Status Badge Custom Colors */
    .dt-badge-warning { background: #fef3c7; color: #92400e; }
    .dt-badge-success { background: #d1fae5; color: #065f46; }
    .dt-badge-danger { background: #fee2e2; color: #991b1b; }
    .dt-badge-info { background: #dbeafe; color: #1e40af; }

    @media (max-width: 768px) {
        .stats-grid {
            grid-template-columns: repeat(2, 1fr);
        }
        
        .page-header {
            flex-direction: column;
            align-items: flex-start;
        }
        
        .table-filters select {
            flex: 1;
            min-width: 120px;
        }
    }
</style>

<div style="padding: 20px;">
    <!-- Header -->
    <div class="page-header">
        <h1>
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
            </svg>
            Delivery Receipts
        </h1>
        <a href="{{ route('inventory.delivery.create') }}" class="btn-add">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
            </svg>
            Create Delivery
        </a>
    </div>

    <!-- Stats Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon blue">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ $stats['total'] }}</div>
                <div class="stat-label">Total Receipts</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon yellow">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ $stats['pending'] }}</div>
                <div class="stat-label">Pending Approval</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon green">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ $stats['approved'] }}</div>
                <div class="stat-label">Approved</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon purple">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                </svg>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ $stats['delivered'] }}</div>
                <div class="stat-label">Delivered</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon red">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </div>
            <div class="stat-content">
                <div class="stat-value">{{ $stats['rejected'] }}</div>
                <div class="stat-label">Rejected</div>
            </div>
        </div>
    </div>

    <!-- Table Card -->
    <div class="table-card">
        <div class="table-card-header">
            <div class="table-card-title">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 10h16M4 14h16M4 18h16"/>
                </svg>
                Delivery Receipt List
            </div>
            <div class="table-filters">
                <select data-dt-filter="status" data-dt-table="deliveryTable">
                    <option value="">All Status</option>
                    <option value="pending">Pending</option>
                    <option value="approved">Approved</option>
                    <option value="delivered">Delivered</option>
                    <option value="rejected">Rejected</option>
                </select>
                <select data-dt-filter="warehouse_id" data-dt-table="deliveryTable">
                    <option value="">All Warehouses</option>
                    @foreach($warehouses as $warehouse)
                        <option value="{{ $warehouse->id }}">{{ $warehouse->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="table-card-body">
            <table class="dt-table dt-search dt-export dt-perpage" 
                   id="deliveryTable"
                   data-route="{{ route('inventory.delivery.data') }}">
                <thead>
                    <tr>
                        <th class="dt-serial">#</th>
                        <th data-col="receipt_number" class="dt-sort" data-render="receipt">Receipt #</th>
                        <th data-col="customer_name">Customer</th>
                        <th data-col="warehouse_name">Warehouse</th>
                        <th data-col="delivery_date" class="dt-sort">Delivery Date</th>
                        <th data-col="total_items" style="text-align: center;">Items</th>
                        <th data-col="status" data-render="status">Status</th>
                        <th data-col="created_at" class="dt-sort">Created</th>
                        <th data-render="actions" style="width: 150px;">Actions</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

{{-- Custom Renderers for DataTable --}}
<script>
window.dtRenders = window.dtRenders || {};

// Receipt Number Renderer
window.dtRenders.receipt = function(value, row) {
    var html = '<span class="receipt-number">' + (row.receipt_number || '-') + '</span>';
    if (row.invoice_number && row.invoice_number !== '-') {
        html += '<a href="/admin/sales/invoices/' + row.invoice_id + '" class="invoice-link" target="_blank">Invoice: ' + row.invoice_number + '</a>';
    }
    return html;
};

// Status Badge Renderer
window.dtRenders.status = function(value, row) {
    var badgeMap = {
        'pending': 'warning',
        'approved': 'success',
        'rejected': 'danger',
        'delivered': 'info'
    };
    var badgeClass = badgeMap[row.status] || 'secondary';
    return '<span class="dt-badge dt-badge-' + badgeClass + '">' + (row.status_label || row.status || '-') + '</span>';
};

// Actions Renderer
window.dtRenders.actions = function(value, row) {
    var html = '<div class="dt-actions">';
    
    // View button (always shown)
    html += '<a href="' + row._show_url + '" class="dt-btn dt-btn-view" title="View">View</a>';
    
    // Edit button (only if can edit)
    if (row.can_edit && row._edit_url) {
        html += '<a href="' + row._edit_url + '" class="dt-btn dt-btn-edit" title="Edit">Edit</a>';
    }
    
    // Print button
    html += '<a href="' + row._print_url + '" class="dt-btn" style="background:#6366f1;color:#fff;" title="Print" target="_blank">Print</a>';
    
    // Delete button (only if can edit)
    if (row.can_edit && row._delete_url) {
        html += '<button type="button" class="dt-btn dt-btn-delete" data-id="' + row.id + '" data-url="' + row._delete_url + '" title="Delete">Delete</button>';
    }
    
    html += '</div>';
    return html;
};
</script>

{{-- Include DataTable Component --}}
@include('components.datatable')