<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Delivery Receipt - {{ $receipt->receipt_number }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 12px;
            line-height: 1.5;
            color: #333;
            background: #fff;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        
        /* Header */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #e5e7eb;
        }
        
        .company-info h1 {
            font-size: 24px;
            color: #1f2937;
            margin-bottom: 5px;
        }
        
        .company-info p {
            color: #6b7280;
            font-size: 11px;
        }
        
        .document-info {
            text-align: right;
        }
        
        .document-title {
            font-size: 20px;
            font-weight: 700;
            color: #3b82f6;
            margin-bottom: 10px;
        }
        
        .document-number {
            font-size: 14px;
            font-family: monospace;
            color: #1f2937;
            margin-bottom: 5px;
        }
        
        .document-date {
            font-size: 11px;
            color: #6b7280;
        }
        
        /* Status Badge */
        .status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            margin-top: 10px;
        }
        
        .status-badge.pending { background: #fef3c7; color: #92400e; }
        .status-badge.approved { background: #d1fae5; color: #065f46; }
        .status-badge.rejected { background: #fee2e2; color: #991b1b; }
        .status-badge.delivered { background: #dbeafe; color: #1e40af; }
        
        /* Info Grid */
        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            margin-bottom: 30px;
        }
        
        .info-box {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 15px;
        }
        
        .info-box h3 {
            font-size: 11px;
            text-transform: uppercase;
            color: #6b7280;
            margin-bottom: 10px;
            letter-spacing: 0.5px;
        }
        
        .info-box p {
            margin-bottom: 4px;
            color: #1f2937;
        }
        
        .info-box p strong {
            font-weight: 600;
        }
        
        /* Items Table */
        .items-section {
            margin-bottom: 30px;
        }
        
        .items-section h3 {
            font-size: 14px;
            color: #1f2937;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #e5e7eb;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        table th,
        table td {
            padding: 10px 12px;
            text-align: left;
            border-bottom: 1px solid #e5e7eb;
        }
        
        table th {
            background: #f3f4f6;
            font-size: 10px;
            text-transform: uppercase;
            color: #6b7280;
            font-weight: 600;
        }
        
        table td {
            font-size: 12px;
            color: #1f2937;
        }
        
        table tr:last-child td {
            border-bottom: none;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .product-name {
            font-weight: 500;
        }
        
        .product-sku {
            font-size: 10px;
            color: #6b7280;
            font-family: monospace;
        }
        
        .location-info {
            font-size: 10px;
            color: #6b7280;
        }
        
        /* Footer */
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #e5e7eb;
        }
        
        .signatures {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 30px;
            margin-top: 50px;
        }
        
        .signature-box {
            text-align: center;
        }
        
        .signature-line {
            border-top: 1px solid #1f2937;
            padding-top: 8px;
            margin-top: 40px;
            font-size: 11px;
            color: #6b7280;
        }
        
        .notes {
            background: #fffbeb;
            border: 1px solid #fcd34d;
            border-radius: 6px;
            padding: 12px;
            margin-top: 20px;
        }
        
        .notes h4 {
            font-size: 11px;
            color: #92400e;
            margin-bottom: 5px;
        }
        
        .notes p {
            font-size: 11px;
            color: #78350f;
        }
        
        /* Print Styles */
        @media print {
            body {
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }
            
            .container {
                padding: 0;
            }
            
            .no-print {
                display: none !important;
            }
        }
        
        /* Print Button */
        .print-btn {
            position: fixed;
            top: 20px;
            right: 20px;
            background: #3b82f6;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 6px;
            font-size: 14px;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .print-btn:hover {
            background: #2563eb;
        }
    </style>
</head>
<body>
    <button class="print-btn no-print" onclick="window.print()">
        <svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"/>
        </svg>
        Print
    </button>

    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="company-info">
                @if(!empty($company['logo']))
                    <img src="{{ $company['logo'] }}" alt="Logo" style="height: 50px; margin-bottom: 10px;">
                @endif
                <h1>{{ $company['name'] ?? 'Company Name' }}</h1>
                @if(!empty($company['address']))
                    <p>{{ $company['address'] }}</p>
                @endif
                @if(!empty($company['phone']))
                    <p>Phone: {{ $company['phone'] }}</p>
                @endif
                @if(!empty($company['email']))
                    <p>Email: {{ $company['email'] }}</p>
                @endif
                @if(!empty($company['gst']))
                    <p>GST: {{ $company['gst'] }}</p>
                @endif
            </div>
            <div class="document-info">
                <div class="document-title">DELIVERY RECEIPT</div>
                <div class="document-number">{{ $receipt->receipt_number }}</div>
                <div class="document-date">Date: {{ $receipt->delivery_date ? $receipt->delivery_date->format('d M Y') : '-' }}</div>
                <span class="status-badge {{ $receipt->status }}">{{ ucfirst($receipt->status) }}</span>
            </div>
        </div>

        <!-- Info Grid -->
        <div class="info-grid">
            <div class="info-box">
                <h3>Customer Details</h3>
                <p><strong>{{ $receipt->invoice->customer->name ?? 'N/A' }}</strong></p>
                @if($receipt->invoice->customer->address ?? false)
                    <p>{{ $receipt->invoice->customer->address }}</p>
                @endif
                @if($receipt->invoice->customer->phone ?? false)
                    <p>Phone: {{ $receipt->invoice->customer->phone }}</p>
                @endif
                @if($receipt->invoice->customer->email ?? false)
                    <p>Email: {{ $receipt->invoice->customer->email }}</p>
                @endif
            </div>
            <div class="info-box">
                <h3>Delivery Details</h3>
                <p><strong>Invoice:</strong> {{ $receipt->invoice->invoice_number ?? '-' }}</p>
                <p><strong>Warehouse:</strong> {{ $receipt->warehouse->name ?? '-' }}</p>
                <p><strong>Delivery Date:</strong> {{ $receipt->delivery_date ? $receipt->delivery_date->format('d M Y') : '-' }}</p>
                <p><strong>Created By:</strong> {{ $receipt->created_by ?? '-' }}</p>
                @if($receipt->approved_by)
                    <p><strong>Approved By:</strong> {{ $receipt->approved_by }}</p>
                @endif
            </div>
        </div>

        <!-- Items -->
        <div class="items-section">
            <h3>Items</h3>
            <table>
                <thead>
                    <tr>
                        <th style="width: 40px;">#</th>
                        <th>Product Description</th>
                        <th>Location</th>
                        <th class="text-right" style="width: 100px;">Quantity</th>
                        <th class="text-right" style="width: 100px;">Delivered</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($receipt->items as $index => $item)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>
                                <div class="product-name">{{ $item->product->name ?? $item->description }}</div>
                                @if($item->product->sku ?? false)
                                    <div class="product-sku">SKU: {{ $item->product->sku }}</div>
                                @endif
                                @if($item->variation)
                                    <div class="product-sku">Variant: {{ $item->variation->name }}</div>
                                @endif
                            </td>
                            <td>
                                <div class="location-info">
                                    @if($item->rack)
                                        Rack: {{ $item->rack->name }}<br>
                                    @endif
                                    @if($item->lot)
                                        Lot: {{ $item->lot->lot_no }}
                                    @endif
                                    @if(!$item->rack && !$item->lot)
                                        -
                                    @endif
                                </div>
                            </td>
                            <td class="text-right">{{ number_format($item->quantity, 2) }} {{ $item->unit->short_name ?? 'PCS' }}</td>
                            <td class="text-right">{{ number_format($item->delivered_qty, 2) }} {{ $item->unit->short_name ?? 'PCS' }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr style="background: #f3f4f6;">
                        <td colspan="3" class="text-right"><strong>Total:</strong></td>
                        <td class="text-right"><strong>{{ number_format($receipt->items->sum('quantity'), 2) }}</strong></td>
                        <td class="text-right"><strong>{{ number_format($receipt->items->sum('delivered_qty'), 2) }}</strong></td>
                    </tr>
                </tfoot>
            </table>
        </div>

        <!-- Remarks -->
        @if($receipt->remarks)
            <div class="notes">
                <h4>Remarks</h4>
                <p>{{ $receipt->remarks }}</p>
            </div>
        @endif

        <!-- Footer -->
        <div class="footer">
            <div class="signatures">
                <div class="signature-box">
                    <div class="signature-line">Prepared By</div>
                </div>
                <div class="signature-box">
                    <div class="signature-line">Authorized By</div>
                </div>
                <div class="signature-box">
                    <div class="signature-line">Received By (Customer)</div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>