<style>
    .page-container {
        padding: 20px;
        max-width: 1000px;
        margin: 0 auto;
    }

    .page-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 24px;
        flex-wrap: wrap;
        gap: 16px;
    }
    
    .page-header-left {
        display: flex;
        align-items: center;
        gap: 16px;
    }
    
    .back-btn {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        color: var(--text-muted);
        text-decoration: none;
        transition: all 0.2s;
    }
    
    .back-btn:hover {
        background: var(--body-bg);
        color: var(--text-primary);
    }
    
    .back-btn svg {
        width: 20px;
        height: 20px;
    }
    
    .page-header h1 {
        font-size: 24px;
        font-weight: 700;
        color: var(--text-primary);
        margin: 0;
    }
    
    .page-header-actions {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
    }

    .detail-card {
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        border-radius: 12px;
        margin-bottom: 24px;
    }
    
    .detail-card-header {
        padding: 16px 20px;
        border-bottom: 1px solid var(--card-border);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .detail-card-title {
        font-size: 16px;
        font-weight: 600;
        color: var(--text-primary);
        margin: 0;
    }
    
    .detail-card-body {
        padding: 20px;
    }

    .info-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
    }
    
    .info-item {
        display: flex;
        flex-direction: column;
        gap: 4px;
    }
    
    .info-label {
        font-size: 12px;
        font-weight: 500;
        color: var(--text-muted);
        text-transform: uppercase;
    }
    
    .info-value {
        font-size: 14px;
        color: var(--text-primary);
        font-weight: 500;
    }
    
    .info-value.mono {
        font-family: monospace;
        color: var(--primary);
    }

    /* Status Badge */
    .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 13px;
        font-weight: 600;
    }
    
    .status-badge.pending { background: #fef3c7; color: #92400e; }
    .status-badge.approved { background: #d1fae5; color: #065f46; }
    .status-badge.rejected { background: #fee2e2; color: #991b1b; }
    .status-badge.delivered { background: #dbeafe; color: #1e40af; }

    /* Items Table */
    .items-table {
        width: 100%;
        border-collapse: collapse;
    }
    
    .items-table th,
    .items-table td {
        padding: 12px 16px;
        text-align: left;
        border-bottom: 1px solid var(--card-border);
    }
    
    .items-table th {
        background: var(--body-bg);
        font-size: 12px;
        font-weight: 600;
        color: var(--text-muted);
        text-transform: uppercase;
    }
    
    .items-table td {
        font-size: 14px;
        color: var(--text-primary);
    }
    
    .items-table tr:last-child td {
        border-bottom: none;
    }
    
    .product-cell {
        display: flex;
        flex-direction: column;
        gap: 2px;
    }
    
    .product-name {
        font-weight: 500;
    }
    
    .product-sku {
        font-size: 12px;
        color: var(--text-muted);
        font-family: monospace;
    }
    
    .location-info {
        font-size: 12px;
        color: var(--text-muted);
    }

    /* Action Buttons */
    .btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        padding: 10px 20px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s;
        border: none;
        text-decoration: none;
    }
    
    .btn svg {
        width: 18px;
        height: 18px;
    }
    
    .btn-primary {
        background: linear-gradient(135deg, var(--primary), var(--primary-hover));
        color: #fff;
    }
    
    .btn-success {
        background: linear-gradient(135deg, #10b981, #059669);
        color: #fff;
    }
    
    .btn-danger {
        background: linear-gradient(135deg, #ef4444, #dc2626);
        color: #fff;
    }
    
    .btn-secondary {
        background: var(--body-bg);
        color: var(--text-primary);
        border: 1px solid var(--card-border);
    }
    
    .btn-info {
        background: linear-gradient(135deg, #6366f1, #4f46e5);
        color: #fff;
    }
    
    .btn:hover {
        transform: translateY(-1px);
        opacity: 0.9;
    }

    /* Rejection Reason Box */
    .rejection-box {
        background: #fef2f2;
        border: 1px solid #fecaca;
        border-radius: 8px;
        padding: 16px;
        margin-top: 16px;
    }
    
    .rejection-box h4 {
        color: #991b1b;
        margin: 0 0 8px 0;
        font-size: 14px;
    }
    
    .rejection-box p {
        color: #7f1d1d;
        margin: 0;
        font-size: 14px;
    }

    /* Timeline */
    .timeline {
        padding: 0;
        margin: 0;
        list-style: none;
    }
    
    .timeline-item {
        display: flex;
        gap: 12px;
        padding-bottom: 16px;
        position: relative;
    }
    
    .timeline-item:last-child {
        padding-bottom: 0;
    }
    
    .timeline-item::before {
        content: '';
        position: absolute;
        left: 11px;
        top: 24px;
        bottom: 0;
        width: 2px;
        background: var(--card-border);
    }
    
    .timeline-item:last-child::before {
        display: none;
    }
    
    .timeline-dot {
        width: 24px;
        height: 24px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
        font-size: 12px;
    }
    
    .timeline-dot.blue { background: #dbeafe; color: #2563eb; }
    .timeline-dot.green { background: #d1fae5; color: #059669; }
    .timeline-dot.red { background: #fee2e2; color: #dc2626; }
    .timeline-dot.purple { background: #ede9fe; color: #7c3aed; }
    
    .timeline-content {
        flex: 1;
    }
    
    .timeline-title {
        font-weight: 500;
        color: var(--text-primary);
        font-size: 14px;
    }
    
    .timeline-meta {
        font-size: 12px;
        color: var(--text-muted);
        margin-top: 2px;
    }

    /* Modal */
    .modal-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0,0,0,0.5);
        z-index: 1000;
        align-items: center;
        justify-content: center;
    }
    
    .modal-overlay.active {
        display: flex;
    }
    
    .modal {
        background: var(--card-bg);
        border-radius: 12px;
        width: 90%;
        max-width: 400px;
        padding: 24px;
    }
    
    .modal h3 {
        margin: 0 0 16px 0;
        font-size: 18px;
        color: var(--text-primary);
    }
    
    .modal textarea {
        width: 100%;
        padding: 12px;
        border: 1px solid var(--card-border);
        border-radius: 8px;
        font-size: 14px;
        min-height: 100px;
        resize: vertical;
        margin-bottom: 16px;
    }
    
    .modal-actions {
        display: flex;
        gap: 10px;
        justify-content: flex-end;
    }
</style>

<div class="page-container">
    <!-- Header -->
    <div class="page-header">
        <div class="page-header-left">
            <a href="{{ route('inventory.delivery.index') }}" class="back-btn">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/>
                </svg>
            </a>
            <h1>{{ $receipt->receipt_number }}</h1>
            <span class="status-badge {{ $receipt->status }}">{{ $receipt->status_label }}</span>
        </div>
        
        <div class="page-header-actions">
            <a href="{{ route('inventory.delivery.print', $receipt->id) }}" class="btn btn-secondary" target="_blank">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"/>
                </svg>
                Print
            </a>
            
            @if($receipt->canEdit())
                <a href="{{ route('inventory.delivery.edit', $receipt->id) }}" class="btn btn-primary">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                    </svg>
                    Edit
                </a>
            @endif
            
            @if($receipt->canApprove() && $canApprove)
                <button type="button" class="btn btn-success" onclick="approveReceipt()">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                    </svg>
                    Approve
                </button>
                <button type="button" class="btn btn-danger" onclick="showRejectModal()">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                    Reject
                </button>
            @endif
            
            @if($receipt->canMarkDelivered())
                <button type="button" class="btn btn-info" onclick="markDelivered()">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                    </svg>
                    Mark as Delivered
                </button>
            @endif
        </div>
    </div>

    @if(session('success'))
        <div style="background: #d1fae5; color: #065f46; padding: 12px 16px; border-radius: 8px; margin-bottom: 20px;">
            {{ session('success') }}
        </div>
    @endif
    
    @if(session('error'))
        <div style="background: #fee2e2; color: #991b1b; padding: 12px 16px; border-radius: 8px; margin-bottom: 20px;">
            {{ session('error') }}
        </div>
    @endif

    <!-- Receipt Details -->
    <div class="detail-card">
        <div class="detail-card-header">
            <h3 class="detail-card-title">Receipt Information</h3>
        </div>
        <div class="detail-card-body">
            <div class="info-grid">
                <div class="info-item">
                    <span class="info-label">Receipt Number</span>
                    <span class="info-value mono">{{ $receipt->receipt_number }}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Invoice</span>
                    <a href="{{ route('admin.sales.invoices.show', $receipt->invoice_id) }}" class="info-value mono" target="_blank">
                        {{ $receipt->invoice->invoice_number ?? '-' }}
                    </a>
                </div>
                <div class="info-item">
                    <span class="info-label">Customer</span>
                    <span class="info-value">{{ $receipt->invoice->customer->name ?? '-' }}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Warehouse</span>
                    <span class="info-value">{{ $receipt->warehouse->name ?? '-' }}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Delivery Date</span>
                    <span class="info-value">{{ $receipt->delivery_date ? $receipt->delivery_date->format('d M Y') : '-' }}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Created By</span>
                    <span class="info-value">{{ $receipt->created_by ?? '-' }}</span>
                </div>
            </div>
            
            @if($receipt->remarks)
                <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid var(--card-border);">
                    <span class="info-label">Remarks</span>
                    <p style="margin: 8px 0 0 0; color: var(--text-primary);">{{ $receipt->remarks }}</p>
                </div>
            @endif
            
            @if($receipt->status === 'rejected' && $receipt->rejection_reason)
                <div class="rejection-box">
                    <h4>Rejection Reason</h4>
                    <p>{{ $receipt->rejection_reason }}</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Items -->
    <div class="detail-card">
        <div class="detail-card-header">
            <h3 class="detail-card-title">Items ({{ $receipt->items->count() }})</h3>
        </div>
        <div class="detail-card-body" style="padding: 0;">
            <table class="items-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Product</th>
                        <th>Location</th>
                        <th style="text-align: right;">Quantity</th>
                        <th style="text-align: right;">Delivered</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($receipt->items as $index => $item)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>
                                <div class="product-cell">
                                    <span class="product-name">{{ $item->product->name ?? $item->description }}</span>
                                    <span class="product-sku">{{ $item->product->sku ?? '' }}</span>
                                    @if($item->variation)
                                        <span class="product-sku">Variant: {{ $item->variation->name }}</span>
                                    @endif
                                </div>
                            </td>
                            <td>
                                <div class="location-info">
                                    @if($item->rack)
                                        <div>Rack: {{ $item->rack->name }}</div>
                                    @endif
                                    @if($item->lot)
                                        <div>Lot: {{ $item->lot->lot_no }}</div>
                                    @endif
                                    @if(!$item->rack && !$item->lot)
                                        <span style="color: var(--text-muted);">-</span>
                                    @endif
                                </div>
                            </td>
                            <td style="text-align: right; font-weight: 500;">
                                {{ number_format($item->quantity, 2) }} {{ $item->unit->short_name ?? 'PCS' }}
                            </td>
                            <td style="text-align: right; font-weight: 500;">
                                {{ number_format($item->delivered_qty, 2) }} {{ $item->unit->short_name ?? 'PCS' }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr style="background: var(--body-bg);">
                        <td colspan="3" style="text-align: right; font-weight: 600;">Total:</td>
                        <td style="text-align: right; font-weight: 600;">{{ number_format($receipt->items->sum('quantity'), 2) }}</td>
                        <td style="text-align: right; font-weight: 600;">{{ number_format($receipt->items->sum('delivered_qty'), 2) }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <!-- Activity Timeline -->
    <div class="detail-card">
        <div class="detail-card-header">
            <h3 class="detail-card-title">Activity</h3>
        </div>
        <div class="detail-card-body">
            <ul class="timeline">
                <li class="timeline-item">
                    <div class="timeline-dot blue">
                        <svg width="12" height="12" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
                        </svg>
                    </div>
                    <div class="timeline-content">
                        <div class="timeline-title">Receipt Created</div>
                        <div class="timeline-meta">{{ $receipt->created_at->format('d M Y, H:i') }} by {{ $receipt->created_by ?? 'System' }}</div>
                    </div>
                </li>
                
                @if($receipt->approved_at)
                    <li class="timeline-item">
                        <div class="timeline-dot {{ $receipt->status === 'rejected' ? 'red' : 'green' }}">
                            <svg width="12" height="12" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                @if($receipt->status === 'rejected')
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                                @else
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                                @endif
                            </svg>
                        </div>
                        <div class="timeline-content">
                            <div class="timeline-title">{{ $receipt->status === 'rejected' ? 'Receipt Rejected' : 'Receipt Approved' }}</div>
                            <div class="timeline-meta">{{ $receipt->approved_at->format('d M Y, H:i') }} by {{ $receipt->approved_by ?? 'Admin' }}</div>
                        </div>
                    </li>
                @endif
                
                @if($receipt->delivered_at)
                    <li class="timeline-item">
                        <div class="timeline-dot purple">
                            <svg width="12" height="12" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                            </svg>
                        </div>
                        <div class="timeline-content">
                            <div class="timeline-title">Marked as Delivered</div>
                            <div class="timeline-meta">{{ $receipt->delivered_at->format('d M Y, H:i') }} by {{ $receipt->delivered_by ?? 'Staff' }}</div>
                        </div>
                    </li>
                @endif
            </ul>
        </div>
    </div>
</div>

<!-- Rejection Modal -->
<div class="modal-overlay" id="rejectModal">
    <div class="modal">
        <h3>Reject Delivery Receipt</h3>
        <p style="color: var(--text-muted); margin-bottom: 16px;">Please provide a reason for rejecting this delivery receipt.</p>
        <textarea id="rejectionReason" placeholder="Enter rejection reason..."></textarea>
        <div class="modal-actions">
            <button type="button" class="btn btn-secondary" onclick="closeRejectModal()">Cancel</button>
            <button type="button" class="btn btn-danger" onclick="rejectReceipt()">Reject Receipt</button>
        </div>
    </div>
</div>

<script>
function approveReceipt() {
    if (!confirm('Are you sure you want to approve this delivery receipt? Stock will be deducted from the warehouse.')) {
        return;
    }
    
    fetch('{{ route("inventory.delivery.approve", $receipt->id) }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert(data.message);
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error occurred');
        console.error(error);
    });
}

function showRejectModal() {
    document.getElementById('rejectModal').classList.add('active');
}

function closeRejectModal() {
    document.getElementById('rejectModal').classList.remove('active');
}

function rejectReceipt() {
    var reason = document.getElementById('rejectionReason').value.trim();
    
    if (!reason) {
        alert('Please enter a rejection reason');
        return;
    }
    
    fetch('{{ route("inventory.delivery.reject", $receipt->id) }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({ rejection_reason: reason })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert(data.message);
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error occurred');
        console.error(error);
    });
}

function markDelivered() {
    if (!confirm('Mark this delivery as completed?')) {
        return;
    }
    
    fetch('{{ route("inventory.delivery.mark-delivered", $receipt->id) }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert(data.message);
            location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error occurred');
        console.error(error);
    });
}
</script>