<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inventory Expiry Alert</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
            line-height: 1.6;
            color: #1f2937;
            background: #f3f4f6;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .header {
            background: linear-gradient(135deg, #ef4444, #dc2626);
            color: #ffffff;
            padding: 24px 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 700;
        }
        .header p {
            margin: 8px 0 0;
            opacity: 0.9;
            font-size: 14px;
        }
        .content {
            padding: 30px;
        }
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 12px;
            margin-bottom: 24px;
        }
        .stat-box {
            text-align: center;
            padding: 16px;
            border-radius: 8px;
        }
        .stat-box.critical {
            background: #fee2e2;
        }
        .stat-box.warning {
            background: #fef3c7;
        }
        .stat-box.expired {
            background: #fecaca;
        }
        .stat-number {
            font-size: 32px;
            font-weight: 700;
            line-height: 1;
        }
        .stat-box.critical .stat-number { color: #dc2626; }
        .stat-box.warning .stat-number { color: #d97706; }
        .stat-box.expired .stat-number { color: #991b1b; }
        .stat-label {
            font-size: 12px;
            color: #6b7280;
            margin-top: 4px;
        }
        .section {
            margin-bottom: 24px;
        }
        .section-title {
            font-size: 16px;
            font-weight: 600;
            color: #1f2937;
            margin-bottom: 12px;
            padding-bottom: 8px;
            border-bottom: 2px solid #e5e7eb;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .section-title.critical { border-color: #ef4444; }
        .section-title.warning { border-color: #f59e0b; }
        .section-title.expired { border-color: #991b1b; }
        .lot-item {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 14px;
            margin-bottom: 10px;
        }
        .lot-item:last-child {
            margin-bottom: 0;
        }
        .lot-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 8px;
        }
        .lot-product {
            font-weight: 600;
            color: #1f2937;
            font-size: 14px;
        }
        .lot-badge {
            font-size: 11px;
            padding: 3px 8px;
            border-radius: 12px;
            font-weight: 600;
        }
        .lot-badge.critical {
            background: #fee2e2;
            color: #dc2626;
        }
        .lot-badge.warning {
            background: #fef3c7;
            color: #d97706;
        }
        .lot-badge.expired {
            background: #fecaca;
            color: #991b1b;
        }
        .lot-details {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 8px;
            font-size: 12px;
            color: #6b7280;
        }
        .lot-detail {
            display: flex;
            align-items: center;
            gap: 4px;
        }
        .lot-detail strong {
            color: #374151;
        }
        .lot-warehouses {
            margin-top: 8px;
            padding-top: 8px;
            border-top: 1px dashed #e5e7eb;
            font-size: 11px;
            color: #6b7280;
        }
        .action-section {
            text-align: center;
            padding: 24px;
            background: #f9fafb;
            border-top: 1px solid #e5e7eb;
        }
        .action-btn {
            display: inline-block;
            background: linear-gradient(135deg, #3b82f6, #2563eb);
            color: #ffffff !important;
            text-decoration: none;
            padding: 12px 28px;
            border-radius: 8px;
            font-weight: 600;
            font-size: 14px;
        }
        .footer {
            text-align: center;
            padding: 20px 30px;
            font-size: 12px;
            color: #9ca3af;
        }
        .footer a {
            color: #6b7280;
        }
        @media (max-width: 480px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
            .lot-details {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>⚠️ Inventory Expiry Alert</h1>
            <p>Generated on {{ $generated_at }}</p>
        </div>
        
        <div class="content">
            <!-- Stats Summary -->
            <div class="stats-grid">
                <div class="stat-box expired">
                    <div class="stat-number">{{ $expired_count }}</div>
                    <div class="stat-label">Expired</div>
                </div>
                <div class="stat-box critical">
                    <div class="stat-number">{{ $critical_count }}</div>
                    <div class="stat-label">Critical (≤7 days)</div>
                </div>
                <div class="stat-box warning">
                    <div class="stat-number">{{ $warning_count }}</div>
                    <div class="stat-label">Warning (≤30 days)</div>
                </div>
            </div>
            
            @if(count($expired) > 0)
            <div class="section">
                <div class="section-title expired">
                    🚫 Expired Items ({{ count($expired) }})
                </div>
                @foreach($expired as $item)
                <div class="lot-item">
                    <div class="lot-header">
                        <div class="lot-product">{{ $item['product_name'] }}</div>
                        <span class="lot-badge expired">EXPIRED</span>
                    </div>
                    <div class="lot-details">
                        <div class="lot-detail">🏷️ Lot: <strong>{{ $item['lot_no'] }}</strong></div>
                        @if($item['batch_no'])
                        <div class="lot-detail">📦 Batch: <strong>{{ $item['batch_no'] }}</strong></div>
                        @endif
                        <div class="lot-detail">📅 Expired: <strong>{{ $item['expiry_date'] }}</strong></div>
                        <div class="lot-detail">📊 Stock: <strong>{{ $item['stock'] }} units</strong></div>
                    </div>
                    @if(!empty($item['warehouses']))
                    <div class="lot-warehouses">
                        📍 Locations: 
                        @foreach($item['warehouses'] as $wh)
                            {{ $wh['name'] }} ({{ $wh['qty'] }}){{ !$loop->last ? ', ' : '' }}
                        @endforeach
                    </div>
                    @endif
                </div>
                @endforeach
            </div>
            @endif
            
            @if(count($critical) > 0)
            <div class="section">
                <div class="section-title critical">
                    🔴 Critical - Expiring within 7 days ({{ count($critical) }})
                </div>
                @foreach($critical as $item)
                <div class="lot-item">
                    <div class="lot-header">
                        <div class="lot-product">{{ $item['product_name'] }}</div>
                        <span class="lot-badge critical">{{ $item['days'] }} day{{ $item['days'] != 1 ? 's' : '' }}</span>
                    </div>
                    <div class="lot-details">
                        <div class="lot-detail">🏷️ Lot: <strong>{{ $item['lot_no'] }}</strong></div>
                        @if($item['batch_no'])
                        <div class="lot-detail">📦 Batch: <strong>{{ $item['batch_no'] }}</strong></div>
                        @endif
                        <div class="lot-detail">📅 Expiry: <strong>{{ $item['expiry_date'] }}</strong></div>
                        <div class="lot-detail">📊 Stock: <strong>{{ $item['stock'] }} units</strong></div>
                    </div>
                    @if(!empty($item['warehouses']))
                    <div class="lot-warehouses">
                        📍 Locations: 
                        @foreach($item['warehouses'] as $wh)
                            {{ $wh['name'] }} ({{ $wh['qty'] }}){{ !$loop->last ? ', ' : '' }}
                        @endforeach
                    </div>
                    @endif
                </div>
                @endforeach
            </div>
            @endif
            
            @if(count($warning) > 0)
            <div class="section">
                <div class="section-title warning">
                    🟡 Warning - Expiring within 30 days ({{ count($warning) }})
                </div>
                @foreach($warning as $item)
                <div class="lot-item">
                    <div class="lot-header">
                        <div class="lot-product">{{ $item['product_name'] }}</div>
                        <span class="lot-badge warning">{{ $item['days'] }} days</span>
                    </div>
                    <div class="lot-details">
                        <div class="lot-detail">🏷️ Lot: <strong>{{ $item['lot_no'] }}</strong></div>
                        @if($item['batch_no'])
                        <div class="lot-detail">📦 Batch: <strong>{{ $item['batch_no'] }}</strong></div>
                        @endif
                        <div class="lot-detail">📅 Expiry: <strong>{{ $item['expiry_date'] }}</strong></div>
                        <div class="lot-detail">📊 Stock: <strong>{{ $item['stock'] }} units</strong></div>
                    </div>
                </div>
                @endforeach
            </div>
            @endif
        </div>
        
        <div class="action-section">
            <p style="margin: 0 0 16px; color: #6b7280;">Take action on expiring inventory to prevent losses.</p>
            <a href="{{ url('admin/inventory/lots/expiring-soon') }}" class="action-btn">View All Expiring Items →</a>
        </div>
        
        <div class="footer">
            <p>This is an automated alert from your Inventory Management System.</p>
            <p>To change alert settings, visit <a href="{{ url('admin/inventory/settings') }}">Inventory Settings</a>.</p>
        </div>
    </div>
</body>
</html>
