
<style>
.expiring-container { padding: 24px; max-width: 1200px; margin: 0 auto; }
.page-header { display: flex; align-items: center; justify-content: space-between; margin-bottom: 24px; flex-wrap: wrap; gap: 16px; }
.page-title { font-size: 24px; font-weight: 600; color: var(--text-primary); }
.filter-group { display: flex; align-items: center; gap: 12px; }
.filter-select { padding: 10px 16px; border: 1px solid var(--card-border); border-radius: 8px; background: var(--card-bg); color: var(--text-primary); font-size: 14px; }
.btn-back { padding: 10px 16px; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 8px; text-decoration: none; color: var(--text-primary); display: inline-flex; align-items: center; gap: 8px; }
.stats-row { display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 16px; margin-bottom: 24px; }
.stat-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; padding: 16px; text-align: center; }
.stat-value { font-size: 28px; font-weight: 700; }
.stat-value.danger { color: #ef4444; }
.stat-value.warning { color: #f59e0b; }
.stat-label { font-size: 13px; color: var(--text-muted); margin-top: 4px; }
.lots-table { width: 100%; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
.lots-table th, .lots-table td { padding: 14px 16px; text-align: left; border-bottom: 1px solid var(--card-border); }
.lots-table th { background: var(--body-bg); font-weight: 600; font-size: 13px; color: var(--text-muted); }
.lots-table tr:last-child td { border-bottom: none; }
.lots-table tr:hover { background: var(--body-bg); }
.badge { padding: 4px 10px; border-radius: 20px; font-size: 12px; font-weight: 600; }
.badge-danger { background: #fef2f2; color: #dc2626; }
.badge-warning { background: #fffbeb; color: #d97706; }
.badge-success { background: #d1fae5; color: #065f46; }
.product-link { color: var(--text-primary); text-decoration: none; font-weight: 500; }
.product-link:hover { color: #3b82f6; }
.days-cell { font-weight: 600; }
.days-cell.critical { color: #ef4444; }
.days-cell.warning { color: #f59e0b; }
.empty-state { text-align: center; padding: 60px 20px; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; }
.empty-state svg { width: 64px; height: 64px; color: var(--text-muted); margin-bottom: 16px; }
</style>

<div class="expiring-container">
    <div class="page-header">
        <div style="display: flex; align-items: center; gap: 16px;">
            <a href="{{ route('inventory.lots.index') }}" class="btn-back">
                <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/></svg>
                Back
            </a>
            <h1 class="page-title">Expiring Soon</h1>
        </div>
        <div class="filter-group">
            <span>Show lots expiring within:</span>
            <select class="filter-select" onchange="window.location.href='?days='+this.value">
                <option value="7" {{ $days == 7 ? 'selected' : '' }}>7 days</option>
                <option value="14" {{ $days == 14 ? 'selected' : '' }}>14 days</option>
                <option value="30" {{ $days == 30 ? 'selected' : '' }}>30 days</option>
                <option value="60" {{ $days == 60 ? 'selected' : '' }}>60 days</option>
                <option value="90" {{ $days == 90 ? 'selected' : '' }}>90 days</option>
            </select>
        </div>
    </div>
    
    <!-- Stats -->
    @php
        $critical = $lots->filter(fn($l) => $l->expiry_date && now()->diffInDays($l->expiry_date, false) <= 7)->count();
        $warning = $lots->filter(fn($l) => $l->expiry_date && now()->diffInDays($l->expiry_date, false) > 7 && now()->diffInDays($l->expiry_date, false) <= 14)->count();
        $upcoming = $lots->count() - $critical - $warning;
    @endphp
    <div class="stats-row">
        <div class="stat-card">
            <div class="stat-value danger">{{ $critical }}</div>
            <div class="stat-label">Critical (≤7 days)</div>
        </div>
        <div class="stat-card">
            <div class="stat-value warning">{{ $warning }}</div>
            <div class="stat-label">Warning (8-14 days)</div>
        </div>
        <div class="stat-card">
            <div class="stat-value">{{ $upcoming }}</div>
            <div class="stat-label">Upcoming (>14 days)</div>
        </div>
        <div class="stat-card">
            <div class="stat-value">{{ $lots->count() }}</div>
            <div class="stat-label">Total Lots</div>
        </div>
    </div>
    
    @if($lots->count() > 0)
    <table class="lots-table">
        <thead>
            <tr>
                <th>Lot #</th>
                <th>Batch #</th>
                <th>Product</th>
                <th>Expiry Date</th>
                <th>Days Left</th>
                <th>Stock</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach($lots as $lot)
            @php
                $daysLeft = now()->diffInDays($lot->expiry_date, false);
                $stock = $lot->stockLevels->sum('qty');
            @endphp
            <tr>
                <td><strong>{{ $lot->lot_no }}</strong></td>
                <td>{{ $lot->batch_no ?? '-' }}</td>
                <td>
                    <a href="{{ route('inventory.products.show', $lot->product_id) }}" class="product-link">
                        {{ $lot->product->name ?? 'Unknown' }}
                    </a>
                    <div style="font-size: 12px; color: var(--text-muted);">{{ $lot->product->sku ?? '' }}</div>
                </td>
                <td>{{ $lot->expiry_date->format('d M Y') }}</td>
                <td class="days-cell {{ $daysLeft <= 7 ? 'critical' : ($daysLeft <= 14 ? 'warning' : '') }}">
                    @if($daysLeft <= 7)
                        <span class="badge badge-danger">{{ $daysLeft }} days</span>
                    @elseif($daysLeft <= 14)
                        <span class="badge badge-warning">{{ $daysLeft }} days</span>
                    @else
                        <span class="badge badge-success">{{ $daysLeft }} days</span>
                    @endif
                </td>
                <td><strong>{{ number_format($stock, 2) }}</strong> {{ $lot->product->unit->short_name ?? 'PCS' }}</td>
                <td>
                    <a href="{{ route('inventory.lots.show', $lot->id) }}" style="color: #3b82f6; text-decoration: none;">View</a>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @else
    <div class="empty-state">
        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>
        <h3>No Expiring Lots</h3>
        <p style="color: var(--text-muted);">No lots are expiring within the next {{ $days }} days.</p>
    </div>
    @endif
</div>
