
<style>
.lot-container { padding: 24px; max-width: 1200px; margin: 0 auto; }
.page-header { display: flex; align-items: center; gap: 16px; margin-bottom: 24px; }
.btn-back { padding: 10px 16px; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 8px; text-decoration: none; color: var(--text-primary); display: inline-flex; align-items: center; gap: 8px; }
.page-title { font-size: 24px; font-weight: 600; color: var(--text-primary); }
.lot-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 24px; }
@media (max-width: 768px) { .lot-grid { grid-template-columns: 1fr; } }
.card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; padding: 24px; }
.card-title { font-size: 16px; font-weight: 600; color: var(--text-primary); margin-bottom: 16px; padding-bottom: 12px; border-bottom: 1px solid var(--card-border); }
.info-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 16px; }
.info-item { }
.info-label { font-size: 12px; color: var(--text-muted); margin-bottom: 4px; }
.info-value { font-size: 15px; font-weight: 500; color: var(--text-primary); }
.info-value.large { font-size: 24px; font-weight: 700; }
.badge { padding: 4px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; display: inline-block; }
.badge-success { background: #d1fae5; color: #065f46; }
.badge-warning { background: #fef3c7; color: #92400e; }
.badge-danger { background: #fee2e2; color: #991b1b; }
.badge-gray { background: #f3f4f6; color: #4b5563; }
.product-card { display: flex; gap: 16px; align-items: center; }
.product-img { width: 80px; height: 80px; border-radius: 12px; object-fit: cover; background: var(--body-bg); }
.product-info h3 { font-size: 18px; font-weight: 600; margin-bottom: 4px; }
.product-info p { color: var(--text-muted); font-size: 14px; }
.table { width: 100%; border-collapse: collapse; margin-top: 16px; }
.table th, .table td { padding: 12px; text-align: left; border-bottom: 1px solid var(--card-border); }
.table th { font-size: 12px; font-weight: 600; color: var(--text-muted); background: var(--body-bg); }
.full-width { grid-column: 1 / -1; }
</style>

<div class="lot-container">
    <div class="page-header">
        <a href="{{ route('inventory.lots.index') }}" class="btn-back">
            <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/></svg>
            Back
        </a>
        <h1 class="page-title">Lot Details: {{ $lot->lot_no }}</h1>
    </div>
    
    <div class="lot-grid">
        <!-- Lot Information -->
        <div class="card">
            <div class="card-title">Lot Information</div>
            <div class="info-grid">
                <div class="info-item">
                    <div class="info-label">Lot Number</div>
                    <div class="info-value">{{ $lot->lot_no }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">Batch Number</div>
                    <div class="info-value">{{ $lot->batch_no ?? '-' }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">Status</div>
                    <div class="info-value">
                        @if($lot->status == 'ACTIVE')
                            <span class="badge badge-success">Active</span>
                        @elseif($lot->status == 'EXPIRED')
                            <span class="badge badge-danger">Expired</span>
                        @elseif($lot->status == 'RECALLED')
                            <span class="badge badge-warning">Recalled</span>
                        @else
                            <span class="badge badge-gray">{{ $lot->status }}</span>
                        @endif
                    </div>
                </div>
                <div class="info-item">
                    <div class="info-label">Manufacturing Date</div>
                    <div class="info-value">{{ $lot->mfg_date ? $lot->mfg_date->format('d M Y') : '-' }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">Expiry Date</div>
                    <div class="info-value">
                        @if($lot->expiry_date)
                            {{ $lot->expiry_date->format('d M Y') }}
                            @if($lot->expiry_date->isPast())
                                <span class="badge badge-danger">Expired</span>
                            @elseif($lot->expiry_date->diffInDays(now()) <= 30)
                                <span class="badge badge-warning">{{ $lot->expiry_date->diffInDays(now()) }} days left</span>
                            @endif
                        @else
                            -
                        @endif
                    </div>
                </div>
                <div class="info-item">
                    <div class="info-label">Purchase Price</div>
                    <div class="info-value">₹{{ number_format($lot->purchase_price ?? 0, 2) }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">Sale Price</div>
                    <div class="info-value">₹{{ number_format($lot->sale_price ?? 0, 2) }}</div>
                </div>
                <div class="info-item">
                    <div class="info-label">Current Stock</div>
                    <div class="info-value large">{{ number_format($lot->stockLevels->sum('qty'), 2) }} {{ $lot->product->unit->short_name ?? 'PCS' }}</div>
                </div>
            </div>
        </div>
        
        <!-- Product Information -->
        <div class="card">
            <div class="card-title">Product</div>
            <div class="product-card">
                @php $img = $lot->product->images->where('is_primary', true)->first() ?? $lot->product->images->first(); @endphp
                <img src="{{ $img ? asset('storage/' . $img->image_path) : asset('images/no-image.png') }}" alt="" class="product-img">
                <div class="product-info">
                    <h3>{{ $lot->product->name }}</h3>
                    <p>SKU: {{ $lot->product->sku }}</p>
                    <p>Unit: {{ $lot->product->unit->name ?? 'Pieces' }}</p>
                    @if($lot->variation)
                        <p>Variation: {{ $lot->variation->variation_name ?? $lot->variation->sku }}</p>
                    @endif
                </div>
            </div>
        </div>
        
        <!-- Stock Levels by Warehouse -->
        <div class="card full-width">
            <div class="card-title">Stock by Location</div>
            @if($lot->stockLevels->count() > 0)
            <table class="table">
                <thead>
                    <tr>
                        <th>Warehouse</th>
                        <th>Rack</th>
                        <th>Quantity</th>
                        <th>Last Updated</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($lot->stockLevels as $stock)
                    <tr>
                        <td>{{ $stock->warehouse->name ?? '-' }}</td>
                        <td>{{ $stock->rack->name ?? '-' }}</td>
                        <td><strong>{{ number_format($stock->qty, 2) }}</strong> {{ $lot->product->unit->short_name ?? 'PCS' }}</td>
                        <td>{{ $stock->updated_at->format('d M Y H:i') }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <p style="color: var(--text-muted); text-align: center; padding: 24px;">No stock levels recorded</p>
            @endif
        </div>
        
        <!-- Recent Stock Movements -->
        <div class="card full-width">
            <div class="card-title">Recent Stock Movements</div>
            @if($stockMovements->count() > 0)
            <table class="table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Quantity</th>
                        <th>Warehouse</th>
                        <th>Reference</th>
                        <th>By</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($stockMovements as $movement)
                    <tr>
                        <td>{{ $movement->created_at->format('d M Y H:i') }}</td>
                        <td>
                            @if($movement->type == 'IN')
                                <span class="badge badge-success">IN</span>
                            @elseif($movement->type == 'OUT')
                                <span class="badge badge-danger">OUT</span>
                            @else
                                <span class="badge badge-gray">{{ $movement->type }}</span>
                            @endif
                        </td>
                        <td><strong>{{ number_format($movement->qty, 2) }}</strong></td>
                        <td>{{ $movement->warehouse->name ?? '-' }}</td>
                        <td>{{ $movement->reference_type ?? '-' }} {{ $movement->reference_id ? '#'.$movement->reference_id : '' }}</td>
                        <td>{{ $movement->creator->name ?? '-' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <p style="color: var(--text-muted); text-align: center; padding: 24px;">No stock movements recorded</p>
            @endif
        </div>
    </div>
</div>
