
<style>
    .page-container { padding: 20px; max-width: 750px; margin: 0 auto; }
    .page-header { display: flex; align-items: center; gap: 16px; margin-bottom: 24px; }
    .back-btn { width: 40px; height: 40px; border-radius: 10px; display: flex; align-items: center; justify-content: center; background: var(--card-bg); border: 1px solid var(--card-border); color: var(--text-muted); text-decoration: none; transition: all 0.2s; flex-shrink: 0; }
    .back-btn:hover { background: var(--body-bg); color: var(--text-primary); }
    .back-btn svg { width: 20px; height: 20px; }
    .page-header h1 { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 10px; }
    .page-header h1 svg { width: 28px; height: 28px; color: #8b5cf6; }
    .form-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; }
    .form-card-header { padding: 20px 24px; border-bottom: 1px solid var(--card-border); background: linear-gradient(135deg, #ede9fe, #ddd6fe); border-radius: 12px 12px 0 0; }
    .form-card-title { font-size: 16px; font-weight: 600; color: #5b21b6; margin: 0; display: flex; align-items: center; gap: 8px; }
    .form-card-title svg { width: 20px; height: 20px; }
    .form-card-body { padding: 24px; }
    .form-section { margin-bottom: 28px; padding-bottom: 28px; border-bottom: 1px solid var(--card-border); }
    .form-section:last-child { margin-bottom: 0; padding-bottom: 0; border-bottom: none; }
    .form-section-title { font-size: 13px; font-weight: 600; color: var(--text-muted); text-transform: uppercase; letter-spacing: 0.5px; margin-bottom: 16px; display: flex; align-items: center; gap: 8px; }
    .form-section-title svg { width: 16px; height: 16px; }
    .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
    .form-row-3 { display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 20px; }
    @media (max-width: 640px) { .form-row, .form-row-3 { grid-template-columns: 1fr; } }
    .form-group { margin-bottom: 20px; }
    .form-group:last-child { margin-bottom: 0; }
    .form-label { display: block; font-size: 13px; font-weight: 500; color: var(--text-primary); margin-bottom: 8px; }
    .form-label .required { color: #ef4444; }
    .form-control { width: 100%; padding: 10px 14px; border: 1px solid var(--card-border); border-radius: 8px; font-size: 14px; background: var(--card-bg); color: var(--text-primary); transition: border-color 0.2s, box-shadow 0.2s; box-sizing: border-box; }
    .form-control:focus { outline: none; border-color: var(--primary); box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); }
    .form-control::placeholder { color: var(--text-muted); }
    textarea.form-control { min-height: 80px; resize: vertical; }
    .form-help { font-size: 12px; color: var(--text-muted); margin-top: 6px; }
    .form-actions { display: flex; gap: 12px; padding-top: 24px; border-top: 1px solid var(--card-border); margin-top: 24px; }
    .btn { display: inline-flex; align-items: center; justify-content: center; gap: 8px; padding: 12px 24px; border-radius: 8px; font-size: 14px; font-weight: 600; cursor: pointer; border: none; text-decoration: none; transition: all 0.2s; }
    .btn svg { width: 18px; height: 18px; }
    .btn-primary { background: linear-gradient(135deg, #8b5cf6, #7c3aed); color: #fff; }
    .btn-primary:hover { transform: translateY(-1px); box-shadow: 0 4px 12px rgba(139, 92, 246, 0.3); }
    .btn-secondary { background: var(--body-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
    .btn-secondary:hover { background: var(--card-border); }
    .alert { padding: 12px 16px; border-radius: 8px; margin-bottom: 20px; font-size: 14px; }
    .alert-error { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }

    /* Storage Type Selector */
    .storage-type-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 10px;
    }
    @media (max-width: 640px) { .storage-type-grid { grid-template-columns: repeat(2, 1fr); } }
    
    .storage-type-chip {
        display: flex;
        flex-direction: column;
        align-items: center;
        padding: 14px 10px;
        background: var(--body-bg);
        border: 2px solid var(--card-border);
        border-radius: 10px;
        cursor: pointer;
        transition: all 0.2s;
        text-align: center;
    }
    
    .storage-type-chip:hover {
        border-color: #c4b5fd;
        background: #faf5ff;
    }
    
    .storage-type-chip.selected {
        border-color: #8b5cf6;
        background: linear-gradient(135deg, #f5f3ff, #ede9fe);
        box-shadow: 0 2px 8px rgba(139, 92, 246, 0.2);
    }
    
    .storage-type-icon {
        font-size: 28px;
        margin-bottom: 6px;
    }
    
    .storage-type-name {
        font-size: 12px;
        font-weight: 600;
        color: var(--text-primary);
    }
    
    .storage-type-chip.selected .storage-type-name {
        color: #7c3aed;
    }

    /* Location Preview Box */
    .location-preview {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 14px 16px;
        background: linear-gradient(135deg, #f5f3ff, #ede9fe);
        border: 1px solid #ddd6fe;
        border-radius: 10px;
        margin-top: 16px;
    }
    
    .location-preview-icon {
        width: 40px;
        height: 40px;
        background: #8b5cf6;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 18px;
    }
    
    .location-preview-info {
        flex: 1;
    }
    
    .location-preview-label {
        font-size: 11px;
        color: #7c3aed;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .location-preview-path {
        font-size: 15px;
        font-weight: 600;
        color: #5b21b6;
        margin-top: 2px;
    }
    
    .location-preview-code {
        font-size: 13px;
        font-family: monospace;
        color: #7c3aed;
        background: white;
        padding: 4px 10px;
        border-radius: 6px;
        border: 1px solid #ddd6fe;
    }

    /* Input with suggestions */
    .input-with-suggestions {
        position: relative;
    }
    
    .suggestions-dropdown {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        border-top: none;
        border-radius: 0 0 8px 8px;
        max-height: 150px;
        overflow-y: auto;
        z-index: 100;
        display: none;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    
    .suggestions-dropdown.show {
        display: block;
    }
    
    .suggestion-item {
        padding: 10px 14px;
        cursor: pointer;
        font-size: 13px;
        color: var(--text-primary);
        border-bottom: 1px solid var(--card-border);
    }
    
    .suggestion-item:last-child {
        border-bottom: none;
    }
    
    .suggestion-item:hover {
        background: #f5f3ff;
        color: #7c3aed;
    }
    
    .no-suggestions {
        padding: 10px 14px;
        font-size: 12px;
        color: var(--text-muted);
        font-style: italic;
    }
</style>

<div class="page-container">
    <div class="page-header">
        <a href="{{ route('inventory.racks.index') }}" class="back-btn">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/></svg>
        </a>
        <h1>
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/></svg>
            Add New Rack
        </h1>
    </div>

    @if(session('error'))
        <div class="alert alert-error">{{ session('error') }}</div>
    @endif

    @if($errors->any())
        <div class="alert alert-error">
            <ul style="margin: 0; padding-left: 20px;">
                @foreach($errors->all() as $error)<li>{{ $error }}</li>@endforeach
            </ul>
        </div>
    @endif

    <div class="form-card">
        <div class="form-card-header">
            <h3 class="form-card-title">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/></svg>
                Rack Information
            </h3>
        </div>
        <div class="form-card-body">
            <form action="{{ route('inventory.racks.store') }}" method="POST">
                @csrf

                <!-- Basic Information -->
                <div class="form-section">
                    <div class="form-section-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                        Basic Information
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label">Warehouse <span class="required">*</span></label>
                        <select name="warehouse_id" id="warehouse_id" class="form-control" required>
                            <option value="">-- Select Warehouse --</option>
                            @foreach($warehouses as $warehouse)
                                <option value="{{ $warehouse->id }}" 
                                        data-code="{{ $warehouse->code ?? strtoupper(substr($warehouse->name, 0, 3)) }}"
                                        data-name="{{ $warehouse->name }}"
                                        {{ old('warehouse_id', request('warehouse_id')) == $warehouse->id ? 'selected' : '' }}>
                                    {{ $warehouse->name }} ({{ $warehouse->code }})
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Rack Code <span class="required">*</span></label>
                            <input type="text" name="code" id="rack_code" class="form-control" placeholder="e.g., A01" value="{{ old('code') }}" required>
                            <div class="form-help">Unique code within the warehouse</div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Rack Name <span class="required">*</span></label>
                            <input type="text" name="name" id="rack_name" class="form-control" placeholder="e.g., Rack A Row 1" value="{{ old('name') }}" required>
                        </div>
                    </div>
                </div>

                <!-- Storage Type -->
                <div class="form-section">
                    <div class="form-section-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/></svg>
                        Storage Type
                    </div>
                    
                    <input type="hidden" name="storage_type" id="storage_type" value="{{ old('storage_type', 'SHELF') }}">
                    <div class="storage-type-grid">
                        <div class="storage-type-chip {{ old('storage_type', 'SHELF') == 'PALLET' ? 'selected' : '' }}" data-value="PALLET" onclick="selectStorageType('PALLET')">
                            <span class="storage-type-icon">📦</span>
                            <span class="storage-type-name">Pallet Rack</span>
                        </div>
                        <div class="storage-type-chip {{ old('storage_type', 'SHELF') == 'SHELF' ? 'selected' : '' }}" data-value="SHELF" onclick="selectStorageType('SHELF')">
                            <span class="storage-type-icon">🗄️</span>
                            <span class="storage-type-name">Shelf</span>
                        </div>
                        <div class="storage-type-chip {{ old('storage_type', 'SHELF') == 'BIN' ? 'selected' : '' }}" data-value="BIN" onclick="selectStorageType('BIN')">
                            <span class="storage-type-icon">📥</span>
                            <span class="storage-type-name">Bin / Box</span>
                        </div>
                        <div class="storage-type-chip {{ old('storage_type', 'SHELF') == 'FLOOR' ? 'selected' : '' }}" data-value="FLOOR" onclick="selectStorageType('FLOOR')">
                            <span class="storage-type-icon">⬜</span>
                            <span class="storage-type-name">Floor Space</span>
                        </div>
                        <div class="storage-type-chip {{ old('storage_type', 'SHELF') == 'COLD' ? 'selected' : '' }}" data-value="COLD" onclick="selectStorageType('COLD')">
                            <span class="storage-type-icon">❄️</span>
                            <span class="storage-type-name">Cold Storage</span>
                        </div>
                        <div class="storage-type-chip {{ old('storage_type', 'SHELF') == 'FREEZER' ? 'selected' : '' }}" data-value="FREEZER" onclick="selectStorageType('FREEZER')">
                            <span class="storage-type-icon">🧊</span>
                            <span class="storage-type-name">Freezer</span>
                        </div>
                    </div>
                </div>

                <!-- Location Details -->
                <div class="form-section">
                    <div class="form-section-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                        Location Details
                    </div>
                    
                    <div class="form-row-3">
                        <div class="form-group">
                            <label class="form-label">Zone</label>
                            <div class="input-with-suggestions">
                                <input type="text" name="zone" id="zone_input" class="form-control" placeholder="e.g., Zone A, North" value="{{ old('zone') }}" autocomplete="off">
                                <div class="suggestions-dropdown" id="zone_suggestions"></div>
                            </div>
                            <div class="form-help">Warehouse zone/area</div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Aisle</label>
                            <div class="input-with-suggestions">
                                <input type="text" name="aisle" id="aisle_input" class="form-control" placeholder="e.g., Aisle 1" value="{{ old('aisle') }}" autocomplete="off">
                                <div class="suggestions-dropdown" id="aisle_suggestions"></div>
                            </div>
                            <div class="form-help">Aisle number/name</div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Level</label>
                            <div class="input-with-suggestions">
                                <input type="text" name="level" id="level_input" class="form-control" placeholder="e.g., Ground, Level 1" value="{{ old('level') }}" autocomplete="off">
                                <div class="suggestions-dropdown" id="level_suggestions"></div>
                            </div>
                            <div class="form-help">Shelf level/floor</div>
                        </div>
                    </div>

                    <!-- Location Preview -->
                    <div class="location-preview" id="locationPreview">
                        <div class="location-preview-icon">📍</div>
                        <div class="location-preview-info">
                            <div class="location-preview-label">Location Path</div>
                            <div class="location-preview-path" id="locationPath">Select warehouse...</div>
                        </div>
                        <div class="location-preview-code" id="locationCode">---</div>
                    </div>
                </div>

                <!-- Capacity Settings -->
                <div class="form-section">
                    <div class="form-section-title">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M4 7v10c0 2.21 3.582 4 8 4s8-1.79 8-4V7M4 7c0 2.21 3.582 4 8 4s8-1.79 8-4M4 7c0-2.21 3.582-4 8-4s8 1.79 8 4"/></svg>
                        Capacity (Optional)
                    </div>
                    
                    <div class="form-row-3">
                        <div class="form-group">
                            <label class="form-label">Max Capacity</label>
                            <input type="number" name="max_capacity" class="form-control" step="0.01" min="0" placeholder="0" value="{{ old('max_capacity') }}">
                        </div>
                        <div class="form-group">
                            <label class="form-label">Capacity Unit</label>
                            <select name="capacity_unit_id" class="form-control">
                                <option value="">-- Select Unit --</option>
                                @foreach($units as $unit)
                                    <option value="{{ $unit->id }}" {{ old('capacity_unit_id') == $unit->id ? 'selected' : '' }}>
                                        {{ $unit->name }} ({{ $unit->short_name }})
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Max Weight (kg)</label>
                            <input type="number" name="max_weight" class="form-control" step="0.01" min="0" placeholder="0" value="{{ old('max_weight') }}">
                        </div>
                    </div>
                </div>

                <!-- Additional Info -->
                <div class="form-section">
                    <div class="form-group">
                        <label class="form-label">Description</label>
                        <textarea name="description" class="form-control" placeholder="Optional notes about this rack...">{{ old('description') }}</textarea>
                    </div>
                </div>

                <!-- Actions -->
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/></svg>
                        Save Rack
                    </button>
                    <a href="{{ route('inventory.racks.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
var locationSuggestions = { zones: [], aisles: [], levels: [] };

function selectStorageType(type) {
    document.getElementById('storage_type').value = type;
    document.querySelectorAll('.storage-type-chip').forEach(function(chip) {
        chip.classList.remove('selected');
    });
    document.querySelector('.storage-type-chip[data-value="' + type + '"]').classList.add('selected');
}

function updateLocationPreview() {
    var warehouseSelect = document.getElementById('warehouse_id');
    var selectedOption = warehouseSelect.selectedOptions[0];
    var warehouseName = selectedOption && selectedOption.dataset.name ? selectedOption.dataset.name : '';
    var warehouseCode = selectedOption && selectedOption.dataset.code ? selectedOption.dataset.code : '';
    var rackCode = document.getElementById('rack_code').value.toUpperCase();
    var zone = document.getElementById('zone_input').value;
    var aisle = document.getElementById('aisle_input').value;
    var level = document.getElementById('level_input').value;
    
    // Build path
    var pathParts = [];
    if (warehouseName) pathParts.push(warehouseName);
    if (zone) pathParts.push(zone);
    if (aisle) pathParts.push(aisle);
    if (level) pathParts.push(level);
    
    var pathEl = document.getElementById('locationPath');
    var codeEl = document.getElementById('locationCode');
    
    if (pathParts.length > 0) {
        pathEl.textContent = pathParts.join(' › ');
    } else {
        pathEl.textContent = 'Select warehouse...';
    }
    
    if (warehouseCode && rackCode) {
        codeEl.textContent = warehouseCode + '-' + rackCode;
    } else if (rackCode) {
        codeEl.textContent = '???-' + rackCode;
    } else {
        codeEl.textContent = '---';
    }
}

function loadLocationSuggestions(warehouseId) {
    if (!warehouseId) {
        locationSuggestions = { zones: [], aisles: [], levels: [] };
        return;
    }
    
    fetch('{{ url("admin/inventory/racks/location-suggestions") }}/' + warehouseId)
        .then(function(r) { return r.json(); })
        .then(function(data) {
            locationSuggestions = data;
        })
        .catch(function(e) {
            console.error('Error loading suggestions:', e);
        });
}

function showSuggestions(inputId, suggestionsId, type) {
    var input = document.getElementById(inputId);
    var dropdown = document.getElementById(suggestionsId);
    var value = input.value.toLowerCase();
    var suggestions = locationSuggestions[type] || [];
    
    // Filter suggestions
    var filtered = suggestions.filter(function(s) {
        return s.toLowerCase().indexOf(value) !== -1;
    });
    
    if (filtered.length === 0 && value === '') {
        filtered = suggestions.slice(0, 5);
    }
    
    if (filtered.length === 0) {
        dropdown.innerHTML = '<div class="no-suggestions">No existing values - type your own</div>';
    } else {
        dropdown.innerHTML = filtered.map(function(s) {
            return '<div class="suggestion-item" onclick="selectSuggestion(\'' + inputId + '\', \'' + suggestionsId + '\', \'' + s.replace(/'/g, "\\'") + '\')">' + s + '</div>';
        }).join('');
    }
    
    dropdown.classList.add('show');
}

function selectSuggestion(inputId, suggestionsId, value) {
    document.getElementById(inputId).value = value;
    document.getElementById(suggestionsId).classList.remove('show');
    updateLocationPreview();
}

function hideSuggestions(suggestionsId) {
    setTimeout(function() {
        document.getElementById(suggestionsId).classList.remove('show');
    }, 200);
}

// Event listeners
document.getElementById('warehouse_id').addEventListener('change', function() {
    loadLocationSuggestions(this.value);
    updateLocationPreview();
});

document.getElementById('rack_code').addEventListener('input', updateLocationPreview);
document.getElementById('zone_input').addEventListener('input', updateLocationPreview);
document.getElementById('aisle_input').addEventListener('input', updateLocationPreview);
document.getElementById('level_input').addEventListener('input', updateLocationPreview);

// Suggestions for zone
document.getElementById('zone_input').addEventListener('focus', function() {
    showSuggestions('zone_input', 'zone_suggestions', 'zones');
});
document.getElementById('zone_input').addEventListener('input', function() {
    showSuggestions('zone_input', 'zone_suggestions', 'zones');
});
document.getElementById('zone_input').addEventListener('blur', function() {
    hideSuggestions('zone_suggestions');
});

// Suggestions for aisle
document.getElementById('aisle_input').addEventListener('focus', function() {
    showSuggestions('aisle_input', 'aisle_suggestions', 'aisles');
});
document.getElementById('aisle_input').addEventListener('input', function() {
    showSuggestions('aisle_input', 'aisle_suggestions', 'aisles');
});
document.getElementById('aisle_input').addEventListener('blur', function() {
    hideSuggestions('aisle_suggestions');
});

// Suggestions for level
document.getElementById('level_input').addEventListener('focus', function() {
    showSuggestions('level_input', 'level_suggestions', 'levels');
});
document.getElementById('level_input').addEventListener('input', function() {
    showSuggestions('level_input', 'level_suggestions', 'levels');
});
document.getElementById('level_input').addEventListener('blur', function() {
    hideSuggestions('level_suggestions');
});

// Initialize
document.addEventListener('DOMContentLoaded', function() {
    var warehouseId = document.getElementById('warehouse_id').value;
    if (warehouseId) {
        loadLocationSuggestions(warehouseId);
    }
    updateLocationPreview();
});
</script>
