@include('inventory::reports.partials.styles')

<div class="rpt-container">
    <!-- Nav -->
    <div class="rpt-nav">
        <a href="{{ route('inventory.reports.stock-summary') }}">Stock Valuation</a>
        <a href="{{ route('inventory.reports.lot-summary') }}">Expiry Forecast</a>
        <a href="{{ route('inventory.reports.abc-analysis') }}" class="active">ABC Analysis</a>
        <a href="{{ route('inventory.reports.dead-stock') }}">Dead Stock</a>
        <a href="{{ route('inventory.reports.reorder') }}">Reorder</a>
        <a href="{{ route('inventory.reports.stock-aging') }}">Stock Aging</a>
    </div>

    <!-- Header -->
    <div class="rpt-header">
        <div>
            <h1>ABC Analysis Report</h1>
            <p>Inventory classification by value (Pareto 80/20 principle)</p>
        </div>
        <div class="rpt-header-actions">
            <button class="btn-export" onclick="exportToExcel('abcTable', 'abc_analysis')">
                <svg width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                Excel
            </button>

        </div>
    </div>

    <!-- Stats -->
    <div class="rpt-stats">
        <div class="rpt-stat highlight">
            <div class="rpt-stat-label">Class A - High Value</div>
            <div class="rpt-stat-value">{{ $stats['class_a_count'] }} items</div>
            <div class="rpt-stat-sub">₹{{ number_format($stats['class_a_value'], 0) }} ({{ $stats['class_a_percent'] }}%)</div>
        </div>
        <div class="rpt-stat">
            <div class="rpt-stat-label">Class B - Medium Value</div>
            <div class="rpt-stat-value">{{ $stats['class_b_count'] }} items</div>
            <div class="rpt-stat-sub">₹{{ number_format($stats['class_b_value'], 0) }} ({{ $stats['class_b_percent'] }}%)</div>
        </div>
        <div class="rpt-stat">
            <div class="rpt-stat-label">Class C - Low Value</div>
            <div class="rpt-stat-value">{{ $stats['class_c_count'] }} items</div>
            <div class="rpt-stat-sub">₹{{ number_format($stats['class_c_value'], 0) }} ({{ $stats['class_c_percent'] }}%)</div>
        </div>
        <div class="rpt-stat">
            <div class="rpt-stat-label">Total Inventory</div>
            <div class="rpt-stat-value">₹{{ number_format($stats['total_value'], 0) }}</div>
            <div class="rpt-stat-sub">{{ $stats['total_items'] }} products</div>
        </div>
    </div>

    <!-- Info Box -->
    <div class="rpt-alert rpt-alert-info">
        <strong>💡 Pareto Principle:</strong>
        Class A items ({{ $stats['total_items'] > 0 ? round(($stats['class_a_count'] / $stats['total_items']) * 100) : 0 }}% of products) represent {{ $stats['class_a_percent'] }}% of total value. Focus management efforts on Class A for maximum impact.
    </div>

    <!-- Filters -->
    <form method="GET" class="rpt-filters">
        <select name="warehouse_id">
            <option value="">All Warehouses</option>
            @foreach($warehouses as $wh)
                <option value="{{ $wh->id }}" {{ request('warehouse_id') == $wh->id ? 'selected' : '' }}>{{ $wh->name }}</option>
            @endforeach
        </select>
        <select name="category_id">
            <option value="">All Categories</option>
            @foreach($categories as $cat)
                <option value="{{ $cat->id }}" {{ request('category_id') == $cat->id ? 'selected' : '' }}>{{ $cat->name }}</option>
            @endforeach
        </select>
        <button type="submit" class="btn-filter">Apply</button>
        <a href="{{ route('inventory.reports.abc-analysis') }}" class="btn-reset">Reset</a>
    </form>

    <!-- Table -->
    <div class="rpt-card">
        <div class="rpt-card-header">ABC Classification</div>
        @php $allItems = array_merge($classA, $classB, array_slice($classC, 0, 20)); @endphp
        @if(count($allItems) > 0)
        <div style="overflow-x:auto;">
            <table class="rpt-table" id="abcTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Class</th>
                        <th>Product</th>
                        <th>Category</th>
                        <th class="text-right">Qty</th>
                        <th class="text-right">Unit Price</th>
                        <th class="text-right">Total Value</th>
                        <th class="text-right">% of Total</th>
                        <th class="text-right">Cumulative</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($allItems as $i => $item)
                    <tr>
                        <td style="color:#94a3b8;">{{ $i + 1 }}</td>
                        <td>
                            <span class="badge {{ $item->abc_class == 'A' ? 'badge-success' : ($item->abc_class == 'B' ? 'badge-info' : 'badge-default') }}">
                                {{ $item->abc_class }}
                            </span>
                        </td>
                        <td>
                            <div class="prod-cell">
                                <div class="prod-avatar">{{ strtoupper(substr($item->product_name, 0, 2)) }}</div>
                                <div>
                                    <div class="prod-name">{{ $item->product_name }}</div>
                                    <div class="prod-sku">{{ $item->sku }}</div>
                                </div>
                            </div>
                        </td>
                        <td>{{ $item->category_name }}</td>
                        <td class="text-right">{{ number_format($item->total_qty, 2) }} {{ $item->unit_name }}</td>
                        <td class="text-right">₹{{ number_format($item->unit_price, 2) }}</td>
                        <td class="text-right" style="font-weight:600;">₹{{ number_format($item->total_value, 2) }}</td>
                        <td class="text-right" style="color:#1e40af;font-weight:600;">{{ $item->value_percent }}%</td>
                        <td class="text-right">{{ $item->cumulative_percent }}%</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @if(count($classC) > 20)
        <div style="padding:12px 16px;text-align:center;color:#64748b;font-size:13px;border-top:1px solid #e5e7eb;">
            + {{ count($classC) - 20 }} more Class C items not shown
        </div>
        @endif
        <div class="rpt-footer">
            <span>Total Inventory Value</span>
            <span class="rpt-footer-value">₹{{ number_format($stats['total_value'], 2) }}</span>
        </div>
        @else
        <div class="rpt-empty">
            <div class="rpt-empty-icon">📭</div>
            <p>No stock data found</p>
        </div>
        @endif
    </div>
</div>