@include('inventory::reports.partials.styles')

<div class="rpt-container">
    <!-- Nav -->
    <div class="rpt-nav">
        <a href="{{ route('inventory.reports.stock-summary') }}">Stock Valuation</a>
        <a href="{{ route('inventory.reports.lot-summary') }}">Expiry Forecast</a>
        <a href="{{ route('inventory.reports.abc-analysis') }}">ABC Analysis</a>
        <a href="{{ route('inventory.reports.dead-stock') }}" class="active">Dead Stock</a>
        <a href="{{ route('inventory.reports.reorder') }}">Reorder</a>
        <a href="{{ route('inventory.reports.stock-aging') }}">Stock Aging</a>
    </div>

    <!-- Header -->
    <div class="rpt-header">
        <div>
            <h1>Dead Stock Report</h1>
            <p>Items with no movement in {{ $days }}+ days - Capital tied up</p>
        </div>
        <div class="rpt-header-actions">
            <button class="btn-export" onclick="exportToExcel('deadTable', 'dead_stock')">
                <svg width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                Excel
            </button>

        </div>
    </div>

    <!-- Stats -->
    <div class="rpt-stats">
        <div class="rpt-stat danger">
            <div class="rpt-stat-label">Dead Stock Items</div>
            <div class="rpt-stat-value">{{ $stats['total_dead_items'] }}</div>
            <div class="rpt-stat-sub">No movement in {{ $days }}+ days</div>
        </div>
        <div class="rpt-stat warning">
            <div class="rpt-stat-label">Capital Tied Up</div>
            <div class="rpt-stat-value">₹{{ number_format($stats['total_dead_value'], 0) }}</div>
            <div class="rpt-stat-sub">Requires attention</div>
        </div>
    </div>

    <!-- Warning -->
    @if($stats['total_dead_value'] > 0)
    <div class="rpt-alert rpt-alert-warning">
        <strong>⚠️ Action Required:</strong>
        Consider clearance sales, promotions, returns to supplier, or write-offs for these items to free up capital and warehouse space.
    </div>
    @endif

    <!-- Filters -->
    <form method="GET" class="rpt-filters">
        <select name="days">
            <option value="30" {{ $days == 30 ? 'selected' : '' }}>30+ days idle</option>
            <option value="60" {{ $days == 60 ? 'selected' : '' }}>60+ days idle</option>
            <option value="90" {{ $days == 90 ? 'selected' : '' }}>90+ days idle</option>
            <option value="180" {{ $days == 180 ? 'selected' : '' }}>180+ days idle</option>
        </select>
        <select name="category_id">
            <option value="">All Categories</option>
            @foreach($categories as $cat)
                <option value="{{ $cat->id }}" {{ request('category_id') == $cat->id ? 'selected' : '' }}>{{ $cat->name }}</option>
            @endforeach
        </select>
        <button type="submit" class="btn-filter">Apply</button>
        <a href="{{ route('inventory.reports.dead-stock') }}" class="btn-reset">Reset</a>
    </form>

    <!-- Table -->
    <div class="rpt-card">
        <div class="rpt-card-header">Dead Stock Items</div>
        @if(count($deadStock) > 0)
        <div style="overflow-x:auto;">
            <table class="rpt-table" id="deadTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Product</th>
                        <th>Category</th>
                        <th class="text-right">Stock Qty</th>
                        <th class="text-right">Unit Price</th>
                        <th class="text-right">Stock Value</th>
                        <th>Last Movement</th>
                        <th>Days Idle</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($deadStock as $i => $item)
                    <tr>
                        <td style="color:#94a3b8;">{{ $i + 1 }}</td>
                        <td>
                            <div class="prod-cell">
                                <div class="prod-avatar">{{ strtoupper(substr($item->product_name, 0, 2)) }}</div>
                                <div>
                                    <div class="prod-name">{{ $item->product_name }}</div>
                                    <div class="prod-sku">{{ $item->sku }}</div>
                                </div>
                            </div>
                        </td>
                        <td>{{ $item->category_name }}</td>
                        <td class="text-right">{{ number_format($item->total_qty, 2) }} {{ $item->unit_name }}</td>
                        <td class="text-right">₹{{ number_format($item->unit_price, 2) }}</td>
                        <td class="text-right" style="font-weight:600;color:#dc2626;">₹{{ number_format($item->stock_value, 2) }}</td>
                        <td>{{ $item->last_movement }}</td>
                        <td>
                            <span class="badge badge-danger">
                                {{ is_numeric($item->days_idle) ? $item->days_idle.'d' : $item->days_idle }}
                            </span>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="rpt-footer">
            <span>Total Dead Stock Value ({{ count($deadStock) }} items)</span>
            <span class="rpt-footer-value">₹{{ number_format($stats['total_dead_value'], 2) }}</span>
        </div>
        @else
        <div class="rpt-empty">
            <div class="rpt-empty-icon">✅</div>
            <p>No dead stock found! All items have recent movement.</p>
        </div>
        @endif
    </div>
</div>