@include('inventory::reports.partials.styles')

<div class="rpt-container">
    <!-- Nav -->
    <div class="rpt-nav">
        <a href="{{ route('inventory.reports.stock-summary') }}">Stock Valuation</a>
        <a href="{{ route('inventory.reports.lot-summary') }}" class="active">Expiry Forecast</a>
        <a href="{{ route('inventory.reports.abc-analysis') }}">ABC Analysis</a>
        <a href="{{ route('inventory.reports.dead-stock') }}">Dead Stock</a>
        <a href="{{ route('inventory.reports.reorder') }}">Reorder</a>
        <a href="{{ route('inventory.reports.stock-aging') }}">Stock Aging</a>
    </div>

    <!-- Header -->
    <div class="rpt-header">
        <div>
            <h1>Expiry Forecast Report</h1>
            <p>Track batch expiry dates and prevent inventory losses</p>
        </div>
        <div class="rpt-header-actions">
            <button class="btn-export" onclick="exportToExcel('expiryTable', 'expiry_forecast')">
                <svg width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                Excel
            </button>

        </div>
    </div>

    <!-- Stats -->
    <div class="rpt-stats">
        <div class="rpt-stat danger">
            <div class="rpt-stat-label">Expired</div>
            <div class="rpt-stat-value">{{ $stats['expired_count'] }}</div>
        </div>
        <div class="rpt-stat warning">
            <div class="rpt-stat-label">Critical (0-7 days)</div>
            <div class="rpt-stat-value">{{ $stats['critical_count'] }}</div>
        </div>
        <div class="rpt-stat">
            <div class="rpt-stat-label">Warning (8-30 days)</div>
            <div class="rpt-stat-value">{{ $stats['warning_count'] }}</div>
        </div>
        <div class="rpt-stat highlight">
            <div class="rpt-stat-label">Upcoming (31-90 days)</div>
            <div class="rpt-stat-value">{{ $stats['upcoming_count'] }}</div>
        </div>
        <div class="rpt-stat success">
            <div class="rpt-stat-label">Safe (90+ days)</div>
            <div class="rpt-stat-value">{{ $stats['safe_count'] }}</div>
        </div>
    </div>

    <!-- Value at Risk Alert -->
    @if($stats['expired_value'] > 0 || $stats['at_risk_value'] > 0)
    <div class="rpt-alert rpt-alert-danger">
        <strong>⚠️ Value at Risk:</strong>
        ₹{{ number_format($stats['expired_value'], 0) }} expired + ₹{{ number_format($stats['at_risk_value'], 0) }} expiring within 30 days = 
        <strong>₹{{ number_format($stats['expired_value'] + $stats['at_risk_value'], 0) }}</strong>
    </div>
    @endif

    <!-- Filters -->
    <form method="GET" class="rpt-filters">
        <select name="product_id">
            <option value="">All Products</option>
            @foreach($products as $product)
                <option value="{{ $product->id }}" {{ request('product_id') == $product->id ? 'selected' : '' }}>{{ $product->name }}</option>
            @endforeach
        </select>
        <select name="days">
            <option value="7" {{ $days == 7 ? 'selected' : '' }}>Next 7 Days</option>
            <option value="30" {{ $days == 30 ? 'selected' : '' }}>Next 30 Days</option>
            <option value="60" {{ $days == 60 ? 'selected' : '' }}>Next 60 Days</option>
            <option value="90" {{ $days == 90 ? 'selected' : '' }}>Next 90 Days</option>
        </select>
        <button type="submit" class="btn-filter">Apply</button>
        <a href="{{ route('inventory.reports.lot-summary') }}" class="btn-reset">Reset</a>
    </form>

    <!-- Combined Table -->
    <div class="rpt-card">
        <div class="rpt-card-header">All Lots by Expiry Status</div>
        @php $allLots = array_merge($expired, $critical, $warning, $upcoming, array_slice($safe, 0, 10)); @endphp
        @if(count($allLots) > 0)
        <div style="overflow-x:auto;">
            <table class="rpt-table" id="expiryTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Lot / Batch</th>
                        <th>Product</th>
                        <th>Warehouse</th>
                        <th class="text-right">Qty</th>
                        <th class="text-right">Value</th>
                        <th>Expiry Date</th>
                        <th>Days Left</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($allLots as $i => $lot)
                    <tr>
                        <td style="color:#94a3b8;">{{ $i + 1 }}</td>
                        <td style="font-weight:500;">{{ $lot->lot_no }}{{ $lot->batch_no ? ' / '.$lot->batch_no : '' }}</td>
                        <td>
                            <div class="prod-name">{{ $lot->product_name }}</div>
                        </td>
                        <td>{{ $lot->warehouse }}</td>
                        <td class="text-right">{{ number_format($lot->qty, 2) }} {{ $lot->unit_name }}</td>
                        <td class="text-right" style="font-weight:600;">₹{{ number_format($lot->value, 0) }}</td>
                        <td>{{ $lot->expiry_date ?? 'N/A' }}</td>
                        <td class="text-center">
                            @if($lot->expiry_status == 'expired')
                                <span style="color:#dc2626;font-weight:600;">{{ abs($lot->days_to_expiry) }}d ago</span>
                            @elseif($lot->days_to_expiry)
                                {{ $lot->days_to_expiry }}d
                            @else
                                -
                            @endif
                        </td>
                        <td>
                            <span class="badge {{ $lot->expiry_status == 'expired' ? 'badge-danger' : ($lot->expiry_status == 'critical' ? 'badge-danger' : ($lot->expiry_status == 'warning' ? 'badge-warning' : ($lot->expiry_status == 'upcoming' ? 'badge-info' : 'badge-success'))) }}">
                                {{ ucfirst($lot->expiry_status) }}
                            </span>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @if(count($safe) > 10)
        <div style="padding:12px 16px;text-align:center;color:#64748b;font-size:13px;border-top:1px solid #e5e7eb;">
            + {{ count($safe) - 10 }} more safe lots not shown
        </div>
        @endif
        @else
        <div class="rpt-empty">
            <div class="rpt-empty-icon">📭</div>
            <p>No batch-managed products found</p>
        </div>
        @endif
    </div>
</div>