{{-- resources/views/inventory/reports/partials/styles.blade.php --}}
<style>
/* ==================== REPORT STYLES - Dark/Light Mode Ready ==================== */

.rpt-container {
    padding: 20px;
    max-width: 1400px;
    margin: 0 auto;
}

/* Navigation */
.rpt-nav {
    display: flex;
    gap: 8px;
    margin-bottom: 20px;
    flex-wrap: wrap;
    padding: 12px;
    background: var(--card-bg);
    border-radius: 12px;
    border: 1px solid var(--card-border);
}

.rpt-nav a {
    padding: 10px 16px;
    font-size: 13px;
    font-weight: 600;
    color: var(--text-muted);
    text-decoration: none;
    border-radius: 8px;
    transition: all 0.2s;
}

.rpt-nav a:hover {
    background: var(--body-bg);
    color: var(--text-primary);
}

.rpt-nav a.active {
    background: rgba(99, 102, 241, 0.15);
    color: #6366f1;
}

/* Header */
.rpt-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 20px;
    flex-wrap: wrap;
    gap: 16px;
}

.rpt-header h1 {
    font-size: 24px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0 0 4px;
}

.rpt-header p {
    font-size: 13px;
    color: var(--text-muted);
    margin: 0;
}

.rpt-header-actions {
    display: flex;
    gap: 10px;
}

.btn-export {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 10px 16px;
    background: rgba(16, 185, 129, 0.15);
    color: #10b981;
    border: 1px solid rgba(16, 185, 129, 0.3);
    border-radius: 8px;
    font-size: 13px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s;
}

.btn-export:hover {
    background: rgba(16, 185, 129, 0.25);
}

/* Stats Row */
.rpt-stats {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 12px;
    margin-bottom: 20px;
}

.rpt-stat {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 12px;
    padding: 16px 20px;
    position: relative;
    overflow: hidden;
}

.rpt-stat::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 3px;
    background: var(--card-border);
}

.rpt-stat.highlight::before { background: linear-gradient(90deg, #6366f1, #818cf8); }
.rpt-stat.success::before { background: linear-gradient(90deg, #10b981, #34d399); }
.rpt-stat.warning::before { background: linear-gradient(90deg, #f59e0b, #fbbf24); }
.rpt-stat.danger::before { background: linear-gradient(90deg, #ef4444, #f87171); }

.rpt-stat-label {
    font-size: 12px;
    font-weight: 600;
    color: var(--text-muted);
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 8px;
}

.rpt-stat-value {
    font-size: 28px;
    font-weight: 800;
    color: var(--text-primary);
    line-height: 1;
}

.rpt-stat.highlight .rpt-stat-value { color: #6366f1; }
.rpt-stat.success .rpt-stat-value { color: #10b981; }
.rpt-stat.warning .rpt-stat-value { color: #f59e0b; }
.rpt-stat.danger .rpt-stat-value { color: #ef4444; }

.rpt-stat-sub {
    font-size: 12px;
    color: var(--text-muted);
    margin-top: 6px;
}

/* Filters */
.rpt-filters {
    display: flex;
    gap: 10px;
    margin-bottom: 20px;
    flex-wrap: wrap;
    align-items: center;
}

.rpt-filters select,
.rpt-filters input {
    padding: 10px 14px;
    border: 1px solid var(--card-border);
    border-radius: 8px;
    font-size: 13px;
    background: var(--card-bg);
    color: var(--text-primary);
    min-width: 150px;
}

.rpt-filters select:focus,
.rpt-filters input:focus {
    outline: none;
    border-color: #6366f1;
    box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.15);
}

.btn-filter {
    padding: 10px 20px;
    background: linear-gradient(135deg, #6366f1, #4f46e5);
    color: #fff;
    border: none;
    border-radius: 8px;
    font-size: 13px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s;
}

.btn-filter:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(99, 102, 241, 0.3);
}

.btn-reset {
    padding: 10px 16px;
    background: var(--body-bg);
    color: var(--text-muted);
    border: 1px solid var(--card-border);
    border-radius: 8px;
    font-size: 13px;
    font-weight: 500;
    text-decoration: none;
    transition: all 0.2s;
}

.btn-reset:hover {
    background: var(--card-border);
    color: var(--text-primary);
}

/* Alerts */
.rpt-alert {
    padding: 14px 18px;
    border-radius: 10px;
    font-size: 13px;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.rpt-alert-danger {
    background: rgba(239, 68, 68, 0.1);
    border: 1px solid rgba(239, 68, 68, 0.3);
    color: #ef4444;
}

.rpt-alert-warning {
    background: rgba(245, 158, 11, 0.1);
    border: 1px solid rgba(245, 158, 11, 0.3);
    color: #f59e0b;
}

.rpt-alert-info {
    background: rgba(99, 102, 241, 0.1);
    border: 1px solid rgba(99, 102, 241, 0.3);
    color: #6366f1;
}

.rpt-alert strong {
    font-weight: 700;
}

/* Cards */
.rpt-card {
    background: var(--card-bg);
    border: 1px solid var(--card-border);
    border-radius: 12px;
    overflow: hidden;
    margin-bottom: 20px;
}

.rpt-card-header {
    padding: 14px 20px;
    font-size: 14px;
    font-weight: 700;
    color: var(--text-primary);
    background: var(--body-bg);
    border-bottom: 1px solid var(--card-border);
}

/* Progress Bar */
.progress-bar {
    height: 6px;
    background: var(--body-bg);
    border-radius: 3px;
    overflow: hidden;
    border: 1px solid var(--card-border);
}

.progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #6366f1, #818cf8);
    border-radius: 3px;
    transition: width 0.3s;
}

/* Table */
.rpt-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 13px;
}

.rpt-table th {
    padding: 12px 16px;
    text-align: left;
    font-weight: 600;
    font-size: 11px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    color: var(--text-muted);
    background: var(--body-bg);
    border-bottom: 1px solid var(--card-border);
    white-space: nowrap;
}

.rpt-table td {
    padding: 12px 16px;
    border-bottom: 1px solid var(--card-border);
    color: var(--text-primary);
    vertical-align: middle;
}

.rpt-table tbody tr:hover {
    background: var(--body-bg);
}

.rpt-table tbody tr:last-child td {
    border-bottom: none;
}

.rpt-table .text-right {
    text-align: right;
}

.rpt-table .text-center {
    text-align: center;
}

/* Product Cell */
.prod-cell {
    display: flex;
    align-items: center;
    gap: 10px;
}

.prod-avatar {
    width: 36px;
    height: 36px;
    border-radius: 8px;
    background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(139, 92, 246, 0.2));
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 12px;
    font-weight: 700;
    color: #6366f1;
    flex-shrink: 0;
}

.prod-name {
    font-weight: 600;
    color: var(--text-primary);
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 200px;
}

.prod-sku {
    font-size: 11px;
    color: var(--text-muted);
    font-family: monospace;
}

/* Badges */
.badge {
    display: inline-block;
    padding: 4px 10px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
    white-space: nowrap;
}

.badge-success {
    background: rgba(16, 185, 129, 0.15);
    color: #10b981;
}

.badge-warning {
    background: rgba(245, 158, 11, 0.15);
    color: #f59e0b;
}

.badge-danger {
    background: rgba(239, 68, 68, 0.15);
    color: #ef4444;
}

.badge-info {
    background: rgba(99, 102, 241, 0.15);
    color: #6366f1;
}

.badge-default {
    background: var(--body-bg);
    color: var(--text-muted);
    border: 1px solid var(--card-border);
}

/* Footer */
.rpt-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 14px 20px;
    background: var(--body-bg);
    border-top: 1px solid var(--card-border);
    font-size: 14px;
    font-weight: 600;
    color: var(--text-secondary);
}

.rpt-footer-value {
    font-size: 18px;
    font-weight: 800;
    color: #10b981;
}

/* Empty State */
.rpt-empty {
    padding: 48px 24px;
    text-align: center;
}

.rpt-empty-icon {
    font-size: 48px;
    margin-bottom: 12px;
    opacity: 0.5;
}

.rpt-empty p {
    color: var(--text-muted);
    font-size: 14px;
    margin: 0;
}

/* Breakdown Cards Grid */
.breakdown-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 12px;
    margin-bottom: 16px;
}

@media (max-width: 768px) {
    .breakdown-grid {
        grid-template-columns: 1fr;
    }
}

.breakdown-item {
    margin-bottom: 10px;
}

.breakdown-row {
    display: flex;
    justify-content: space-between;
    font-size: 13px;
    margin-bottom: 4px;
}

.breakdown-name {
    color: var(--text-secondary);
}

.breakdown-value {
    font-weight: 600;
    color: #6366f1;
}

/* Responsive */
@media (max-width: 768px) {
    .rpt-container {
        padding: 12px;
    }
    
    .rpt-header {
        flex-direction: column;
    }
    
    .rpt-stats {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .rpt-filters {
        flex-direction: column;
    }
    
    .rpt-filters select,
    .rpt-filters input {
        width: 100%;
    }
}

@media (max-width: 480px) {
    .rpt-stats {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
// ========== EXPORT FUNCTIONS ==========

// Export to Excel
function exportToExcel(tableId, filename) {
    const table = document.getElementById(tableId);
    if (!table) return alert('Table not found');
    
    let csv = [];
    const rows = table.querySelectorAll('tr');
    
    rows.forEach(row => {
        const cols = row.querySelectorAll('th, td');
        let rowData = [];
        cols.forEach(col => {
            let text = col.innerText.replace(/"/g, '""').trim();
            rowData.push('"' + text + '"');
        });
        csv.push(rowData.join(','));
    });
    
    const csvContent = csv.join('\n');
    const blob = new Blob(['\ufeff' + csvContent], { type: 'text/csv;charset=utf-8;' });
    const link = document.createElement('a');
    link.href = URL.createObjectURL(blob);
    link.download = filename + '_' + new Date().toISOString().slice(0,10) + '.csv';
    link.click();
}

</script>