@include('inventory::reports.partials.styles')

<div class="rpt-container">
    <!-- Nav -->
    <div class="rpt-nav">
        <a href="{{ route('inventory.reports.stock-summary') }}">Stock Valuation</a>
        <a href="{{ route('inventory.reports.lot-summary') }}">Expiry Forecast</a>
        <a href="{{ route('inventory.reports.abc-analysis') }}">ABC Analysis</a>
        <a href="{{ route('inventory.reports.dead-stock') }}">Dead Stock</a>
        <a href="{{ route('inventory.reports.reorder') }}" class="active">Reorder</a>
        <a href="{{ route('inventory.reports.stock-aging') }}">Stock Aging</a>
    </div>

    <!-- Header -->
    <div class="rpt-header">
        <div>
            <h1>Reorder Report</h1>
            <p>Products below reorder point - Know what to buy</p>
        </div>
        <div class="rpt-header-actions">
            <button class="btn-export" onclick="exportToExcel('reorderTable', 'reorder_report')">
                <svg width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                Excel
            </button>

        </div>
    </div>

    <!-- Stats -->
    <div class="rpt-stats">
        <div class="rpt-stat danger">
            <div class="rpt-stat-label">Out of Stock</div>
            <div class="rpt-stat-value">{{ $stats['out_of_stock'] }}</div>
            <div class="rpt-stat-sub">Urgent reorder needed</div>
        </div>
        <div class="rpt-stat warning">
            <div class="rpt-stat-label">Critical Low</div>
            <div class="rpt-stat-value">{{ $stats['critical'] }}</div>
            <div class="rpt-stat-sub">Below 50% of reorder point</div>
        </div>
        <div class="rpt-stat">
            <div class="rpt-stat-label">Low Stock</div>
            <div class="rpt-stat-value">{{ $stats['low'] }}</div>
            <div class="rpt-stat-sub">Below reorder point</div>
        </div>
        <div class="rpt-stat highlight">
            <div class="rpt-stat-label">Est. Order Value</div>
            <div class="rpt-stat-value">₹{{ number_format($stats['total_reorder_value'], 0) }}</div>
            <div class="rpt-stat-sub">Based on suggested qty</div>
        </div>
    </div>

    <!-- Filters -->
    <form method="GET" class="rpt-filters">
        <select name="category_id">
            <option value="">All Categories</option>
            @foreach($categories as $cat)
                <option value="{{ $cat->id }}" {{ request('category_id') == $cat->id ? 'selected' : '' }}>{{ $cat->name }}</option>
            @endforeach
        </select>
        <button type="submit" class="btn-filter">Apply</button>
        <a href="{{ route('inventory.reports.reorder') }}" class="btn-reset">Reset</a>
    </form>

    <!-- Table -->
    <div class="rpt-card">
        <div class="rpt-card-header">Items Needing Reorder</div>
        @if(count($needsReorder) > 0)
        <div style="overflow-x:auto;">
            <table class="rpt-table" id="reorderTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Product</th>
                        <th>Category</th>
                        <th class="text-right">Current</th>
                        <th class="text-right">Reorder Pt</th>
                        <th class="text-right">Avg Daily</th>
                        <th class="text-right">Days Left</th>
                        <th class="text-right">Suggested Qty</th>
                        <th class="text-right">Order Value</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($needsReorder as $i => $item)
                    <tr>
                        <td style="color:#94a3b8;">{{ $i + 1 }}</td>
                        <td>
                            <div class="prod-cell">
                                <div class="prod-avatar">{{ strtoupper(substr($item->product_name, 0, 2)) }}</div>
                                <div>
                                    <div class="prod-name">{{ $item->product_name }}</div>
                                    <div class="prod-sku">{{ $item->sku }}</div>
                                </div>
                            </div>
                        </td>
                        <td>{{ $item->category_name }}</td>
                        <td class="text-right">{{ number_format($item->current_stock, 2) }} {{ $item->unit_name }}</td>
                        <td class="text-right">{{ number_format($item->reorder_point, 0) }}</td>
                        <td class="text-right">{{ $item->avg_daily_usage }}/day</td>
                        <td class="text-right">
                            <span style="font-weight:600;{{ $item->days_of_stock <= 3 ? 'color:#dc2626;' : ($item->days_of_stock <= 7 ? 'color:#d97706;' : '') }}">
                                {{ $item->days_of_stock == 999 ? '∞' : $item->days_of_stock.'d' }}
                            </span>
                        </td>
                        <td class="text-right" style="font-weight:600;color:#1e40af;">{{ number_format($item->suggested_qty, 0) }}</td>
                        <td class="text-right">₹{{ number_format($item->order_value, 0) }}</td>
                        <td>
                            <span class="badge {{ $item->status == 'out' ? 'badge-danger' : ($item->status == 'critical' ? 'badge-warning' : 'badge-info') }}">
                                {{ $item->status == 'out' ? 'Out' : ($item->status == 'critical' ? 'Critical' : 'Low') }}
                            </span>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="rpt-footer">
            <span>Estimated Total Order Value ({{ count($needsReorder) }} items)</span>
            <span class="rpt-footer-value">₹{{ number_format($stats['total_reorder_value'], 2) }}</span>
        </div>
        @else
        <div class="rpt-empty">
            <div class="rpt-empty-icon">✅</div>
            <p>All products are well stocked! No reorder needed.</p>
        </div>
        @endif
    </div>
</div>