@include('inventory::reports.partials.styles')

<div class="rpt-container">
    <!-- Nav -->
    <div class="rpt-nav">
        <a href="{{ route('inventory.reports.stock-summary') }}">Stock Valuation</a>
        <a href="{{ route('inventory.reports.lot-summary') }}">Expiry Forecast</a>
        <a href="{{ route('inventory.reports.abc-analysis') }}">ABC Analysis</a>
        <a href="{{ route('inventory.reports.dead-stock') }}">Dead Stock</a>
        <a href="{{ route('inventory.reports.reorder') }}">Reorder</a>
        <a href="{{ route('inventory.reports.stock-aging') }}" class="active">Stock Aging</a>
    </div>

    <!-- Header -->
    <div class="rpt-header">
        <div>
            <h1>Stock Aging Report</h1>
            <p>Inventory freshness analysis by last receipt date</p>
        </div>
        <div class="rpt-header-actions">
            <button class="btn-export" onclick="exportToExcel('agingTable', 'stock_aging')">
                <svg width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                Excel
            </button>

        </div>
    </div>

    <!-- Stats -->
    <div class="rpt-stats">
        <div class="rpt-stat success">
            <div class="rpt-stat-label">Fresh (0-30 days)</div>
            <div class="rpt-stat-value">{{ $stats['fresh_count'] }}</div>
            <div class="rpt-stat-sub">₹{{ number_format($stats['fresh_value'], 0) }} ({{ $stats['fresh_percent'] }}%)</div>
        </div>
        <div class="rpt-stat highlight">
            <div class="rpt-stat-label">Normal (31-60 days)</div>
            <div class="rpt-stat-value">{{ $stats['normal_count'] }}</div>
            <div class="rpt-stat-sub">₹{{ number_format($stats['normal_value'], 0) }} ({{ $stats['normal_percent'] }}%)</div>
        </div>
        <div class="rpt-stat warning">
            <div class="rpt-stat-label">Aging (61-90 days)</div>
            <div class="rpt-stat-value">{{ $stats['aging_count'] }}</div>
            <div class="rpt-stat-sub">₹{{ number_format($stats['aging_value'], 0) }} ({{ $stats['aging_percent'] }}%)</div>
        </div>
        <div class="rpt-stat danger">
            <div class="rpt-stat-label">Stale (90+ days)</div>
            <div class="rpt-stat-value">{{ $stats['stale_count'] }}</div>
            <div class="rpt-stat-sub">₹{{ number_format($stats['stale_value'], 0) }} ({{ $stats['stale_percent'] }}%)</div>
        </div>
    </div>

    <!-- Filters -->
    <form method="GET" class="rpt-filters">
        <select name="warehouse_id">
            <option value="">All Warehouses</option>
            @foreach($warehouses as $wh)
                <option value="{{ $wh->id }}" {{ request('warehouse_id') == $wh->id ? 'selected' : '' }}>{{ $wh->name }}</option>
            @endforeach
        </select>
        <select name="category_id">
            <option value="">All Categories</option>
            @foreach($categories as $cat)
                <option value="{{ $cat->id }}" {{ request('category_id') == $cat->id ? 'selected' : '' }}>{{ $cat->name }}</option>
            @endforeach
        </select>
        <button type="submit" class="btn-filter">Apply</button>
        <a href="{{ route('inventory.reports.stock-aging') }}" class="btn-reset">Reset</a>
    </form>

    <!-- Table -->
    <div class="rpt-card">
        <div class="rpt-card-header">Stock by Age</div>
        @php $allItems = array_merge($stale, $aging, array_slice($normal, 0, 10), array_slice($fresh, 0, 10)); @endphp
        @if(count($allItems) > 0)
        <div style="overflow-x:auto;">
            <table class="rpt-table" id="agingTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Age</th>
                        <th>Product</th>
                        <th>Category</th>
                        <th class="text-right">Qty</th>
                        <th class="text-right">Value</th>
                        <th>Last Receipt</th>
                        <th class="text-right">Days Old</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($allItems as $i => $item)
                    <tr>
                        <td style="color:#94a3b8;">{{ $i + 1 }}</td>
                        <td>
                            <span class="badge {{ $item->age_class == 'fresh' ? 'badge-success' : ($item->age_class == 'normal' ? 'badge-info' : ($item->age_class == 'aging' ? 'badge-warning' : 'badge-danger')) }}">
                                {{ ucfirst($item->age_class) }}
                            </span>
                        </td>
                        <td>
                            <div class="prod-cell">
                                <div class="prod-avatar">{{ strtoupper(substr($item->product_name, 0, 2)) }}</div>
                                <div>
                                    <div class="prod-name">{{ $item->product_name }}</div>
                                    <div class="prod-sku">{{ $item->sku }}</div>
                                </div>
                            </div>
                        </td>
                        <td>{{ $item->category_name }}</td>
                        <td class="text-right">{{ number_format($item->total_qty, 2) }} {{ $item->unit_name }}</td>
                        <td class="text-right" style="font-weight:600;">₹{{ number_format($item->stock_value, 0) }}</td>
                        <td>{{ $item->last_receipt }}</td>
                        <td class="text-right" style="font-weight:600;{{ $item->age_class == 'stale' ? 'color:#dc2626;' : ($item->age_class == 'aging' ? 'color:#d97706;' : '') }}">
                            {{ $item->age_days }}d
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @php $hiddenCount = max(0, count($normal) - 10) + max(0, count($fresh) - 10); @endphp
        @if($hiddenCount > 0)
        <div style="padding:12px 16px;text-align:center;color:#64748b;font-size:13px;border-top:1px solid #e5e7eb;">
            + {{ $hiddenCount }} more items not shown (prioritizing stale/aging stock)
        </div>
        @endif
        <div class="rpt-footer">
            <span>Total Inventory Value</span>
            <span class="rpt-footer-value">₹{{ number_format($stats['total_value'], 2) }}</span>
        </div>
        @else
        <div class="rpt-empty">
            <div class="rpt-empty-icon">📭</div>
            <p>No stock data found</p>
        </div>
        @endif
    </div>
</div>