@include('inventory::reports.partials.styles')

<div class="rpt-container">
    <!-- Nav -->
    <div class="rpt-nav">
        <a href="{{ route('inventory.reports.stock-summary') }}" class="active">Stock Valuation</a>
        <a href="{{ route('inventory.reports.lot-summary') }}">Expiry Forecast</a>
        <a href="{{ route('inventory.reports.abc-analysis') }}">ABC Analysis</a>
        <a href="{{ route('inventory.reports.dead-stock') }}">Dead Stock</a>
        <a href="{{ route('inventory.reports.reorder') }}">Reorder</a>
        <a href="{{ route('inventory.reports.stock-aging') }}">Stock Aging</a>
    </div>

    <!-- Header -->
    <div class="rpt-header">
        <div>
            <h1>Stock Valuation Report</h1>
            <p>Generated on {{ now()->format('d M Y, h:i A') }}</p>
        </div>
        <div class="rpt-header-actions">
            <button class="btn-export" onclick="exportToExcel('stockTable', 'stock_valuation')">
                <svg width="14" height="14" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                Excel
            </button>

        </div>
    </div>

    <!-- Stats -->
    @php $avgValue = $stockReport->count() > 0 ? $totalValue / $stockReport->count() : 0; @endphp
    <div class="rpt-stats">
        <div class="rpt-stat highlight">
            <div class="rpt-stat-label">Total Stock Value</div>
            <div class="rpt-stat-value">₹{{ number_format($totalValue, 0) }}</div>
            <div class="rpt-stat-sub">Avg ₹{{ number_format($avgValue, 0) }} per item</div>
        </div>
        <div class="rpt-stat">
            <div class="rpt-stat-label">Total Quantity</div>
            <div class="rpt-stat-value">{{ number_format($totalQty, 0) }}</div>
            <div class="rpt-stat-sub">{{ $stockReport->count() }} unique products</div>
        </div>
        <div class="rpt-stat warning">
            <div class="rpt-stat-label">Low Stock Items</div>
            <div class="rpt-stat-value">{{ $lowStockCount }}</div>
            <div class="rpt-stat-sub">Below reorder point</div>
        </div>
        <div class="rpt-stat danger">
            <div class="rpt-stat-label">Dead Stock</div>
            <div class="rpt-stat-value">{{ $deadStockCount }}</div>
            <div class="rpt-stat-sub">No movement in 30 days</div>
        </div>
    </div>

    <!-- Filters -->
    <form method="GET" class="rpt-filters">
        <select name="warehouse_id">
            <option value="">All Warehouses</option>
            @foreach($warehouses as $wh)
                <option value="{{ $wh->id }}" {{ request('warehouse_id') == $wh->id ? 'selected' : '' }}>{{ $wh->name }}</option>
            @endforeach
        </select>
        <select name="category_id">
            <option value="">All Categories</option>
            @foreach($categories as $cat)
                <option value="{{ $cat->id }}" {{ request('category_id') == $cat->id ? 'selected' : '' }}>{{ $cat->name }}</option>
            @endforeach
        </select>
        <select name="brand_id">
            <option value="">All Brands</option>
            @foreach($brands as $brand)
                <option value="{{ $brand->id }}" {{ request('brand_id') == $brand->id ? 'selected' : '' }}>{{ $brand->name }}</option>
            @endforeach
        </select>
        <button type="submit" class="btn-filter">Apply</button>
        <a href="{{ route('inventory.reports.stock-summary') }}" class="btn-reset">Reset</a>
    </form>

    <!-- Breakdown Cards -->
    @if($stockReport->count() > 0)
    <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:12px;margin-bottom:16px;">
        <div class="rpt-card">
            <div class="rpt-card-header">Value by Category</div>
            <div style="padding:12px 16px;">
                @forelse(array_slice($categoryBreakdown, 0, 5, true) as $name => $data)
                    @php $pct = $totalValue > 0 ? ($data['value'] / $totalValue) * 100 : 0; @endphp
                    <div style="margin-bottom:10px;">
                        <div style="display:flex;justify-content:space-between;font-size:13px;margin-bottom:4px;">
                            <span style="color:#334155;">{{ $name }}</span>
                            <span style="font-weight:600;color:#1e40af;">₹{{ number_format($data['value'], 0) }}</span>
                        </div>
                        <div class="progress-bar"><div class="progress-fill" style="width:{{ $pct }}%"></div></div>
                    </div>
                @empty
                    <p style="color:#94a3b8;font-size:13px;">No data</p>
                @endforelse
            </div>
        </div>
        <div class="rpt-card">
            <div class="rpt-card-header">Value by Warehouse</div>
            <div style="padding:12px 16px;">
                @forelse(array_slice($warehouseBreakdown, 0, 5, true) as $name => $data)
                    @php $pct = $totalValue > 0 ? ($data['value'] / $totalValue) * 100 : 0; @endphp
                    <div style="margin-bottom:10px;">
                        <div style="display:flex;justify-content:space-between;font-size:13px;margin-bottom:4px;">
                            <span style="color:#334155;">{{ $name }}</span>
                            <span style="font-weight:600;color:#1e40af;">₹{{ number_format($data['value'], 0) }}</span>
                        </div>
                        <div class="progress-bar"><div class="progress-fill" style="width:{{ $pct }}%"></div></div>
                    </div>
                @empty
                    <p style="color:#94a3b8;font-size:13px;">No data</p>
                @endforelse
            </div>
        </div>
    </div>
    @endif

    <!-- Table -->
    <div class="rpt-card">
        <div class="rpt-card-header">Stock Details</div>
        @if($stockReport->count() > 0)
        <div style="overflow-x:auto;">
            <table class="rpt-table" id="stockTable">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Product</th>
                        <th>Category</th>
                        <th>Warehouse</th>
                        <th class="text-right">Qty</th>
                        <th class="text-right">Unit Cost</th>
                        <th class="text-right">Value</th>
                        <th class="text-right">Margin</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($stockReport as $i => $item)
                    <tr>
                        <td style="color:#94a3b8;">{{ $i + 1 }}</td>
                        <td>
                            <div class="prod-cell">
                                <div class="prod-avatar">{{ strtoupper(substr($item->product_name, 0, 2)) }}</div>
                                <div>
                                    <div class="prod-name">{{ $item->product_name }}</div>
                                    <div class="prod-sku">{{ $item->sku }}</div>
                                </div>
                            </div>
                        </td>
                        <td>{{ $item->category_name }}</td>
                        <td>{{ $item->warehouse_name }}</td>
                        <td class="text-right">{{ number_format($item->qty, 2) }} <span style="color:#94a3b8;font-size:11px;">{{ $item->unit_name }}</span></td>
                        <td class="text-right">₹{{ number_format($item->purchase_price, 2) }}</td>
                        <td class="text-right" style="font-weight:600;">₹{{ number_format($item->stock_value, 2) }}</td>
                        <td class="text-right {{ $item->margin >= 20 ? 'badge-success' : ($item->margin < 10 ? 'badge-danger' : '') }}" style="font-weight:600;">{{ number_format($item->margin, 1) }}%</td>
                        <td>
                            <span class="badge {{ $item->status == 'ok' ? 'badge-success' : ($item->status == 'low' ? 'badge-warning' : 'badge-danger') }}">
                                {{ $item->status == 'ok' ? 'In Stock' : ($item->status == 'low' ? 'Low' : 'Out') }}
                            </span>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="rpt-footer">
            <span>Total Value ({{ $stockReport->count() }} items)</span>
            <span class="rpt-footer-value">₹{{ number_format($totalValue, 2) }}</span>
        </div>
        @else
        <div class="rpt-empty">
            <div class="rpt-empty-icon">📭</div>
            <p>No stock data found</p>
        </div>
        @endif
    </div>
</div>