{{-- Stock Deliver - Fixed: No arrow functions, handles products with has_variants but no variations --}}

<style>
    .page-container { padding: 20px; max-width: 900px; margin: 0 auto; }
    
    .page-header { display: flex; align-items: center; gap: 16px; margin-bottom: 24px; }
    .back-btn { width: 44px; height: 44px; border-radius: 12px; display: flex; align-items: center; justify-content: center; background: var(--card-bg); border: 1px solid var(--card-border); color: var(--text-muted); text-decoration: none; transition: all 0.2s; flex-shrink: 0; }
    .back-btn:hover { background: var(--body-bg); color: var(--text-primary); }
    .page-title { font-size: 24px; font-weight: 700; color: var(--text-primary); display: flex; align-items: center; gap: 12px; }
    .page-title-icon { width: 48px; height: 48px; border-radius: 12px; background: linear-gradient(135deg, #dc2626, #b91c1c); display: flex; align-items: center; justify-content: center; color: #fff; font-size: 22px; }
    
    .form-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 16px; overflow: hidden; }
    .form-card-header { padding: 20px 24px; background: linear-gradient(135deg, #fee2e2, #fecaca); border-bottom: 1px solid #fecaca; }
    .form-card-title { font-size: 16px; font-weight: 700; color: #991b1b; margin: 0; }
    .form-card-body { padding: 24px; }
    
    .form-section { margin-bottom: 28px; padding-bottom: 28px; border-bottom: 1px solid var(--card-border); }
    .form-section:last-child { margin-bottom: 0; padding-bottom: 0; border-bottom: none; }
    .form-section-title { font-size: 13px; font-weight: 700; color: #dc2626; text-transform: uppercase; letter-spacing: 0.5px; margin-bottom: 16px; }
    
    .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
    @media (max-width: 640px) { .form-row { grid-template-columns: 1fr; } }
    
    .form-group { margin-bottom: 16px; }
    .form-group:last-child { margin-bottom: 0; }
    .form-label { display: block; font-size: 13px; font-weight: 600; color: var(--text-primary); margin-bottom: 8px; }
    .form-label .required { color: #ef4444; }
    
    .form-control { width: 100%; padding: 12px 14px; border: 2px solid var(--card-border); border-radius: 10px; font-size: 14px; background: var(--card-bg); color: var(--text-primary); transition: all 0.2s; box-sizing: border-box; }
    .form-control:focus { outline: none; border-color: #dc2626; box-shadow: 0 0 0 3px rgba(220, 38, 38, 0.15); }
    textarea.form-control { min-height: 80px; resize: vertical; }
    .form-help { font-size: 11px; color: var(--text-muted); margin-top: 6px; }
    
    /* Product Search - Red Theme */
    .product-search-box { position: relative; }
    .product-search-input { width: 100%; padding: 14px 16px 14px 48px; border: 2px solid var(--card-border); border-radius: 12px; font-size: 15px; background: var(--card-bg); color: var(--text-primary); box-sizing: border-box; }
    .product-search-input:focus { outline: none; border-color: #dc2626; box-shadow: 0 0 0 3px rgba(220, 38, 38, 0.15); }
    .product-search-icon { position: absolute; left: 16px; top: 50%; transform: translateY(-50%); color: var(--text-muted); pointer-events: none; }
    
    .product-dropdown { position: absolute; top: 100%; left: 0; right: 0; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; box-shadow: 0 10px 40px rgba(0,0,0,0.15); margin-top: 4px; max-height: 350px; overflow-y: auto; z-index: 100; display: none; }
    .product-dropdown.show { display: block; }
    
    .product-item { display: flex; align-items: center; gap: 14px; padding: 12px 16px; cursor: pointer; border-bottom: 1px solid var(--card-border); transition: background 0.15s; }
    .product-item:last-child { border-bottom: none; }
    .product-item:hover { background: #fee2e2; }
    
    .product-item-image { width: 50px; height: 50px; border-radius: 10px; object-fit: cover; background: var(--body-bg); border: 1px solid var(--card-border); flex-shrink: 0; }
    .product-item-placeholder { width: 50px; height: 50px; border-radius: 10px; background: linear-gradient(135deg, #fee2e2, #fecaca); display: flex; align-items: center; justify-content: center; color: #dc2626; font-weight: 700; font-size: 14px; flex-shrink: 0; }
    
    .product-item-info { flex: 1; min-width: 0; }
    .product-item-name { font-weight: 600; color: var(--text-primary); font-size: 14px; margin-bottom: 2px; }
    .product-item-meta { display: flex; align-items: center; gap: 8px; font-size: 11px; color: var(--text-muted); flex-wrap: wrap; }
    .product-item-sku { font-family: monospace; background: var(--body-bg); padding: 2px 6px; border-radius: 4px; }
    .product-item-badge { padding: 2px 6px; border-radius: 4px; font-size: 10px; font-weight: 600; }
    .product-item-badge.batch { background: #fef3c7; color: #92400e; }
    .product-item-badge.variant { background: #ede9fe; color: #6d28d9; }
    
    .product-item-stock { text-align: right; flex-shrink: 0; }
    .product-item-stock-value { font-size: 16px; font-weight: 700; color: #dc2626; }
    .product-item-stock-label { font-size: 10px; color: var(--text-muted); }
    
    .product-no-results { text-align: center; padding: 20px; color: var(--text-muted); font-size: 13px; display: none; }
    
    /* Selected Product Card - Red Theme */
    .selected-product { display: none; background: #fee2e2; border: 2px solid #fecaca; border-radius: 14px; padding: 18px; margin-top: 16px; }
    .selected-product.show { display: block; }
    
    .selected-product-header { display: flex; align-items: flex-start; gap: 16px; }
    .selected-product-image { width: 80px; height: 80px; border-radius: 12px; object-fit: cover; background: #fff; border: 2px solid #fecaca; flex-shrink: 0; }
    .selected-product-placeholder { width: 80px; height: 80px; border-radius: 12px; background: linear-gradient(135deg, #fff, #fecaca); display: flex; align-items: center; justify-content: center; color: #dc2626; font-weight: 700; font-size: 24px; flex-shrink: 0; }
    
    .selected-product-info { flex: 1; }
    .selected-product-name { font-size: 18px; font-weight: 700; color: #991b1b; margin-bottom: 4px; }
    .selected-product-sku { font-size: 13px; color: #dc2626; font-family: monospace; background: #fff; padding: 4px 10px; border-radius: 6px; display: inline-block; }
    .selected-product-badges { display: flex; gap: 8px; margin-top: 10px; flex-wrap: wrap; }
    .selected-product-badge { padding: 4px 10px; border-radius: 12px; font-size: 11px; font-weight: 600; }
    .selected-product-badge.unit { background: #dbeafe; color: #1e40af; }
    .selected-product-badge.batch { background: #fef3c7; color: #92400e; }
    .selected-product-badge.variant { background: #ede9fe; color: #6d28d9; }
    .selected-product-badge.stock { background: #fff; color: #991b1b; font-size: 13px; }
    
    .selected-product-clear { padding: 8px; border: none; background: transparent; color: #991b1b; cursor: pointer; border-radius: 8px; transition: background 0.15s; }
    .selected-product-clear:hover { background: #fecaca; }
    
    .selected-product-prices { display: grid; grid-template-columns: repeat(4, 1fr); gap: 12px; margin-top: 16px; padding-top: 16px; border-top: 2px dashed #fecaca; }
    @media (max-width: 640px) { .selected-product-prices { grid-template-columns: repeat(2, 1fr); } }
    .price-box { background: #fff; border-radius: 10px; padding: 12px; text-align: center; }
    .price-box-label { font-size: 10px; color: var(--text-muted); text-transform: uppercase; margin-bottom: 4px; }
    .price-box-value { font-size: 16px; font-weight: 700; color: #991b1b; }
    .price-box-source { font-size: 9px; color: #dc2626; margin-top: 2px; }
    
    /* Variation Selection */
    .variation-section { display: none; margin-top: 16px; padding-top: 16px; border-top: 2px dashed #fecaca; }
    .variation-section.show { display: block; }
    .variation-section-title { font-size: 13px; font-weight: 600; color: #991b1b; margin-bottom: 12px; }
    
    .variation-grid { display: flex; flex-wrap: wrap; gap: 10px; }
    .variation-chip { display: flex; align-items: center; gap: 8px; padding: 10px 14px; background: #fff; border: 2px solid #d1d5db; border-radius: 10px; cursor: pointer; transition: all 0.15s; }
    .variation-chip:hover { border-color: #dc2626; }
    .variation-chip.selected { border-color: #dc2626; background: #fee2e2; }
    .variation-chip-color { width: 20px; height: 20px; border-radius: 50%; border: 2px solid rgba(0,0,0,0.1); flex-shrink: 0; }
    .variation-chip-image { width: 32px; height: 32px; border-radius: 6px; object-fit: cover; border: 1px solid #d1d5db; }
    .variation-chip-name { font-size: 13px; font-weight: 500; color: var(--text-primary); }
    .variation-chip-stock { font-size: 11px; color: var(--text-muted); margin-left: 8px; }
    .variation-chip-stock.low { color: #dc2626; font-weight: 600; }
    .variation-chip-price { font-size: 11px; font-weight: 600; color: #dc2626; margin-left: 4px; background: #fee2e2; padding: 2px 6px; border-radius: 4px; }
    
    /* Lot Section - FEFO Priority */
    .lot-section { display: none; background: #f0fdf4; border: 2px solid #86efac; border-radius: 14px; padding: 18px; margin-top: 16px; }
    .lot-section.show { display: block; }
    .lot-section-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 14px; flex-wrap: wrap; gap: 10px; }
    .lot-section-title { font-size: 14px; font-weight: 700; color: #166534; }
    .lot-section-hint { font-size: 11px; color: #16a34a; background: #dcfce7; padding: 4px 10px; border-radius: 20px; }
    
    .lot-list { max-height: 250px; overflow-y: auto; }
    
    .lot-item { display: flex; align-items: center; gap: 14px; padding: 12px 14px; background: #fff; border: 2px solid #e5e7eb; border-radius: 10px; margin-bottom: 8px; cursor: pointer; transition: all 0.15s; position: relative; }
    .lot-item:last-child { margin-bottom: 0; }
    .lot-item:hover { border-color: #16a34a; }
    .lot-item.selected { border-color: #16a34a; background: #dcfce7; }
    .lot-item.recommended { border-color: #22c55e; background: #f0fdf4; }
    .lot-item.recommended::before { content: '⭐ FEFO'; position: absolute; top: -8px; right: 10px; background: #22c55e; color: #fff; font-size: 9px; font-weight: 700; padding: 2px 8px; border-radius: 10px; }
    
    .lot-item-icon { width: 40px; height: 40px; border-radius: 10px; display: flex; align-items: center; justify-content: center; font-size: 18px; flex-shrink: 0; }
    .lot-item-icon.ok { background: #d1fae5; }
    .lot-item-icon.warn { background: #fef3c7; }
    .lot-item-icon.bad { background: #fee2e2; }
    
    .lot-item-info { flex: 1; min-width: 0; }
    .lot-item-header { display: flex; align-items: center; gap: 8px; margin-bottom: 4px; flex-wrap: wrap; }
    .lot-item-no { font-weight: 700; font-size: 13px; color: var(--text-primary); }
    .lot-item-batch { font-size: 11px; color: var(--text-muted); background: #f3f4f6; padding: 2px 6px; border-radius: 4px; }
    .lot-item-expiry { font-size: 10px; padding: 3px 8px; border-radius: 10px; font-weight: 600; margin-left: auto; }
    .lot-item-expiry.ok { background: #d1fae5; color: #065f46; }
    .lot-item-expiry.warn { background: #fef3c7; color: #92400e; }
    .lot-item-expiry.bad { background: #fee2e2; color: #991b1b; }
    
    .lot-item-meta { display: flex; gap: 12px; font-size: 11px; color: var(--text-muted); flex-wrap: wrap; }
    
    .lot-item-prices { text-align: right; flex-shrink: 0; }
    .lot-item-price { font-size: 14px; font-weight: 700; color: #16a34a; }
    .lot-item-price-label { font-size: 10px; color: var(--text-muted); }
    .lot-item-stock { font-size: 12px; font-weight: 600; color: var(--text-primary); margin-top: 4px; }
    
    .lot-no-items { text-align: center; padding: 20px; color: var(--text-muted); font-size: 13px; }
    
    /* Selected Lot Display */
    .selected-lot { display: none; background: #fff; border: 2px solid #16a34a; border-radius: 12px; padding: 14px; margin-top: 12px; }
    .selected-lot.show { display: flex; align-items: center; gap: 14px; flex-wrap: wrap; }
    .selected-lot-icon { width: 48px; height: 48px; border-radius: 10px; background: #dcfce7; display: flex; align-items: center; justify-content: center; font-size: 22px; flex-shrink: 0; }
    .selected-lot-info { flex: 1; min-width: 150px; }
    .selected-lot-no { font-size: 15px; font-weight: 700; color: var(--text-primary); }
    .selected-lot-meta { display: flex; gap: 12px; margin-top: 4px; font-size: 11px; color: var(--text-muted); flex-wrap: wrap; }
    .selected-lot-prices { display: flex; gap: 16px; }
    .selected-lot-price { text-align: center; }
    .selected-lot-price-value { font-size: 16px; font-weight: 700; color: #16a34a; }
    .selected-lot-price-label { font-size: 10px; color: var(--text-muted); }
    .selected-lot-clear { padding: 8px; border: none; background: transparent; color: #166534; cursor: pointer; border-radius: 8px; }
    .selected-lot-clear:hover { background: #dcfce7; }
    
    /* Available Stock Warning */
    .stock-warning { background: #fef3c7; border: 2px solid #fcd34d; border-radius: 10px; padding: 12px 16px; margin-top: 12px; display: none; }
    .stock-warning.show { display: flex; align-items: center; gap: 12px; }
    .stock-warning-icon { font-size: 24px; }
    .stock-warning-text { flex: 1; font-size: 13px; color: #92400e; }
    .stock-warning-value { font-weight: 700; }
    
    /* Form Actions */
    .form-actions { display: flex; gap: 12px; padding-top: 24px; border-top: 1px solid var(--card-border); margin-top: 24px; }
    .btn { display: inline-flex; align-items: center; justify-content: center; gap: 8px; padding: 14px 28px; border-radius: 10px; font-size: 14px; font-weight: 600; cursor: pointer; border: none; text-decoration: none; transition: all 0.2s; }
    .btn-primary { background: linear-gradient(135deg, #dc2626, #b91c1c); color: #fff; }
    .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 6px 20px rgba(220, 38, 38, 0.3); }
    .btn-secondary { background: var(--body-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
    .btn-secondary:hover { background: var(--card-border); }
    
    .alert { padding: 14px 18px; border-radius: 10px; margin-bottom: 20px; font-size: 14px; }
    .alert-success { background: #d1fae5; color: #065f46; border: 1px solid #a7f3d0; }
    .alert-error { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }
</style>

<div class="page-container">
    <div class="page-header">
        <a href="{{ route('inventory.stock.movements') }}" class="back-btn">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/></svg>
        </a>
        <div class="page-title">
            <div class="page-title-icon">📤</div>
            <span>Deliver Stock</span>
        </div>
    </div>
    
    @if(session('success'))<div class="alert alert-success">{{ session('success') }}</div>@endif
    @if(session('error'))<div class="alert alert-error">{{ session('error') }}</div>@endif
    
    
    
    <div class="form-card">
        <div class="form-card-header">
            <h3 class="form-card-title">📤 Stock Out - Deliver / Issue Goods</h3>
        </div>
        <div class="form-card-body">
            <form action="{{ route('inventory.stock.deliver.store') }}" method="POST" id="deliverForm">
                @csrf
                
                <!-- Product Selection -->
                <div class="form-section">
                    <div class="form-section-title">📦 Product Selection</div>
                    
                    <div class="product-search-box">
                        <svg class="product-search-icon" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                        </svg>
                        <input type="text" class="product-search-input" id="productSearch" placeholder="Search by product name or SKU" autocomplete="off">
                        <input type="hidden" name="product_id" id="product_id" required>
                        <input type="hidden" name="variation_id" id="variation_id">
                        
                        <div class="product-dropdown" id="productDropdown">
                            @foreach($products as $product)
                            @php
                                $img = $product->images->where('is_primary', true)->first();
                                if(!$img) $img = $product->images->first();
                                $imgUrl = $img ? asset('storage/' . $img->image_path) : null;
                                $totalStock = $product->stockLevels->sum('qty');
                                
                                // Build variations array properly
                                $variationsData = [];
                                foreach($product->variations as $v) {
                                    $vImg = $v->image_path ? asset('storage/' . $v->image_path) : null;
                                    
                                    // Get color from attribute values
                                    $vColor = null;
                                    if($v->attributeValues && $v->attributeValues->count() > 0) {
                                        $firstAttr = $v->attributeValues->first();
                                        $vColor = $firstAttr ? $firstAttr->color_code : null;
                                    }
                                    
                                    // Get variation name from attribute values if not set
                                    $vName = $v->variation_name;
                                    if (!$vName && $v->attributeValues) {
                                        $parts = [];
                                        foreach($v->attributeValues as $av) {
                                            $parts[] = $av->value;
                                        }
                                        $vName = implode(' / ', $parts);
                                    }
                                    if (!$vName) $vName = $v->sku;
                                    
                                    $variationsData[] = [
                                        'id' => $v->id,
                                        'sku' => $v->sku,
                                        'barcode' => $v->barcode,
                                        'name' => $vName,
                                        'stock' => $v->stockLevels ? $v->stockLevels->sum('qty') : 0,
                                        // Variation's own prices (null if not set)
                                        'purchase_price' => $v->purchase_price,
                                        'sale_price' => $v->sale_price,
                                        'mrp' => $v->mrp,
                                        // Effective prices (fallback to product if variation price is null)
                                        'effective_purchase' => $v->purchase_price ?? $product->purchase_price ?? 0,
                                        'effective_sale' => $v->sale_price ?? $product->sale_price ?? 0,
                                        'effective_mrp' => $v->mrp ?? $product->mrp ?? 0,
                                        'image' => $vImg,
                                        'color' => $vColor
                                    ];
                                }
                                
                                $hasRealVariants = count($variationsData) > 0;
                            @endphp
                            <div class="product-item" 
                                 data-id="{{ $product->id }}"
                                 data-name="{{ $product->name }}"
                                 data-sku="{{ $product->sku }}"
                                 data-barcode="{{ $product->barcode }}"
                                 data-image="{{ $imgUrl }}"
                                 data-unit="{{ $product->unit->short_name ?? 'PCS' }}"
                                 data-unit-id="{{ $product->unit_id }}"
                                 data-purchase="{{ $product->purchase_price ?? 0 }}"
                                 data-sale="{{ $product->sale_price ?? 0 }}"
                                 data-mrp="{{ $product->mrp ?? 0 }}"
                                 data-batch="{{ $product->is_batch_managed ? '1' : '0' }}"
                                 data-variants="{{ $hasRealVariants ? '1' : '0' }}"
                                 data-stock="{{ $totalStock }}"
                                 data-variations="{{ base64_encode(json_encode($variationsData)) }}">
                                @if($imgUrl)
                                    <img src="{{ $imgUrl }}" alt="" class="product-item-image">
                                @else
                                    <div class="product-item-placeholder">{{ strtoupper(substr($product->name, 0, 2)) }}</div>
                                @endif
                                <div class="product-item-info">
                                    <div class="product-item-name">{{ $product->name }}</div>
                                    <div class="product-item-meta">
                                        <span class="product-item-sku">{{ $product->sku }}</span>
                                        @if($product->is_batch_managed)<span class="product-item-badge batch">Batch</span>@endif
                                        @if($hasRealVariants)<span class="product-item-badge variant">{{ count($variationsData) }} Variants</span>@endif
                                    </div>
                                </div>
                                <div class="product-item-stock">
                                    <div class="product-item-stock-value">{{ number_format($totalStock, 0) }}</div>
                                    <div class="product-item-stock-label">Available</div>
                                </div>
                            </div>
                            @endforeach
                            <div class="product-no-results" id="noProductsMsg">No products found</div>
                        </div>
                    </div>
                    
                    <!-- Selected Product Display -->
                    <div class="selected-product" id="selectedProduct">
                        <div class="selected-product-header">
                            <div id="selectedProductImage"></div>
                            <div class="selected-product-info">
                                <div class="selected-product-name" id="selectedProductName"></div>
                                <div class="selected-product-sku" id="selectedProductSku"></div>
                                <div class="selected-product-badges" id="selectedProductBadges"></div>
                            </div>
                            <button type="button" class="selected-product-clear" onclick="clearProduct()">
                                <svg width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/></svg>
                            </button>
                        </div>
                        
                        <!-- Variation Selection -->
                        <div class="variation-section" id="variationSection">
                            <div class="variation-section-title">🎨 Select Variation: <span class="required">*</span></div>
                            <div class="variation-grid" id="variationGrid"></div>
                        </div>
                        
                        <!-- Price Display -->
                        <div class="selected-product-prices">
                            <div class="price-box">
                                <div class="price-box-label">Available</div>
                                <div class="price-box-value" id="priceStock">0</div>
                                <div class="price-box-source" id="priceStockUnit">PCS</div>
                            </div>
                            <div class="price-box">
                                <div class="price-box-label">Sale Price</div>
                                <div class="price-box-value" id="priceSale">₹0</div>
                                <div class="price-box-source" id="priceSaleSource">Product</div>
                            </div>
                            <div class="price-box">
                                <div class="price-box-label">MRP</div>
                                <div class="price-box-value" id="priceMrp">₹0</div>
                            </div>
                            <div class="price-box">
                                <div class="price-box-label">Unit</div>
                                <div class="price-box-value" id="priceUnit">PCS</div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Lot Section - FEFO Selection -->
                    <div class="lot-section" id="lotSection">
                        <div class="lot-section-header">
                            <div class="lot-section-title">🏷️ Select Lot (FEFO - First Expiry First Out)</div>
                            <div class="lot-section-hint">⭐ Lots sorted by expiry date</div>
                        </div>
                        <div class="lot-list" id="lotList"></div>
                        <input type="hidden" name="lot_id" id="lot_id">
                    </div>
                    
                    <!-- Selected Lot Display -->
                    <div class="selected-lot" id="selectedLot">
                        <div class="selected-lot-icon">🏷️</div>
                        <div class="selected-lot-info">
                            <div class="selected-lot-no" id="selectedLotNo"></div>
                            <div class="selected-lot-meta" id="selectedLotMeta"></div>
                        </div>
                        <div class="selected-lot-prices">
                            <div class="selected-lot-price">
                                <div class="selected-lot-price-value" id="selectedLotStock">0</div>
                                <div class="selected-lot-price-label">Available</div>
                            </div>
                            <div class="selected-lot-price">
                                <div class="selected-lot-price-value" id="selectedLotSale">₹0</div>
                                <div class="selected-lot-price-label">Sale</div>
                            </div>
                        </div>
                        <button type="button" class="selected-lot-clear" onclick="clearLot()">
                            <svg width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/></svg>
                        </button>
                    </div>
                </div>
                
                <!-- Location Section -->
                <div class="form-section">
                    <div class="form-section-title">📍 Source Location</div>
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Warehouse <span class="required">*</span></label>
                            <select name="warehouse_id" id="warehouse_id" class="form-control" required>
                                <option value="">Select warehouse...</option>
                                @foreach($warehouses as $wh)
                                    <option value="{{ $wh->id }}" {{ $wh->is_default ? 'selected' : '' }}>{{ $wh->name }} {{ $wh->is_default ? '(Default)' : '' }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Rack / Location</label>
                            <select name="rack_id" id="rack_id" class="form-control">
                                <option value="">Any rack...</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="stock-warning" id="stockWarning">
                        <div class="stock-warning-icon">⚠️</div>
                        <div class="stock-warning-text">Available stock at this location: <span class="stock-warning-value" id="stockWarningValue">0</span></div>
                    </div>
                </div>
                
                <!-- Quantity Section -->
                <div class="form-section">
                    <div class="form-section-title">🔢 Quantity & Reference</div>
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Quantity <span class="required">*</span></label>
                            <input type="number" name="qty" id="qty" class="form-control" step="any" min="0.001" placeholder="Enter quantity to deliver" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Unit <span class="required">*</span></label>
                            <select name="unit_id" id="unit_id" class="form-control" required>
                                <option value="">Select unit...</option>
                                @foreach($units as $u)<option value="{{ $u->id }}">{{ $u->name }} ({{ $u->short_name }})</option>@endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Reference Type</label>
                            <select name="reference_type" class="form-control">
                                <option value="SALE">Sale / Order</option>
                                <option value="ISSUE">Internal Issue</option>
                                <option value="DAMAGE">Damage / Wastage</option>
                                <option value="OTHER">Other</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Reference Number</label>
                            <input type="text" name="reference_no" class="form-control" placeholder="Order/Invoice number...">
                        </div>
                    </div>
                </div>
                
                <!-- Notes -->
                <div class="form-section">
                    <div class="form-group">
                        <label class="form-label">Reason / Notes</label>
                        <textarea name="notes" class="form-control" placeholder="Reason for delivery..."></textarea>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">📤 Deliver Stock</button>
                    <a href="{{ route('inventory.stock.movements') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
var selectedProduct = null;
var selectedVariation = null;
var productVariations = [];
var productLots = [];
var selectedLot = null;
var productDefaults = { purchase: 0, sale: 0, mrp: 0 };
var availableStock = 0;
var requiresVariation = false;

document.addEventListener('DOMContentLoaded', function() {
    var searchInput = document.getElementById('productSearch');
    var dropdown = document.getElementById('productDropdown');
    var productItems = dropdown.querySelectorAll('.product-item');
    var noProductsMsg = document.getElementById('noProductsMsg');
    
    searchInput.addEventListener('focus', function() { 
        if (!selectedProduct) dropdown.classList.add('show'); 
        // Auto-select preselected product from URL
    @if(isset($preselectedProduct) && $preselectedProduct)
    (function() {
        var preselectedId = '{{ $preselectedProduct->id }}';
        var productItem = document.querySelector('.product-item[data-id="' + preselectedId + '"]');
        if (productItem) {
            selectProduct(productItem);
        }
    })();
    @endif
    });
    
    searchInput.addEventListener('input', function() {
        var query = this.value.toLowerCase().trim();
        var hasVisible = false;
        productItems.forEach(function(item) {
            var name = item.dataset.name.toLowerCase();
            var sku = item.dataset.sku.toLowerCase();
            var barcode = (item.dataset.barcode || '').toLowerCase();
            var match = name.indexOf(query) !== -1 || sku.indexOf(query) !== -1 || barcode.indexOf(query) !== -1;
            item.style.display = match ? 'flex' : 'none';
            if (match) hasVisible = true;
        });
        noProductsMsg.style.display = hasVisible ? 'none' : 'block';
        dropdown.classList.add('show');
    });
    
    document.addEventListener('click', function(e) { 
        if (!e.target.closest('.product-search-box')) dropdown.classList.remove('show'); 
    });
    
    productItems.forEach(function(item) { 
        item.addEventListener('click', function() { selectProduct(this); }); 
    });
    
    document.getElementById('warehouse_id').addEventListener('change', function() { 
        loadRacks(this.value); 
        checkStock(); 
    });
    document.getElementById('rack_id').addEventListener('change', checkStock);
    
    // Form validation
    document.getElementById('deliverForm').addEventListener('submit', function(e) {
        if (requiresVariation && !selectedVariation) {
            e.preventDefault();
            alert('Please select a variation for this product.');
            return false;
        }
    });
    
    var initWh = document.getElementById('warehouse_id').value;
    if (initWh) loadRacks(initWh);
});

function selectProduct(item) {
    selectedProduct = {
        id: item.dataset.id,
        name: item.dataset.name,
        sku: item.dataset.sku,
        image: item.dataset.image,
        unit: item.dataset.unit,
        unitId: item.dataset.unitId,
        purchase: parseFloat(item.dataset.purchase) || 0,
        sale: parseFloat(item.dataset.sale) || 0,
        mrp: parseFloat(item.dataset.mrp) || 0,
        isBatch: item.dataset.batch === '1',
        hasVariants: item.dataset.variants === '1',
        stock: parseFloat(item.dataset.stock) || 0
    };
    productDefaults = { purchase: selectedProduct.purchase, sale: selectedProduct.sale, mrp: selectedProduct.mrp };
    
    // Parse variations safely - decode base64 first
    try {
        var variationsBase64 = item.dataset.variations || '';
        console.log('Variations base64 length:', variationsBase64.length);
        if (variationsBase64) {
            productVariations = JSON.parse(atob(variationsBase64));
            console.log('Parsed variations count:', productVariations.length);
        } else {
            productVariations = [];
        }
    } catch(e) {
        console.error('Error parsing variations:', e);
        productVariations = [];
        
        // If base64 fails and product has variants, load via AJAX
        if (selectedProduct.hasVariants) {
            loadVariationsViaAjax(selectedProduct.id);
        }
    }
    
    requiresVariation = productVariations.length > 0;
    console.log('requiresVariation:', requiresVariation, 'hasVariants:', selectedProduct.hasVariants);
    
    document.getElementById('product_id').value = selectedProduct.id;
    document.getElementById('variation_id').value = '';
    selectedVariation = null;
    
    document.getElementById('productSearch').style.display = 'none';
    document.getElementById('productDropdown').classList.remove('show');
    document.getElementById('selectedProduct').classList.add('show');
    
    var imgContainer = document.getElementById('selectedProductImage');
    if (selectedProduct.image) {
        imgContainer.innerHTML = '<img src="' + selectedProduct.image + '" class="selected-product-image" alt="">';
    } else {
        imgContainer.innerHTML = '<div class="selected-product-placeholder">' + selectedProduct.name.substring(0, 2).toUpperCase() + '</div>';
    }
    
    document.getElementById('selectedProductName').textContent = selectedProduct.name;
    document.getElementById('selectedProductSku').textContent = selectedProduct.sku;
    
    var badges = '<span class="selected-product-badge stock">📦 ' + selectedProduct.stock + ' ' + selectedProduct.unit + ' available</span>';
    if (selectedProduct.isBatch) badges += '<span class="selected-product-badge batch">🏷️ Batch</span>';
    if (requiresVariation || selectedProduct.hasVariants) badges += '<span class="selected-product-badge variant">🎨 ' + (productVariations.length || '...') + ' Variants</span>';
    document.getElementById('selectedProductBadges').innerHTML = badges;
    
    document.getElementById('priceStock').textContent = selectedProduct.stock;
    document.getElementById('priceStockUnit').textContent = selectedProduct.unit;
    document.getElementById('priceSale').textContent = '₹' + selectedProduct.sale.toFixed(2);
    document.getElementById('priceMrp').textContent = '₹' + selectedProduct.mrp.toFixed(2);
    document.getElementById('priceUnit').textContent = selectedProduct.unit;
    
    if (requiresVariation) {
        showVariations();
    } else if (selectedProduct.hasVariants) {
        // Product has variants flag but no parsed variations - try AJAX
        loadVariationsViaAjax(selectedProduct.id);
    } else {
        document.getElementById('variationSection').classList.remove('show');
    }
    
    if (selectedProduct.isBatch) { 
        document.getElementById('lotSection').classList.add('show'); 
        loadLots(); 
    } else {
        document.getElementById('lotSection').classList.remove('show');
    }
    
    loadUnits(selectedProduct.id);
    checkStock();
}

// AJAX fallback to load variations
function loadVariationsViaAjax(productId) {
    fetch('{{ url("admin/inventory/products") }}/' + productId + '/variations')
        .then(function(r) { return r.json(); })
        .then(function(data) {
            console.log('AJAX loaded variations:', data);
            
            if (data.success && data.variations) {
                productVariations = data.variations.map(function(v) {
                    var name = v.variation_name;
                    if (!name && v.attributes && v.attributes.length > 0) {
                        name = v.attributes.map(function(a) { return a.value; }).join(' / ');
                    }
                    if (!name) name = v.sku;
                    
                    var color = null;
                    if (v.attributes && v.attributes.length > 0) {
                        v.attributes.forEach(function(a) {
                            if (a.color_code) color = a.color_code;
                        });
                    }
                    
                    return {
                        id: v.id,
                        sku: v.sku,
                        name: name,
                        stock: v.stock_qty || 0,
                        purchase_price: v.purchase_price,
                        sale_price: v.sale_price,
                        effective_sale: v.sale_price || productDefaults.sale,
                        image: v.image_url,
                        color: color
                    };
                });
                
                requiresVariation = productVariations.length > 0;
                
                var badges = '<span class="selected-product-badge stock">📦 ' + selectedProduct.stock + ' ' + selectedProduct.unit + ' available</span>';
                if (selectedProduct.isBatch) badges += '<span class="selected-product-badge batch">🏷️ Batch</span>';
                if (requiresVariation) badges += '<span class="selected-product-badge variant">🎨 ' + productVariations.length + ' Variants</span>';
                document.getElementById('selectedProductBadges').innerHTML = badges;
                
                if (requiresVariation) {
                    showVariations();
                }
            }
        })
        .catch(function(e) {
            console.error('AJAX variation load failed:', e);
        });
}

function showVariations() {
    var grid = document.getElementById('variationGrid');
    grid.innerHTML = '';
    
    productVariations.forEach(function(v) {
        var chip = document.createElement('div');
        chip.className = 'variation-chip';
        chip.dataset.id = v.id;
        
        var content = '';
        
        // Image or color indicator
        if (v.image) {
            content += '<img src="' + v.image + '" class="variation-chip-image" alt="">';
        } else if (v.color) {
            content += '<span class="variation-chip-color" style="background:' + v.color + '"></span>';
        }
        
        // Variation name
        content += '<span class="variation-chip-name">' + v.name + '</span>';
        
        // Stock count
        content += '<span class="variation-chip-stock' + (v.stock < 10 ? ' low' : '') + '">' + v.stock + ' avail</span>';
        
        // Show sale price
        var effectiveSale = parseFloat(v.effective_sale) || 0;
        if (effectiveSale > 0) {
            content += '<span class="variation-chip-price">₹' + effectiveSale.toFixed(0) + '</span>';
        }
        
        chip.innerHTML = content;
        chip.addEventListener('click', function() { selectVariation(v, this); });
        grid.appendChild(chip);
    });
    
    document.getElementById('variationSection').classList.add('show');
}

function selectVariation(v, chipEl) {
    document.querySelectorAll('.variation-chip').forEach(function(c) { c.classList.remove('selected'); });
    chipEl.classList.add('selected');
    selectedVariation = v;
    document.getElementById('variation_id').value = v.id;
    
    // Update stock display
    document.getElementById('priceStock').textContent = v.stock;
    
    // Use effective prices
    var sale = parseFloat(v.effective_sale) || selectedProduct.sale;
    var mrp = parseFloat(v.effective_mrp) || selectedProduct.mrp;
    
    // Determine price source
    var saleSource = (v.sale_price !== null && v.sale_price !== '') ? 'Variation' : 'Product';
    
    document.getElementById('priceSale').textContent = '₹' + sale.toFixed(2);
    document.getElementById('priceMrp').textContent = '₹' + mrp.toFixed(2);
    document.getElementById('priceSaleSource').textContent = saleSource;
    document.getElementById('selectedProductSku').textContent = v.sku;
    
    if (v.image) {
        document.getElementById('selectedProductImage').innerHTML = '<img src="' + v.image + '" class="selected-product-image" alt="">';
    }
    
    if (selectedProduct.isBatch) loadLots();
    checkStock();
}

function clearProduct() {
    selectedProduct = null;
    selectedVariation = null;
    productVariations = [];
    selectedLot = null;
    requiresVariation = false;
    
    document.getElementById('product_id').value = '';
    document.getElementById('variation_id').value = '';
    document.getElementById('lot_id').value = '';
    document.getElementById('productSearch').style.display = 'block';
    document.getElementById('productSearch').value = '';
    document.getElementById('selectedProduct').classList.remove('show');
    document.getElementById('lotSection').classList.remove('show');
    document.getElementById('selectedLot').classList.remove('show');
    document.getElementById('stockWarning').classList.remove('show');
    
    document.querySelectorAll('.product-item').forEach(function(i) { i.style.display = 'flex'; });
}

function loadLots() {
    var productId = selectedProduct.id;
    var variationId = selectedVariation ? selectedVariation.id : '';
    var warehouseId = document.getElementById('warehouse_id').value;
    
    var url = '{{ url("admin/inventory/lots/with-stock") }}/' + productId + '?fefo=1';
    if (variationId) url += '&variation_id=' + variationId;
    if (warehouseId) url += '&warehouse_id=' + warehouseId;
    
    fetch(url)
        .then(function(r) { return r.json(); })
        .then(function(data) { 
            productLots = Array.isArray(data) ? data : (data.lots || []); 
            renderLots(); 
        })
        .catch(function() { productLots = []; renderLots(); });
}

function renderLots() {
    var list = document.getElementById('lotList');
    list.innerHTML = '';
    
    if (productLots.length === 0) { 
        list.innerHTML = '<div class="lot-no-items">No lots with available stock</div>'; 
        return; 
    }
    
    // Get variation price for fallback
    var variationSale = selectedVariation ? (parseFloat(selectedVariation.effective_sale) || productDefaults.sale) : productDefaults.sale;
    
    productLots.forEach(function(lot, index) {
        var expStatus = getExpiryStatus(lot.expiry_date);
        var item = document.createElement('div');
        item.className = 'lot-item' + (index === 0 ? ' recommended' : '');
        item.dataset.id = lot.id;
        
        var daysText = expStatus.days !== null 
            ? (expStatus.days <= 0 ? 'EXPIRED' : expStatus.days + ' days') 
            : 'No expiry';
        
        // Price hierarchy: Lot > Variation > Product
        var displaySale = parseFloat(lot.sale_price) || variationSale;
        var priceSource = lot.sale_price ? 'Lot' : (selectedVariation && selectedVariation.sale_price ? 'Var' : '');
        
        item.innerHTML = 
            '<div class="lot-item-icon ' + expStatus.cls + '">🏷️</div>' +
            '<div class="lot-item-info"><div class="lot-item-header"><span class="lot-item-no">' + lot.lot_no + '</span>' +
            (lot.batch_no ? '<span class="lot-item-batch">' + lot.batch_no + '</span>' : '') +
            '<span class="lot-item-expiry ' + expStatus.cls + '">' + daysText + '</span></div>' +
            '<div class="lot-item-meta">' + 
            (lot.manufacturing_date ? '<span>📅 Mfg: ' + lot.manufacturing_date + '</span>' : '') +
            (lot.expiry_date ? '<span>⏰ Exp: ' + lot.expiry_date + '</span>' : '') + 
            '</div></div>' +
            '<div class="lot-item-prices"><div class="lot-item-stock">' + (lot.available_stock || lot.current_stock || 0) + ' avail</div>' +
            '<div class="lot-item-price">₹' + displaySale.toFixed(2) + '</div>' +
            '<div class="lot-item-price-label">Sale' + (priceSource ? ' (' + priceSource + ')' : '') + '</div></div>';
        
        item.addEventListener('click', function() { selectLot(lot, this); });
        list.appendChild(item);
    });
}

function getExpiryStatus(expiryDate) {
    if (!expiryDate) return { cls: 'ok', days: null };
    var today = new Date(); 
    today.setHours(0, 0, 0, 0);
    var exp = new Date(expiryDate);
    var diff = Math.ceil((exp - today) / (1000 * 60 * 60 * 24));
    if (diff <= 0) return { cls: 'bad', days: diff };
    if (diff <= 30) return { cls: 'warn', days: diff };
    return { cls: 'ok', days: diff };
}

function selectLot(lot, itemEl) {
    document.querySelectorAll('.lot-item').forEach(function(i) { i.classList.remove('selected'); });
    itemEl.classList.add('selected');
    selectedLot = lot;
    document.getElementById('lot_id').value = lot.id;
    
    document.getElementById('selectedLotNo').textContent = lot.lot_no + (lot.batch_no ? ' / ' + lot.batch_no : '');
    
    var meta = [];
    if (lot.manufacturing_date) meta.push('📅 Mfg: ' + lot.manufacturing_date);
    if (lot.expiry_date) meta.push('⏰ Exp: ' + lot.expiry_date);
    document.getElementById('selectedLotMeta').innerHTML = meta.map(function(m) { return '<span>' + m + '</span>'; }).join('');
    
    // Price hierarchy: Lot > Variation > Product
    var variationSale = selectedVariation ? (parseFloat(selectedVariation.effective_sale) || productDefaults.sale) : productDefaults.sale;
    var variationMrp = selectedVariation ? (parseFloat(selectedVariation.effective_mrp) || productDefaults.mrp) : productDefaults.mrp;
    
    var sale = parseFloat(lot.sale_price) || variationSale;
    var mrp = variationMrp;
    
    // Determine price source
    var source = 'Product';
    if (lot.sale_price) {
        source = 'Lot';
    } else if (selectedVariation && selectedVariation.sale_price) {
        source = 'Variation';
    }
    
    document.getElementById('selectedLotStock').textContent = (lot.available_stock || lot.current_stock || 0);
    document.getElementById('selectedLotSale').textContent = '₹' + sale.toFixed(2);
    
    // Update main price display
    document.getElementById('priceSale').textContent = '₹' + sale.toFixed(2);
    document.getElementById('priceSaleSource').textContent = source;
    document.getElementById('priceMrp').textContent = '₹' + mrp.toFixed(2);
    
    document.getElementById('selectedLot').classList.add('show');
    document.getElementById('lotSection').classList.remove('show');
}

function clearLot() {
    selectedLot = null;
    document.getElementById('lot_id').value = '';
    document.querySelectorAll('.lot-item').forEach(function(i) { i.classList.remove('selected'); });
    document.getElementById('selectedLot').classList.remove('show');
    document.getElementById('lotSection').classList.add('show');
    
    // Restore variation or product price
    if (selectedVariation) {
        var sale = parseFloat(selectedVariation.effective_sale) || productDefaults.sale;
        var mrp = parseFloat(selectedVariation.effective_mrp) || productDefaults.mrp;
        var source = selectedVariation.sale_price ? 'Variation' : 'Product';
        document.getElementById('priceSale').textContent = '₹' + sale.toFixed(2);
        document.getElementById('priceSaleSource').textContent = source;
        document.getElementById('priceMrp').textContent = '₹' + mrp.toFixed(2);
    } else if (selectedProduct) {
        document.getElementById('priceSale').textContent = '₹' + productDefaults.sale.toFixed(2);
        document.getElementById('priceSaleSource').textContent = 'Product';
        document.getElementById('priceMrp').textContent = '₹' + productDefaults.mrp.toFixed(2);
    }
}

var loadingRacks = false;
function loadRacks(warehouseId) {
    if (loadingRacks) return;
    var rackSelect = document.getElementById('rack_id');
    rackSelect.innerHTML = '<option value="">Any rack...</option>';
    if (!warehouseId) return;
    
    loadingRacks = true;
    fetch('{{ url("admin/inventory/racks/by-warehouse") }}/' + warehouseId)
        .then(function(r) { return r.json(); })
        .then(function(racks) {
            rackSelect.innerHTML = '<option value="">Any rack...</option>';
            racks.forEach(function(r) {
                var opt = new Option(r.code + ' - ' + r.name + ' (' + (r.current_stock || 0) + ' items)', r.id);
                rackSelect.add(opt);
            });
            loadingRacks = false;
        })
        .catch(function() { loadingRacks = false; });
}

function checkStock() {
    var productId = document.getElementById('product_id').value;
    var warehouseId = document.getElementById('warehouse_id').value;
    var variationId = document.getElementById('variation_id').value;
    var rackId = document.getElementById('rack_id').value;
    
    if (!productId || !warehouseId) { 
        document.getElementById('stockWarning').classList.remove('show'); 
        return; 
    }
    
    var url = '{{ route("inventory.stock.check") }}?product_id=' + productId + '&warehouse_id=' + warehouseId;
    if (variationId) url += '&variation_id=' + variationId;
    if (rackId) url += '&rack_id=' + rackId;
    
    fetch(url)
        .then(function(r) { return r.json(); })
        .then(function(data) {
            availableStock = data.base_stock || 0;
            document.getElementById('stockWarningValue').textContent = availableStock + ' ' + (data.base_unit || 'PCS');
            document.getElementById('stockWarning').classList.add('show');
            
            if (selectedProduct && selectedProduct.isBatch) loadLots();
        })
        .catch(function() {});
}

function loadUnits(productId) {
    fetch('{{ url("admin/inventory/stock/product-units") }}?product_id=' + productId)
        .then(function(r) { return r.json(); })
        .then(function(data) {
            var unitSelect = document.getElementById('unit_id');
            unitSelect.innerHTML = '<option value="">Select unit...</option>';
            (data.units || []).forEach(function(u) {
                var label = u.name;
                if (u.is_base) label += ' (Base)';
                else if (u.conversion_factor != 1) label += ' (=' + u.conversion_factor + ' ' + data.base_unit_name + ')';
                unitSelect.add(new Option(label, u.id));
            });
            if (data.base_unit_id) unitSelect.value = data.base_unit_id;
        })
        .catch(function() {});
}
</script>
