{{-- Stock Transfer - Fixed: No arrow functions, handles products with has_variants but no variations --}}

<style>
    .page-container { padding: 20px; max-width: 1000px; margin: 0 auto; }
    
    .page-header { display: flex; align-items: center; gap: 16px; margin-bottom: 24px; }
    .back-btn { width: 44px; height: 44px; border-radius: 12px; display: flex; align-items: center; justify-content: center; background: var(--card-bg); border: 1px solid var(--card-border); color: var(--text-muted); text-decoration: none; transition: all 0.2s; flex-shrink: 0; }
    .back-btn:hover { background: var(--body-bg); color: var(--text-primary); }
    .page-title { font-size: 24px; font-weight: 700; color: var(--text-primary); display: flex; align-items: center; gap: 12px; }
    .page-title-icon { width: 48px; height: 48px; border-radius: 12px; background: linear-gradient(135deg, #2563eb, #1d4ed8); display: flex; align-items: center; justify-content: center; color: #fff; font-size: 22px; }
    
    .form-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 16px; overflow: hidden; }
    .form-card-header { padding: 20px 24px; background: linear-gradient(135deg, #dbeafe, #93c5fd); border-bottom: 1px solid #93c5fd; }
    .form-card-title { font-size: 16px; font-weight: 700; color: #1e40af; margin: 0; }
    .form-card-body { padding: 24px; }
    
    .form-section { margin-bottom: 28px; padding-bottom: 28px; border-bottom: 1px solid var(--card-border); }
    .form-section:last-child { margin-bottom: 0; padding-bottom: 0; border-bottom: none; }
    .form-section-title { font-size: 13px; font-weight: 700; color: #2563eb; text-transform: uppercase; letter-spacing: 0.5px; margin-bottom: 16px; }
    
    .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; }
    @media (max-width: 640px) { .form-row { grid-template-columns: 1fr; } }
    
    .form-group { margin-bottom: 16px; }
    .form-group:last-child { margin-bottom: 0; }
    .form-label { display: block; font-size: 13px; font-weight: 600; color: var(--text-primary); margin-bottom: 8px; }
    .form-label .required { color: #ef4444; }
    
    .form-control { width: 100%; padding: 12px 14px; border: 2px solid var(--card-border); border-radius: 10px; font-size: 14px; background: var(--card-bg); color: var(--text-primary); transition: all 0.2s; box-sizing: border-box; }
    .form-control:focus { outline: none; border-color: #2563eb; box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.15); }
    textarea.form-control { min-height: 80px; resize: vertical; }
    
    /* Product Search */
    .product-search-box { position: relative; }
    .product-search-input { width: 100%; padding: 14px 16px 14px 48px; border: 2px solid var(--card-border); border-radius: 12px; font-size: 15px; background: var(--card-bg); color: var(--text-primary); box-sizing: border-box; }
    .product-search-input:focus { outline: none; border-color: #2563eb; box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.15); }
    .product-search-icon { position: absolute; left: 16px; top: 50%; transform: translateY(-50%); color: var(--text-muted); pointer-events: none; }
    
    .product-dropdown { position: absolute; top: 100%; left: 0; right: 0; background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; box-shadow: 0 10px 40px rgba(0,0,0,0.15); margin-top: 4px; max-height: 300px; overflow-y: auto; z-index: 100; display: none; }
    .product-dropdown.show { display: block; }
    
    .product-item { display: flex; align-items: center; gap: 14px; padding: 12px 16px; cursor: pointer; border-bottom: 1px solid var(--card-border); transition: background 0.15s; }
    .product-item:last-child { border-bottom: none; }
    .product-item:hover { background: #dbeafe; }
    
    .product-item-image { width: 50px; height: 50px; border-radius: 10px; object-fit: cover; background: var(--body-bg); border: 1px solid var(--card-border); flex-shrink: 0; }
    .product-item-placeholder { width: 50px; height: 50px; border-radius: 10px; background: linear-gradient(135deg, #dbeafe, #93c5fd); display: flex; align-items: center; justify-content: center; color: #2563eb; font-weight: 700; font-size: 14px; flex-shrink: 0; }
    
    .product-item-info { flex: 1; min-width: 0; }
    .product-item-name { font-weight: 600; color: var(--text-primary); font-size: 14px; margin-bottom: 2px; }
    .product-item-meta { display: flex; align-items: center; gap: 8px; font-size: 11px; color: var(--text-muted); }
    .product-item-sku { font-family: monospace; background: var(--body-bg); padding: 2px 6px; border-radius: 4px; }
    
    .product-item-stock { text-align: right; flex-shrink: 0; }
    .product-item-stock-value { font-size: 16px; font-weight: 700; color: #2563eb; }
    .product-item-stock-label { font-size: 10px; color: var(--text-muted); }
    
    .product-no-results { text-align: center; padding: 20px; color: var(--text-muted); font-size: 13px; display: none; }
    
    /* Selected Product Card */
    .selected-product { display: none; background: #dbeafe; border: 2px solid #93c5fd; border-radius: 14px; padding: 18px; margin-top: 16px; }
    .selected-product.show { display: block; }
    
    .selected-product-header { display: flex; align-items: flex-start; gap: 16px; }
    .selected-product-image { width: 70px; height: 70px; border-radius: 12px; object-fit: cover; background: #fff; border: 2px solid #93c5fd; flex-shrink: 0; }
    .selected-product-placeholder { width: 70px; height: 70px; border-radius: 12px; background: linear-gradient(135deg, #fff, #93c5fd); display: flex; align-items: center; justify-content: center; color: #2563eb; font-weight: 700; font-size: 22px; flex-shrink: 0; }
    
    .selected-product-info { flex: 1; }
    .selected-product-name { font-size: 17px; font-weight: 700; color: #1e40af; margin-bottom: 4px; }
    .selected-product-sku { font-size: 12px; color: #2563eb; font-family: monospace; background: #fff; padding: 4px 10px; border-radius: 6px; display: inline-block; }
    .selected-product-badges { display: flex; gap: 8px; margin-top: 8px; flex-wrap: wrap; }
    .selected-product-badge { padding: 4px 10px; border-radius: 12px; font-size: 11px; font-weight: 600; background: #fff; color: #1e40af; }
    .selected-product-badge.variant { background: #ede9fe; color: #6d28d9; }
    .variation-chip-price { font-size: 11px; font-weight: 600; color: #2563eb; margin-left: 4px; background: #dbeafe; padding: 2px 6px; border-radius: 4px; }
    
    .selected-product-clear { padding: 8px; border: none; background: transparent; color: #1e40af; cursor: pointer; border-radius: 8px; transition: background 0.15s; }
    .selected-product-clear:hover { background: #93c5fd; }
    
    /* Variation Selection */
    .variation-section { display: none; margin-top: 14px; padding-top: 14px; border-top: 2px dashed #93c5fd; }
    .variation-section.show { display: block; }
    .variation-section-title { font-size: 12px; font-weight: 600; color: #1e40af; margin-bottom: 10px; }
    
    .variation-grid { display: flex; flex-wrap: wrap; gap: 8px; }
    .variation-chip { display: flex; align-items: center; gap: 6px; padding: 8px 12px; background: #fff; border: 2px solid #d1d5db; border-radius: 8px; cursor: pointer; transition: all 0.15s; font-size: 12px; }
    .variation-chip:hover { border-color: #2563eb; }
    .variation-chip.selected { border-color: #2563eb; background: #dbeafe; }
    .variation-chip-color { width: 16px; height: 16px; border-radius: 50%; border: 2px solid rgba(0,0,0,0.1); }
    .variation-chip-image { width: 24px; height: 24px; border-radius: 4px; object-fit: cover; }
    .variation-chip-name { font-weight: 500; color: var(--text-primary); }
    .variation-chip-stock { font-size: 10px; color: var(--text-muted); }
    .variation-chip-price { font-size: 10px; font-weight: 600; color: #2563eb; background: #dbeafe; padding: 2px 6px; border-radius: 4px; margin-left: 4px; }
    
    /* Transfer Locations Grid */
    .transfer-grid { display: grid; grid-template-columns: 1fr auto 1fr; gap: 16px; align-items: start; }
    @media (max-width: 768px) { .transfer-grid { grid-template-columns: 1fr; } }
    
    .transfer-arrow { display: flex; align-items: center; justify-content: center; padding-top: 60px; }
    .transfer-arrow svg { width: 32px; height: 32px; color: #2563eb; }
    @media (max-width: 768px) { .transfer-arrow { padding: 10px 0; transform: rotate(90deg); } }
    
    .location-box { background: var(--body-bg); border: 2px solid var(--card-border); border-radius: 14px; padding: 16px; }
    .location-box.from { border-color: #fecaca; background: #fef2f2; }
    .location-box.to { border-color: #86efac; background: #f0fdf4; }
    
    .location-box-title { font-size: 13px; font-weight: 700; margin-bottom: 12px; display: flex; align-items: center; gap: 8px; }
    .location-box-title.from { color: #991b1b; }
    .location-box-title.to { color: #166534; }
    
    /* Rack Visual Grid */
    .rack-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(90px, 1fr)); gap: 8px; max-height: 200px; overflow-y: auto; margin-top: 10px; }
    
    .rack-item { background: #fff; border: 2px solid var(--card-border); border-radius: 8px; padding: 10px; cursor: pointer; transition: all 0.15s; text-align: center; }
    .rack-item:hover { border-color: #2563eb; transform: translateY(-2px); }
    .rack-item.selected { border-color: #2563eb; background: #dbeafe; }
    .rack-item.selected.from { border-color: #dc2626; background: #fee2e2; }
    .rack-item.selected.to { border-color: #16a34a; background: #dcfce7; }
    
    .rack-item-code { font-weight: 700; font-size: 12px; color: var(--text-primary); margin-bottom: 6px; }
    
    .rack-capacity-bar { height: 6px; background: #e5e7eb; border-radius: 3px; overflow: hidden; margin-bottom: 4px; }
    .rack-capacity-fill { height: 100%; border-radius: 3px; }
    .rack-capacity-fill.low { background: linear-gradient(90deg, #22c55e, #4ade80); }
    .rack-capacity-fill.medium { background: linear-gradient(90deg, #eab308, #facc15); }
    .rack-capacity-fill.high { background: linear-gradient(90deg, #f97316, #fb923c); }
    .rack-capacity-fill.full { background: linear-gradient(90deg, #ef4444, #f87171); }
    
    .rack-capacity-text { font-size: 9px; color: var(--text-muted); }
    
    .rack-no-items { text-align: center; padding: 16px; color: var(--text-muted); font-size: 12px; }
    
    /* Stock Summary */
    .stock-summary { display: none; grid-template-columns: 1fr auto 1fr; gap: 16px; margin-top: 16px; padding: 16px; background: var(--body-bg); border-radius: 12px; }
    .stock-summary.show { display: grid; }
    @media (max-width: 640px) { .stock-summary { grid-template-columns: 1fr; text-align: center; } }
    
    .stock-summary-box { text-align: center; }
    .stock-summary-label { font-size: 11px; color: var(--text-muted); text-transform: uppercase; margin-bottom: 4px; }
    .stock-summary-value { font-size: 22px; font-weight: 700; }
    .stock-summary-value.from { color: #dc2626; }
    .stock-summary-value.to { color: #16a34a; }
    .stock-summary-arrow { display: flex; align-items: center; justify-content: center; font-size: 24px; color: #2563eb; }
    
    /* Form Actions */
    .form-actions { display: flex; gap: 12px; padding-top: 24px; border-top: 1px solid var(--card-border); margin-top: 24px; }
    .btn { display: inline-flex; align-items: center; justify-content: center; gap: 8px; padding: 14px 28px; border-radius: 10px; font-size: 14px; font-weight: 600; cursor: pointer; border: none; text-decoration: none; transition: all 0.2s; }
    .btn-primary { background: linear-gradient(135deg, #2563eb, #1d4ed8); color: #fff; }
    .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 6px 20px rgba(37, 99, 235, 0.3); }
    .btn-secondary { background: var(--body-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
    .btn-secondary:hover { background: var(--card-border); }
    
    .alert { padding: 14px 18px; border-radius: 10px; margin-bottom: 20px; font-size: 14px; }
    .alert-success { background: #d1fae5; color: #065f46; border: 1px solid #a7f3d0; }
    .alert-error { background: #fee2e2; color: #991b1b; border: 1px solid #fecaca; }
</style>

<div class="page-container">
    <div class="page-header">
        <a href="{{ route('inventory.stock.movements') }}" class="back-btn">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/></svg>
        </a>
        <div class="page-title">
            <div class="page-title-icon">🔄</div>
            <span>Transfer Stock</span>
        </div>
    </div>
    
    @if(session('success'))<div class="alert alert-success">{{ session('success') }}</div>@endif
    @if(session('error'))<div class="alert alert-error">{{ session('error') }}</div>@endif
    
    <div class="form-card">
        <div class="form-card-header">
            <h3 class="form-card-title">🔄 Transfer Stock Between Locations</h3>
        </div>
        <div class="form-card-body">
            <form action="{{ route('inventory.stock.transfer.store') }}" method="POST" id="transferForm">
                @csrf
                
                <!-- Product Selection -->
                <div class="form-section">
                    <div class="form-section-title">📦 Select Product</div>
                    
                    <div class="product-search-box">
                        <svg class="product-search-icon" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                        </svg>
                        <input type="text" class="product-search-input" id="productSearch" placeholder="Search product to transfer..." autocomplete="off">
                        <input type="hidden" name="product_id" id="product_id" required>
                        <input type="hidden" name="variation_id" id="variation_id">
                        
                        <div class="product-dropdown" id="productDropdown">
                            @foreach($products as $product)
                            @php
                                $img = $product->images->where('is_primary', true)->first();
                                if(!$img) $img = $product->images->first();
                                $imgUrl = $img ? asset('storage/' . $img->image_path) : null;
                                $totalStock = $product->stockLevels->sum('qty');
                                
                                // Build variations array
                                $variationsData = [];
                                foreach($product->variations as $v) {
                                    $vImg = $v->image_path ? asset('storage/' . $v->image_path) : null;
                                    
                                    // Get color from attribute values
                                    $vColor = null;
                                    if($v->attributeValues && $v->attributeValues->count() > 0) {
                                        $firstAttr = $v->attributeValues->first();
                                        $vColor = $firstAttr ? $firstAttr->color_code : null;
                                    }
                                    
                                    // Get variation name from attribute values if not set
                                    $vName = $v->variation_name;
                                    if (!$vName && $v->attributeValues) {
                                        $parts = [];
                                        foreach($v->attributeValues as $av) {
                                            $parts[] = $av->value;
                                        }
                                        $vName = implode(' / ', $parts);
                                    }
                                    if (!$vName) $vName = $v->sku;
                                    
                                    $variationsData[] = [
                                        'id' => $v->id,
                                        'sku' => $v->sku,
                                        'barcode' => $v->barcode,
                                        'name' => $vName,
                                        'stock' => $v->stockLevels ? $v->stockLevels->sum('qty') : 0,
                                        // Variation's own prices
                                        'purchase_price' => $v->purchase_price,
                                        'sale_price' => $v->sale_price,
                                        'mrp' => $v->mrp,
                                        // Effective prices (fallback to product)
                                        'effective_purchase' => $v->purchase_price ?? $product->purchase_price ?? 0,
                                        'effective_sale' => $v->sale_price ?? $product->sale_price ?? 0,
                                        'effective_mrp' => $v->mrp ?? $product->mrp ?? 0,
                                        'image' => $vImg,
                                        'color' => $vColor
                                    ];
                                }
                                
                                $hasRealVariants = count($variationsData) > 0;
                            @endphp
                            <div class="product-item" 
                                 data-id="{{ $product->id }}" 
                                 data-name="{{ $product->name }}" 
                                 data-sku="{{ $product->sku }}"
                                 data-barcode="{{ $product->barcode }}" 
                                 data-image="{{ $imgUrl }}"
                                 data-unit="{{ $product->unit->short_name ?? 'PCS' }}" 
                                 data-unit-id="{{ $product->unit_id }}"
                                 data-batch="{{ $product->is_batch_managed ? '1' : '0' }}"
                                 data-variants="{{ $hasRealVariants ? '1' : '0' }}" 
                                 data-stock="{{ $totalStock }}"
                                 data-variations="{{ base64_encode(json_encode($variationsData)) }}">
                                @if($imgUrl)
                                    <img src="{{ $imgUrl }}" alt="" class="product-item-image">
                                @else
                                    <div class="product-item-placeholder">{{ strtoupper(substr($product->name, 0, 2)) }}</div>
                                @endif
                                <div class="product-item-info">
                                    <div class="product-item-name">{{ $product->name }}</div>
                                    <div class="product-item-meta">
                                        <span class="product-item-sku">{{ $product->sku }}</span>
                                    </div>
                                </div>
                                <div class="product-item-stock">
                                    <div class="product-item-stock-value">{{ number_format($totalStock, 0) }}</div>
                                    <div class="product-item-stock-label">{{ $product->unit->short_name ?? 'PCS' }}</div>
                                </div>
                            </div>
                            @endforeach
                            <div class="product-no-results" id="noProductsMsg">No products found</div>
                        </div>
                    </div>
                    
                    <div class="selected-product" id="selectedProduct">
                        <div class="selected-product-header">
                            <div id="selectedProductImage"></div>
                            <div class="selected-product-info">
                                <div class="selected-product-name" id="selectedProductName"></div>
                                <div class="selected-product-sku" id="selectedProductSku"></div>
                                <div class="selected-product-badges" id="selectedProductBadges"></div>
                            </div>
                            <button type="button" class="selected-product-clear" onclick="clearProduct()">
                                <svg width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/></svg>
                            </button>
                        </div>
                        
                        <div class="variation-section" id="variationSection">
                            <div class="variation-section-title">🎨 Select Variation: <span style="color:#ef4444">*</span></div>
                            <div class="variation-grid" id="variationGrid"></div>
                        </div>
                    </div>
                </div>
                
                <!-- Transfer Locations -->
                <div class="form-section">
                    <div class="form-section-title">📍 Transfer Locations</div>
                    
                    <div class="transfer-grid">
                        <!-- FROM Location -->
                        <div class="location-box from">
                            <div class="location-box-title from">📤 FROM (Source)</div>
                            <div class="form-group">
                                <label class="form-label">Warehouse <span class="required">*</span></label>
                                <select name="from_warehouse_id" id="from_warehouse_id" class="form-control" required>
                                    <option value="">Select source...</option>
                                    @foreach($warehouses as $wh)
                                        <option value="{{ $wh->id }}" {{ $wh->is_default ? 'selected' : '' }}>{{ $wh->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="rack-grid" id="fromRackGrid"></div>
                            <input type="hidden" name="from_rack_id" id="from_rack_id">
                        </div>
                        
                        <!-- Arrow -->
                        <div class="transfer-arrow">
                            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M14 5l7 7m0 0l-7 7m7-7H3"/>
                            </svg>
                        </div>
                        
                        <!-- TO Location -->
                        <div class="location-box to">
                            <div class="location-box-title to">📥 TO (Destination)</div>
                            <div class="form-group">
                                <label class="form-label">Warehouse <span class="required">*</span></label>
                                <select name="to_warehouse_id" id="to_warehouse_id" class="form-control" required>
                                    <option value="">Select destination...</option>
                                    @foreach($warehouses as $wh)
                                        <option value="{{ $wh->id }}">{{ $wh->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="rack-grid" id="toRackGrid"></div>
                            <input type="hidden" name="to_rack_id" id="to_rack_id">
                        </div>
                    </div>
                    
                    <!-- Stock Summary -->
                    <div class="stock-summary" id="stockSummary">
                        <div class="stock-summary-box">
                            <div class="stock-summary-label">Source Stock</div>
                            <div class="stock-summary-value from" id="fromStockValue">0</div>
                        </div>
                        <div class="stock-summary-arrow">→</div>
                        <div class="stock-summary-box">
                            <div class="stock-summary-label">Destination Stock</div>
                            <div class="stock-summary-value to" id="toStockValue">0</div>
                        </div>
                    </div>
                </div>
                
                <!-- Quantity Section -->
                <div class="form-section">
                    <div class="form-section-title">🔢 Transfer Quantity</div>
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Quantity <span class="required">*</span></label>
                            <input type="number" name="qty" id="qty" class="form-control" step="any" min="0.001" placeholder="Quantity to transfer" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Unit <span class="required">*</span></label>
                            <select name="unit_id" id="unit_id" class="form-control" required>
                                <option value="">Select unit...</option>
                                @foreach($units as $u)<option value="{{ $u->id }}">{{ $u->name }} ({{ $u->short_name }})</option>@endforeach
                            </select>
                        </div>
                    </div>
                </div>
                
                <!-- Notes -->
                <div class="form-section">
                    <div class="form-group">
                        <label class="form-label">Reason / Notes</label>
                        <textarea name="notes" class="form-control" placeholder="Reason for transfer..."></textarea>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">🔄 Transfer Stock</button>
                    <a href="{{ route('inventory.stock.movements') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
var selectedProduct = null;
var selectedVariation = null;
var productVariations = [];
var fromRacks = [];
var toRacks = [];
var selectedFromRack = null;
var selectedToRack = null;
var requiresVariation = false;

document.addEventListener('DOMContentLoaded', function() {
    var searchInput = document.getElementById('productSearch');
    var dropdown = document.getElementById('productDropdown');
    var productItems = dropdown.querySelectorAll('.product-item');
    
    searchInput.addEventListener('focus', function() { 
        if (!selectedProduct) dropdown.classList.add('show'); 
    // Auto-select preselected product from URL
    @if(isset($preselectedProduct) && $preselectedProduct)
    (function() {
        var preselectedId = '{{ $preselectedProduct->id }}';
        var productItem = document.querySelector('.product-item[data-id="' + preselectedId + '"]');
        if (productItem) {
            selectProduct(productItem);
        }
    })();
    @endif
    });
    
    searchInput.addEventListener('input', function() {
        var query = this.value.toLowerCase().trim();
        var hasVisible = false;
        productItems.forEach(function(item) {
            var name = item.dataset.name.toLowerCase();
            var sku = item.dataset.sku.toLowerCase();
            var match = name.indexOf(query) !== -1 || sku.indexOf(query) !== -1;
            item.style.display = match ? 'flex' : 'none';
            if (match) hasVisible = true;
        });
        document.getElementById('noProductsMsg').style.display = hasVisible ? 'none' : 'block';
        dropdown.classList.add('show');
    });
    
    document.addEventListener('click', function(e) { 
        if (!e.target.closest('.product-search-box')) dropdown.classList.remove('show'); 
    });
    
    productItems.forEach(function(item) { 
        item.addEventListener('click', function() { selectProduct(this); }); 
    });
    
    document.getElementById('from_warehouse_id').addEventListener('change', function() { 
        loadRacks(this.value, 'from'); 
        checkStock(); 
    });
    document.getElementById('to_warehouse_id').addEventListener('change', function() { 
        loadRacks(this.value, 'to'); 
        checkStock(); 
    });
    
    // Form validation
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        if (requiresVariation && !selectedVariation) {
            e.preventDefault();
            alert('Please select a variation for this product.');
            return false;
        }
    });
    
    var initFrom = document.getElementById('from_warehouse_id').value;
    if (initFrom) loadRacks(initFrom, 'from');
});

function selectProduct(item) {
    selectedProduct = {
        id: item.dataset.id,
        name: item.dataset.name,
        sku: item.dataset.sku,
        image: item.dataset.image,
        unit: item.dataset.unit,
        unitId: item.dataset.unitId,
        stock: parseFloat(item.dataset.stock) || 0,
        hasVariants: item.dataset.variants === '1'
    };
    
    // Parse variations safely - decode base64 first
    try {
        var variationsBase64 = item.dataset.variations || '';
        console.log('Variations base64 length:', variationsBase64.length);
        if (variationsBase64) {
            productVariations = JSON.parse(atob(variationsBase64));
            console.log('Parsed variations count:', productVariations.length);
        } else {
            productVariations = [];
        }
    } catch(e) {
        console.error('Error parsing variations:', e);
        productVariations = [];
        
        // If base64 fails and product has variants, load via AJAX
        if (selectedProduct.hasVariants) {
            loadVariationsViaAjax(selectedProduct.id);
        }
    }
    
    requiresVariation = productVariations.length > 0;
    console.log('requiresVariation:', requiresVariation, 'hasVariants:', selectedProduct.hasVariants);
    
    document.getElementById('product_id').value = selectedProduct.id;
    document.getElementById('variation_id').value = '';
    selectedVariation = null;
    
    document.getElementById('productSearch').style.display = 'none';
    document.getElementById('productDropdown').classList.remove('show');
    document.getElementById('selectedProduct').classList.add('show');
    
    var imgContainer = document.getElementById('selectedProductImage');
    if (selectedProduct.image) {
        imgContainer.innerHTML = '<img src="' + selectedProduct.image + '" class="selected-product-image" alt="">';
    } else {
        imgContainer.innerHTML = '<div class="selected-product-placeholder">' + selectedProduct.name.substring(0, 2).toUpperCase() + '</div>';
    }
    
    document.getElementById('selectedProductName').textContent = selectedProduct.name;
    document.getElementById('selectedProductSku').textContent = selectedProduct.sku;
    
    var badges = '<span class="selected-product-badge">📦 ' + selectedProduct.stock + ' ' + selectedProduct.unit + ' total</span>';
    if (requiresVariation || selectedProduct.hasVariants) badges += '<span class="selected-product-badge variant">🎨 ' + (productVariations.length || '...') + ' Variants</span>';
    document.getElementById('selectedProductBadges').innerHTML = badges;
    
    if (requiresVariation) {
        showVariations();
    } else if (selectedProduct.hasVariants) {
        // Product has variants flag but no parsed variations - try AJAX
        loadVariationsViaAjax(selectedProduct.id);
    } else {
        document.getElementById('variationSection').classList.remove('show');
    }
    
    loadUnits(selectedProduct.id);
    checkStock();
}

// AJAX fallback to load variations
function loadVariationsViaAjax(productId) {
    fetch('{{ url("admin/inventory/products") }}/' + productId + '/variations')
        .then(function(r) { return r.json(); })
        .then(function(data) {
            console.log('AJAX loaded variations:', data);
            
            if (data.success && data.variations) {
                productVariations = data.variations.map(function(v) {
                    var name = v.variation_name;
                    if (!name && v.attributes && v.attributes.length > 0) {
                        name = v.attributes.map(function(a) { return a.value; }).join(' / ');
                    }
                    if (!name) name = v.sku;
                    
                    var color = null;
                    if (v.attributes && v.attributes.length > 0) {
                        v.attributes.forEach(function(a) {
                            if (a.color_code) color = a.color_code;
                        });
                    }
                    
                    return {
                        id: v.id,
                        sku: v.sku,
                        name: name,
                        stock: v.stock_qty || 0,
                        effective_sale: v.sale_price,
                        image: v.image_url,
                        color: color
                    };
                });
                
                requiresVariation = productVariations.length > 0;
                
                var badges = '<span class="selected-product-badge">📦 ' + selectedProduct.stock + ' ' + selectedProduct.unit + ' total</span>';
                if (requiresVariation) badges += '<span class="selected-product-badge variant">🎨 ' + productVariations.length + ' Variants</span>';
                document.getElementById('selectedProductBadges').innerHTML = badges;
                
                if (requiresVariation) {
                    showVariations();
                }
            }
        })
        .catch(function(e) {
            console.error('AJAX variation load failed:', e);
        });
}

function showVariations() {
    var grid = document.getElementById('variationGrid');
    grid.innerHTML = '';
    
    productVariations.forEach(function(v) {
        var chip = document.createElement('div');
        chip.className = 'variation-chip';
        
        var content = '';
        if (v.image) {
            content += '<img src="' + v.image + '" class="variation-chip-image" alt="">';
        } else if (v.color) {
            content += '<span class="variation-chip-color" style="background:' + v.color + '"></span>';
        }
        content += '<span class="variation-chip-name">' + v.name + '</span>';
        content += '<span class="variation-chip-stock">' + v.stock + '</span>';
        
        // Show price if variation has its own price
        var effectiveSale = parseFloat(v.effective_sale) || 0;
        if (effectiveSale > 0) {
            content += '<span class="variation-chip-price">₹' + effectiveSale.toFixed(0) + '</span>';
        }
        
        chip.innerHTML = content;
        chip.addEventListener('click', function() {
            document.querySelectorAll('.variation-chip').forEach(function(c) { c.classList.remove('selected'); });
            chip.classList.add('selected');
            selectedVariation = v;
            document.getElementById('variation_id').value = v.id;
            document.getElementById('selectedProductSku').textContent = v.sku;
            
            // Update badge to show variation stock
            document.getElementById('selectedProductBadges').innerHTML = '<span class="selected-product-badge">📦 ' + v.stock + ' ' + selectedProduct.unit + ' available</span>';
            
            checkStock();
        });
        grid.appendChild(chip);
    });
    
    document.getElementById('variationSection').classList.add('show');
}

function clearProduct() {
    selectedProduct = null;
    selectedVariation = null;
    requiresVariation = false;
    
    document.getElementById('product_id').value = '';
    document.getElementById('variation_id').value = '';
    document.getElementById('productSearch').style.display = 'block';
    document.getElementById('productSearch').value = '';
    document.getElementById('selectedProduct').classList.remove('show');
    document.getElementById('stockSummary').classList.remove('show');
    
    document.querySelectorAll('.product-item').forEach(function(i) { i.style.display = 'flex'; });
}

var loadingRacks = {};
function loadRacks(warehouseId, target) {
    if (loadingRacks[target]) return;
    
    var grid = document.getElementById(target + 'RackGrid');
    grid.innerHTML = '<div class="rack-no-items">Loading...</div>';
    
    if (!warehouseId) { 
        grid.innerHTML = '<div class="rack-no-items">Select warehouse first</div>'; 
        return; 
    }
    
    loadingRacks[target] = true;
    fetch('{{ url("admin/inventory/racks/by-warehouse") }}/' + warehouseId)
        .then(function(r) { return r.json(); })
        .then(function(racks) {
            if (target === 'from') fromRacks = racks;
            else toRacks = racks;
            renderRacks(racks, target);
            loadingRacks[target] = false;
        })
        .catch(function() { 
            grid.innerHTML = '<div class="rack-no-items">Failed to load racks</div>'; 
            loadingRacks[target] = false;
        });
}

function renderRacks(racks, target) {
    var grid = document.getElementById(target + 'RackGrid');
    grid.innerHTML = '';
    
    if (racks.length === 0) { 
        grid.innerHTML = '<div class="rack-no-items">No racks in this warehouse</div>'; 
        return; 
    }
    
    racks.forEach(function(rack) {
        var cap = getCapacity(rack);
        var item = document.createElement('div');
        item.className = 'rack-item';
        item.dataset.id = rack.id;
        
        item.innerHTML = 
            '<div class="rack-item-code">' + rack.code + '</div>' +
            '<div class="rack-capacity-bar"><div class="rack-capacity-fill ' + cap.cls + '" style="width:' + cap.percent + '%"></div></div>' +
            '<div class="rack-capacity-text">' + cap.percent + '% (' + (rack.current_stock || 0) + ')</div>';
        
        item.addEventListener('click', function() {
            grid.querySelectorAll('.rack-item').forEach(function(i) { i.classList.remove('selected', 'from', 'to'); });
            item.classList.add('selected', target);
            
            if (target === 'from') { 
                selectedFromRack = rack; 
                document.getElementById('from_rack_id').value = rack.id; 
            } else { 
                selectedToRack = rack; 
                document.getElementById('to_rack_id').value = rack.id; 
            }
            checkStock();
        });
        
        grid.appendChild(item);
    });
}

function getCapacity(rack) {
    var current = parseFloat(rack.current_stock) || 0;
    var max = parseFloat(rack.max_capacity) || 0;
    if (max === 0) return { percent: 0, cls: 'low' };
    var percent = Math.min(100, Math.round((current / max) * 100));
    var cls = percent >= 90 ? 'full' : percent >= 70 ? 'high' : percent >= 40 ? 'medium' : 'low';
    return { percent: percent, cls: cls };
}

function checkStock() {
    var productId = document.getElementById('product_id').value;
    var fromWh = document.getElementById('from_warehouse_id').value;
    var toWh = document.getElementById('to_warehouse_id').value;
    var variationId = document.getElementById('variation_id').value;
    
    if (!productId || !fromWh) { 
        document.getElementById('stockSummary').classList.remove('show'); 
        return; 
    }
    
    // Get from stock
    var fromUrl = '{{ route("inventory.stock.check") }}?product_id=' + productId + '&warehouse_id=' + fromWh;
    if (variationId) fromUrl += '&variation_id=' + variationId;
    if (selectedFromRack) fromUrl += '&rack_id=' + selectedFromRack.id;
    
    fetch(fromUrl)
        .then(function(r) { return r.json(); })
        .then(function(data) {
            document.getElementById('fromStockValue').textContent = (data.base_stock || 0) + ' ' + (data.base_unit || 'PCS');
        })
        .catch(function() {});
    
    // Get to stock
    if (toWh) {
        var toUrl = '{{ route("inventory.stock.check") }}?product_id=' + productId + '&warehouse_id=' + toWh;
        if (variationId) toUrl += '&variation_id=' + variationId;
        if (selectedToRack) toUrl += '&rack_id=' + selectedToRack.id;
        
        fetch(toUrl)
            .then(function(r) { return r.json(); })
            .then(function(data) {
                document.getElementById('toStockValue').textContent = (data.base_stock || 0) + ' ' + (data.base_unit || 'PCS');
            })
            .catch(function() {});
    } else {
        document.getElementById('toStockValue').textContent = '0';
    }
    
    document.getElementById('stockSummary').classList.add('show');
}

function loadUnits(productId) {
    fetch('{{ url("admin/inventory/stock/product-units") }}?product_id=' + productId)
        .then(function(r) { return r.json(); })
        .then(function(data) {
            var unitSelect = document.getElementById('unit_id');
            unitSelect.innerHTML = '<option value="">Select unit...</option>';
            (data.units || []).forEach(function(u) {
                var label = u.name + (u.is_base ? ' (Base)' : u.conversion_factor != 1 ? ' (=' + u.conversion_factor + ')' : '');
                unitSelect.add(new Option(label, u.id));
            });
            if (data.base_unit_id) unitSelect.value = data.base_unit_id;
        })
        .catch(function() {});
}
</script>
