
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
    .page-header {
        display: flex;
        align-items: center;
        gap: 16px;
        margin-bottom: 24px;
    }
    
    .back-btn {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        color: var(--text-muted);
        text-decoration: none;
        transition: all 0.2s;
    }
    
    .back-btn:hover {
        background: var(--body-bg);
        color: var(--text-primary);
    }
    
    .back-btn svg {
        width: 20px;
        height: 20px;
    }
    
    .page-header h1 {
        font-size: 24px;
        font-weight: 700;
        color: var(--text-primary);
        margin: 0;
    }

    .form-card {
        background: var(--card-bg);
        border: 1px solid var(--card-border);
        border-radius: 12px;
        max-width: 800px;
    }
    
    .form-card-header {
        padding: 20px 24px;
        border-bottom: 1px solid var(--card-border);
    }
    
    .form-card-title {
        font-size: 16px;
        font-weight: 600;
        color: var(--text-primary);
        margin: 0;
    }
    
    .form-card-body {
        padding: 24px;
    }

    .form-section {
        margin-bottom: 32px;
        padding-bottom: 32px;
        border-bottom: 1px solid var(--card-border);
    }
    
    .form-section:last-child {
        margin-bottom: 0;
        padding-bottom: 0;
        border-bottom: none;
    }
    
    .form-section-title {
        font-size: 14px;
        font-weight: 600;
        color: var(--text-muted);
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
    }
    
    @media (max-width: 640px) {
        .form-row {
            grid-template-columns: 1fr;
        }
    }

    .form-group {
        margin-bottom: 20px;
    }
    
    .form-group:last-child {
        margin-bottom: 0;
    }
    
    .form-label {
        display: block;
        font-size: 13px;
        font-weight: 500;
        color: var(--text-primary);
        margin-bottom: 8px;
    }
    
    .form-label .required {
        color: #ef4444;
    }
    
    .form-control {
        width: 100%;
        padding: 10px 14px;
        border: 1px solid var(--card-border);
        border-radius: 8px;
        font-size: 14px;
        background: var(--card-bg);
        color: var(--text-primary);
        transition: border-color 0.2s, box-shadow 0.2s;
        box-sizing: border-box;
    }
    
    .form-control:focus {
        outline: none;
        border-color: var(--primary);
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }
    
    textarea.form-control {
        min-height: 100px;
        resize: vertical;
    }

    .form-check {
        display: flex;
        align-items: center;
        gap: 10px;
        cursor: pointer;
    }
    
    .form-check input[type="checkbox"] {
        width: 18px;
        height: 18px;
        cursor: pointer;
    }
    
    .form-check-label {
        font-size: 14px;
        color: var(--text-primary);
    }

    .form-help {
        font-size: 12px;
        color: var(--text-muted);
        margin-top: 6px;
    }

    .form-actions {
        display: flex;
        gap: 12px;
        padding-top: 24px;
        border-top: 1px solid var(--card-border);
        margin-top: 24px;
    }

    .btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        padding: 12px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        cursor: pointer;
        border: none;
        text-decoration: none;
        transition: all 0.2s;
    }
    
    .btn svg {
        width: 18px;
        height: 18px;
    }
    
    .btn-primary {
        background: linear-gradient(135deg, var(--primary), var(--primary-hover));
        color: #fff;
    }
    
    .btn-primary:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
    }
    
    .btn-secondary {
        background: var(--body-bg);
        color: var(--text-primary);
        border: 1px solid var(--card-border);
    }
    
    .btn-secondary:hover {
        background: var(--card-border);
    }
    /* Select2 Custom Styling */
.select2-container--default .select2-selection--single {
    height: 42px;
    padding: 6px 14px;
    border: 1px solid var(--card-border);
    border-radius: 8px;
    background: var(--card-bg);
}
.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 28px;
    color: var(--text-primary);
    padding-left: 0;
}
.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 40px;
}
.select2-dropdown {
    border: 1px solid var(--card-border);
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}
.select2-container--default .select2-search--dropdown .select2-search__field {
    border: 1px solid var(--card-border);
    border-radius: 6px;
    padding: 8px 12px;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background: var(--primary);
}
</style>

<div style="padding: 20px;">
    <!-- Header -->
    <div class="page-header">
        <a href="{{ route('inventory.warehouses.index') }}" class="back-btn">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/>
            </svg>
        </a>
        <h1>Edit Warehouse</h1>
    </div>

    <!-- Form Card -->
    <div class="form-card">
        <div class="form-card-header">
            <h3 class="form-card-title">Edit: {{ $warehouse->name }}</h3>
        </div>
        <div class="form-card-body">
            <form action="{{ route('inventory.warehouses.update', $warehouse->id) }}" method="POST">
                @csrf
                @method('PUT')

                <!-- Basic Information -->
                <div class="form-section">
                    <div class="form-section-title">Basic Information</div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">Warehouse Code <span class="required">*</span></label>
                            <input type="text" name="code" class="form-control" value="{{ old('code', $warehouse->code) }}" required>
                            @error('code')<div class="form-help" style="color: #ef4444;">{{ $message }}</div>@enderror
                        </div>
                        <div class="form-group">
                            <label class="form-label">Warehouse Name <span class="required">*</span></label>
                            <input type="text" name="name" class="form-control" value="{{ old('name', $warehouse->name) }}" required>
                            @error('name')<div class="form-help" style="color: #ef4444;">{{ $message }}</div>@enderror
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Warehouse Type <span class="required">*</span></label>
                        <input type="hidden" name="type" id="warehouseType" value="{{ old('type', $warehouse->type) }}" required>
                        <div class="type-selector">
                            <div class="type-chip {{ old('type', $warehouse->type) == 'STORAGE' ? 'selected' : '' }}" data-value="STORAGE" onclick="selectType('STORAGE')">
                                <div class="type-chip-icon" style="background: #dbeafe;">📦</div>
                                <div class="type-chip-info">
                                    <div class="type-chip-name">Storage</div>
                                    <div class="type-chip-desc">Main inventory storage</div>
                                </div>
                                <div class="type-chip-check">
                                    <svg fill="none" stroke="currentColor" stroke-width="3" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/></svg>
                                </div>
                            </div>
                            <div class="type-chip {{ old('type', $warehouse->type) == 'SHOP' ? 'selected' : '' }}" data-value="SHOP" onclick="selectType('SHOP')">
                                <div class="type-chip-icon" style="background: #f3e8ff;">🏪</div>
                                <div class="type-chip-info">
                                    <div class="type-chip-name">Shop / Retail</div>
                                    <div class="type-chip-desc">Point of sale location</div>
                                </div>
                                <div class="type-chip-check">
                                    <svg fill="none" stroke="currentColor" stroke-width="3" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/></svg>
                                </div>
                            </div>
                            <div class="type-chip {{ old('type', $warehouse->type) == 'RETURN_CENTER' ? 'selected' : '' }}" data-value="RETURN_CENTER" onclick="selectType('RETURN_CENTER')">
                                <div class="type-chip-icon" style="background: #fef3c7;">↩️</div>
                                <div class="type-chip-info">
                                    <div class="type-chip-name">Return Center</div>
                                    <div class="type-chip-desc">Returns & defects handling</div>
                                </div>
                                <div class="type-chip-check">
                                    <svg fill="none" stroke="currentColor" stroke-width="3" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/></svg>
                                </div>
                            </div>
                        </div>
                        @error('type')<div class="form-help" style="color: #ef4444;">{{ $message }}</div>@enderror
                    </div>
                </div>

                <!-- Address -->
                <div class="form-section">
                    <div class="form-section-title">Address</div>
                    
                    <div class="form-group">
                        <label class="form-label">Address</label>
                        <textarea name="address" class="form-control" placeholder="Full address">{{ old('address', $warehouse->address) }}</textarea>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label">City</label>
                            <input type="text" name="city" class="form-control" value="{{ old('city', $warehouse->city) }}">
                        </div>
                        <div class="form-group">
                            <label class="form-label">State</label>
                            <input type="text" name="state" class="form-control" value="{{ old('state', $warehouse->state) }}">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Country</label>
                        <input type="text" name="country" class="form-control" value="{{ old('country', $warehouse->country) }}">
                    </div>
                </div>

                <!-- Contact Information -->
                <div class="form-section">
                    <div class="form-section-title">Contact Information</div>
                    
                    <div class="form-group">
                        <label class="form-label">Assign Contact Person</label>
                        <select name="contact_staff_id" id="contact_staff_id" class="form-control select2-staff">
                            <option value="">-- Select Staff Member --</option>
                            @foreach($staffs as $staff)
                                <option value="{{ $staff->id }}" 
                                        data-phone="{{ $staff->phone }}"
                                        data-email="{{ $staff->email }}"
                                        {{ old('contact_staff_id', $warehouse->contact_staff_id) == $staff->id ? 'selected' : '' }}>
                                    {{ $staff->display_name }}
                                </option>
                            @endforeach
                        </select>
                        <div class="form-help">Select a staff member to assign as warehouse contact</div>
                    </div>
                    
                    <!-- Selected Staff Info Card -->
                    <div class="staff-info-card" id="staffInfoCard" style="display: none;">
                        <div class="staff-info-icon">👤</div>
                        <div class="staff-info-details">
                            <div class="staff-info-name" id="staffInfoName"></div>
                            <div class="staff-info-meta">
                                <span id="staffInfoEmail"></span>
                                <span id="staffInfoPhone"></span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-row" style="margin-top: 16px;">
                        <div class="form-group">
                            <label class="form-label">Contact Person Name</label>
                            <input type="text" name="contact_person" id="contact_person" class="form-control" placeholder="Auto-filled or enter manually" value="{{ old('contact_person', $warehouse->contact_person) }}">
                            <div class="form-help">Auto-filled when staff selected, or enter manually</div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Phone</label>
                            <input type="text" name="phone" id="phone" class="form-control" placeholder="Phone number" value="{{ old('phone', $warehouse->phone) }}">
                            <div class="form-help">Auto-filled when staff selected, can be overridden</div>
                        </div>
                    </div>
                </div>

                <!-- Settings -->
                <div class="form-section">
                    <div class="form-section-title">Settings</div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-check">
                                <input type="checkbox" name="is_default" value="1" {{ old('is_default', $warehouse->is_default) ? 'checked' : '' }}>
                                <span class="form-check-label">Set as Default Warehouse</span>
                            </label>
                        </div>
                        <div class="form-group">
                            <label class="form-check">
                                <input type="checkbox" name="is_active" value="1" {{ old('is_active', $warehouse->is_active) ? 'checked' : '' }}>
                                <span class="form-check-label">Active</span>
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
                        </svg>
                        Update Warehouse
                    </button>
                    <a href="{{ route('inventory.warehouses.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .type-selector {
        display: flex;
        gap: 12px;
        flex-wrap: wrap;
    }
    
    .type-chip {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 14px 18px;
        background: var(--body-bg);
        border: 2px solid var(--card-border);
        border-radius: 12px;
        cursor: pointer;
        transition: all 0.2s;
        flex: 1;
        min-width: 180px;
    }
    
    .type-chip:hover {
        border-color: #a5b4fc;
        background: #f5f3ff;
    }
    
    .type-chip.selected {
        border-color: #6366f1;
        background: linear-gradient(135deg, #eef2ff, #e0e7ff);
        box-shadow: 0 2px 8px rgba(99, 102, 241, 0.2);
    }
    
    .type-chip-icon {
        width: 44px;
        height: 44px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 22px;
        flex-shrink: 0;
    }
    
    .type-chip-info {
        flex: 1;
    }
    
    .type-chip-name {
        font-size: 14px;
        font-weight: 600;
        color: var(--text-primary);
    }
    
    .type-chip-desc {
        font-size: 12px;
        color: var(--text-muted);
        margin-top: 2px;
    }
    
    .type-chip-check {
        width: 24px;
        height: 24px;
        border-radius: 50%;
        background: #6366f1;
        color: white;
        display: none;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }
    
    .type-chip.selected .type-chip-check {
        display: flex;
    }
    
    .type-chip-check svg {
        width: 14px;
        height: 14px;
    }
    
    /* Staff Info Card */
    .staff-info-card {
        display: flex;
        align-items: center;
        gap: 14px;
        padding: 14px 18px;
        background: linear-gradient(135deg, #ecfdf5, #d1fae5);
        border: 2px solid #10b981;
        border-radius: 12px;
        margin-top: 12px;
    }
    
    .staff-info-icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        background: #10b981;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        flex-shrink: 0;
    }
    
    .staff-info-details {
        flex: 1;
    }
    
    .staff-info-name {
        font-size: 16px;
        font-weight: 700;
        color: #065f46;
    }
    
    .staff-info-meta {
        display: flex;
        gap: 16px;
        margin-top: 4px;
        font-size: 13px;
        color: #047857;
    }
    
    .staff-info-meta span:before {
        margin-right: 4px;
    }
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function selectType(type) {
    document.getElementById('warehouseType').value = type;
    document.querySelectorAll('.type-chip').forEach(function(chip) {
        chip.classList.remove('selected');
    });
    document.querySelector('.type-chip[data-value="' + type + '"]').classList.add('selected');
}

// Staff selection handler
document.getElementById('contact_staff_id').addEventListener('change', function() {
    var select = this;
    var option = select.options[select.selectedIndex];
    var infoCard = document.getElementById('staffInfoCard');
    
    if (select.value) {
        var name = option.text;
        var phone = option.dataset.phone || '';
        var email = option.dataset.email || '';
        
        // Update info card
        document.getElementById('staffInfoName').textContent = name;
        document.getElementById('staffInfoEmail').textContent = email ? '📧 ' + email : '';
        document.getElementById('staffInfoPhone').textContent = phone ? '📞 ' + phone : '';
        infoCard.style.display = 'flex';
        
        // Auto-fill contact fields
        var nameParts = name.split(' - ');
        var displayName = nameParts.length > 1 ? nameParts[1].split(' (')[0] : name;
        document.getElementById('contact_person').value = displayName.trim();
        
        if (phone) {
            document.getElementById('phone').value = phone;
        }
    } else {
        infoCard.style.display = 'none';
    }
});

// Trigger on page load if staff pre-selected
document.addEventListener('DOMContentLoaded', function() {
    var staffSelect = document.getElementById('contact_staff_id');
    if (staffSelect.value) {
        staffSelect.dispatchEvent(new Event('change'));
    }
});
// Load Select2 dynamically
(function() {
    var script = document.createElement('script');
    script.src = 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js';
    script.onload = function() {
        // Initialize Select2
        $('#contact_staff_id').select2({
            placeholder: '-- Search & Select Staff Member --',
            allowClear: true,
            width: '100%'
        });
        
        // Rebind change event for Select2
        $('#contact_staff_id').on('select2:select select2:clear', function(e) {
            var select = this;
            var option = select.options[select.selectedIndex];
            var infoCard = document.getElementById('staffInfoCard');
            
            if (select.value) {
                var name = option.text;
                var phone = option.dataset.phone || '';
                var email = option.dataset.email || '';
                
                document.getElementById('staffInfoName').textContent = name;
                document.getElementById('staffInfoEmail').textContent = email ? '📧 ' + email : '';
                document.getElementById('staffInfoPhone').textContent = phone ? '📞 ' + phone : '';
                infoCard.style.display = 'flex';
                
                var nameParts = name.split(' - ');
                var displayName = nameParts.length > 1 ? nameParts[1].split(' (')[0] : name;
                document.getElementById('contact_person').value = displayName.trim();
                
                if (phone) {
                    document.getElementById('phone').value = phone;
                }
            } else {
                infoCard.style.display = 'none';
                document.getElementById('contact_person').value = '';
                document.getElementById('phone').value = '';
            }
        });
    };
    document.head.appendChild(script);
})();
</script>
