<style>
    .page-container { padding: 20px; max-width: 1200px; margin: 0 auto; }
    
    .page-header { display: flex; align-items: center; gap: 16px; margin-bottom: 24px; flex-wrap: wrap; }
    .back-btn { width: 40px; height: 40px; border-radius: 10px; display: flex; align-items: center; justify-content: center; background: var(--card-bg); border: 1px solid var(--card-border); color: var(--text-muted); text-decoration: none; transition: all 0.2s; flex-shrink: 0; }
    .back-btn:hover { background: var(--body-bg); color: var(--text-primary); }
    .back-btn svg { width: 20px; height: 20px; }
    
    .page-title-group { flex: 1; }
    .page-title { font-size: 24px; font-weight: 700; color: var(--text-primary); margin: 0; display: flex; align-items: center; gap: 12px; }
    .page-subtitle { font-size: 14px; color: var(--text-muted); margin-top: 4px; }
    
    .header-badges { display: flex; gap: 8px; align-items: center; }
    .badge { padding: 6px 14px; border-radius: 20px; font-size: 12px; font-weight: 600; }
    .badge-default { background: linear-gradient(135deg, #fbbf24, #f59e0b); color: #fff; }
    .badge-active { background: #d1fae5; color: #065f46; }
    .badge-inactive { background: #fee2e2; color: #991b1b; }
    .badge-type { background: #dbeafe; color: #1e40af; }
    .badge-type.shop { background: #f3e8ff; color: #7c3aed; }
    .badge-type.return { background: #fef3c7; color: #92400e; }
    
    .header-actions { display: flex; gap: 10px; }
    .btn { display: inline-flex; align-items: center; gap: 8px; padding: 10px 18px; border-radius: 8px; font-size: 13px; font-weight: 600; text-decoration: none; transition: all 0.2s; border: none; cursor: pointer; }
    .btn-primary { background: linear-gradient(135deg, var(--primary), var(--primary-hover)); color: #fff; }
    .btn-primary:hover { transform: translateY(-1px); box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3); }
    .btn-secondary { background: var(--card-bg); color: var(--text-primary); border: 1px solid var(--card-border); }
    .btn-secondary:hover { background: var(--body-bg); }
    .btn svg { width: 16px; height: 16px; }

    /* Stats Grid */
    .stats-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 16px; margin-bottom: 24px; }
    .stat-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; padding: 20px; display: flex; align-items: center; gap: 16px; }
    .stat-icon { width: 52px; height: 52px; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 24px; }
    .stat-icon.blue { background: linear-gradient(135deg, #dbeafe, #bfdbfe); }
    .stat-icon.green { background: linear-gradient(135deg, #d1fae5, #a7f3d0); }
    .stat-icon.purple { background: linear-gradient(135deg, #ede9fe, #ddd6fe); }
    .stat-icon.orange { background: linear-gradient(135deg, #ffedd5, #fed7aa); }
    .stat-value { font-size: 26px; font-weight: 700; color: var(--text-primary); }
    .stat-label { font-size: 12px; color: var(--text-muted); margin-top: 2px; }

    /* Info Cards */
    .info-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; margin-bottom: 24px; }
    .info-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
    .info-card-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); background: var(--body-bg); }
    .info-card-title { font-size: 14px; font-weight: 600; color: var(--text-primary); display: flex; align-items: center; gap: 8px; }
    .info-card-title svg { width: 18px; height: 18px; color: var(--text-muted); }
    .info-card-body { padding: 20px; }
    .info-row { display: flex; justify-content: space-between; padding: 10px 0; border-bottom: 1px solid var(--card-border); }
    .info-row:last-child { border-bottom: none; }
    .info-label { font-size: 13px; color: var(--text-muted); }
    .info-value { font-size: 13px; font-weight: 500; color: var(--text-primary); text-align: right; }

    /* Racks Section */
    .section-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px; }
    .section-title { font-size: 18px; font-weight: 600; color: var(--text-primary); display: flex; align-items: center; gap: 10px; }
    .section-title svg { width: 22px; height: 22px; color: #7c3aed; }
    
    .racks-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 16px; margin-bottom: 24px; }
    .rack-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; padding: 16px; transition: all 0.2s; cursor: pointer; }
    .rack-card:hover { transform: translateY(-2px); box-shadow: 0 8px 24px rgba(0,0,0,0.1); border-color: #7c3aed; }
    .rack-card-header { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 10px; }
    .rack-code { font-size: 16px; font-weight: 700; color: #7c3aed; }
    .rack-type { font-size: 18px; }
    .rack-name { font-size: 13px; color: var(--text-muted); margin-bottom: 8px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
    .rack-location { font-size: 11px; color: var(--text-muted); background: var(--body-bg); padding: 4px 8px; border-radius: 4px; margin-bottom: 12px; display: inline-block; }
    .rack-capacity { margin-bottom: 8px; }
    .rack-bar { height: 8px; background: #e5e7eb; border-radius: 4px; overflow: hidden; }
    .rack-fill { height: 100%; border-radius: 4px; transition: width 0.3s; }
    .rack-fill.empty { background: #e5e7eb; }
    .rack-fill.low { background: linear-gradient(90deg, #22c55e, #4ade80); }
    .rack-fill.medium { background: linear-gradient(90deg, #eab308, #facc15); }
    .rack-fill.high { background: linear-gradient(90deg, #f97316, #fb923c); }
    .rack-fill.full { background: linear-gradient(90deg, #ef4444, #f87171); }
    .rack-stats { display: flex; justify-content: space-between; font-size: 11px; color: var(--text-muted); }
    .rack-percent { font-weight: 700; }
    .rack-percent.low { color: #16a34a; }
    .rack-percent.medium { color: #ca8a04; }
    .rack-percent.high { color: #ea580c; }
    .rack-percent.full { color: #dc2626; }
    
    /* Contact Staff Card */
    .contact-staff-card {
        display: flex;
        align-items: center;
        gap: 14px;
        padding: 14px;
        background: linear-gradient(135deg, #ecfdf5, #d1fae5);
        border: 1px solid #10b981;
        border-radius: 10px;
        margin-bottom: 16px;
    }
    
    .contact-staff-avatar {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        background: #10b981;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        flex-shrink: 0;
    }
    
    .contact-staff-info {
        flex: 1;
    }
    
    .contact-staff-name {
        font-size: 16px;
        font-weight: 700;
        color: #065f46;
    }
    
    .contact-staff-code {
        font-size: 12px;
        color: #047857;
        margin-top: 2px;
    }
    
    .contact-staff-designation {
        font-size: 11px;
        color: #10b981;
        background: #fff;
        padding: 2px 8px;
        border-radius: 4px;
        display: inline-block;
        margin-top: 4px;
    }
    
    .empty-racks { text-align: center; padding: 40px; color: var(--text-muted); }
    .empty-racks svg { width: 48px; height: 48px; margin-bottom: 12px; opacity: 0.5; }

    /* Movements Section */
    .movements-card { background: var(--card-bg); border: 1px solid var(--card-border); border-radius: 12px; overflow: hidden; }
    .movements-header { padding: 16px 20px; border-bottom: 1px solid var(--card-border); display: flex; justify-content: space-between; align-items: center; }
    .movements-title { font-size: 16px; font-weight: 600; color: var(--text-primary); display: flex; align-items: center; gap: 8px; }
    .movements-title svg { width: 20px; height: 20px; color: #10b981; }
    .movements-list { padding: 0; }
    .movement-item { display: flex; align-items: center; gap: 14px; padding: 14px 20px; border-bottom: 1px solid var(--card-border); }
    .movement-item:last-child { border-bottom: none; }
    .movement-icon { width: 36px; height: 36px; border-radius: 8px; display: flex; align-items: center; justify-content: center; font-size: 16px; flex-shrink: 0; }
    .movement-icon.in { background: #d1fae5; }
    .movement-icon.out { background: #fee2e2; }
    .movement-icon.transfer { background: #dbeafe; }
    .movement-icon.adjust { background: #f3e8ff; }
    .movement-info { flex: 1; min-width: 0; }
    .movement-product { font-size: 13px; font-weight: 500; color: var(--text-primary); white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
    .movement-details { font-size: 12px; color: var(--text-muted); margin-top: 2px; }
    .movement-qty { font-size: 14px; font-weight: 700; white-space: nowrap; }
    .movement-qty.in { color: #059669; }
    .movement-qty.out { color: #dc2626; }
    .movement-time { font-size: 11px; color: var(--text-muted); white-space: nowrap; }
    
    .no-movements { padding: 40px; text-align: center; color: var(--text-muted); font-size: 14px; }
</style>

<div class="page-container">
    <!-- Header -->
    <div class="page-header">
        <a href="{{ route('inventory.warehouses.index') }}" class="back-btn">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"/>
            </svg>
        </a>
        <div class="page-title-group">
            <h1 class="page-title">
                🏭 {{ $warehouse->name }}
            </h1>
            <div class="page-subtitle">{{ $warehouse->code }} • {{ $warehouse->city ?? 'No location' }}</div>
        </div>
        <div class="header-badges">
            @if($warehouse->is_default)
                <span class="badge badge-default">★ Default</span>
            @endif
            @php
                $typeClass = match($warehouse->type) {
                    'SHOP' => 'shop',
                    'RETURN_CENTER' => 'return',
                    default => ''
                };
                $typeLabel = match($warehouse->type) {
                    'STORAGE' => '📦 Storage',
                    'SHOP' => '🏪 Shop',
                    'RETURN_CENTER' => '↩️ Return Center',
                    default => $warehouse->type
                };
            @endphp
            <span class="badge badge-type {{ $typeClass }}">{{ $typeLabel }}</span>
            <span class="badge {{ $warehouse->is_active ? 'badge-active' : 'badge-inactive' }}">
                {{ $warehouse->is_active ? 'Active' : 'Inactive' }}
            </span>
        </div>
        <div class="header-actions">
            <a href="{{ route('inventory.warehouses.edit', $warehouse->id) }}" class="btn btn-primary">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                </svg>
                Edit
            </a>
            <a href="{{ route('inventory.racks.create') }}?warehouse_id={{ $warehouse->id }}" class="btn btn-secondary">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
                </svg>
                Add Rack
            </a>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon purple">🗃️</div>
            <div>
                <div class="stat-value">{{ $stats['total_racks'] }}</div>
                <div class="stat-label">Total Racks</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon blue">📦</div>
            <div>
                <div class="stat-value">{{ number_format($stats['total_stock']) }}</div>
                <div class="stat-label">Total Stock</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon green">📊</div>
            <div>
                <div class="stat-value">{{ $stats['total_products'] }}</div>
                <div class="stat-label">Products</div>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon orange">💰</div>
            <div>
                <div class="stat-value">₹{{ number_format($stats['stock_value'], 0) }}</div>
                <div class="stat-label">Stock Value</div>
            </div>
        </div>
    </div>

    <!-- Info Cards -->
    <div class="info-grid">
        <div class="info-card">
            <div class="info-card-header">
                <div class="info-card-title">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                    Location
                </div>
            </div>
            <div class="info-card-body">
                <div class="info-row">
                    <span class="info-label">Address</span>
                    <span class="info-value">{{ $warehouse->address ?: '-' }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">City</span>
                    <span class="info-value">{{ $warehouse->city ?: '-' }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">State</span>
                    <span class="info-value">{{ $warehouse->state ?: '-' }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Country</span>
                    <span class="info-value">{{ $warehouse->country ?: 'India' }}</span>
                </div>
            </div>
        </div>
        
        <div class="info-card">
            <div class="info-card-header">
                <div class="info-card-title">
                    <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                    Contact
                </div>
            </div>
            <div class="info-card-body">
                @if($warehouse->contactStaff)
                    <div class="contact-staff-card">
                        <div class="contact-staff-avatar">👤</div>
                        <div class="contact-staff-info">
                            <div class="contact-staff-name">{{ $warehouse->contact_name }}</div>
                            <div class="contact-staff-code">{{ $warehouse->contactStaff->employee_code }}</div>
                            @if($warehouse->contactStaff->designation)
                                <div class="contact-staff-designation">{{ $warehouse->contactStaff->designation }}</div>
                            @endif
                        </div>
                    </div>
                    <div class="info-row">
                        <span class="info-label">📧 Email</span>
                        <span class="info-value">
                            <a href="/cdn-cgi/l/email-protection#394242191d4e584b5c51564c4a5c14075a56574d585a4d665c54585055194444" style="color: #2563eb; text-decoration: none;">
                                {{ $warehouse->contact_email }}
                            </a>
                        </span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">📞 Phone</span>
                        <span class="info-value">
                            <a href="tel:{{ $warehouse->contact_phone }}" style="color: #2563eb; text-decoration: none;">
                                {{ $warehouse->contact_phone ?: '-' }}
                            </a>
                        </span>
                    </div>
                @else
                    <div class="info-row">
                        <span class="info-label">Contact Person</span>
                        <span class="info-value">{{ $warehouse->contact_person ?: '-' }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Phone</span>
                        <span class="info-value">{{ $warehouse->phone ?: '-' }}</span>
                    </div>
                @endif
                <div class="info-row">
                    <span class="info-label">Created</span>
                    <span class="info-value">{{ $warehouse->created_at->format('d M Y') }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Last Updated</span>
                    <span class="info-value">{{ $warehouse->updated_at->diffForHumans() }}</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Racks Section -->
    <div class="section-header">
        <h2 class="section-title">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/>
            </svg>
            Racks ({{ $warehouse->racks->count() }})
        </h2>
        <a href="{{ route('inventory.racks.layout') }}?warehouse={{ $warehouse->id }}" class="btn btn-secondary">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M4 5a1 1 0 011-1h14a1 1 0 011 1v2a1 1 0 01-1 1H5a1 1 0 01-1-1V5zM4 13a1 1 0 011-1h6a1 1 0 011 1v6a1 1 0 01-1 1H5a1 1 0 01-1-1v-6zM16 13a1 1 0 011-1h2a1 1 0 011 1v6a1 1 0 01-1 1h-2a1 1 0 01-1-1v-6z"/>
            </svg>
            View Layout
        </a>
    </div>

    @if($warehouse->racks->count() > 0)
        <div class="racks-grid">
            @foreach($warehouse->racks as $rack)
                @php
                    $current = $rack->current_stock ?? 0;
                    $max = $rack->max_capacity ?? 0;
                    $percent = $max > 0 ? min(100, round(($current / $max) * 100)) : 0;
                    $fillClass = 'empty';
                    if ($percent >= 90) $fillClass = 'full';
                    elseif ($percent >= 70) $fillClass = 'high';
                    elseif ($percent >= 40) $fillClass = 'medium';
                    elseif ($percent > 0) $fillClass = 'low';
                    
                    $storageTypes = \Modules\Inventory\Models\Rack::STORAGE_TYPES;
                    $typeInfo = $storageTypes[$rack->storage_type ?? 'SHELF'] ?? $storageTypes['SHELF'];
                @endphp
                <div class="rack-card" onclick="window.location='{{ route('inventory.racks.edit', $rack->id) }}'">
                    <div class="rack-card-header">
                        <span class="rack-code">{{ $rack->code }}</span>
                        <span class="rack-type" title="{{ $typeInfo['label'] }}">{{ $typeInfo['icon'] }}</span>
                    </div>
                    <div class="rack-name">{{ $rack->name ?: 'Unnamed' }}</div>
                    @if($rack->zone || $rack->aisle || $rack->level)
                        <div class="rack-location">
                            {{ collect([$rack->zone, $rack->aisle ? 'Aisle '.$rack->aisle : null, $rack->level ? 'Level '.$rack->level : null])->filter()->implode(' › ') }}
                        </div>
                    @endif
                    <div class="rack-capacity">
                        <div class="rack-bar">
                            <div class="rack-fill {{ $fillClass }}" style="width: {{ $percent }}%"></div>
                        </div>
                    </div>
                    <div class="rack-stats">
                        <span class="rack-percent {{ $fillClass }}">{{ $percent }}%</span>
                        <span>{{ number_format($current) }} / {{ $max > 0 ? number_format($max) : '∞' }}</span>
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div class="empty-racks">
            <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/>
            </svg>
            <p>No racks in this warehouse yet</p>
            <a href="{{ route('inventory.racks.create') }}?warehouse_id={{ $warehouse->id }}" class="btn btn-primary" style="margin-top: 12px;">
                Add First Rack
            </a>
        </div>
    @endif

    <!-- Recent Movements -->
    <div class="movements-card">
        <div class="movements-header">
            <div class="movements-title">
                <svg fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4"/>
                </svg>
                Recent Movements
            </div>
            <a href="{{ route('inventory.reports.movement-history') }}?warehouse_id={{ $warehouse->id }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">
                View All
            </a>
        </div>
        <div class="movements-list">
            @forelse($recentMovements as $movement)
                @php
                    $iconClass = match($movement->type) {
                        'IN', 'RETURN' => 'in',
                        'OUT' => 'out',
                        'TRANSFER_IN', 'TRANSFER_OUT' => 'transfer',
                        default => 'adjust'
                    };
                    $icon = match($movement->type) {
                        'IN' => '📥',
                        'OUT' => '📤',
                        'RETURN' => '↩️',
                        'TRANSFER_IN' => '➡️',
                        'TRANSFER_OUT' => '⬅️',
                        'ADJUSTMENT' => '⚖️',
                        default => '📦'
                    };
                    $qtyClass = in_array($movement->type, ['IN', 'RETURN', 'TRANSFER_IN', 'ADJUSTMENT']) && $movement->qty > 0 ? 'in' : 'out';
                    $qtySign = $qtyClass === 'in' ? '+' : '-';
                @endphp
                <div class="movement-item">
                    <div class="movement-icon {{ $iconClass }}">{{ $icon }}</div>
                    <div class="movement-info">
                        <div class="movement-product">{{ $movement->product->name ?? 'Unknown' }}</div>
                        <div class="movement-details">{{ $movement->type }} • {{ $movement->user->name ?? 'System' }}</div>
                    </div>
                    <div class="movement-qty {{ $qtyClass }}">{{ $qtySign }}{{ number_format(abs($movement->qty)) }}</div>
                    <div class="movement-time">{{ $movement->created_at->diffForHumans() }}</div>
                </div>
            @empty
                <div class="no-movements">No movements recorded yet</div>
   