<?php

namespace Modules\Inventory\Services;

/**
 * Inventory Module Service
 * 
 * Provides module configuration and menu structure for auto-registration.
 */
class InventoryService
{
    /**
     * Module configuration
     */
    public static function config(): array
    {
        return [
            'name' => 'Inventory',
            'alias' => 'inventory',
            'description' => 'Inventory management with warehouses, products, and stock tracking',
            'version' => '1.0.0',
            'is_core' => false,
            'sort_order' => 20,
        ];
    }

    /**
     * Menu configuration for auto-registration
     */
    public static function menus(): array
    {
        return [
            [
                'menu_name' => 'Inventory',
                'slug' => 'inventory',
                'icon' => 'cube',
                'route' => 'inventory.dashboard',
                'category' => 'core',
                'sort_order' => 20,
                'actions' => ['read', 'create', 'edit', 'delete', 'export', 'import'],
                'children' => [
                    [
                        'menu_name' => 'Dashboard',
                        'slug' => 'dashboard',
                        'icon' => 'home',
                        'route' => 'inventory.dashboard',
                        'sort_order' => 1,
                    ],
                    [
                        'menu_name' => 'Products',
                        'slug' => 'products',
                        'icon' => 'tag',
                        'route' => 'inventory.products.index',
                        'sort_order' => 2,
                    ],
                    [
                        'menu_name' => 'Warehouses',
                        'slug' => 'warehouses',
                        'icon' => 'building-office',
                        'route' => 'inventory.warehouses.index',
                        'sort_order' => 3,
                    ],
                    [
                        'menu_name' => 'Racks',
                        'slug' => 'racks',
                        'icon' => 'squares-2x2',
                        'route' => 'inventory.racks.index',
                        'sort_order' => 4,
                    ],
                    [
                        'menu_name' => 'Lots/Batches',
                        'slug' => 'lots',
                        'icon' => 'clipboard-document-list',
                        'route' => 'inventory.lots.index',
                        'sort_order' => 5,
                    ],
                    [
                        'menu_name' => 'Stock Movements',
                        'slug' => 'stock-movements',
                        'icon' => 'arrows-right-left',
                        'route' => 'inventory.stock.movements',
                        'sort_order' => 6,
                    ],
                    [
                        'menu_name' => 'Delivery Receipts',
                        'slug' => 'delivery',
                        'icon' => 'fa fa-truck',
                        'route' => 'inventory.delivery.index',
                        'sort_order' => 7,
                    ],
                    [
                        'menu_name' => 'Reports',
                        'slug' => 'reports',
                        'icon' => 'document-chart-bar',
                        'route' => 'inventory.reports.stock-summary',
                        'sort_order' => 8,
                    ],
                    [
                        'menu_name' => 'Settings',
                        'slug' => 'settings',
                        'icon' => 'cog-6-tooth',
                        'route' => 'inventory.settings.index',
                        'sort_order' => 9,
                    ],
                ],
            ],
        ];
    }

    /**
     * Get module alias
     */
    public static function getAlias(): string
    {
        return self::config()['alias'];
    }

    /**
     * Get module name
     */
    public static function getName(): string
    {
        return self::config()['name'];
    }
}